/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.MessageSecurityFlowParameter;
import org.openspcoop2.core.config.MtomProcessorFlowParameter;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetto;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_porteApplicativeDriver;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_porteApplicativeSearchDriver {
    private DriverConfigurazioneDB driver = null;
    private DriverConfigurazioneDB_porteApplicativeDriver porteApplicativeDriver = null;

    protected DriverConfigurazioneDB_porteApplicativeSearchDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
        this.porteApplicativeDriver = new DriverConfigurazioneDB_porteApplicativeDriver(driver);
    }

    protected List<String> portaApplicativaRuoliList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "portaApplicativaRuoliList";
        int idLista = Liste.PORTE_APPLICATIVE_RUOLI;
        String nomeTabella = "pa_ruoli";
        return this._portaApplicativaRuoliList(idPA, ricerca, nomeMetodo, nomeTabella, idLista);
    }

    protected List<String> portaApplicativaRuoliTokenList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "portaApplicativaRuoliTokenList";
        int idLista = Liste.PORTE_APPLICATIVE_TOKEN_RUOLI;
        String nomeTabella = "pa_token_ruoli";
        return this._portaApplicativaRuoliList(idPA, ricerca, nomeMetodo, nomeTabella, idLista);
    }

    private List<String> _portaApplicativaRuoliList(long idPA, ISearch ricerca, String nomeMetodo, String nomeTabella, int idLista) throws DriverConfigurazioneException {
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<String> listIdRuoli = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
                sqlQueryObject.addWhereLikeCondition(nomeTabella + ".ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectField(nomeTabella + ".ruolo");
                sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
                sqlQueryObject.addWhereLikeCondition(nomeTabella + ".ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy(nomeTabella + ".ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectField(nomeTabella + ".ruolo");
                sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy(nomeTabella + ".ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            risultato = stmt.executeQuery();
            listIdRuoli = new ArrayList<String>();
            while (risultato.next()) {
                listIdRuoli.add(risultato.getString(1));
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return listIdRuoli;
    }

    protected List<String> portaApplicativaScopeList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "portaApplicativaScopeList";
        int idLista = Liste.PORTE_APPLICATIVE_SCOPE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<String> listIdScope = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_scope");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("pa_scope.id_porta=?");
                sqlQueryObject.addWhereLikeCondition("pa_scope.scope", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_scope");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("pa_scope.id_porta=?");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_scope");
                sqlQueryObject.addSelectField("pa_scope.scope");
                sqlQueryObject.addWhereCondition("pa_scope.id_porta=?");
                sqlQueryObject.addWhereLikeCondition("pa_scope.scope", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("pa_scope.scope");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_scope");
                sqlQueryObject.addSelectField("pa_scope.scope");
                sqlQueryObject.addWhereCondition("pa_scope.id_porta=?");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("pa_scope.scope");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            risultato = stmt.executeQuery();
            listIdScope = new ArrayList<String>();
            while (risultato.next()) {
                listIdScope.add(risultato.getString(1));
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return listIdScope;
    }

    protected List<PortaApplicativa> porteAppList(long idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<PortaApplicativa> arrayList;
        int idLista = Liste.PORTE_APPLICATIVE_BY_SOGGETTO;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteAppList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stm.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idSoggetto);
            rs = stm.executeQuery();
            PortaApplicativa pa = null;
            while (rs.next()) {
                pa = this.porteApplicativeDriver.getPortaApplicativa(rs.getLong("id"), con);
                lista.add(pa);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortaApplicativa> porteAppList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<PortaApplicativa> arrayList;
        int idLista = Liste.PORTE_APPLICATIVE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
        List<String> tipoSoggettiProtocollo = null;
        try {
            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteAppList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stm = con.prepareStatement(queryString);
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                stm.setString(1, superuser);
            }
            if ((rs = stm.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stm.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_applicative.id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_applicative.id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stm = con.prepareStatement(queryString);
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                stm.setString(1, superuser);
            }
            rs = stm.executeQuery();
            PortaApplicativa pa = null;
            while (rs.next()) {
                pa = this.porteApplicativeDriver.getPortaApplicativa(rs.getLong("id"), con);
                lista.add(pa);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Proprieta> porteAppPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Proprieta> arrayList;
        int idLista = Liste.PORTE_APPLICATIVE_PROP;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Proprieta> lista = new ArrayList<Proprieta>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteAppPropList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_properties");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_properties");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            Proprieta prop = null;
            while (risultato.next()) {
                prop = new Proprieta();
                prop.setId(risultato.getLong("id_porta"));
                prop.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    prop.setValore(encValue);
                } else {
                    prop.setValore(plainValue);
                }
                lista.add(prop);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Proprieta> porteApplicativeAutenticazioneCustomPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Proprieta> arrayList;
        int idLista = Liste.PORTE_APPLICATIVE_PROPRIETA_AUTENTICAZIONE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Proprieta> lista = new ArrayList<Proprieta>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteApplicativeAutorizzazioneCustomPropList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_auth_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_auth_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_auth_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_auth_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            Proprieta prop = null;
            while (risultato.next()) {
                prop = new Proprieta();
                prop.setId(risultato.getLong("id"));
                prop.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    prop.setValore(encValue);
                } else {
                    prop.setValore(plainValue);
                }
                lista.add(prop);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Proprieta> porteApplicativeAutorizzazioneCustomPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Proprieta> arrayList;
        int idLista = Liste.PORTE_APPLICATIVE_PROPRIETA_AUTORIZZAZIONE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Proprieta> lista = new ArrayList<Proprieta>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteApplicativeAutorizzazioneCustomPropList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_authz_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_authz_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_authz_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_authz_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            Proprieta prop = null;
            while (risultato.next()) {
                prop = new Proprieta();
                prop.setId(risultato.getLong("id"));
                prop.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    prop.setValore(encValue);
                } else {
                    prop.setValore(plainValue);
                }
                lista.add(prop);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Proprieta> porteApplicativeAutorizzazioneContenutoCustomPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Proprieta> arrayList;
        int idLista = Liste.PORTE_APPLICATIVE_PROPRIETA_AUTORIZZAZIONE_CONTENUTO;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Proprieta> lista = new ArrayList<Proprieta>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteApplicativeAutorizzazioneCustomPropList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_authzc_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_authzc_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_authzc_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_authzc_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            Proprieta prop = null;
            while (risultato.next()) {
                prop = new Proprieta();
                prop.setId(risultato.getLong("id"));
                prop.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    prop.setValore(encValue);
                } else {
                    prop.setValore(plainValue);
                }
                lista.add(prop);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortaApplicativaAzione> porteAppAzioneList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<PortaApplicativaAzione> arrayList;
        int idLista = Liste.PORTE_APPLICATIVE_AZIONI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaApplicativaAzione> lista = new ArrayList<PortaApplicativaAzione>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteAppPropList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pa_azioni");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("azione", search, true, true);
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pa_azioni");
            sqlQueryObject.addSelectField("id_porta");
            sqlQueryObject.addSelectField("azione");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("azione");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            PortaApplicativaAzione azione = null;
            while (risultato.next()) {
                azione = new PortaApplicativaAzione();
                azione.setId(risultato.getLong("id"));
                azione.setNome(risultato.getString("azione"));
                String nomePortaDelegante = null;
                azione.setNomePortaDelegante(nomePortaDelegante);
                PortaApplicativaAzioneIdentificazione identificazione = null;
                azione.setIdentificazione(identificazione);
                StatoFunzionalita forceInterfaceBased = StatoFunzionalita.ABILITATO;
                azione.setForceInterfaceBased(forceInterfaceBased);
                lista.add(azione);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<ServizioApplicativo> porteAppServizioApplicativoList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<ServizioApplicativo> arrayList;
        String nomeMetodo = "porteAppServizioApplicativoList";
        int idLista = Liste.PORTE_APPLICATIVE_SERVIZIO_APPLICATIVO;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        PreparedStatement stmt1 = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteAppServizioApplicativoList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative_sa");
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereCondition("porte_applicative_sa.id_servizio_applicativo=servizi_applicativi.id");
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative_sa");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative_sa");
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("id_servizio_applicativo");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereCondition("porte_applicative_sa.id_servizio_applicativo=servizi_applicativi.id");
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id_servizio_applicativo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative_sa");
                sqlQueryObject.addSelectField("id_servizio_applicativo");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id_servizio_applicativo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            ServizioApplicativo sa = null;
            long idServizioApplicativo = 0L;
            while (risultato.next()) {
                idServizioApplicativo = risultato.getLong("id_servizio_applicativo");
                sa = new ServizioApplicativo();
                ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("servizi_applicativi");
                sqlQueryObject2.addSelectField("*");
                sqlQueryObject2.addWhereCondition("id = ?");
                queryString = sqlQueryObject2.createSQLQuery();
                stmt1 = con.prepareStatement(queryString);
                stmt1.setLong(1, idServizioApplicativo);
                ResultSet rs1 = stmt1.executeQuery();
                if (!rs1.next()) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore recuperando i dati del Servizio Applicativo.");
                }
                sa.setId(idServizioApplicativo);
                sa.setNome(rs1.getString("nome"));
                sa.setDescrizione(rs1.getString("descrizione"));
                sa.setIdSoggetto(rs1.getLong("id_soggetto"));
                rs1.close();
                stmt1.close();
                lista.add(sa);
            }
            risultato.close();
            stmt.close();
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                JDBCUtilities.closeResources(stmt1);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        JDBCUtilities.closeResources(stmt1);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortaApplicativaAutorizzazioneSoggetto> porteAppSoggettoList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<PortaApplicativaAutorizzazioneSoggetto> arrayList;
        String nomeMetodo = "porteAppSoggettoList";
        int idLista = Liste.PORTE_APPLICATIVE_SOGGETTO;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        PreparedStatement stmt1 = null;
        ResultSet risultato = null;
        ArrayList<PortaApplicativaAutorizzazioneSoggetto> lista = new ArrayList<PortaApplicativaAutorizzazioneSoggetto>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteAppSoggettoList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pa_soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("pa_soggetti.nome_soggetto", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pa_soggetti");
            sqlQueryObject.addSelectField("id_porta");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("pa_soggetti.nome_soggetto", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
            }
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            PortaApplicativaAutorizzazioneSoggetto paAuthSoggetto = null;
            while (risultato.next()) {
                paAuthSoggetto = new PortaApplicativaAutorizzazioneSoggetto();
                paAuthSoggetto.setNome(risultato.getString("nome_soggetto"));
                paAuthSoggetto.setTipo(risultato.getString("tipo_soggetto"));
                lista.add(paAuthSoggetto);
            }
            risultato.close();
            stmt.close();
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                JDBCUtilities.closeResources(stmt1);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        JDBCUtilities.closeResources(stmt1);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortaApplicativaAutorizzazioneServizioApplicativo> porteAppServiziApplicativiAutorizzatiList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteAppServiziApplicativiAutorizzatiList";
        int idLista = Liste.PORTE_APPLICATIVE_SERVIZIO_APPLICATIVO_AUTORIZZATO;
        String nomeTabella = "porte_applicative_sa_auth";
        return this._porteAppServiziApplicativiAutorizzatiTokenList(idPortaApplicativa, ricerca, nomeMetodo, nomeTabella, idLista);
    }

    protected List<PortaApplicativaAutorizzazioneServizioApplicativo> porteAppServiziApplicativiAutorizzatiTokenList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteAppServiziApplicativiAutorizzatiTokenList";
        int idLista = Liste.PORTE_APPLICATIVE_TOKEN_SERVIZIO_APPLICATIVO;
        String nomeTabella = "pa_token_sa";
        return this._porteAppServiziApplicativiAutorizzatiTokenList(idPortaApplicativa, ricerca, nomeMetodo, nomeTabella, idLista);
    }

    private List<PortaApplicativaAutorizzazioneServizioApplicativo> _porteAppServiziApplicativiAutorizzatiTokenList(long idPortaApplicativa, ISearch ricerca, String nomeMetodo, String nomeTabella, int idLista) throws DriverConfigurazioneException {
        ArrayList<PortaApplicativaAutorizzazioneServizioApplicativo> arrayList;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        PreparedStatement stmt1 = null;
        ResultSet risultato = null;
        ArrayList<PortaApplicativaAutorizzazioneServizioApplicativo> lista = new ArrayList<PortaApplicativaAutorizzazioneServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteAppServiziApplicativiAutorizzatiTokenList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (!search.equals("")) {
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=" + nomeTabella + ".id_servizio_applicativo");
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("id_porta");
            sqlQueryObject.addSelectField("id_servizio_applicativo");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectAliasField("servizi_applicativi", "id_soggetto", "idSoggettoProprietarioSA");
            sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", "tipoSoggettoProprietarioSA");
            sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", "nomeSoggettoProprietarioSA");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            sqlQueryObject.addWhereCondition("servizi_applicativi.id=" + nomeTabella + ".id_servizio_applicativo");
            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
            }
            sqlQueryObject.addOrderBy("servizi_applicativi.nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            PortaApplicativaAutorizzazioneServizioApplicativo paAuthSa = null;
            while (risultato.next()) {
                paAuthSa = new PortaApplicativaAutorizzazioneServizioApplicativo();
                paAuthSa.setNome(risultato.getString("nome"));
                paAuthSa.setTipoSoggettoProprietario(risultato.getString("tipoSoggettoProprietarioSA"));
                paAuthSa.setNomeSoggettoProprietario(risultato.getString("nomeSoggettoProprietarioSA"));
                lista.add(paAuthSa);
            }
            risultato.close();
            stmt.close();
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                JDBCUtilities.closeResources(stmt1);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        JDBCUtilities.closeResources(stmt1);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<MessageSecurityFlowParameter> porteAppMessageSecurityRequestList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<MessageSecurityFlowParameter> arrayList;
        String nomeMetodo = "porteAppMessageSecurityRequestList";
        int idLista = Liste.PORTE_APPLICATIVE_MESSAGE_SECURITY_REQUEST;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<MessageSecurityFlowParameter> lista = new ArrayList<MessageSecurityFlowParameter>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteAppMessageSecurityRequestList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_security_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_security_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_security_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_security_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MessageSecurityFlowParameter wsreq = new MessageSecurityFlowParameter();
                wsreq.setId(risultato.getLong("id_porta"));
                wsreq.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    wsreq.setValore(encValue);
                } else {
                    wsreq.setValore(plainValue);
                }
                lista.add(wsreq);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<MessageSecurityFlowParameter> porteAppMessageSecurityResponseList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<MessageSecurityFlowParameter> arrayList;
        String nomeMetodo = "porteAppMessageSecurityResponseList";
        int idLista = Liste.PORTE_APPLICATIVE_MESSAGE_SECURITY_RESPONSE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<MessageSecurityFlowParameter> lista = new ArrayList<MessageSecurityFlowParameter>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteAppMessageSecurityResponseList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_security_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_security_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_security_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_security_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MessageSecurityFlowParameter wsresp = new MessageSecurityFlowParameter();
                wsresp.setId(risultato.getLong("id_porta"));
                wsresp.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    wsresp.setValore(encValue);
                } else {
                    wsresp.setValore(plainValue);
                }
                lista.add(wsresp);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<CorrelazioneApplicativaElemento> porteApplicativeCorrelazioneApplicativaList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<CorrelazioneApplicativaElemento> arrayList;
        String nomeMetodo = "porteApplicativeCorrelazioneApplicativaList";
        int idLista = Liste.PORTE_APPLICATIVE_CORRELAZIONE_APPLICATIVA;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<CorrelazioneApplicativaElemento> lista = new ArrayList<CorrelazioneApplicativaElemento>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteApplicativeCorrelazioneApplicativaList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            CorrelazioneApplicativaElemento cae = null;
            while (risultato.next()) {
                cae = new CorrelazioneApplicativaElemento();
                cae.setId(risultato.getLong("id"));
                cae.setNome(risultato.getString("nome_elemento"));
                cae.setIdentificazione(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaRichiestaIdentificazione(risultato.getString("mode_correlazione")));
                cae.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(risultato.getString("identificazione_fallita")));
                lista.add(cae);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<CorrelazioneApplicativaRispostaElemento> porteApplicativeCorrelazioneApplicativaRispostaList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<CorrelazioneApplicativaRispostaElemento> arrayList;
        String nomeMetodo = "porteApplicativeCorrelazioneApplicativaRispostaList";
        int idLista = Liste.PORTE_APPLICATIVE_CORRELAZIONE_APPLICATIVA_RISPOSTA;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<CorrelazioneApplicativaRispostaElemento> lista = new ArrayList<CorrelazioneApplicativaRispostaElemento>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteApplicativeCorrelazioneApplicativaRispostaList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione_risposta");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione_risposta");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione_risposta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione_risposta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            CorrelazioneApplicativaRispostaElemento cae = null;
            while (risultato.next()) {
                cae = new CorrelazioneApplicativaRispostaElemento();
                cae.setId(risultato.getLong("id"));
                cae.setNome(risultato.getString("nome_elemento"));
                cae.setIdentificazione(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaRispostaIdentificazione(risultato.getString("mode_correlazione")));
                cae.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(risultato.getString("identificazione_fallita")));
                lista.add(cae);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortaApplicativa> serviziPorteAppList(String tipoServizio, String nomeServizio, Integer versioneServizio, long idServizio, long idSoggettoErogatore, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<PortaApplicativa> arrayList;
        String nomeMetodo = "serviziPorteAppList";
        int idLista = Liste.CONFIGURAZIONE_EROGAZIONE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        try {
            String queryString;
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource(nomeMetodo);
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto = ? AND tipo_servizio = ? AND servizio=? AND versione_servizio=? AND id_soggetto_virtuale <= ?", "id_soggetto = ? AND id_servizio = ? AND id_soggetto_virtuale <= ?", "id_soggetto_virtuale = ? AND tipo_servizio = ? AND servizio=?  AND versione_servizio=?", "id_soggetto_virtuale = ? AND id_servizio = ?"});
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto = ? AND tipo_servizio = ? AND servizio=? AND versione_servizio=? AND id_soggetto_virtuale <= ?", "id_soggetto = ? AND id_servizio = ? AND id_soggetto_virtuale <= ?", "id_soggetto_virtuale = ? AND tipo_servizio = ? AND servizio=? AND versione_servizio=?", "id_soggetto_virtuale = ? AND id_servizio = ?"});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idSoggettoErogatore);
            stmt.setString(index++, tipoServizio);
            stmt.setString(index++, nomeServizio);
            stmt.setInt(index++, versioneServizio);
            stmt.setLong(index++, 0L);
            stmt.setLong(index++, idSoggettoErogatore);
            stmt.setLong(index++, idServizio);
            stmt.setLong(index++, 0L);
            stmt.setLong(index++, idSoggettoErogatore);
            stmt.setString(index++, tipoServizio);
            stmt.setString(index++, nomeServizio);
            stmt.setInt(index++, versioneServizio);
            stmt.setLong(index++, idSoggettoErogatore);
            stmt.setLong(index++, idServizio);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_servizio");
                sqlQueryObject.addSelectField("id_soggetto_virtuale");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto = ? AND tipo_servizio = ? AND servizio=? AND versione_servizio=? AND id_soggetto_virtuale <= ?", "id_soggetto = ? AND id_servizio = ? AND id_soggetto_virtuale <= ?", "id_soggetto_virtuale = ? AND tipo_servizio = ? AND servizio=? AND versione_servizio=?", "id_soggetto_virtuale = ? AND id_servizio = ?"});
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_servizio");
                sqlQueryObject.addSelectField("id_soggetto_virtuale");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto = ? AND tipo_servizio = ? AND servizio=? AND versione_servizio=? AND id_soggetto_virtuale <= ?", "id_soggetto = ? AND id_servizio = ? AND id_soggetto_virtuale <= ?", "id_soggetto_virtuale = ? AND tipo_servizio = ? AND servizio=? AND versione_servizio=?", "id_soggetto_virtuale = ? AND id_servizio = ?"});
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            stmt.setLong(index++, idSoggettoErogatore);
            stmt.setString(index++, tipoServizio);
            stmt.setString(index++, nomeServizio);
            stmt.setInt(index++, versioneServizio);
            stmt.setLong(index++, 0L);
            stmt.setLong(index++, idSoggettoErogatore);
            stmt.setLong(index++, idServizio);
            stmt.setLong(index++, 0L);
            stmt.setLong(index++, idSoggettoErogatore);
            stmt.setString(index++, tipoServizio);
            stmt.setString(index++, nomeServizio);
            stmt.setInt(index++, versioneServizio);
            stmt.setLong(index++, idSoggettoErogatore);
            stmt.setLong(index++, idServizio);
            risultato = stmt.executeQuery();
            PortaApplicativa pa = null;
            while (risultato.next()) {
                pa = this.porteApplicativeDriver.getPortaApplicativa(risultato.getLong("id"));
                lista.add(pa);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<MtomProcessorFlowParameter> porteApplicativeMTOMRequestList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<MtomProcessorFlowParameter> arrayList;
        String nomeMetodo = "porteApplicativeMTOMRequestList";
        int idLista = Liste.PORTE_APPLICATIVE_MTOM_REQUEST;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<MtomProcessorFlowParameter> lista = new ArrayList<MtomProcessorFlowParameter>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MtomProcessorFlowParameter reqPar = new MtomProcessorFlowParameter();
                reqPar.setId(risultato.getLong("id_porta"));
                reqPar.setNome(risultato.getString("nome"));
                reqPar.setPattern(risultato.getString("pattern"));
                reqPar.setContentType(risultato.getString("content_type"));
                int required = risultato.getInt("required");
                boolean isrequired = false;
                if (required == 1) {
                    isrequired = true;
                }
                reqPar.setRequired(isrequired);
                lista.add(reqPar);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<MtomProcessorFlowParameter> porteApplicativeMTOMResponseList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<MtomProcessorFlowParameter> arrayList;
        String nomeMetodo = "porteApplicativeMTOMResponseList";
        int idLista = Liste.PORTE_APPLICATIVE_MTOM_RESPONSE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<MtomProcessorFlowParameter> lista = new ArrayList<MtomProcessorFlowParameter>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MtomProcessorFlowParameter resPar = new MtomProcessorFlowParameter();
                resPar.setId(risultato.getLong("id_porta"));
                resPar.setNome(risultato.getString("nome"));
                resPar.setPattern(risultato.getString("pattern"));
                resPar.setContentType(risultato.getString("content_type"));
                int required = risultato.getInt("required");
                boolean isrequired = false;
                if (required == 1) {
                    isrequired = true;
                }
                resPar.setRequired(isrequired);
                lista.add(resPar);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Proprieta> porteApplicativeConnettoriMultipliConfigPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Proprieta> arrayList;
        int idLista = Liste.PORTE_APPLICATIVE_CONNETTORI_MULTIPLI_CONFIG_PROPRIETA;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Proprieta> lista = new ArrayList<Proprieta>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteApplicativeConnettoriMultipliConfigPropList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteApplicativeConnettoriMultipliConfigPropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pa_behaviour_props");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pa_behaviour_props");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("id_porta");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("valore");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
            }
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            Proprieta prop = null;
            while (risultato.next()) {
                prop = new Proprieta();
                prop.setId(risultato.getLong("id"));
                prop.setNome(risultato.getString("nome"));
                prop.setValore(risultato.getString("valore"));
                lista.add(prop);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteApplicativeConnettoriMultipliConfigPropList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Proprieta> porteApplicativeConnettoriMultipliPropList(long idPaSa, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Proprieta> arrayList;
        int idLista = Liste.PORTE_APPLICATIVE_CONNETTORI_MULTIPLI_PROPRIETA;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Proprieta> lista = new ArrayList<Proprieta>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteApplicativeAutorizzazioneCustomPropList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pa_sa_properties");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPaSa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pa_sa_properties");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("id_porta");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("valore");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
            }
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPaSa);
            risultato = stmt.executeQuery();
            Proprieta prop = null;
            while (risultato.next()) {
                prop = new Proprieta();
                prop.setId(risultato.getLong("id"));
                prop.setNome(risultato.getString("nome"));
                prop.setValore(risultato.getString("valore"));
                lista.add(prop);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }
}

