/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons.search.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.openspcoop2.core.commons.search.IdPortaApplicativa;
import org.openspcoop2.core.commons.search.IdServizioApplicativo;
import org.openspcoop2.core.commons.search.IdSoggetto;
import org.openspcoop2.core.commons.search.PortaApplicativa;
import org.openspcoop2.core.commons.search.PortaApplicativaAzione;
import org.openspcoop2.core.commons.search.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.dao.IDBSoggettoServiceSearch;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.commons.search.dao.jdbc.converter.PortaApplicativaFieldConverter;
import org.openspcoop2.core.commons.search.dao.jdbc.fetch.PortaApplicativaFetch;
import org.openspcoop2.core.commons.search.utils.ExpressionProperties;
import org.openspcoop2.generic_project.beans.AliasField;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.InUse;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.IJDBCFetch;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.utils.Utilities;
import org.openspcoop2.generic_project.utils.UtilsTemplate;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class JDBCPortaApplicativaServiceSearchImpl
implements IJDBCServiceSearchWithId<PortaApplicativa, IdPortaApplicativa, JDBCServiceManager> {
    private PortaApplicativaFieldConverter _portaApplicativaFieldConverter = null;
    private PortaApplicativaFetch portaApplicativaFetch = new PortaApplicativaFetch();
    private JDBCServiceManager jdbcServiceManager = null;

    public PortaApplicativaFieldConverter getPortaApplicativaFieldConverter() {
        if (this._portaApplicativaFieldConverter == null) {
            this._portaApplicativaFieldConverter = new PortaApplicativaFieldConverter(this.jdbcServiceManager.getJdbcProperties().getDatabaseType());
        }
        return this._portaApplicativaFieldConverter;
    }

    public ISQLFieldConverter getFieldConverter() {
        return this.getPortaApplicativaFieldConverter();
    }

    public PortaApplicativaFetch getPortaApplicativaFetch() {
        return this.portaApplicativaFetch;
    }

    public IJDBCFetch getFetch() {
        return this.getPortaApplicativaFetch();
    }

    public void setServiceManager(JDBCServiceManager serviceManager) throws ServiceException {
        this.jdbcServiceManager = serviceManager;
    }

    public JDBCServiceManager getServiceManager() throws ServiceException {
        return this.jdbcServiceManager;
    }

    public JDBCServiceManager getServiceManager(Connection connection, JDBCServiceManagerProperties jdbcProperties, Logger log) throws ServiceException {
        return new JDBCServiceManager(connection, jdbcProperties, log);
    }

    public IdPortaApplicativa convertToId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, PortaApplicativa portaApplicativa) throws NotImplementedException, ServiceException, Exception {
        IdPortaApplicativa idPortaApplicativa = new IdPortaApplicativa();
        idPortaApplicativa.setNome(portaApplicativa.getNome());
        return idPortaApplicativa;
    }

    public PortaApplicativa get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaApplicativa id, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_portaApplicativa = id != null && id.getId() != null && id.getId() > 0L ? id.getId() : this.findIdPortaApplicativa(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, id_portaApplicativa, idMappingResolutionBehaviour);
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaApplicativa id) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_portaApplicativa = this.findIdPortaApplicativa(jdbcProperties, log, connection, sqlQueryObject, id, false);
        return id_portaApplicativa != null && id_portaApplicativa > 0L;
    }

    public List<IdPortaApplicativa> findAllIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<IdPortaApplicativa> list = new ArrayList<IdPortaApplicativa>();
        List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
        for (Long id : ids) {
            PortaApplicativa portaApplicativa = this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
            IdPortaApplicativa idPortaApplicativa = this.convertToId(jdbcProperties, log, connection, sqlQueryObject, portaApplicativa);
            list.add(idPortaApplicativa);
        }
        return list;
    }

    public List<PortaApplicativa> findAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<PortaApplicativa> list = new ArrayList<PortaApplicativa>();
        boolean soloDatiIdentificativiServizio = ExpressionProperties.isEnabledSoloDatiIdentificativiServizio((IExpression)expression);
        if (soloDatiIdentificativiServizio) {
            ArrayList<Object> fields = new ArrayList<Object>();
            fields.add(PortaApplicativa.model().NOME);
            fields.add(PortaApplicativa.model().STATO);
            fields.add(PortaApplicativa.model().TIPO_SERVIZIO);
            fields.add(PortaApplicativa.model().NOME_SERVIZIO);
            fields.add(PortaApplicativa.model().VERSIONE_SERVIZIO);
            fields.add(PortaApplicativa.model().MODE_AZIONE);
            fields.add(PortaApplicativa.model().NOME_AZIONE);
            fields.add(PortaApplicativa.model().NOME_PORTA_DELEGANTE_AZIONE);
            String aliasSoggettoTipo = "proprietarioSoggettoTipo";
            fields.add(new AliasField(PortaApplicativa.model().ID_SOGGETTO.TIPO, aliasSoggettoTipo));
            String aliasSoggettoNome = "proprietarioSoggettoNome";
            fields.add(new AliasField(PortaApplicativa.model().ID_SOGGETTO.NOME, aliasSoggettoNome));
            List<Map<String, Object>> returnMap = null;
            try {
                boolean distinct = false;
                returnMap = this.select(jdbcProperties, log, connection, sqlQueryObject, expression, distinct, fields.toArray(new IField[1]));
                for (Map<String, Object> map : returnMap) {
                    PortaApplicativa pa = (PortaApplicativa)this.getPortaApplicativaFetch().fetch(jdbcProperties.getDatabase(), (IModel<?>)PortaApplicativa.model(), map);
                    Object proprietarioSoggettoTipo = this.getObjectFromMap(map, aliasSoggettoTipo);
                    Object proprietarioSoggettoNome = this.getObjectFromMap(map, aliasSoggettoNome);
                    if (proprietarioSoggettoTipo != null && proprietarioSoggettoNome != null) {
                        IdSoggetto idSoggetto = new IdSoggetto();
                        if (proprietarioSoggettoTipo != null && proprietarioSoggettoTipo instanceof String) {
                            idSoggetto.setTipo((String)proprietarioSoggettoTipo);
                        }
                        if (proprietarioSoggettoNome != null && proprietarioSoggettoNome instanceof String) {
                            idSoggetto.setNome((String)proprietarioSoggettoNome);
                        }
                        pa.setIdSoggetto(idSoggetto);
                    }
                    list.add(pa);
                }
            }
            catch (NotFoundException notFoundException) {}
        } else {
            List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
            for (Long id : ids) {
                list.add(this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour));
            }
        }
        return list;
    }

    private Object getObjectFromMap(Map<String, Object> map, String name) {
        if (map == null) {
            return null;
        }
        if (map.containsKey(name)) {
            Object o = map.get(name);
            if (o instanceof ObjectUtils.Null) {
                return null;
            }
            return o;
        }
        return null;
    }

    public PortaApplicativa find(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        long id = this.findTableId(jdbcProperties, log, connection, sqlQueryObject, expression);
        if (id > 0L) {
            return this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
        }
        throw new NotFoundException("Entry with id[" + id + "] not found");
    }

    public NonNegativeNumber count(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List listaQuery = GenericJDBCUtilities.prepareCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model());
        sqlQueryObject.addSelectCountField(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model()) + ".id", "tot", true);
        this.joinEngine((IExpression)expression, sqlQueryObject);
        return GenericJDBCUtilities.count((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model(), (List)listaQuery);
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaApplicativa id) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        Long id_portaApplicativa = this.findIdPortaApplicativa(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, id_portaApplicativa);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List<Map<String, Object>> map = this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, distinct, new IField[]{field});
        return GenericJDBCUtilities.selectSingleObject(map);
    }

    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        try {
            ISQLQueryObject sqlQueryObjectDistinct = GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((boolean)distinct, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (Logger)log, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IField[])field);
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression, sqlQueryObjectDistinct);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        }
    }

    public Object aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        Map<String, Object> map = this.aggregate(jdbcProperties, log, connection, sqlQueryObject, expression, new FunctionField[]{functionField});
        return GenericJDBCUtilities.selectAggregateObject(map, (FunctionField)functionField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            Map<String, Object> map = list.get(0);
            return map;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (expression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (paginatedExpression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        }
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, expression, null);
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLQueryObject sqlQueryObjectDistinct) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        ArrayList listaQuery = new ArrayList();
        ArrayList listaParams = new ArrayList();
        List returnField = GenericJDBCUtilities.prepareSelect((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model(), listaQuery, listaParams);
        this.joinEngine(expression, sqlQueryObject);
        List list = GenericJDBCUtilities.select((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((ISQLQueryObject)sqlQueryObject, (ISQLQueryObject)sqlQueryObjectDistinct), (IExpression)expression, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model(), listaQuery, listaParams, (List)returnField);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public List<Map<String, Object>> union(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List list;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnion((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((list = GenericJDBCUtilities.union((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public NonNegativeNumber unionCount(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        NonNegativeNumber number;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((number = GenericJDBCUtilities.unionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && number.longValue() >= 0L) {
            return number;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public JDBCExpression newExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression((ISQLFieldConverter)this.getPortaApplicativaFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression newPaginatedExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression((ISQLFieldConverter)this.getPortaApplicativaFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCExpression toExpression(JDBCPaginatedExpression paginatedExpression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression(paginatedExpression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression toPaginatedExpression(JDBCExpression expression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression(expression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaApplicativa id, PortaApplicativa obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, id, null));
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, PortaApplicativa obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, tableId, (IDMappingBehaviour)null));
    }

    private void _mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, PortaApplicativa obj, PortaApplicativa imgSaved) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        boolean objEqualsToImgSaved_;
        List<BaseBeanWithId> listImgSaved_;
        PortaApplicativaServizioApplicativo itemAlreadySaved_;
        List<BaseBeanWithId> listObj_;
        if (imgSaved == null) {
            return;
        }
        obj.setId(imgSaved.getId());
        if (obj.getIdSoggetto() != null && imgSaved.getIdSoggetto() != null) {
            obj.getIdSoggetto().setId(imgSaved.getIdSoggetto().getId());
        }
        if (obj.getPortaApplicativaServizioApplicativoList() != null) {
            listObj_ = obj.getPortaApplicativaServizioApplicativoList();
            for (BaseBeanWithId itemObj_ : listObj_) {
                itemAlreadySaved_ = null;
                if (imgSaved.getPortaApplicativaServizioApplicativoList() != null) {
                    listImgSaved_ = imgSaved.getPortaApplicativaServizioApplicativoList();
                    for (BaseBeanWithId itemImgSaved_ : listImgSaved_) {
                        objEqualsToImgSaved_ = false;
                        if (itemObj_.getIdServizioApplicativo() != null && itemObj_.getIdServizioApplicativo().getIdSoggetto() != null && itemImgSaved_.getIdServizioApplicativo() != null && itemImgSaved_.getIdServizioApplicativo().getIdSoggetto() != null) {
                            boolean bl = objEqualsToImgSaved_ = Utilities.equals((Object)itemObj_.getIdServizioApplicativo().getNome(), (Object)itemImgSaved_.getIdServizioApplicativo().getNome()) && Utilities.equals((Object)itemObj_.getIdServizioApplicativo().getIdSoggetto().getTipo(), (Object)itemImgSaved_.getIdServizioApplicativo().getIdSoggetto().getTipo()) && Utilities.equals((Object)itemObj_.getIdServizioApplicativo().getIdSoggetto().getNome(), (Object)itemImgSaved_.getIdServizioApplicativo().getIdSoggetto().getNome());
                        }
                        if (!objEqualsToImgSaved_) continue;
                        itemAlreadySaved_ = itemImgSaved_;
                        break;
                    }
                }
                if (itemAlreadySaved_ == null) continue;
                itemObj_.setId(itemAlreadySaved_.getId());
                if (itemObj_.getIdServizioApplicativo() == null || itemAlreadySaved_.getIdServizioApplicativo() == null) continue;
                itemObj_.getIdServizioApplicativo().setId(itemAlreadySaved_.getIdServizioApplicativo().getId());
                if (itemObj_.getIdServizioApplicativo().getIdSoggetto() == null || itemAlreadySaved_.getIdServizioApplicativo().getIdSoggetto() == null) continue;
                itemObj_.getIdServizioApplicativo().getIdSoggetto().setId(itemAlreadySaved_.getIdServizioApplicativo().getIdSoggetto().getId());
            }
        }
        if (obj.getPortaApplicativaAzioneList() != null) {
            listObj_ = obj.getPortaApplicativaAzioneList();
            for (BaseBeanWithId itemObj_ : listObj_) {
                itemAlreadySaved_ = null;
                if (imgSaved.getPortaApplicativaAzioneList() != null) {
                    listImgSaved_ = imgSaved.getPortaApplicativaAzioneList();
                    for (BaseBeanWithId itemImgSaved_ : listImgSaved_) {
                        objEqualsToImgSaved_ = false;
                        objEqualsToImgSaved_ = Utilities.equals((Object)itemObj_.getNome(), (Object)itemImgSaved_.getNome());
                        if (!objEqualsToImgSaved_) continue;
                        itemAlreadySaved_ = itemImgSaved_;
                        break;
                    }
                }
                if (itemAlreadySaved_ == null) continue;
                itemObj_.setId(itemAlreadySaved_.getId());
            }
        }
    }

    public PortaApplicativa get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, tableId, idMappingResolutionBehaviour);
    }

    private PortaApplicativa getEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        PortaApplicativa portaApplicativa = new PortaApplicativa();
        ISQLQueryObject sqlQueryObjectGet_portaApplicativa = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_portaApplicativa.setANDLogicOperator(true);
        sqlQueryObjectGet_portaApplicativa.addFromTable(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model()));
        sqlQueryObjectGet_portaApplicativa.addSelectField("id");
        sqlQueryObjectGet_portaApplicativa.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().NOME, true));
        sqlQueryObjectGet_portaApplicativa.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().STATO, true));
        sqlQueryObjectGet_portaApplicativa.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().TIPO_SERVIZIO, true));
        sqlQueryObjectGet_portaApplicativa.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().NOME_SERVIZIO, true));
        sqlQueryObjectGet_portaApplicativa.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().VERSIONE_SERVIZIO, true));
        sqlQueryObjectGet_portaApplicativa.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().MODE_AZIONE, true));
        sqlQueryObjectGet_portaApplicativa.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().NOME_AZIONE, true));
        sqlQueryObjectGet_portaApplicativa.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().NOME_PORTA_DELEGANTE_AZIONE, true));
        sqlQueryObjectGet_portaApplicativa.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().CANALE, true));
        sqlQueryObjectGet_portaApplicativa.addWhereCondition("id=?");
        portaApplicativa = (PortaApplicativa)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_portaApplicativa.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)PortaApplicativa.model(), (IJDBCFetch)this.getPortaApplicativaFetch(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        ISQLQueryObject sqlQueryObjectGet_portaApplicativa_soggetto_readFkId = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_portaApplicativa_soggetto_readFkId.addFromTable(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model()));
        sqlQueryObjectGet_portaApplicativa_soggetto_readFkId.addSelectField("id_soggetto");
        sqlQueryObjectGet_portaApplicativa_soggetto_readFkId.addWhereCondition("id=?");
        sqlQueryObjectGet_portaApplicativa_soggetto_readFkId.setANDLogicOperator(true);
        Long idFK_portaApplicativa_soggetto = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_portaApplicativa_soggetto_readFkId.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, new JDBCObject[]{new JDBCObject((Object)portaApplicativa.getId(), Long.class)});
        ISQLQueryObject sqlQueryObjectGet_portaApplicativa_soggetto = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_portaApplicativa_soggetto.addFromTable("soggetti");
        sqlQueryObjectGet_portaApplicativa_soggetto.addSelectField("tipo_soggetto");
        sqlQueryObjectGet_portaApplicativa_soggetto.addSelectField("nome_soggetto");
        sqlQueryObjectGet_portaApplicativa_soggetto.setANDLogicOperator(true);
        sqlQueryObjectGet_portaApplicativa_soggetto.addWhereCondition("id=?");
        JDBCObject[] searchParams_portaApplicativa_soggetto = new JDBCObject[]{new JDBCObject((Object)idFK_portaApplicativa_soggetto, Long.class)};
        ArrayList<Class<String>> listaFieldIdReturnType_portaApplicativa_soggetto = new ArrayList<Class<String>>();
        listaFieldIdReturnType_portaApplicativa_soggetto.add(String.class);
        listaFieldIdReturnType_portaApplicativa_soggetto.add(String.class);
        List listaFieldId_portaApplicativa_soggetto = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_portaApplicativa_soggetto.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_portaApplicativa_soggetto, searchParams_portaApplicativa_soggetto);
        IdSoggetto idSoggetto = new IdSoggetto();
        idSoggetto.setTipo((String)listaFieldId_portaApplicativa_soggetto.get(0));
        idSoggetto.setNome((String)listaFieldId_portaApplicativa_soggetto.get(1));
        portaApplicativa.setIdSoggetto(idSoggetto);
        ISQLQueryObject sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo.setANDLogicOperator(true);
        sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo.addFromTable(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO));
        sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo.addSelectField("id");
        sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo.addWhereCondition("id_porta=?");
        List portaApplicativa_portaApplicativaServizioApplicativo_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO, (IJDBCFetch)this.getPortaApplicativaFetch(), new JDBCObject[]{new JDBCObject((Object)portaApplicativa.getId(), Long.class)});
        if (portaApplicativa_portaApplicativaServizioApplicativo_list != null) {
            for (Object portaApplicativa_portaApplicativaServizioApplicativo_object : portaApplicativa_portaApplicativaServizioApplicativo_list) {
                PortaApplicativaServizioApplicativo portaApplicativa_portaApplicativaServizioApplicativo = (PortaApplicativaServizioApplicativo)portaApplicativa_portaApplicativaServizioApplicativo_object;
                ISQLQueryObject sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo_readFkId = sqlQueryObjectGet.newSQLQueryObject();
                sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo_readFkId.addFromTable(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO));
                sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo_readFkId.addSelectField("id_servizio_applicativo");
                sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo_readFkId.addWhereCondition("id=?");
                sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo_readFkId.setANDLogicOperator(true);
                Long idFK_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo_readFkId.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, new JDBCObject[]{new JDBCObject((Object)portaApplicativa_portaApplicativaServizioApplicativo.getId(), Long.class)});
                ISQLQueryObject sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo = sqlQueryObjectGet.newSQLQueryObject();
                sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo.addFromTable("servizi_applicativi");
                sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo.addSelectField("nome");
                sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo.addSelectField("id_soggetto");
                sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo.setANDLogicOperator(true);
                sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo.addWhereCondition("id=?");
                JDBCObject[] searchParams_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo = new JDBCObject[]{new JDBCObject((Object)idFK_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo, Long.class)};
                ArrayList<Class> listaFieldIdReturnType_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo = new ArrayList<Class>();
                listaFieldIdReturnType_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo.add(String.class);
                listaFieldIdReturnType_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo.add(Long.class);
                List listaFieldId_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo, searchParams_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo);
                IdServizioApplicativo idServizioApplicativo = new IdServizioApplicativo();
                idServizioApplicativo.setNome((String)listaFieldId_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo.get(0));
                Long idSoggettoLong = (Long)listaFieldId_portaApplicativa_portaApplicativaServizioApplicativo_servizioApplicativo.get(1);
                IdSoggetto idSoggettoSA = (IdSoggetto)this.jdbcServiceManager.getSoggettoServiceSearch().convertToId((Soggetto)((IDBSoggettoServiceSearch)this.jdbcServiceManager.getSoggettoServiceSearch()).get(idSoggettoLong));
                idServizioApplicativo.setIdSoggetto(idSoggettoSA);
                portaApplicativa_portaApplicativaServizioApplicativo.setIdServizioApplicativo(idServizioApplicativo);
                portaApplicativa.addPortaApplicativaServizioApplicativo(portaApplicativa_portaApplicativaServizioApplicativo);
            }
        }
        ISQLQueryObject sqlQueryObjectGet_portaApplicativa_portaApplicativaAzione = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_portaApplicativa_portaApplicativaAzione.setANDLogicOperator(true);
        sqlQueryObjectGet_portaApplicativa_portaApplicativaAzione.addFromTable(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_AZIONE));
        sqlQueryObjectGet_portaApplicativa_portaApplicativaAzione.addSelectField("id");
        sqlQueryObjectGet_portaApplicativa_portaApplicativaAzione.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().PORTA_APPLICATIVA_AZIONE.NOME, true));
        sqlQueryObjectGet_portaApplicativa_portaApplicativaAzione.addWhereCondition("id_porta=?");
        List portaApplicativa_portaApplicativaAzione_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_portaApplicativa_portaApplicativaAzione.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)PortaApplicativa.model().PORTA_APPLICATIVA_AZIONE, (IJDBCFetch)this.getPortaApplicativaFetch(), new JDBCObject[]{new JDBCObject((Object)portaApplicativa.getId(), Long.class)});
        if (portaApplicativa_portaApplicativaAzione_list != null) {
            for (Object portaApplicativa_portaApplicativaAzione_object : portaApplicativa_portaApplicativaAzione_list) {
                PortaApplicativaAzione portaApplicativa_portaApplicativaAzione = (PortaApplicativaAzione)portaApplicativa_portaApplicativaAzione_object;
                portaApplicativa.addPortaApplicativaAzione(portaApplicativa_portaApplicativaAzione);
            }
        }
        return portaApplicativa;
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this._exists(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private boolean _exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        boolean existsPortaApplicativa = false;
        sqlQueryObject = sqlQueryObject.newSQLQueryObject();
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addFromTable(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model()));
        sqlQueryObject.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().NOME, true));
        sqlQueryObject.addWhereCondition("id=?");
        existsPortaApplicativa = jdbcUtilities.exists(sqlQueryObject.createSQLQuery(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        return existsPortaApplicativa;
    }

    private void joinEngine(IExpression expression, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        String tableName2;
        String tableName1;
        String tableName22;
        String tableName12;
        if (expression.inUseModel((IModel)PortaApplicativa.model().ID_SOGGETTO, false)) {
            tableName12 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model());
            tableName22 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model().ID_SOGGETTO);
            sqlQueryObject.addWhereCondition(tableName12 + ".id_soggetto=" + tableName22 + ".id");
        }
        if (expression.inUseModel((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO, false)) {
            tableName12 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model());
            tableName22 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO);
            sqlQueryObject.addWhereCondition(tableName12 + ".id=" + tableName22 + ".id_porta");
        }
        if (expression.inUseModel((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO, false)) {
            tableName12 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO);
            tableName22 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO);
            sqlQueryObject.addWhereCondition(tableName12 + ".id_servizio_applicativo=" + tableName22 + ".id");
        }
        if (expression.inUseModel((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.ID_SOGGETTO, false)) {
            tableName12 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO);
            tableName22 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.ID_SOGGETTO);
            sqlQueryObject.addWhereCondition(tableName12 + ".id_soggetto=" + tableName22 + ".id");
        }
        if (expression.inUseModel((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_AZIONE, false)) {
            tableName12 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model());
            tableName22 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_AZIONE);
            sqlQueryObject.addWhereCondition(tableName12 + ".id=" + tableName22 + ".id_porta");
        }
        boolean addFromPDSA = false;
        if (expression.inUseModel((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO, false) && !expression.inUseModel((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO, false)) {
            sqlQueryObject.addFromTable(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO));
            tableName1 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model());
            tableName2 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO);
            try {
                sqlQueryObject.addWhereCondition(tableName1 + ".id=" + tableName2 + ".id_porta");
            }
            catch (Exception exception) {
                // empty catch block
            }
            addFromPDSA = true;
        }
        if (expression.inUseModel((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.ID_SOGGETTO, false)) {
            if (!expression.inUseModel((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO, false)) {
                sqlQueryObject.addFromTable(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO));
                tableName1 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO);
                tableName2 = this.getPortaApplicativaFieldConverter().toAliasTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO);
                try {
                    sqlQueryObject.addWhereCondition(tableName1 + ".id_servizio_applicativo=" + tableName2 + ".id");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!addFromPDSA) {
                sqlQueryObject.addFromTable(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO));
            }
        }
    }

    protected List<Object> getRootTablePrimaryKeyValuesEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaApplicativa id) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        ArrayList<Object> rootTableIdValues = new ArrayList<Object>();
        Long longId = this.findIdPortaApplicativa(jdbcProperties, log, connection, sqlQueryObject.newSQLQueryObject(), id, true);
        rootTableIdValues.add(longId);
        return rootTableIdValues;
    }

    protected Map<String, List<IField>> getMapTableToPKColumnEngine() throws NotImplementedException, Exception {
        PortaApplicativaFieldConverter converter = this.getPortaApplicativaFieldConverter();
        HashMap<String, List<IField>> mapTableToPKColumn = new HashMap<String, List<IField>>();
        UtilsTemplate utilities = new UtilsTemplate();
        mapTableToPKColumn.put(converter.toTable((IModel)PortaApplicativa.model()), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaApplicativa.model()))}));
        mapTableToPKColumn.put(converter.toTable((IModel)PortaApplicativa.model().ID_SOGGETTO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaApplicativa.model().ID_SOGGETTO))}));
        mapTableToPKColumn.put(converter.toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO))}));
        mapTableToPKColumn.put(converter.toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO))}));
        mapTableToPKColumn.put(converter.toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.ID_SOGGETTO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.ID_SOGGETTO))}));
        mapTableToPKColumn.put(converter.toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_AZIONE), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaApplicativa.model().PORTA_APPLICATIVA_AZIONE))}));
        return mapTableToPKColumn;
    }

    public List<Long> findAllTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression) throws ServiceException, NotImplementedException, Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFindAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model());
        this.joinEngine((IExpression)paginatedExpression, sqlQueryObject);
        List listObjects = GenericJDBCUtilities.findAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model(), objectIdClass, (List)listaQuery);
        for (Object object : listObjects) {
            list.add((Long)object);
        }
        return list;
    }

    public long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, Exception {
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFind((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model());
        this.joinEngine((IExpression)expression, sqlQueryObject);
        Object res = GenericJDBCUtilities.find((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPortaApplicativaFieldConverter(), (IModel)PortaApplicativa.model(), objectIdClass, (List)listaQuery);
        if (res != null && (Long)res > 0L) {
            return (Long)res;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private InUse inUseEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        InUse inUse = new InUse();
        inUse.setInUse(false);
        boolean throwNotImplemented = true;
        if (throwNotImplemented) {
            throw new NotImplementedException("NotImplemented");
        }
        return inUse;
    }

    public IdPortaApplicativa findId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectGet.addFromTable(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model()));
        sqlQueryObjectGet.addSelectField(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().NOME, true));
        sqlQueryObjectGet.setANDLogicOperator(true);
        sqlQueryObjectGet.addWhereCondition("id=?");
        JDBCObject[] searchParams_portaApplicativa = new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)};
        ArrayList<Class<String>> listaFieldIdReturnType_portaApplicativa = new ArrayList<Class<String>>();
        listaFieldIdReturnType_portaApplicativa.add(String.class);
        IdPortaApplicativa id_portaApplicativa = null;
        List listaFieldId_portaApplicativa = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_portaApplicativa, searchParams_portaApplicativa);
        if (listaFieldId_portaApplicativa == null || listaFieldId_portaApplicativa.size() <= 0) {
            if (throwNotFound) {
                throw GenericJDBCUtilities.newNotFoundException();
            }
        } else {
            id_portaApplicativa = new IdPortaApplicativa();
            id_portaApplicativa.setNome((String)listaFieldId_portaApplicativa.get(0));
        }
        return id_portaApplicativa;
    }

    public Long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaApplicativa id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        return this.findIdPortaApplicativa(jdbcProperties, log, connection, sqlQueryObject, id, throwNotFound);
    }

    public List<List<Object>> nativeQuery(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String sql, List<Class<?>> returnClassTypes, Object ... param) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeQuery((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)sql, returnClassTypes, (Object[])param);
    }

    protected Long findIdPortaApplicativa(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaApplicativa id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        Long id_portaApplicativa;
        block5: {
            JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
            ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
            if (id == null) {
                throw new ServiceException("Id not defined");
            }
            if (id.getNome() == null) {
                throw new ServiceException("Id.nome not defined");
            }
            sqlQueryObjectGet.addFromTable(this.getPortaApplicativaFieldConverter().toTable((IModel)PortaApplicativa.model()));
            sqlQueryObjectGet.addSelectField("id");
            sqlQueryObjectGet.setANDLogicOperator(true);
            sqlQueryObjectGet.setSelectDistinct(true);
            sqlQueryObjectGet.addWhereCondition(this.getPortaApplicativaFieldConverter().toColumn(PortaApplicativa.model().NOME, true) + "=?");
            JDBCObject[] searchParams_portaApplicativa = new JDBCObject[]{new JDBCObject((Object)id.getNome(), String.class)};
            id_portaApplicativa = null;
            try {
                id_portaApplicativa = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, searchParams_portaApplicativa);
            }
            catch (NotFoundException notFound) {
                if (!throwNotFound) break block5;
                throw new NotFoundException((Throwable)notFound);
            }
        }
        if ((id_portaApplicativa == null || id_portaApplicativa <= 0L) && throwNotFound) {
            throw GenericJDBCUtilities.newNotFoundException();
        }
        return id_portaApplicativa;
    }
}

