/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons.dao;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.core.commons.dao.DAOFactoryException;
import org.openspcoop2.core.commons.dao.DAOFactoryInstanceProperties;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.utils.TipiDatabase;
import org.slf4j.Logger;

public class DAOFactoryProperties {
    private static DAOFactoryProperties daoFactoryProperties = null;
    private DAOFactoryInstanceProperties reader;
    private static final String PREFIX_FACTORY = "factory.";
    private static final String PROP_TIPO_DATABASE = "db.tipoDatabase";
    private static final String PROP_SHOW_SQL = "db.showSql";
    private static final String PROP_GENERATE_DDL = "db.generateDDL";
    private static final String PROP_AUTO_COMMIT = "db.autoCommit";
    private static final String PROP_SECONDS_TO_REFRESH_CONNECTION = "db.secondsToRefreshConnection";
    private static final String PROP_TIPO = "db.tipo";
    protected static final String PROP_TIPO_VALUE_DATASOURCE = "datasource";
    protected static final String PROP_TIPO_VALUE_CONNECTION = "connection";
    private static final String PROP_DATASOURCE_JNDI_NAME = "db.datasource.jndiName";
    private static final String PROP_DATASOURCE_JNDI_CONTEXT = "db.datasource.jndiContext";
    private static final String PROP_CONNECTION_URL = "db.connection.url";
    private static final String PROP_CONNECTION_DRIVER = "db.connection.driver";
    private static final String PROP_CONNECTION_AUTH_USER = "db.connection.user";
    private static final String PROP_CONNECTION_AUTH_PASSWORD = "db.connection.password";

    private static synchronized void initialize(Logger log) throws Exception {
        if (daoFactoryProperties == null) {
            daoFactoryProperties = new DAOFactoryProperties(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DAOFactoryProperties getInstance(Logger log) throws Exception {
        if (daoFactoryProperties != null) return daoFactoryProperties;
        Class<DAOFactoryProperties> clazz = DAOFactoryProperties.class;
        synchronized (DAOFactoryProperties.class) {
            DAOFactoryProperties.initialize(log);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return daoFactoryProperties;
        }
    }

    protected DAOFactoryProperties(Logger log) throws Exception {
        Properties propertiesReaded = new Properties();
        InputStream propertiesInternal = null;
        try {
            propertiesInternal = DAOFactoryProperties.class.getResourceAsStream("/daoFactory.internal.properties");
            if (propertiesInternal == null) {
                throw new Exception("Properties daoFactory.internal.properties not found");
            }
            propertiesReaded.load(propertiesInternal);
            propertiesInternal.close();
        }
        catch (IOException e) {
            log.error("Riscontrato errore durante la lettura del file 'daoFactory.internal.properties': " + e.getMessage(), (Throwable)e);
            try {
                if (propertiesInternal != null) {
                    propertiesInternal.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        InputStream properties = null;
        try {
            properties = DAOFactoryProperties.class.getResourceAsStream("/daoFactory.properties");
            if (properties != null) {
                Properties tmp = new Properties();
                tmp.load(properties);
                properties.close();
                if (tmp.size() > 0) {
                    for (Object oKey : tmp.keySet()) {
                        if (!(oKey instanceof String)) continue;
                        String key = (String)oKey;
                        String value = tmp.getProperty(key);
                        if (propertiesReaded.containsKey(key)) {
                            propertiesReaded.remove(key);
                        }
                        propertiesReaded.setProperty(key, value);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Riscontrato errore durante la lettura del file 'daoFactory.properties': " + e.getMessage(), (Throwable)e);
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        try {
            this.reader = new DAOFactoryInstanceProperties(propertiesReaded, log);
        }
        catch (Exception e) {
            throw new DAOFactoryException(e.getMessage(), e);
        }
    }

    private String getProperty(String name, boolean required, boolean convertEnvProperty) throws Exception {
        String tmp = null;
        tmp = convertEnvProperty ? this.reader.getValueConvertEnvProperties(name) : this.reader.getValue(name);
        if (tmp == null && required) {
            throw new Exception("Property [" + name + "] not found");
        }
        if (tmp != null) {
            return tmp.trim();
        }
        return null;
    }

    public String getDAOClassName(IProjectInfo tipoDAO) throws Exception {
        return this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName(), true, false);
    }

    public String getTipoDatabase(IProjectInfo tipoDAO) throws Exception {
        String v = this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.tipoDatabase", false, false);
        if (v == null) {
            v = this.getProperty(PROP_TIPO_DATABASE, true, false);
        }
        return v;
    }

    public TipiDatabase getTipoDatabaseEnum(IProjectInfo tipoDAO) throws Exception {
        return TipiDatabase.toEnumConstant((String)this.getTipoDatabase(tipoDAO));
    }

    public boolean isShowSql(IProjectInfo tipoDAO) throws Exception {
        String v = this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.showSql", false, false);
        if (v == null) {
            v = this.getProperty(PROP_SHOW_SQL, true, false);
        }
        return Boolean.parseBoolean(v);
    }

    public boolean isGenerateDDL(IProjectInfo tipoDAO) throws Exception {
        String v = this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.generateDDL", false, false);
        if (v == null) {
            v = this.getProperty(PROP_GENERATE_DDL, true, false);
        }
        return Boolean.parseBoolean(v);
    }

    public boolean isAutoCommit(IProjectInfo tipoDAO) throws Exception {
        String v = this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.autoCommit", false, false);
        if (v == null) {
            v = this.getProperty(PROP_AUTO_COMMIT, true, false);
        }
        return Boolean.parseBoolean(v);
    }

    public int getSecondsToRefreshConnection(IProjectInfo tipoDAO) throws Exception {
        String v = this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.secondsToRefreshConnection", false, false);
        if (v == null) {
            v = this.getProperty(PROP_SECONDS_TO_REFRESH_CONNECTION, true, false);
        }
        return Integer.parseInt(v);
    }

    public ServiceManagerProperties getServiceManagerProperties(IProjectInfo tipoDAO) throws Exception {
        ServiceManagerProperties sm = new ServiceManagerProperties();
        sm.setDatabaseType(this.getTipoDatabase(tipoDAO));
        sm.setShowSql(this.isShowSql(tipoDAO));
        sm.setGenerateDdl(this.isGenerateDDL(tipoDAO));
        sm.setAutomaticTransactionManagement(this.isAutoCommit(tipoDAO));
        sm.setSecondsToRefreshConnection(this.getSecondsToRefreshConnection(tipoDAO));
        return sm;
    }

    protected String getTipoAccessoDatabase(IProjectInfo tipoDAO) throws Exception {
        String v = this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.tipo", false, true);
        if (v == null) {
            v = this.getProperty(PROP_TIPO, true, true);
        }
        if (!PROP_TIPO_VALUE_DATASOURCE.equals(v) && !PROP_TIPO_VALUE_CONNECTION.equals(v)) {
            throw new Exception("Tipo di accesso al database fornito [" + v + "] non valido (supportati datasource,connection)");
        }
        return v;
    }

    public boolean isTipoAccessoTramiteDatasource(IProjectInfo tipoDAO) throws Exception {
        return PROP_TIPO_VALUE_DATASOURCE.equals(this.getTipoAccessoDatabase(tipoDAO));
    }

    public boolean isTipoAccessoTramiteConnection(IProjectInfo tipoDAO) throws Exception {
        return PROP_TIPO_VALUE_CONNECTION.equals(this.getTipoAccessoDatabase(tipoDAO));
    }

    public String getDatasourceJNDIName(IProjectInfo tipoDAO) throws Exception {
        String v = this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.datasource.jndiName", false, true);
        if (v == null) {
            v = this.getProperty(PROP_DATASOURCE_JNDI_NAME, PROP_TIPO_VALUE_DATASOURCE.equals(this.getTipoAccessoDatabase(tipoDAO)), true);
        }
        return v;
    }

    public Properties getDatasourceJNDIContext(IProjectInfo tipoDAO) throws Exception {
        Properties p = this.reader.readPropertiesConvertEnvProperties(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.datasource.jndiContext");
        if (p == null || p.size() <= 0) {
            p = this.reader.readPropertiesConvertEnvProperties(PROP_DATASOURCE_JNDI_CONTEXT);
        }
        return p;
    }

    public String getConnectionUrl(IProjectInfo tipoDAO) throws Exception {
        String v = this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.connection.url", false, true);
        if (v == null) {
            v = this.getProperty(PROP_CONNECTION_URL, true, true);
        }
        return v;
    }

    public String getConnectionDriverJDBC(IProjectInfo tipoDAO) throws Exception {
        String v = this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.connection.driver", false, true);
        if (v == null) {
            v = this.getProperty(PROP_CONNECTION_DRIVER, PROP_TIPO_VALUE_CONNECTION.equals(this.getTipoAccessoDatabase(tipoDAO)), true);
        }
        return v;
    }

    public String getConnectionAuthUsername(IProjectInfo tipoDAO) throws Exception {
        String v = this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.connection.user", false, true);
        if (v == null) {
            v = this.getProperty(PROP_CONNECTION_AUTH_USER, PROP_TIPO_VALUE_CONNECTION.equals(this.getTipoAccessoDatabase(tipoDAO)), true);
        }
        return v;
    }

    public String getConnectionAuthPassword(IProjectInfo tipoDAO) throws Exception {
        String v = this.getProperty(PREFIX_FACTORY + tipoDAO.getProjectName() + ".db.connection.password", false, true);
        if (v == null) {
            v = this.getProperty(PROP_CONNECTION_AUTH_PASSWORD, PROP_TIPO_VALUE_CONNECTION.equals(this.getTipoAccessoDatabase(tipoDAO)), true);
        }
        return v;
    }
}

