/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client;

import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.w3c.dom.Node;

@MessageLogger(projectCode="AMQ")
public interface ActiveMQClientLogger
extends BasicLogger {
    public static final ActiveMQClientLogger LOGGER = (ActiveMQClientLogger)Logger.getMessageLogger(ActiveMQClientLogger.class, (String)ActiveMQClientLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=211000, value="**** Dumping session creation stacks ****", format=Message.Format.MESSAGE_FORMAT)
    public void dumpingSessionStacks();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=211001, value="session created", format=Message.Format.MESSAGE_FORMAT)
    public void dumpingSessionStack(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212000, value="{0}", format=Message.Format.MESSAGE_FORMAT)
    public void warn(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212001, value="Error on clearing messages", format=Message.Format.MESSAGE_FORMAT)
    public void errorClearingMessages(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212002, value="Timed out waiting for handler to complete processing", format=Message.Format.MESSAGE_FORMAT)
    public void timeOutWaitingForProcessing();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212003, value="Unable to close session", format=Message.Format.MESSAGE_FORMAT)
    public void unableToCloseSession(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212004, value="Failed to connect to server.", format=Message.Format.MESSAGE_FORMAT)
    public void failedToConnectToServer();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212005, value="Tried {0} times to connect. Now giving up on reconnecting it.", format=Message.Format.MESSAGE_FORMAT)
    public void failedToConnectToServer(Integer var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212007, value="connector.create or connectorFactory.createConnector should never throw an exception, implementation is badly behaved, but we will deal with it anyway.", format=Message.Format.MESSAGE_FORMAT)
    public void createConnectorException(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212008, value="I am closing a core ClientSessionFactory you left open. Please make sure you close all ClientSessionFactories explicitly before letting them go out of scope! {0}", format=Message.Format.MESSAGE_FORMAT)
    public void factoryLeftOpen(@Cause Exception var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212009, value="resetting session after failure", format=Message.Format.MESSAGE_FORMAT)
    public void resettingSessionAfterFailure();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212010, value="Server is starting, retry to create the session {0}", format=Message.Format.MESSAGE_FORMAT)
    public void retryCreateSessionSeverStarting(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212011, value="committing transaction after failover occurred, any non persistent messages may be lost", format=Message.Format.MESSAGE_FORMAT)
    public void commitAfterFailover();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212012, value="failure occurred during commit throwing XAException", format=Message.Format.MESSAGE_FORMAT)
    public void failoverDuringCommit();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212014, value="failover occurred during prepare rolling back", format=Message.Format.MESSAGE_FORMAT)
    public void failoverDuringPrepareRollingBack();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212015, value="failover occurred during prepare rolling back", format=Message.Format.MESSAGE_FORMAT)
    public void errorDuringPrepare(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212016, value="I am closing a core ClientSession you left open. Please make sure you close all ClientSessions explicitly before letting them go out of scope! {0}", format=Message.Format.MESSAGE_FORMAT)
    public void clientSessionNotClosed(@Cause Exception var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212017, value="error adding packet", format=Message.Format.MESSAGE_FORMAT)
    public void errorAddingPacket(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212018, value="error calling cancel", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingCancel(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212019, value="error reading index", format=Message.Format.MESSAGE_FORMAT)
    public void errorReadingIndex(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212020, value="error setting index", format=Message.Format.MESSAGE_FORMAT)
    public void errorSettingIndex(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212021, value="error resetting index", format=Message.Format.MESSAGE_FORMAT)
    public void errorReSettingIndex(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212022, value="error reading LargeMessage file cache", format=Message.Format.MESSAGE_FORMAT)
    public void errorReadingCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212023, value="error closing LargeMessage file cache", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212024, value="Exception during finalization for LargeMessage file cache", format=Message.Format.MESSAGE_FORMAT)
    public void errorFinalisingCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212025, value="did not connect the cluster connection to other nodes", format=Message.Format.MESSAGE_FORMAT)
    public void errorConnectingToNodes(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212026, value="Timed out waiting for pool to terminate", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutWaitingForTermination();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212027, value="Timed out waiting for scheduled pool to terminate", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutWaitingForScheduledPoolTermination();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212028, value="error starting server locator", format=Message.Format.MESSAGE_FORMAT)
    public void errorStartingLocator(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=212029, value="Closing a Server Locator left open. Please make sure you close all Server Locators explicitly before letting them go out of scope! {0}", format=Message.Format.MESSAGE_FORMAT)
    public void serverLocatorNotClosed(@Cause Exception var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212030, value="error sending topology", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingTopology(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212031, value="error sending topology", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingTopologyNodedown(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212032, value="Timed out waiting to stop discovery thread", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutStoppingDiscovery();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212033, value="unable to send notification when discovery group is stopped", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingNotifOnDiscoveryStop(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212034, value="There are more than one servers on the network broadcasting the same node id. You will see this message exactly once (per node) if a node is restarted, in which case it can be safely ignored. But if it is logged continuously it means you really do have more than one node on the same network active concurrently with the same node id. This could occur if you have a backup node active at the same time as its live node. nodeID={0}", format=Message.Format.MESSAGE_FORMAT)
    public void multipleServersBroadcastingSameNode(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212035, value="error receiving packet in discovery", format=Message.Format.MESSAGE_FORMAT)
    public void errorReceivingPacketInDiscovery(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212036, value="Can not find packet to clear: {0} last received command id first stored command id {1}", format=Message.Format.MESSAGE_FORMAT)
    public void cannotFindPacketToClear(Integer var1, Integer var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212037, value="Connection failure has been detected: {0} [code={1}]", format=Message.Format.MESSAGE_FORMAT)
    public void connectionFailureDetected(String var1, ActiveMQExceptionType var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212038, value="Failure in calling interceptor: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingInterceptor(@Cause Throwable var1, Interceptor var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212040, value="Timed out waiting for netty ssl close future to complete", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutClosingSSL();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212041, value="Timed out waiting for netty channel to close", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutClosingNettyChannel();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212042, value="Timed out waiting for packet to be flushed", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutFlushingPacket();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212043, value="Property {0} must be an Integer, it is {1}", format=Message.Format.MESSAGE_FORMAT)
    public void propertyNotInteger(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212044, value="Property {0} must be a Long, it is {1}", format=Message.Format.MESSAGE_FORMAT)
    public void propertyNotLong(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212045, value="Property {0} must be a Boolean, it is {1}", format=Message.Format.MESSAGE_FORMAT)
    public void propertyNotBoolean(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212046, value="Cannot find activemq-version.properties on classpath: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void noVersionOnClasspath(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212047, value="Warning: JVM allocated more data what would make results invalid {0}:{1}", format=Message.Format.MESSAGE_FORMAT)
    public void jvmAllocatedMoreMemory(Long var1, Long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212048, value="Random address ({0}) was already in use, trying another time", format=Message.Format.MESSAGE_FORMAT)
    public void broadcastGroupBindErrorRetry(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212049, value="Could not bind to {0} ({1} address); make sure your discovery group-address is of the same type as the IP stack (IPv4 or IPv6).\nIgnoring discovery group-address, but this may lead to cross talking.", format=Message.Format.MESSAGE_FORMAT)
    public void ioDiscoveryError(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212050, value="Compressed large message tried to read {0} bytes from stream {1}", format=Message.Format.MESSAGE_FORMAT)
    public void compressedLargeMessageError(int var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212051, value="Invalid concurrent session usage. Sessions are not supposed to be used by more than one thread concurrently.", format=Message.Format.MESSAGE_FORMAT)
    public void invalidConcurrentSessionUsage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212052, value="Packet {0} was answered out of sequence due to a previous server timeout and it''s being ignored", format=Message.Format.MESSAGE_FORMAT)
    public void packetOutOfOrder(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212053, value="CompletionListener/SendAcknowledgementHandler used with confirmationWindowSize=-1. Enable confirmationWindowSize to receive acks from server!", format=Message.Format.MESSAGE_FORMAT)
    public void confirmationWindowDisabledWarning();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212054, value="Destination address={0} is blocked. If the system is configured to block make sure you consume messages on this configuration.", format=Message.Format.MESSAGE_FORMAT)
    public void outOfCreditOnFlowControl(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212055, value="Unable to close consumer", format=Message.Format.MESSAGE_FORMAT)
    public void unableToCloseConsumer(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212056, value="local-bind-address specified for broadcast group but no local-bind-port. Using random port for UDP Broadcast ({0})", format=Message.Format.MESSAGE_FORMAT)
    public void broadcastGroupBindError(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212057, value="Large Message Streaming is taking too long to flush on back pressure.", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutStreamingLargeMessage();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214000, value="Failed to call onMessage", format=Message.Format.MESSAGE_FORMAT)
    public void onMessageError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214001, value="failed to cleanup session", format=Message.Format.MESSAGE_FORMAT)
    public void failedToCleanupSession(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214002, value="Failed to execute failure listener", format=Message.Format.MESSAGE_FORMAT)
    public void failedToExecuteListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214003, value="Failed to handle failover", format=Message.Format.MESSAGE_FORMAT)
    public void failedToHandleFailover(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214004, value="XA end operation failed ", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingEnd(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214005, value="XA start operation failed {0} code:{1}", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingStart(String var1, Integer var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214006, value="Session is not XA", format=Message.Format.MESSAGE_FORMAT)
    public void sessionNotXA();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214007, value="Received exception asynchronously from server", format=Message.Format.MESSAGE_FORMAT)
    public void receivedExceptionAsynchronously(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214008, value="Failed to handle packet", format=Message.Format.MESSAGE_FORMAT)
    public void failedToHandlePacket(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214009, value="Failed to stop discovery group", format=Message.Format.MESSAGE_FORMAT)
    public void failedToStopDiscovery(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214010, value="Failed to receive datagram", format=Message.Format.MESSAGE_FORMAT)
    public void failedToReceiveDatagramInDiscovery(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214011, value="Failed to call discovery listener", format=Message.Format.MESSAGE_FORMAT)
    public void failedToCallListenerInDiscovery(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214012, value="Unexpected error handling packet {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorHandlingPacket(@Cause Throwable var1, Packet var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214013, value="Failed to decode packet", format=Message.Format.MESSAGE_FORMAT)
    public void errorDecodingPacket(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214014, value="Failed to execute failure listener", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingFailureListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214015, value="Failed to execute connection life cycle listener", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingLifeCycleListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214016, value="Failed to create netty connection", format=Message.Format.MESSAGE_FORMAT)
    public void errorCreatingNettyConnection(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214017, value="Caught unexpected Throwable", format=Message.Format.MESSAGE_FORMAT)
    public void caughtunexpectedThrowable(@Cause Throwable var1);

    @Deprecated
    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214018, value="Failed to invoke getTextContent() on node {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorOnXMLTransform(@Cause Throwable var1, Node var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214019, value="Invalid configuration", format=Message.Format.MESSAGE_FORMAT)
    public void errorOnXMLTransformInvalidConf(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214020, value="Exception happened while stopping Discovery BroadcastEndpoint {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingDiscoveryBroadcastEndpoint(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214021, value="Invalid cipher suite specified. Supported cipher suites are: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void invalidCipherSuite(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214022, value="Invalid protocol specified. Supported protocols are: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void invalidProtocol(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=214023, value="HTTP Handshake failed, received %s")
    public void httpHandshakeFailed(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214024, value="HTTP upgrade not supported by remote acceptor")
    public void httpUpgradeNotSupportedByRemoteAcceptor();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214025, value="Invalid type {0}, Using default connection factory at {1}", format=Message.Format.MESSAGE_FORMAT)
    public void invalidCFType(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=214026, value="Failure captured on connectionID={0}, performing failover or reconnection now", format=Message.Format.MESSAGE_FORMAT)
    public void failoverOrReconnect(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=214027, value="Replaying commands for channelID={0} with lastCommandID from the server={1}", format=Message.Format.MESSAGE_FORMAT)
    public void replayingCommands(Object var1, int var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=214028, value="Couldn't reattach session {0}, performing as a failover operation now and recreating objects", format=Message.Format.MESSAGE_FORMAT)
    public void reconnectCreatingNewSession(long var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214029, value="Unexpected response from HTTP server: %s")
    public void unexpectedResponseFromHttpServer(Object var1);
}

