/*
 * Decompiled with CFR 0.152.
 */
package com.kendelong.web.jmxconsole;

import com.kendelong.web.jmxconsole.MBeanAttribute;
import com.kendelong.web.jmxconsole.OperationInfoComparator;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class ShowBeanData
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MBeanInfo mbeanInfo;
        ObjectInstance objectInstance;
        String beanName = request.getParameter("beanName");
        ArrayList<MBeanAttribute> attributes = new ArrayList<MBeanAttribute>();
        ArrayList<MBeanFeatureInfo> operations = new ArrayList<MBeanFeatureInfo>();
        try {
            MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
            ObjectName oname = new ObjectName(beanName);
            objectInstance = server.queryMBeans(oname, null).iterator().next();
            mbeanInfo = server.getMBeanInfo(oname);
            for (MBeanAttributeInfo mBeanAttributeInfo : mbeanInfo.getAttributes()) {
                String attrName = mBeanAttributeInfo.getName();
                Object value = server.getAttribute(oname, attrName);
                MBeanAttribute mba = new MBeanAttribute(mBeanAttributeInfo, value);
                attributes.add(mba);
            }
            Collections.sort(attributes);
            for (MBeanFeatureInfo mBeanFeatureInfo : mbeanInfo.getOperations()) {
                operations.add(mBeanFeatureInfo);
            }
            Collections.sort(operations, new OperationInfoComparator());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        request.setAttribute("instance", (Object)objectInstance);
        request.setAttribute("info", (Object)mbeanInfo);
        request.setAttribute("attributes", attributes);
        request.setAttribute("operations", operations);
        request.getRequestDispatcher("showBeanData.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

