/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TypedCollections {
    TypedCollections() {
    }

    private static boolean checkCollectionMembers(Collection<?> c, Class<?> type) {
        for (Object element : c) {
            if (element == null || type.isInstance(element)) continue;
            return false;
        }
        return true;
    }

    static <E, TypedC extends Collection<E>> TypedC dynamicallyCastCollection(Collection<?> c, Class<E> type, Class<TypedC> collectionType) {
        if (c == null) {
            return null;
        }
        if (!collectionType.isInstance(c)) {
            throw new ClassCastException(c.getClass().getName());
        }
        assert (TypedCollections.checkCollectionMembers(c, type)) : "The collection contains members with a type other than " + type.getName();
        return (TypedC)((Collection)collectionType.cast(c));
    }

    static <E> List<E> dynamicallyCastList(List<?> list, Class<E> type) {
        return TypedCollections.dynamicallyCastCollection(list, type, List.class);
    }

    static <E> Set<E> dynamicallyCastSet(Set<?> set, Class<E> type) {
        return TypedCollections.dynamicallyCastCollection(set, type, Set.class);
    }

    static <K, V> Map<K, V> dynamicallyCastMap(Map<?, ?> map, Class<K> keyType, Class<V> valueType) {
        if (map == null) {
            return null;
        }
        assert (TypedCollections.checkCollectionMembers(map.keySet(), keyType)) : "The map contains keys with a type other than " + keyType.getName();
        assert (TypedCollections.checkCollectionMembers(map.values(), valueType)) : "The map contains values with a type other than " + valueType.getName();
        return map;
    }
}

