/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.LayoutStructure;
import org.richfaces.component.UILayout;

public class LayoutRenderer
extends RendererBase {
    public static final String LAYOUT_STRUCTURE_ATTRIBUTE = UILayout.class.getName() + ".structure";
    private static final Object[] LAYOUT_EXCLUSIONS = new Object[]{"id", "style"};
    private String uuid;

    public String getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString().replace("-", "");
        }
        return this.uuid;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.startElement("div", component);
        this.getUtils().encodeCustomId(context, component);
        this.getUtils().encodePassThruWithExclusionsArray(context, component, LAYOUT_EXCLUSIONS);
        Object style = component.getAttributes().get("style");
        if (style != null) {
            writer.writeAttribute("class", (Object)("css-" + this.getUuid()), null);
        }
    }

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.renderLayout(writer, context, (UILayout)component);
    }

    public void renderLayout(ResponseWriter writer, FacesContext context, UILayout layout) throws IOException {
        LayoutStructure structure = new LayoutStructure(layout);
        structure.calculateWidth();
        Map requestMap = context.getExternalContext().getRequestMap();
        Object oldLayout = requestMap.get(LAYOUT_STRUCTURE_ATTRIBUTE);
        requestMap.put(LAYOUT_STRUCTURE_ATTRIBUTE, structure);
        if (null != structure.getTop()) {
            structure.getTop().encodeAll(context);
        }
        if (structure.getColumns() > 0) {
            if (null != structure.getLeft()) {
                structure.getLeft().encodeAll(context);
            }
            if (null != structure.getCenter()) {
                structure.getCenter().encodeAll(context);
            }
            if (null != structure.getRight()) {
                structure.getRight().encodeAll(context);
            }
        }
        writer.startElement("div", (UIComponent)layout);
        writer.writeAttribute("class", (Object)("css-layout-" + this.getUuid()), null);
        writer.writeText((Object)".", null);
        writer.endElement("div");
        writer.startElement("style", (UIComponent)layout);
        writer.writeAttribute("type", (Object)"text/css", null);
        String cspValue = RendererUtils.getCspNonceValue((FacesContext)context);
        if (cspValue != null) {
            writer.writeAttribute("nonce", (Object)cspValue, null);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(".").append("css-layout-").append(this.getUuid()).append(" {\n").append("display: block; height: 0;line-height:0px; font-size:0px; clear: both; visibility: hidden;").append("}\n");
        writer.writeText((Object)sb.toString(), null);
        writer.endElement("style");
        if (null != structure.getBottom()) {
            this.renderChild(context, (UIComponent)structure.getBottom());
        }
        requestMap.put(LAYOUT_STRUCTURE_ATTRIBUTE, oldLayout);
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("div");
        Object style = component.getAttributes().get("style");
        if (style != null) {
            writer.startElement("style", component);
            writer.writeAttribute("type", (Object)"text/css", null);
            String cspValue = RendererUtils.getCspNonceValue((FacesContext)context);
            if (cspValue != null) {
                writer.writeAttribute("nonce", (Object)cspValue, null);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(".").append("css-").append(this.getUuid()).append(" {\n").append(style.toString()).append(";\n").append("zoom:1;\n").append("}\n");
            writer.writeText((Object)sb.toString(), null);
            writer.endElement("style");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UILayout.class;
    }
}

