/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.TabEncoder;
import org.richfaces.component.UITab;
import org.richfaces.component.UITabPanel;

public class TabRendererBase
extends RendererBase
implements TabEncoder {
    private RendererBase tabHeaderRenderer;

    private synchronized RendererBase getHeaderRenderer() {
        if (this.tabHeaderRenderer == null) {
            Package pkg = this.getClass().getPackage();
            try {
                this.tabHeaderRenderer = (RendererBase)Class.forName(pkg.getName() + ".TabHeaderRenderer").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new FacesException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FacesException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new FacesException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new FacesException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new FacesException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new FacesException((Throwable)e);
            }
            catch (SecurityException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return this.tabHeaderRenderer;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        UITab tab = (UITab)component;
        UITabPanel panel = tab.getPane();
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (AjaxRendererUtils.isAjaxRequest((FacesContext)context) && tab.getSwitchTypeOrDefault().equals("ajax") && requestParameterMap.get(tab.getClientId(context)) != null) {
            AjaxRendererUtils.addRegionByName((FacesContext)context, (UIComponent)panel, (String)panel.getId());
            AjaxRendererUtils.addRegionsFromComponent((UIComponent)tab, (FacesContext)context);
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
            HashSet<String> toProcess = ajaxContext.getAjaxAreasToProcess();
            if (toProcess == null) {
                toProcess = new HashSet<String>(1);
                ajaxContext.setAjaxAreasToProcess(toProcess);
            }
            toProcess.add(panel.getClientId(context));
            ajaxContext.addAreasToProcessFromComponent(context, (UIComponent)tab);
        }
    }

    @Override
    public void encodeTab(FacesContext context, UITab tab, boolean active) throws IOException {
        this.getHeaderRenderer().encodeBegin(context, (UIComponent)tab);
        this.getHeaderRenderer().encodeEnd(context, (UIComponent)tab);
    }

    public String getTabDisplay(FacesContext context, UITab tab) {
        if (!tab.isActive()) {
            return "display: none;";
        }
        return "";
    }

    protected boolean shouldRenderTab(UITab tab) {
        String method = tab.getSwitchTypeOrDefault();
        return tab.isActive() || !tab.isDisabled() && "client".equals(method);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UITab tab = (UITab)component;
        if (this.shouldRenderTab(tab)) {
            super.encodeBegin(context, component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        UITab tab = (UITab)component;
        if (this.shouldRenderTab(tab)) {
            super.encodeEnd(context, component);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UITab tab = (UITab)component;
        if (this.shouldRenderTab(tab)) {
            if (tab.getChildren() != null && tab.getChildren().size() > 0) {
                this.renderChildren(context, component);
            } else {
                ResponseWriter out = context.getResponseWriter();
                out.write("&#160;");
            }
        }
    }

    protected Class<UITab> getComponentClass() {
        return UITab.class;
    }

    public boolean getRendersChildren() {
        return true;
    }
}

