/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.util.InputUtils;
import org.ajax4jsf.util.SelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIComboBox;

public class ComboBoxBaseRenderer
extends HeaderResourcesRendererBase {
    public static final String RICH_COMBOBOX_ITEM_CLASSES = "rich-combobox-item rich-combobox-item-normal";
    private static Log logger = LogFactory.getLog(ComboBoxBaseRenderer.class);

    protected Class<? extends UIComponent> getComponentClass() {
        return UIComboBox.class;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        Map request;
        String newValue;
        UIComboBox comboBox = null;
        if (!(component instanceof UIComboBox)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is not an instance or a sub class of UIComboBox"));
            }
            return;
        }
        comboBox = (UIComboBox)component;
        String clientId = comboBox.getClientId(context);
        if (clientId == null) {
            throw new NullPointerException("component client id is NULL");
        }
        if ((InputUtils.isDisabled((UIComponent)comboBox) || InputUtils.isReadOnly((UIComponent)comboBox)) && logger.isDebugEnabled()) {
            logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is disabled"));
        }
        if ((newValue = (String)(request = context.getExternalContext().getRequestParameterMap()).get(clientId)) != null) {
            comboBox.setSubmittedValue(newValue);
        }
    }

    public List<Object> getItems(FacesContext context, UIComponent component) throws IOException, IllegalArgumentException {
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.isAcceptableComponent(component)) {
            UIComboBox comboBox = (UIComboBox)component;
            values.addAll(this.encodeSuggestionValues(context, comboBox));
            List selectItems = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)component);
            for (SelectItem selectItem : selectItems) {
                String convertedValue = this.getConvertedStringValue(context, component, selectItem.getValue());
                if ("".equals(convertedValue)) {
                    convertedValue = "\u00a0";
                }
                values.add(convertedValue);
            }
        }
        return values;
    }

    public String getReadOnlyValue(Object enableManualInput) {
        return (Boolean)enableManualInput != false ? "readonly" : "";
    }

    public List<Object> encodeSuggestionValues(FacesContext context, UIComboBox combobox) throws IOException, IllegalArgumentException {
        ArrayList<Object> values = new ArrayList<Object>();
        Object suggestionValues = combobox.getSuggestionValues();
        if (suggestionValues != null) {
            if (suggestionValues instanceof Collection) {
                Collection collection = (Collection)suggestionValues;
                for (Object suggestionValue : collection) {
                    String convertedValue = this.getConvertedStringValue(context, (UIComponent)combobox, suggestionValue);
                    values.add(convertedValue);
                }
            } else if (suggestionValues.getClass().isArray()) {
                Object[] suggestions;
                for (Object suggestionValue : suggestions = (Object[])suggestionValues) {
                    String convertedValue = this.getConvertedStringValue(context, (UIComponent)combobox, suggestionValue);
                    values.add(convertedValue);
                }
            } else {
                throw new IllegalArgumentException("suggestionValues should be Collection or Array");
            }
        }
        return values;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return InputUtils.getConvertedValue((FacesContext)context, (UIComponent)component, (Object)submittedValue);
    }

    protected String getConvertedStringValue(FacesContext context, UIComponent component, Object value) {
        return InputUtils.getConvertedStringValue((FacesContext)context, (UIComponent)component, (Object)value);
    }

    protected boolean isAcceptableComponent(UIComponent component) {
        return component != null && this.getComponentClass().isAssignableFrom(component.getClass());
    }
}

