/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import jakarta.el.ELContext;
import jakarta.el.Expression;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.component.SequenceDataAdaptor;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.model.DataComponentState;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.util.ELUtils;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.Column;
import org.richfaces.component.ScriptExportable;
import org.richfaces.component.Selectable;
import org.richfaces.component.Sortable;
import org.richfaces.convert.rowkey.ScrollableDataTableRowKeyConverter;
import org.richfaces.event.AttributeHolder;
import org.richfaces.event.ScrollableGridViewEvent;
import org.richfaces.event.sort.MultiColumnSortListener;
import org.richfaces.event.sort.SingleColumnSortListener;
import org.richfaces.event.sort.SortEvent;
import org.richfaces.event.sort.SortListener;
import org.richfaces.model.DataModelCache;
import org.richfaces.model.Modifiable;
import org.richfaces.model.ModifiableModel;
import org.richfaces.model.Ordering;
import org.richfaces.model.ScrollableTableDataModel;
import org.richfaces.model.ScrollableTableDataRange;
import org.richfaces.model.SelectionMode;
import org.richfaces.model.SortField;
import org.richfaces.model.SortField2;
import org.richfaces.model.SortOrder;
import org.richfaces.renderkit.html.ScrollableDataTableUtils;

public abstract class UIScrollableDataTable
extends SequenceDataAdaptor
implements AjaxComponent,
Sortable,
Selectable,
ScriptExportable {
    public static final String COMPONENT_TYPE = "org.richfaces.component.ScrollableDataTable";
    public static final String SORT_SINGLE = "single";
    public static final String SORT_MULTI = "multi";
    private static final Log log = LogFactory.getLog(UIScrollableDataTable.class);
    private boolean useSavedRanges = true;
    private List<ScrollableTableDataRange> ranges;
    private Collection<String> responseData = new ArrayList<String>();
    private int reqRowsCount = -1;
    private transient boolean keepSaved;
    private String scrollPos;
    private SortListener sortListener;
    private Converter defaultRowKeyConverter = new ScrollableDataTableRowKeyConverter();

    public abstract SortOrder getSortOrder();

    public abstract void setSortOrder(SortOrder var1);

    public Collection<String> getResponseData() {
        return this.responseData;
    }

    public void setResponseData(Collection<String> responseData) {
        this.responseData = responseData;
    }

    protected DataComponentState createComponentState() {
        return new DataComponentState(){

            public Range getRange() {
                int curentRow = UIScrollableDataTable.this.getFirst();
                int rows = UIScrollableDataTable.this.reqRowsCount == -1 ? UIScrollableDataTable.this.getRows() : UIScrollableDataTable.this.reqRowsCount;
                int rowsCount = UIScrollableDataTable.this.getExtendedDataModel().getRowCount();
                if (rows > 0) {
                    if ((rows += curentRow) >= 0) {
                        rows = Math.min(rows, rowsCount);
                    }
                } else {
                    rows = rowsCount >= 0 ? rowsCount : -1;
                }
                return new ScrollableTableDataRange(curentRow, rows, UIScrollableDataTable.this.getSortOrder());
            }
        };
    }

    public void processDecodes(FacesContext faces) {
        this.useSavedRanges = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)"UIScrollableDataTable.processDecodes(faces)");
        }
        this.checkRange();
        super.processDecodes(faces);
    }

    public void processValidators(FacesContext faces) {
        this.useSavedRanges = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)"UIScrollableDataTable.processValidators(faces)");
        }
        super.processValidators(faces);
    }

    public void processUpdates(FacesContext faces) {
        this.useSavedRanges = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)"UIScrollableDataTable.processUpdates(faces)");
        }
        super.processUpdates(faces);
        this.ranges = null;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"UIScrollableDataTable.encodeBegin(context)");
        }
        this.useSavedRanges = false;
        this.checkRange();
        super.encodeBegin(context);
    }

    protected ExtendedDataModel createDataModel() {
        ExtendedDataModel model = super.createDataModel();
        if (model instanceof ScrollableTableDataModel) {
            if (this.isCacheable()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initializing cache of type " + DataModelCache.class));
                }
                model = new DataModelCache((ScrollableTableDataModel)model);
            }
        } else {
            List<SortField2> sortFields = this.getSortFields();
            if (sortFields != null && !sortFields.isEmpty()) {
                Modifiable modifiable = null;
                if (model instanceof Modifiable) {
                    modifiable = (Modifiable)model;
                } else {
                    ModifiableModel modifiableModel = new ModifiableModel(model, this.getVar());
                    model = modifiableModel;
                    modifiable = modifiableModel;
                }
                modifiable.modify(null, sortFields);
            }
        }
        return model;
    }

    private List<SortField2> getSortFields() {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext eLContext = context.getELContext();
        ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
        String var = this.getVar();
        SortOrder sortOrder = this.getSortOrder();
        LinkedList<SortField2> sortFields2 = null;
        if (sortOrder != null) {
            SortField[] sortFields = sortOrder.getFields();
            sortFields2 = new LinkedList<SortField2>();
            for (SortField sortField : sortFields) {
                ValueExpression valueExpression = null;
                String name = sortField.getName();
                if (ELUtils.isValueReference((String)name)) {
                    valueExpression = expressionFactory.createValueExpression(eLContext, name, Object.class);
                } else if (!name.startsWith("j_id")) {
                    valueExpression = expressionFactory.createValueExpression(eLContext, "#{" + var + "." + name + "}", Object.class);
                }
                Ordering ordering = Ordering.UNSORTED;
                Boolean ascending = sortField.getAscending();
                if (ascending != null) {
                    ordering = ascending != false ? Ordering.ASCENDING : Ordering.DESCENDING;
                }
                if (valueExpression == null || Ordering.UNSORTED.equals((Object)ordering)) continue;
                sortFields2.add(new SortField2((Expression)valueExpression, ordering));
            }
        }
        return sortFields2;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.ranges, this.scrollPos, UIScrollableDataTable.saveAttachedState((FacesContext)context, (Object)this.sortListener)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.ranges = (List)values[1];
        this.scrollPos = (String)values[2];
        this.sortListener = (SortListener)UIScrollableDataTable.restoreAttachedState((FacesContext)context, (Object)values[3]);
    }

    protected Iterator<UIComponent> dataChildren() {
        IteratorChain chain = new IteratorChain();
        chain.addIterator(this.getFacets().values().iterator());
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof Column) && !(kid instanceof UIColumn)) continue;
            chain.addIterator(kid.getChildren().iterator());
        }
        return chain;
    }

    protected Iterator<UIComponent> fixedChildren() {
        IteratorChain chain = new IteratorChain(this.getFacets().values().iterator());
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof Column) && !(kid instanceof UIColumn)) continue;
            chain.addIterator(kid.getFacets().values().iterator());
        }
        return chain;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof AttributeHolder) {
            ((AttributeHolder)event).applyAttributes((UIComponent)this);
        }
        if (event instanceof AjaxEvent) {
            AjaxContext.getCurrentInstance().addComponentToAjaxRender((UIComponent)this);
        } else if (event instanceof SortEvent) {
            this.processSortingChange(event);
        } else if (event instanceof ScrollableGridViewEvent) {
            this.processScrolling(event);
        }
    }

    protected boolean broadcastLocal(FacesEvent event) {
        return super.broadcastLocal(event) || event instanceof SortEvent || event instanceof ScrollableGridViewEvent;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof AjaxEvent) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else if (event instanceof SortEvent) {
            new AjaxEvent((UIComponent)this).queue();
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else if (event instanceof ScrollableGridViewEvent) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            new AjaxEvent((UIComponent)this).queue();
        }
        super.queueEvent(event);
    }

    public void processScrolling(FacesEvent event) {
        ScrollableGridViewEvent e = (ScrollableGridViewEvent)event;
        this.setFirst(e.getFirst());
        this.reqRowsCount = e.getRows();
        this.keepSaved = true;
        this.getFacesContext().renderResponse();
    }

    public void processSortingChange(FacesEvent event) {
        SortEvent e = (SortEvent)event;
        this.getSortListener().processSort(e);
        this.setFirst(e.getFirst());
        this.reqRowsCount = e.getRows();
        this.resetDataModel();
        this.getFacesContext().renderResponse();
    }

    private void addRange() {
        ScrollableTableDataRange visitedRange = (ScrollableTableDataRange)this.getComponentState().getRange();
        if (this.ranges == null) {
            this.ranges = new ArrayList<ScrollableTableDataRange>();
        }
        Iterator<ScrollableTableDataRange> iter = this.ranges.iterator();
        ScrollableTableDataRange range = null;
        while (iter.hasNext() && range == null) {
            ScrollableTableDataRange temp = iter.next();
            if (temp.getLast() < visitedRange.getFirst()) continue;
            range = temp;
        }
        if (range != null) {
            if (range.getFirst() > visitedRange.getLast()) {
                this.ranges.add(0, visitedRange);
            } else {
                if (range.getFirst() > visitedRange.getFirst()) {
                    range.setFirst(visitedRange.getFirst());
                }
                if (range.getLast() < visitedRange.getLast()) {
                    ScrollableTableDataRange nextRange = null;
                    if (iter.hasNext()) {
                        nextRange = iter.next();
                    }
                    if (nextRange != null && nextRange.getFirst() <= visitedRange.getLast()) {
                        range.setLast(nextRange.getLast());
                    } else {
                        range.setLast(visitedRange.getLast());
                    }
                }
            }
        } else {
            this.ranges.add(visitedRange);
        }
    }

    public void walk(FacesContext faces, DataVisitor visitor, Object argument) throws IOException {
        this.addRange();
        if (this.useSavedRanges) {
            for (ScrollableTableDataRange range : this.ranges) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Range is: " + range.getFirst() + " - " + range.getLast() + " sortOrder: " + range.getSortOrder()));
                }
                this.getExtendedDataModel().walk(faces, visitor, (Range)range, argument);
            }
        } else {
            super.walk(faces, visitor, argument);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
    }

    public boolean isCacheable() {
        return true;
    }

    public String getScrollPos() {
        return this.scrollPos;
    }

    public void setScrollPos(String scrollPos) {
        this.scrollPos = scrollPos;
    }

    public SortListener getSortListener() {
        if (this.sortListener != null) {
            return this.sortListener;
        }
        if (SORT_MULTI.equals(this.getSortMode())) {
            return MultiColumnSortListener.INSTANCE;
        }
        return SingleColumnSortListener.INSTANCE;
    }

    public void setSortListener(SortListener sortListener) {
        this.sortListener = sortListener;
    }

    public abstract String getSortMode();

    public abstract void setSortMode(String var1);

    public abstract SelectionMode getSelectionMode();

    public abstract void setSelectionMode(SelectionMode var1);

    public boolean isSelectionEnabled() {
        return this.getSelectionMode().isSelectionEnabled();
    }

    public abstract Object getActiveRowKey();

    public abstract void setActiveRowKey(Object var1);

    public void setRowIndex(int index) {
        if (index < 0) {
            this.setRowKey(null);
        }
    }

    public void resetReqRowsCount() {
        this.reqRowsCount = -1;
    }

    private void checkRange() {
        int rows = this.reqRowsCount == -1 ? this.getRows() : this.reqRowsCount;
        if (this.getRowCount() < this.getFirst() + rows) {
            this.setFirst(0);
            this.setScrollPos("0,0," + rows + "," + ScrollableDataTableUtils.getClientRowIndex(this));
        }
    }

    public boolean isLimitToList() {
        return false;
    }

    public void setLimitToList(boolean submitForm) {
    }

    public boolean isAjaxSingle() {
        return false;
    }

    public void setAjaxSingle(boolean single) {
    }

    public Converter getRowKeyConverter() {
        Converter converter = super.getRowKeyConverter();
        if (null == converter) {
            return this.defaultRowKeyConverter;
        }
        return converter;
    }

    public void setRowKeyConverter(Converter rowKeyConverter) {
        super.setRowKeyConverter(rowKeyConverter);
    }

    protected boolean keepSaved(FacesContext context) {
        return this.keepSaved || super.keepSaved(context);
    }
}

