/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.SequenceDataAdaptor;
import org.ajax4jsf.context.ContextInitParameters;
import org.ajax4jsf.model.ExtendedDataModel;
import org.richfaces.component.ColumnsIterator;
import org.richfaces.component.DataIterator;
import org.richfaces.component.FixedChildrenIterator;
import org.richfaces.component.UIColumn;
import org.richfaces.model.FilterField;
import org.richfaces.model.LocaleAware;
import org.richfaces.model.Modifiable;
import org.richfaces.model.ModifiableModel;
import org.richfaces.model.SortField2;

public abstract class UIDataTable
extends SequenceDataAdaptor {
    Collection<Object> sortPriority = new ArrayList<Object>();
    public static final String COMPONENT_TYPE = "org.richfaces.DataTable";
    public static final String COMPONENT_FAMILY = "org.richfaces.DataTable";

    public Iterator<UIComponent> dataChildren() {
        return new DataIterator((UIComponent)this);
    }

    public Iterator<UIComponent> fixedChildren() {
        return new FixedChildrenIterator((UIComponent)this);
    }

    public Iterator<UIComponent> columns() {
        return new ColumnsIterator((UIComponent)this);
    }

    /*
     * WARNING - void declaration
     */
    protected ExtendedDataModel createDataModel() {
        void var7_13;
        FacesContext facesContext;
        LinkedList<FilterField> filterFields = new LinkedList<FilterField>();
        LinkedHashMap<String, SortField2> sortFieldsMap = new LinkedHashMap<String, SortField2>();
        List list = this.getChildren();
        for (UIComponent component : list) {
            SortField2 sortField;
            Object column;
            if (!(component instanceof UIColumn) || !((UIColumn)((Object)(column = (UIColumn)component))).isRendered()) continue;
            FilterField filterField = ((UIColumn)((Object)column)).getFilterField();
            if (filterField != null) {
                filterFields.add(filterField);
            }
            if ((sortField = ((UIColumn)((Object)column)).getSortField()) == null) continue;
            sortFieldsMap.put(component.getId(), sortField);
        }
        LinkedList<Object> sortFields = new LinkedList<Object>();
        Collection<Object> sortPriority = this.getSortPriority();
        if (sortPriority != null) {
            for (Object e : sortPriority) {
                String id;
                SortField2 sortField;
                if (!(e instanceof String) || (sortField = (SortField2)sortFieldsMap.get(id = (String)e)) == null) continue;
                sortFields.add(sortField);
                sortFieldsMap.remove(id);
            }
        }
        sortFields.addAll(sortFieldsMap.values());
        ExtendedDataModel dataModel = super.createDataModel();
        Object var7_10 = null;
        if (dataModel instanceof Modifiable) {
            Modifiable modifiable = (Modifiable)dataModel;
        } else if (!filterFields.isEmpty() || !sortFields.isEmpty()) {
            ModifiableModel modifiableModel = new ModifiableModel(dataModel, this.getVar());
            dataModel = modifiableModel;
            ModifiableModel modifiableModel2 = modifiableModel;
        }
        if (dataModel instanceof LocaleAware && ContextInitParameters.isDatatableUsesViewLocale((FacesContext)(facesContext = this.getFacesContext()))) {
            UIViewRoot viewRoot = facesContext.getViewRoot();
            ((LocaleAware)dataModel).setLocale(viewRoot.getLocale());
        }
        if (var7_13 != null) {
            var7_13.modify(filterFields, sortFields);
        }
        return dataModel;
    }

    public Collection<Object> getSortPriority() {
        ValueExpression ve = this.getValueExpression("sortPriority");
        if (ve != null) {
            Collection value = null;
            try {
                value = (Collection)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            return value;
        }
        return this.sortPriority;
    }

    public void setSortPriority(Collection<Object> sortPriority) {
        ELContext context = this.getFacesContext().getELContext();
        ValueExpression ve = this.getValueExpression("sortPriority");
        if (ve != null && !ve.isReadOnly(context)) {
            try {
                ve.setValue(context, sortPriority);
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        } else {
            this.sortPriority = sortPriority;
        }
    }

    public abstract String getSortMode();

    public abstract void setSortMode(String var1);

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.sortPriority};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this.sortPriority = (Collection)states[1];
    }
}

