/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import org.richfaces.component.Column;

class ColumnsIterator
implements Iterator<UIComponent> {
    private UIComponent next;
    private boolean initialized = false;
    protected Iterator<UIComponent> childrenIterator;

    public ColumnsIterator(UIComponent dataTable) {
        this.childrenIterator = dataTable.getChildren().iterator();
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.next = this.nextColumn();
            this.initialized = true;
        }
        return null != this.next;
    }

    @Override
    public UIComponent next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        UIComponent result = this.next;
        this.next = this.nextColumn();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator is read-only");
    }

    protected UIComponent nextColumn() {
        UIComponent nextColumn = null;
        while (this.childrenIterator.hasNext()) {
            UIComponent child = this.childrenIterator.next();
            if (!(child instanceof UIColumn) && !(child instanceof Column)) continue;
            nextColumn = child;
            break;
        }
        return nextColumn;
    }
}

