/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.utils;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.statistiche.constants.TipoBanda;
import org.openspcoop2.core.statistiche.constants.TipoLatenza;
import org.openspcoop2.core.statistiche.constants.TipoStatistica;
import org.openspcoop2.core.statistiche.constants.TipoVisualizzazione;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.monitor.engine.statistic.StatisticheSettimanali;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.datamodel.Res;
import org.openspcoop2.web.monitor.core.datamodel.ResBase;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.statistiche.bean.DimensioneCustom;
import org.openspcoop2.web.monitor.statistiche.bean.StatsSearchForm;
import org.openspcoop2.web.monitor.statistiche.utils.JsonStatsUtils;
import org.slf4j.Logger;

public class StatsUtils {
    public static String getXmlPieChartDistribuzione(List<ResDistribuzione> list, StatsSearchForm search, String caption, String subCaption, Integer slice) {
        StringBuilder sb = new StringBuilder();
        sb.append("<chart caption='");
        sb.append(caption);
        sb.append("' labelSepChar=':' subcaption='").append(subCaption).append("'  decimalSeparator=',' thousandSeparator='.'  showPercentageValues='1' formatNumberScale='0' palette='1' ");
        sb.append(" decimals='0' enableSmartLabels='1' enableRotation='1' bgColor='99CCFF,FFFFFF' ");
        sb.append(" bgAlpha='40,100' bgRatio='0,100' bgAngle='360' showBorder='1' startingAngle='70' >");
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
        if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
            occupazioneBanda = true;
        } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
            tempoMedio = true;
        }
        if (list != null && list.size() > 0) {
            int i = 0;
            long altri_sum = 0L;
            int altri_sum_numeroItem = 0;
            for (ResDistribuzione entry : list) {
                String r = entry.getRisultato();
                Number sum = entry.getSomma();
                if (++i <= slice) {
                    String toolText = StatsUtils.getToolText(search, sum);
                    if (!entry.getParentMap().isEmpty()) {
                        toolText = StatsUtils.getToolTextConParent(search, r, entry.getParentMap(), sum);
                    }
                    sb.append("<set label='");
                    sb.append(StringEscapeUtils.escapeXml10((String)r));
                    sb.append("' value='");
                    sb.append(sum);
                    sb.append("' toolText='");
                    sb.append(toolText != null ? StringEscapeUtils.escapeXml10((String)toolText) : toolText);
                    sb.append("'/>");
                    continue;
                }
                altri_sum += sum.longValue();
                ++altri_sum_numeroItem;
            }
            if (i > slice) {
                long v = altri_sum;
                if (altri_sum_numeroItem > 1 && (occupazioneBanda || tempoMedio) && altri_sum_numeroItem > 0) {
                    v /= (long)altri_sum_numeroItem;
                }
                String toolText = StatsUtils.getToolText(search, v);
                sb.append("<set label='Altri' value='");
                sb.append(v);
                sb.append("' toolText='");
                sb.append(toolText != null ? StringEscapeUtils.escapeXml10((String)toolText) : toolText);
                sb.append("'/>");
            }
        } else {
            sb.append("<set label='Non esistono transazioni per il periodo selezionato' value='1'");
            sb.append(" toolText='Non esistono transazioni per il periodo selezionato'/>");
        }
        sb.append("</chart>");
        return sb.toString();
    }

    public static String getXmlBarChartDistribuzione(List<ResDistribuzione> list, StatsSearchForm search, String caption, String subCaption, Integer slice) {
        ArrayList<ResBase> listI = new ArrayList<ResBase>();
        listI.addAll(list);
        return StatsUtils._getXmlBarChartDistribuzione(listI, search, caption, subCaption, slice, null, new String[0]);
    }

    public static String getXmlBarChartDistribuzione(List<Res> list, StatsSearchForm search, String caption, String subCaption, Integer slice, StatisticType tempo) {
        ArrayList<ResBase> listI = new ArrayList<ResBase>();
        listI.addAll(list);
        return StatsUtils._getXmlBarChartDistribuzione(listI, search, caption, subCaption, slice, tempo, new String[0]);
    }

    private static String _getXmlBarChartDistribuzione(List<ResBase> list, StatsSearchForm search, String caption, String subCaption, Integer sliceParam, StatisticType tempo, String ... series) {
        StringBuilder sb = new StringBuilder();
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        boolean distribuzionePerEsiti = false;
        if (search.isAndamentoTemporalePerEsiti()) {
            distribuzionePerEsiti = true;
        } else {
            TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
            if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
                occupazioneBanda = true;
            } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
                tempoMedio = true;
            }
        }
        int numeroCategorie = 1;
        boolean showSeries = false;
        Object color = null;
        if (list != null && list.size() > 0) {
            if (series != null && series.length > 0) {
                showSeries = true;
                numeroCategorie = series.length;
                color = "3B83B7";
            } else if (distribuzionePerEsiti) {
                numeroCategorie = 3;
                series = new String[numeroCategorie];
                showSeries = true;
                series[0] = "Ok";
                series[1] = "Fault Applicativo";
                series[2] = "Fallite";
                color = "95B964,FF8F52,CD4A50";
            } else if (occupazioneBanda) {
                numeroCategorie = search.getTipiBandaImpostati().size();
                boolean bl = showSeries = numeroCategorie > 1;
                if (showSeries) {
                    series = new String[numeroCategorie];
                }
                for (i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiBanda();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null) continue;
                    if (tipoLat.equals("0")) {
                        if (showSeries) {
                            series[i] = TipoBanda.COMPLESSIVA.getValue();
                        }
                        if (color != null) {
                            color = (String)color + ",";
                            color = (String)color + "3B83B7";
                            continue;
                        }
                        color = "3B83B7";
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (showSeries) {
                            series[i] = TipoBanda.INTERNA.getValue();
                        }
                        if (color != null) {
                            color = (String)color + ",";
                            color = (String)color + "FF8F52";
                            continue;
                        }
                        color = "FF8F52";
                        continue;
                    }
                    if (!tipoLat.equals("2")) continue;
                    if (showSeries) {
                        series[i] = TipoBanda.ESTERNA.getValue();
                    }
                    if (color != null) {
                        color = (String)color + ",";
                        color = (String)color + "95B964";
                        continue;
                    }
                    color = "95B964";
                }
            } else if (tempoMedio) {
                numeroCategorie = search.getTipiLatenzaImpostati().size();
                boolean bl = showSeries = numeroCategorie > 1;
                if (showSeries) {
                    series = new String[numeroCategorie];
                }
                for (i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiLatenza();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null) continue;
                    if (tipoLat.equals("0")) {
                        if (showSeries) {
                            series[i] = TipoLatenza.LATENZA_TOTALE.getValue();
                        }
                        if (color != null) {
                            color = (String)color + ",";
                            color = (String)color + "3B83B7";
                            continue;
                        }
                        color = "3B83B7";
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (showSeries) {
                            series[i] = "Tempo Risposta Servizio";
                        }
                        if (color != null) {
                            color = (String)color + ",";
                            color = (String)color + "FF8F52";
                            continue;
                        }
                        color = "FF8F52";
                        continue;
                    }
                    if (!tipoLat.equals("2")) continue;
                    if (showSeries) {
                        series[i] = TipoLatenza.LATENZA_PORTA.getValue();
                    }
                    if (color != null) {
                        color = (String)color + ",";
                        color = (String)color + "95B964";
                        continue;
                    }
                    color = "95B964";
                }
            }
        }
        if (color == null) {
            color = "3B83B7";
        }
        color = "paletteColors='" + (String)color + "' ";
        String xName = "Data";
        Object xNameDirective = "xAxisName='" + xName + "'";
        xNameDirective = "";
        String yAxisName = StatsUtils.getSubCaption(search, true);
        sb.append("<chart pallete='3' caption='");
        sb.append(caption);
        sb.append("' subCaption='");
        sb.append(subCaption);
        sb.append("' " + (String)xNameDirective + " yAxisName='");
        sb.append(yAxisName);
        sb.append("' decimalSeparator=',' thousandSeparator='.'  decimals='0' useRoundEdges='1' showSum='1' formatNumber='1' formatNumberScale='0' labelDisplay='Rotate' slantLabels='1' " + (String)color + ">");
        DateFormat sdf = null;
        if (list != null && list.size() > 0) {
            String value;
            String toolText;
            int iterazione = 0;
            long altri_sum_serie1 = 0L;
            int altri_sum_serie1_numeroItem = 0;
            long altri_sum_serie2 = 0L;
            int altri_sum_serie2_numeroItem = 0;
            long altri_sum_serie3 = 0L;
            int altri_sum_serie3_numeroItem = 0;
            StringBuilder labelsSB = new StringBuilder();
            StringBuilder barSB_serie1 = new StringBuilder();
            StringBuilder barSB_serie2 = new StringBuilder();
            StringBuilder barSB_serie3 = new StringBuilder();
            labelsSB.append("<categories>");
            if (!showSeries) {
                barSB_serie1.append("<dataset seriesName='' showValues='1' showLabels='1'>");
            } else {
                barSB_serie1.append("<dataset seriesName='" + series[0] + "' showValues='1' showLabels='1'>");
                if (numeroCategorie > 1) {
                    barSB_serie2.append("<dataset seriesName='" + series[1] + "' showValues='1' showLabels='1'>");
                }
                if (numeroCategorie > 2) {
                    barSB_serie3.append("<dataset seriesName='" + series[2] + "' showValues='1' showLabels='1'>");
                }
            }
            int slice = sliceParam;
            if (slice != Integer.MAX_VALUE) {
                slice *= numeroCategorie;
            }
            for (ResBase entry : list) {
                for (int j = 0; j < numeroCategorie; ++j) {
                    Number sum = null;
                    if (entry instanceof ResDistribuzione) {
                        sum = entry.getSomma();
                    } else if (entry instanceof Res) {
                        sum = (Number)entry.getSomme().get(j);
                    }
                    if (++iterazione <= slice) {
                        Object r = null;
                        if (entry instanceof ResDistribuzione) {
                            r = ((ResDistribuzione)entry).getRisultato();
                        } else if (entry instanceof Res) {
                            if (sdf == null) {
                                if (StatisticType.ORARIA.equals((Object)tempo)) {
                                    sdf = new SimpleDateFormat("dd/MM/yy HH", ApplicationBean.getInstance().getLocale());
                                } else if (StatisticType.GIORNALIERA.equals((Object)tempo)) {
                                    sdf = new SimpleDateFormat("dd/MM/yy", ApplicationBean.getInstance().getLocale());
                                } else if (StatisticType.SETTIMANALE.equals((Object)tempo)) {
                                    sdf = new SimpleDateFormat("dd/MM/yy", ApplicationBean.getInstance().getLocale());
                                } else if (StatisticType.MENSILE.equals((Object)tempo)) {
                                    sdf = new SimpleDateFormat("MMM/yy", ApplicationBean.getInstance().getLocale());
                                }
                            }
                            if (sdf == null) {
                                throw new RuntimeException("SimpleDateFormat undefined");
                            }
                            Date rDate = ((Res)entry).getRisultato();
                            r = sdf.format(rDate);
                        } else {
                            r = "ERROR: TIPO [" + entry.getClass().getName() + "] NON GESTITO";
                        }
                        if (j == 0) {
                            labelsSB.append("<category label='");
                            labelsSB.append(StringEscapeUtils.escapeXml10((String)r));
                            labelsSB.append("' />");
                        }
                        toolText = StatsUtils.getToolText(search, sum);
                        if (!entry.getParentMap().isEmpty()) {
                            toolText = StatsUtils.getToolTextConParent(search, (String)r, entry.getParentMap(), sum);
                        }
                        value = StatsUtils.getValue(search, sum);
                        StringBuilder barSB = null;
                        if (j == 0) {
                            barSB = barSB_serie1;
                        } else if (j == 1) {
                            barSB = barSB_serie2;
                        } else if (j == 2) {
                            barSB = barSB_serie3;
                        }
                        if (barSB == null) {
                            throw new RuntimeException("barSB undefined");
                        }
                        barSB.append("<set value='");
                        barSB.append(value);
                        barSB.append("' toolText='");
                        barSB.append(toolText != null ? StringEscapeUtils.escapeXml10((String)toolText) : toolText);
                        barSB.append("' />");
                        continue;
                    }
                    if (j == 0) {
                        if (sum != null) {
                            altri_sum_serie1 += sum.longValue();
                        }
                        ++altri_sum_serie1_numeroItem;
                        continue;
                    }
                    if (j == 1) {
                        if (sum != null) {
                            altri_sum_serie2 += sum.longValue();
                        }
                        ++altri_sum_serie2_numeroItem;
                        continue;
                    }
                    if (j != 2) continue;
                    if (sum != null) {
                        altri_sum_serie3 += sum.longValue();
                    }
                    ++altri_sum_serie3_numeroItem;
                }
            }
            if (iterazione > slice) {
                String label = "Altri";
                labelsSB.append("<category label='");
                labelsSB.append(label);
                labelsSB.append("' />");
                for (int j = 0; j < numeroCategorie; ++j) {
                    StringBuilder barSB = null;
                    long v = -1L;
                    if (j == 0) {
                        barSB = barSB_serie1;
                        v = altri_sum_serie1;
                        if (altri_sum_serie1_numeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altri_sum_serie1_numeroItem;
                        }
                    } else if (j == 1) {
                        barSB = barSB_serie2;
                        v = altri_sum_serie2;
                        if (altri_sum_serie2_numeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altri_sum_serie2_numeroItem;
                        }
                    } else if (j == 2) {
                        barSB = barSB_serie3;
                        v = altri_sum_serie3;
                        if (altri_sum_serie3_numeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altri_sum_serie3_numeroItem;
                        }
                    }
                    if (barSB == null) {
                        throw new RuntimeException("barSB undefined");
                    }
                    toolText = StatsUtils.getToolText(search, v);
                    value = StatsUtils.getValue(search, v);
                    barSB.append("<set value='");
                    barSB.append(value);
                    barSB.append("' toolText='");
                    barSB.append(toolText != null ? StringEscapeUtils.escapeXml10((String)toolText) : toolText);
                    barSB.append("' />");
                }
            }
            labelsSB.append("</categories>");
            barSB_serie1.append("</dataset>");
            if (numeroCategorie > 1) {
                barSB_serie2.append("</dataset>");
            }
            if (numeroCategorie > 2) {
                barSB_serie3.append("</dataset>");
            }
            sb.append(labelsSB.toString());
            sb.append(barSB_serie1.toString());
            if (barSB_serie2.length() > 0) {
                sb.append(barSB_serie2.toString());
            }
            if (barSB_serie3.length() > 0) {
                sb.append(barSB_serie3.toString());
            }
        } else {
            sb.append("<categories> ");
            sb.append("     <category label='-'/>");
            sb.append(" </categories>");
            sb.append("<dataset seriesName='' showValues='1' showLabels='1' >");
            sb.append("     <set value='0' label='Non esistono transazioni per il periodo selezionato' toolText='Non esistono transazioni per il periodo selezionato' />");
            sb.append(" </dataset>");
        }
        sb.append("</chart> ");
        return sb.toString();
    }

    public static List<Res> checkEstremi(List<Res> list, StatsSearchForm search, StatisticType tempo, SimpleDateFormat sdf) {
        ArrayList<Integer> l;
        Res r;
        Date dataInizio = search.getDataInizio();
        Date dataFine = search.getDataFine();
        int sizeRisultati = 0;
        if (list.get(0).getSomme() != null) {
            sizeRisultati = list.get(0).getSomme().size();
        }
        if (StatsUtils.addEstremoSX(list, search, tempo, sdf)) {
            r = new Res();
            r.setRisultato(dataInizio);
            r.setSomma((Number)0);
            l = new ArrayList<Integer>();
            for (int i = 0; i < sizeRisultati; ++i) {
                l.add(0);
            }
            r.setSomme(l);
            ArrayList<Res> newList = new ArrayList<Res>();
            newList.add(r);
            newList.addAll(list);
            list = newList;
        }
        if (StatsUtils.addEstremoDX(list, search, tempo, sdf)) {
            r = new Res();
            r.setRisultato(dataFine);
            r.setSomma((Number)0);
            l = new ArrayList();
            for (int i = 0; i < sizeRisultati; ++i) {
                l.add(0);
            }
            r.setSomme(l);
            list.add(r);
        }
        return list;
    }

    public static boolean addEstremoSX(List<Res> list, StatsSearchForm search, StatisticType tempo, SimpleDateFormat sdf) {
        Date dataInizio = search.getDataInizio();
        Date risultatoLower = list.get(0).getRisultato();
        String dataInizioAsString = null;
        String risultatoLowerAsString = null;
        if (StatisticType.ORARIA.equals((Object)tempo)) {
            dataInizioAsString = sdf.format(dataInizio);
            risultatoLowerAsString = sdf.format(risultatoLower);
        } else if (StatisticType.SETTIMANALE.equals((Object)tempo)) {
            sdf.applyPattern("dd/MM/yy");
            StatisticheSettimanali statisticheSettimanaliUtils = StatisticheSettimanali.getInstanceForUtils();
            Date dataInizioSettimanale = (Date)dataInizio.clone();
            dataInizioAsString = sdf.format(statisticheSettimanaliUtils.truncDate(dataInizioSettimanale, false));
            risultatoLowerAsString = sdf.format(risultatoLower);
        } else if (StatisticType.MENSILE.equals((Object)tempo)) {
            sdf.applyPattern("MMM/yy");
            dataInizioAsString = sdf.format(dataInizio);
            risultatoLowerAsString = sdf.format(risultatoLower);
        } else {
            dataInizioAsString = sdf.format(dataInizio);
            risultatoLowerAsString = sdf.format(risultatoLower);
        }
        return !dataInizioAsString.equals(risultatoLowerAsString);
    }

    public static boolean addEstremoDX(List<Res> list, StatsSearchForm search, StatisticType tempo, SimpleDateFormat sdf) {
        Date dataFine = search.getDataFine();
        Date risultatoHigh = list.get(list.size() - 1).getRisultato();
        String dataFineAsString = null;
        String risultatoHighAsString = null;
        if (StatisticType.ORARIA.equals((Object)tempo)) {
            dataFineAsString = sdf.format(dataFine);
            risultatoHighAsString = sdf.format(risultatoHigh);
        } else if (StatisticType.SETTIMANALE.equals((Object)tempo)) {
            sdf.applyPattern("dd/MM/yy");
            StatisticheSettimanali statisticheSettimanaliUtils = StatisticheSettimanali.getInstanceForUtils();
            Date dataInizioSettimanale = (Date)dataFine.clone();
            dataFineAsString = sdf.format(statisticheSettimanaliUtils.truncDate(dataInizioSettimanale, false));
            risultatoHighAsString = sdf.format(risultatoHigh);
        } else if (StatisticType.MENSILE.equals((Object)tempo)) {
            sdf.applyPattern("MMM/yy");
            dataFineAsString = sdf.format(dataFine);
            risultatoHighAsString = sdf.format(risultatoHigh);
        } else {
            dataFineAsString = sdf.format(dataFine);
            risultatoHighAsString = sdf.format(risultatoHigh);
        }
        return !dataFineAsString.equals(risultatoHighAsString);
    }

    public static String getXmlAndamentoTemporale(List<Res> list, StatsSearchForm search, String caption, String subCaption, StatisticType tempo) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf_last = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
        SimpleDateFormat sdf = StatisticType.ORARIA.equals((Object)tempo) ? new SimpleDateFormat("dd/MM/yy HH", ApplicationBean.getInstance().getLocale()) : new SimpleDateFormat("dd/MM/yy", ApplicationBean.getInstance().getLocale());
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        boolean distribuzionePerEsiti = false;
        if (search.isAndamentoTemporalePerEsiti()) {
            distribuzionePerEsiti = true;
        } else {
            TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
            if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
                occupazioneBanda = true;
            } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
                tempoMedio = true;
            }
        }
        int numeroCategorie = 1;
        boolean visualizzaSeriesName = false;
        String[] series = null;
        Object color = null;
        if (list != null && list.size() > 0) {
            if (distribuzionePerEsiti) {
                numeroCategorie = 3;
                visualizzaSeriesName = true;
                series = new String[numeroCategorie];
                series[0] = "Ok";
                series[1] = "Fault Applicativo";
                series[2] = "Fallite";
                color = "95B964,FF8F52,CD4A50";
            } else if (occupazioneBanda) {
                numeroCategorie = search.getTipiBandaImpostati().size();
                boolean bl = visualizzaSeriesName = numeroCategorie > 1;
                if (visualizzaSeriesName) {
                    series = new String[numeroCategorie];
                }
                for (i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiBanda();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null) continue;
                    if (tipoLat.equals("0")) {
                        if (visualizzaSeriesName) {
                            series[i] = TipoBanda.COMPLESSIVA.getValue();
                        }
                        if (color != null) {
                            color = (String)color + ",";
                            color = (String)color + "3B83B7";
                            continue;
                        }
                        color = "3B83B7";
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (visualizzaSeriesName) {
                            series[i] = TipoBanda.INTERNA.getValue();
                        }
                        if (color != null) {
                            color = (String)color + ",";
                            color = (String)color + "FF8F52";
                            continue;
                        }
                        color = "FF8F52";
                        continue;
                    }
                    if (!tipoLat.equals("2")) continue;
                    if (visualizzaSeriesName) {
                        series[i] = TipoBanda.ESTERNA.getValue();
                    }
                    if (color != null) {
                        color = (String)color + ",";
                        color = (String)color + "95B964";
                        continue;
                    }
                    color = "95B964";
                }
            } else if (tempoMedio) {
                numeroCategorie = search.getTipiLatenzaImpostati().size();
                boolean bl = visualizzaSeriesName = numeroCategorie > 1;
                if (visualizzaSeriesName) {
                    series = new String[numeroCategorie];
                }
                for (i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiLatenza();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null) continue;
                    if (tipoLat.equals("0")) {
                        if (visualizzaSeriesName) {
                            series[i] = TipoLatenza.LATENZA_TOTALE.getValue();
                        }
                        if (color != null) {
                            color = (String)color + ",";
                            color = (String)color + "3B83B7";
                            continue;
                        }
                        color = "3B83B7";
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (visualizzaSeriesName) {
                            series[i] = "Tempo Risposta Servizio";
                        }
                        if (color != null) {
                            color = (String)color + ",";
                            color = (String)color + "FF8F52";
                            continue;
                        }
                        color = "FF8F52";
                        continue;
                    }
                    if (!tipoLat.equals("2")) continue;
                    if (visualizzaSeriesName) {
                        series[i] = TipoLatenza.LATENZA_PORTA.getValue();
                    }
                    if (color != null) {
                        color = (String)color + ",";
                        color = (String)color + "95B964";
                        continue;
                    }
                    color = "95B964";
                }
            }
        }
        if (color == null) {
            color = "3B83B7";
        }
        color = "paletteColors='" + (String)color + "' ";
        String xName = "Data";
        Object xNameDirective = "xAxisName='" + xName + "'";
        xNameDirective = "";
        String yAxisName = StatsUtils.getSubCaption(search, true);
        sb.append("<chart caption='").append(caption).append("' labelSepChar=':' subcaption='").append(subCaption).append("' palette='3' numVisiblePlot='30' " + (String)xNameDirective + " yAxisName='").append(yAxisName).append("'   decimalSeparator=',' thousandSeparator='.'  lineThickness='2' showValues='0'  rotateNames='1' slantLabels='1' areaOverColumns='0' formatNumberScale='0' " + (String)color + ">");
        if (list != null && list.size() > 0) {
            list = StatsUtils.checkEstremi(list, search, tempo, sdf);
            sb.append("<categories>");
            for (Res entry : list) {
                Date r = entry.getRisultato();
                Calendar c = Calendar.getInstance();
                c.setTime(r);
                if (StatisticType.ORARIA.equals((Object)tempo)) {
                    sdf_last.applyPattern("HH");
                    c.add(10, 1);
                    sb.append("\t<category label='" + sdf.format(r) + "-").append(sdf_last.format(c.getTime()) + "' />");
                    continue;
                }
                if (StatisticType.SETTIMANALE.equals((Object)tempo)) {
                    sdf.applyPattern("dd/MM/yy");
                    sdf_last.applyPattern("dd/MM/yy");
                    c.add(4, 1);
                    c.add(7, -1);
                    sb.append("\t<category label='" + sdf.format(r) + "-").append(sdf_last.format(c.getTime()) + "' />");
                    continue;
                }
                if (StatisticType.MENSILE.equals((Object)tempo)) {
                    sdf.applyPattern("MMM/yy");
                    sb.append("\t<category label='" + sdf.format(r) + "' />");
                    continue;
                }
                sb.append("\t<category label='" + sdf.format(r) + "' />");
            }
            sb.append("</categories>");
            for (int i = 0; i < numeroCategorie; ++i) {
                sb.append("<dataset renderAs='Line' ");
                if (visualizzaSeriesName) {
                    sb.append("seriesname='").append(series[i]).append("' ");
                }
                sb.append(">");
                for (Res entry : list) {
                    Number sum = (Number)entry.getSomme().get(i);
                    String toolText = StatsUtils.getToolText(search, sum);
                    String value = StatsUtils.getValue(search, sum);
                    sb.append("<set value='" + value + "' toolText='" + (toolText != null ? StringEscapeUtils.escapeXml10((String)toolText) : toolText) + "' />");
                }
                sb.append("</dataset>");
            }
        } else {
            sb.append("<categories> ");
            sb.append("    <category label='" + sdf.format(search.getDataInizio()) + "' />\t");
            sb.append("    <category label='" + sdf.format(search.getDataFine()) + "' />");
            sb.append(" </categories>");
            sb.append("<dataset renderAs='Line' >");
            sb.append("   <set value='0' toolText='Non esistono transazioni per il periodo selezionato'/>");
            sb.append("   <set value='0' toolText='Non esistono transazioni per il periodo selezionato'/>");
            sb.append(" </dataset>");
        }
        sb.append("</chart>");
        return sb.toString();
    }

    public static String getXmlAndamentoTemporaleStatPersonalizzate(SimpleDateFormat sdf, SimpleDateFormat sdf_last_hour, StatisticType tempo, Map<String, List<Res>> results, StatsSearchForm search, String caption, String subCaption) {
        StringBuilder sb = new StringBuilder();
        String xName = "Data";
        Object xNameDirective = "xAxisName='" + xName + "'";
        xNameDirective = "";
        String yAxisName = StatsUtils.getSubCaption(search, true);
        sb.append("<chart caption='");
        sb.append(caption);
        sb.append("' labelSepChar=':' subcaption='");
        sb.append(subCaption);
        sb.append("' palette='3' numVisiblePlot='30' " + (String)xNameDirective + " yAxisName='");
        sb.append(yAxisName);
        sb.append("'   decimalSeparator=',' thousandSeparator='.'  lineThickness='2' showValues='0'  rotateNames='1' slantLabels='1' areaOverColumns='0' formatNumberScale='0'>");
        if (results != null && results.size() > 0) {
            sb.append("<categories>");
            Set<String> keys = results.keySet();
            Iterator<String> it = keys.iterator();
            int i = 0;
            while (it.hasNext()) {
                String key = it.next();
                List<Res> list = results.get(key);
                list = StatsUtils.checkEstremi(list, search, tempo, sdf);
                if (i < 1) {
                    for (Res entry : list) {
                        Date r = entry.getRisultato();
                        if (StatisticType.ORARIA.equals((Object)tempo)) {
                            Calendar c = Calendar.getInstance();
                            c.setTime(r);
                            c.add(10, 1);
                            sb.append("\t<category label='" + sdf.format(r) + "-" + sdf_last_hour.format(c.getTime()) + "' />");
                            continue;
                        }
                        sb.append("\t<category label='" + sdf.format(r) + "' />");
                    }
                    sb.append("</categories>");
                }
                sb.append("<dataset renderAs='Line' seriesname='" + key + "' >");
                for (Res entry : list) {
                    Number sum = entry.getSomma();
                    String toolText = StatsUtils.getToolText(search, sum);
                    String value = StatsUtils.getValue(search, sum);
                    sb.append("<set value='" + value + "' toolText='" + (toolText != null ? StringEscapeUtils.escapeXml10((String)toolText) : toolText) + "'/>");
                }
                sb.append("</dataset>");
                ++i;
            }
        } else {
            sb.append("<categories> ");
            sb.append("    <category label='" + sdf.format(search.getDataInizio()) + "' />\t");
            sb.append("    <category label='" + sdf.format(search.getDataFine()) + "' />");
            sb.append(" </categories>");
            sb.append("<dataset renderAs='Line' >");
            sb.append("   <set value='0' toolText='Non esistono transazioni per il periodo selezionato'/>");
            sb.append("   <set value='0' toolText='Non esistono transazioni per il periodo selezionato'/>");
            sb.append(" </dataset>");
        }
        sb.append("</chart>");
        return sb.toString();
    }

    public static String getXmlPieChartStatistichePersonalizzate(List<ResDistribuzione> list, StatsSearchForm search, int slice, String caption, String subCaption) {
        StringBuilder sb = new StringBuilder();
        sb.append("<chart caption='");
        sb.append(caption);
        sb.append("' labelSepChar=':' subcaption='");
        sb.append(subCaption);
        sb.append("'  decimalSeparator=',' thousandSeparator='.'  showPercentageValues='1' formatNumberScale='0' palette='1'  decimals='0' enableSmartLabels='1' enableRotation='1' bgColor='99CCFF,FFFFFF' bgAlpha='40,100' bgRatio='0,100' bgAngle='360' showBorder='1' startingAngle='70' >");
        if (list != null && list.size() > 0) {
            boolean occupazioneBanda = false;
            boolean tempoMedio = false;
            TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
            if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
                occupazioneBanda = true;
            } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
                tempoMedio = true;
            }
            int i = 0;
            long altri_sum = 0L;
            int altri_sum_numeroItem = 0;
            for (ResDistribuzione entry : list) {
                String r = entry.getRisultato();
                Number sum = entry.getSomma();
                if (++i <= slice) {
                    String toolText = StatsUtils.getToolText(search, sum);
                    sb.append("<set label='" + StringEscapeUtils.escapeXml10((String)r) + "' value='" + String.valueOf(sum) + "' toolText='" + (toolText != null ? StringEscapeUtils.escapeXml10((String)toolText) : toolText) + "'/>");
                    continue;
                }
                altri_sum += sum.longValue();
                ++altri_sum_numeroItem;
            }
            if (i > slice) {
                String toolText;
                long v = altri_sum;
                if (altri_sum_numeroItem > 1 && (occupazioneBanda || tempoMedio) && altri_sum_numeroItem > 0) {
                    v /= (long)altri_sum_numeroItem;
                }
                sb.append("<set label='Altri' value='" + v + "' toolText='" + ((toolText = StatsUtils.getToolText(search, v)) != null ? StringEscapeUtils.escapeXml10((String)toolText) : toolText) + "'/>");
            }
        } else {
            sb.append("<set label='Non esistono transazioni per il periodo selezionato' value='1'");
            sb.append(" toolText='Non esistono transazioni per il periodo selezionato'/>");
        }
        sb.append("</chart>");
        return sb.toString();
    }

    public static String getXmlBarChartStatistichePersonalizzate(List<ResDistribuzione> list, StatsSearchForm search, int slice, String caption, String subCaption) {
        StringBuilder sb = new StringBuilder();
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        Object color = "3B83B7";
        int numeroCategorie = 1;
        color = "paletteColors='" + (String)color + "' ";
        String xName = "Data";
        Object xNameDirective = "xAxisName='" + xName + "'";
        xNameDirective = "";
        String yAxisName = StatsUtils.getSubCaption(search, true);
        sb.append("<chart pallete='3' caption='");
        sb.append(caption);
        sb.append("' subCaption='");
        sb.append(subCaption);
        sb.append("' " + (String)xNameDirective + " yAxisName='");
        sb.append(yAxisName);
        sb.append("' decimalSeparator=',' thousandSeparator='.'  decimals='0' useRoundEdges='1' showSum='1' formatNumber='1' formatNumberScale='0' labelDisplay='Rotate' slantLabels='1' " + (String)color + ">");
        if (list != null && list.size() > 0) {
            String toolText;
            String value;
            int iterazione = 0;
            long altri_sum_serie1 = 0L;
            int altri_sum_serie1_numeroItem = 0;
            StringBuilder labelsSB = new StringBuilder();
            StringBuilder barSB_serie1 = new StringBuilder();
            labelsSB.append("<categories>");
            barSB_serie1.append("<dataset seriesName='' showValues='1' showLabels='1'>");
            if (slice != Integer.MAX_VALUE) {
                slice *= numeroCategorie;
            }
            for (ResDistribuzione entry : list) {
                for (int j = 0; j < numeroCategorie; ++j) {
                    Number sum = entry.getSomma();
                    if (++iterazione <= slice) {
                        String r = entry.getRisultato();
                        if (j == 0) {
                            labelsSB.append("<category label='");
                            labelsSB.append(StringEscapeUtils.escapeXml10((String)r));
                            labelsSB.append("' />");
                        }
                        value = StatsUtils.getValue(search, sum);
                        toolText = StatsUtils.getToolText(search, sum);
                        StringBuilder barSB = null;
                        if (j == 0) {
                            barSB = barSB_serie1;
                        }
                        if (barSB == null) {
                            throw new RuntimeException("barSB undefined");
                        }
                        barSB.append("<set value='");
                        barSB.append(value);
                        barSB.append("' toolText='");
                        barSB.append(toolText != null ? StringEscapeUtils.escapeXml10((String)toolText) : toolText);
                        barSB.append("' />");
                        continue;
                    }
                    if (j != 0) continue;
                    altri_sum_serie1 += sum.longValue();
                    ++altri_sum_serie1_numeroItem;
                }
            }
            if (iterazione > slice) {
                String label = "Altri";
                labelsSB.append("<category label='");
                labelsSB.append(label);
                labelsSB.append("' />");
                for (int j = 0; j < numeroCategorie; ++j) {
                    StringBuilder barSB = null;
                    long v = -1L;
                    if (j == 0) {
                        barSB = barSB_serie1;
                        v = altri_sum_serie1;
                        if (altri_sum_serie1_numeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altri_sum_serie1_numeroItem;
                        }
                    }
                    if (barSB == null) {
                        throw new RuntimeException("barSB undefined");
                    }
                    value = StatsUtils.getValue(search, v);
                    toolText = StatsUtils.getToolText(search, v);
                    barSB.append("<set value='");
                    barSB.append(value);
                    barSB.append("' toolText='");
                    barSB.append(toolText != null ? StringEscapeUtils.escapeXml10((String)toolText) : toolText);
                    barSB.append("' />");
                }
            }
            labelsSB.append("</categories>");
            barSB_serie1.append("</dataset>");
            sb.append(labelsSB.toString());
            sb.append(barSB_serie1.toString());
        } else {
            sb.append("<categories> ");
            sb.append("     <category label='-'/>");
            sb.append(" </categories>");
            sb.append("<dataset seriesName='' showValues='1' showLabels='1' >");
            sb.append("     <set value='0' label='Non esistono transazioni per il periodo selezionato' toolText='Non esistono transazioni per il periodo selezionato' />");
            sb.append(" </dataset>");
        }
        sb.append("</chart> ");
        return sb.toString();
    }

    public static String getSubCaption(StatsSearchForm form) {
        return StatsUtils.getSubCaption(form, false);
    }

    public static String getSubCaption(StatsSearchForm form, boolean showUnitaMisura) {
        TipoVisualizzazione tipoVisualizzazione = form.getTipoVisualizzazione();
        switch (tipoVisualizzazione) {
            case NUMERO_TRANSAZIONI: {
                return "Numero Transazioni ";
            }
            case TEMPO_MEDIO_RISPOSTA: {
                String tipoLatenzaLabel = StatsUtils.getTipoLatenzaServizioLabel(form);
                if (showUnitaMisura) {
                    return "Tempo Medio Risposta" + tipoLatenzaLabel + " [ms]";
                }
                return "Tempo Medio Risposta" + tipoLatenzaLabel + " ";
            }
        }
        String tipoBandaLabel = StatsUtils.getTipoBandaLabel(form);
        if (showUnitaMisura) {
            return "Occupazione Banda" + tipoBandaLabel + " [kb]";
        }
        return "Occupazione Banda" + tipoBandaLabel + " ";
    }

    private static String getTipoLatenzaServizioLabel(StatsSearchForm form) {
        String tipoLatenzaLabel = "";
        TipoLatenza tipoLatenza = null;
        if (TipoStatistica.ANDAMENTO_TEMPORALE.equals((Object)form.getTipoStatistica()) && !form.isAndamentoTemporalePerEsiti()) {
            if (form.getTipiLatenzaImpostati() != null && form.getTipiLatenzaImpostati().size() > 0 && form.getTipiLatenzaImpostati().size() == 1) {
                tipoLatenza = form.getTipiLatenzaImpostati().get(0);
            }
        } else {
            tipoLatenza = form.getTipoLatenza();
        }
        if (tipoLatenza != null) {
            switch (tipoLatenza) {
                case LATENZA_PORTA: {
                    tipoLatenzaLabel = " Porta";
                    break;
                }
                case LATENZA_SERVIZIO: {
                    tipoLatenzaLabel = " Servizio";
                    break;
                }
                case LATENZA_TOTALE: {
                    tipoLatenzaLabel = " Totale";
                }
            }
        }
        return tipoLatenzaLabel;
    }

    private static String getTipoBandaLabel(StatsSearchForm form) {
        String tipoBandaLabel = "";
        TipoBanda tipoBanda = null;
        if (TipoStatistica.ANDAMENTO_TEMPORALE.equals((Object)form.getTipoStatistica()) && !form.isAndamentoTemporalePerEsiti()) {
            if (form.getTipiBandaImpostati() != null && form.getTipiBandaImpostati().size() > 0 && form.getTipiBandaImpostati().size() == 1) {
                tipoBanda = form.getTipiBandaImpostati().get(0);
            }
        } else {
            tipoBanda = form.getTipoBanda();
        }
        if (tipoBanda != null) {
            switch (tipoBanda) {
                case COMPLESSIVA: {
                    tipoBandaLabel = " Complessiva";
                    break;
                }
                case ESTERNA: {
                    tipoBandaLabel = " Esterna";
                    break;
                }
                case INTERNA: {
                    tipoBandaLabel = " Interna";
                }
            }
        }
        return tipoBandaLabel;
    }

    public static String getValue(StatsSearchForm form, Number value) {
        TipoVisualizzazione tipoVisualizzazione = null;
        if (form != null) {
            tipoVisualizzazione = form.getTipoVisualizzazione();
        }
        if (tipoVisualizzazione != null && value != null) {
            switch (tipoVisualizzazione) {
                case NUMERO_TRANSAZIONI: {
                    return String.valueOf(value);
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    return String.valueOf(value);
                }
            }
            double d = value.doubleValue();
            double dRes = d / 1024.0;
            return "" + dRes;
        }
        return value != null ? String.valueOf(value) : null;
    }

    public static String getToolText(StatsSearchForm form, Number value) {
        TipoVisualizzazione tipoVisualizzazione = null;
        if (form != null) {
            tipoVisualizzazione = form.getTipoVisualizzazione();
        }
        if (tipoVisualizzazione != null && value != null) {
            switch (tipoVisualizzazione) {
                case NUMERO_TRANSAZIONI: {
                    return Utility.numberConverter((Number)value);
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    return Utilities.convertSystemTimeIntoStringMillisecondi((long)value.longValue(), (boolean)true);
                }
            }
            return Utility.fileSizeConverter((Number)value);
        }
        return value != null ? String.valueOf(value) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getToolTextConParent(StatsSearchForm form, String risultato, Map<String, String> parent, Number value) {
        TipoVisualizzazione tipoVisualizzazione = null;
        if (form != null) {
            tipoVisualizzazione = form.getTipoVisualizzazione();
        }
        if (tipoVisualizzazione != null && value != null) {
            StringBuilder sb = new StringBuilder();
            String valore = null;
            Object labelValore = null;
            switch (tipoVisualizzazione) {
                case NUMERO_TRANSAZIONI: {
                    valore = Utility.numberConverter((Number)value);
                    labelValore = "Numero Transazioni";
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    valore = Utilities.convertSystemTimeIntoStringMillisecondi((long)value.longValue(), (boolean)true);
                    String tipoLatenzaLabel = StatsUtils.getTipoLatenzaServizioLabel(form);
                    labelValore = "Tempo Medio Risposta" + tipoLatenzaLabel;
                    break;
                }
                default: {
                    valore = Utility.fileSizeConverter((Number)value);
                    String tipoBandaLabel = StatsUtils.getTipoBandaLabel(form);
                    labelValore = "Occupazione Banda" + tipoBandaLabel;
                }
            }
            TipoStatistica tipoStatistica = form.getTipoStatistica();
            switch (tipoStatistica) {
                case DISTRIBUZIONE_ERRORI: {
                    if (form.isUseGraficiSVG()) {
                        String labelTooltipDistribuzioneErroriSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.errori.tooltip.svg.pattern");
                        sb.append(MessageFormat.format(labelTooltipDistribuzioneErroriSvgPattern, labelValore, valore, risultato, JsonStatsUtils.escapeJsonLabel(parent.get("0"))));
                        return sb.toString();
                    }
                    String tooltipSectionErrori = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.errori.pattern");
                    String tooltipSectionErroriDescrizione = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.errori.descrizione.pattern");
                    sb.append((String)labelValore).append(": ").append(valore).append(tooltipSectionErrori).append(risultato).append(tooltipSectionErroriDescrizione).append(parent.get("0"));
                    return sb.toString();
                }
                case DISTRIBUZIONE_SERVIZIO: {
                    if (form.isUseGraficiSVG()) {
                        String labelTooltipDistribuzioneServizioSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.servizio.tooltip.svg.pattern");
                        sb.append(MessageFormat.format(labelTooltipDistribuzioneServizioSvgPattern, labelValore, valore, risultato, parent.get("0")));
                        return sb.toString();
                    }
                    String tooltipSectionErogatore = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.erogatore.pattern");
                    String tooltipSectionServizio = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.servizio.pattern");
                    sb.append((String)labelValore).append(": ").append(valore).append(tooltipSectionServizio).append(risultato).append(tooltipSectionErogatore).append(parent.get("0"));
                    return sb.toString();
                }
                case DISTRIBUZIONE_AZIONE: {
                    if (form.isUseGraficiSVG()) {
                        String labelTooltipDistribuzioneAzioneSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.azione.tooltip.svg.pattern");
                        sb.append(MessageFormat.format(labelTooltipDistribuzioneAzioneSvgPattern, labelValore, valore, risultato, parent.get("0"), parent.get("1")));
                        return sb.toString();
                    }
                    String tooltipSectionErogatore = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.erogatore.pattern");
                    String tooltipSectionServizio = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.servizio.pattern");
                    String tooltipSectionAzione = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.azione.pattern");
                    sb.append((String)labelValore).append(": ").append(valore).append(tooltipSectionAzione).append(risultato).append(tooltipSectionServizio).append(parent.get("0")).append(tooltipSectionErogatore).append(parent.get("1"));
                    return sb.toString();
                }
                case DISTRIBUZIONE_SERVIZIO_APPLICATIVO: {
                    TipoCredenzialeMittente tcm;
                    if (form.isUseGraficiSVG()) {
                        if (!StringUtils.isNotEmpty((CharSequence)form.getRiconoscimento())) return sb.toString();
                        if (form.getRiconoscimento().equals("applicativo")) {
                            boolean add = true;
                            if (StringUtils.isNotBlank((CharSequence)form.getIdentificazione()) && "commons.identificazione.token.label".equals(form.getIdentificazione()) && parent.get("1") != null) {
                                String labelTooltipDistribuzioneClientIdSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.applicativo.clientId.tooltip.svg.pattern");
                                sb.append(MessageFormat.format(labelTooltipDistribuzioneClientIdSvgPattern, labelValore, valore, risultato, parent.get("0"), parent.get("1")));
                                add = false;
                            }
                            if (!add) return sb.toString();
                            String labelTooltipDistribuzioneSaSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.applicativo.tooltip.svg.pattern");
                            sb.append(MessageFormat.format(labelTooltipDistribuzioneSaSvgPattern, labelValore, valore, risultato, parent.get("0")));
                            return sb.toString();
                        }
                        if (form.getRiconoscimento().equals("identificativoAutenticato")) {
                            String labelTooltipDistribuzioneIdentificativoAutenticatoSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.identificativoAutenticato.tooltip.svg.pattern");
                            sb.append(MessageFormat.format(labelTooltipDistribuzioneIdentificativoAutenticatoSvgPattern, labelValore, valore, risultato, parent.get("0")));
                            return sb.toString();
                        }
                        if (form.getRiconoscimento().equals("ip")) {
                            String labelTooltipDistribuzioneIndirizzoIPSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.indirizzoIP.tooltip.svg.pattern");
                            sb.append(MessageFormat.format(labelTooltipDistribuzioneIndirizzoIPSvgPattern, labelValore, valore, risultato));
                            return sb.toString();
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)form.getTokenClaim())) return sb.toString();
                        tcm = null;
                        try {
                            tcm = TipoCredenzialeMittente.toEnumConstant((String)form.getTokenClaim(), (boolean)true);
                        }
                        catch (Exception e) {
                            Logger log = LoggerManager.getPddMonitorCoreLogger();
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        String labelTooltipDistribuzioneTokenInfoSvgPattern = null;
                        boolean append = true;
                        if (tcm != null) {
                            switch (tcm) {
                                case TOKEN_CLIENT_ID: {
                                    labelTooltipDistribuzioneTokenInfoSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tokenInfo.clientID.tooltip.svg.pattern");
                                    if (parent.get("0") == null || parent.get("1") == null) break;
                                    labelTooltipDistribuzioneTokenInfoSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tokenInfo.clientID.applicativo.tooltip.svg.pattern");
                                    sb.append(MessageFormat.format(labelTooltipDistribuzioneTokenInfoSvgPattern, labelValore, valore, risultato, parent.get("0"), parent.get("1")));
                                    append = false;
                                    break;
                                }
                                case TOKEN_EMAIL: {
                                    labelTooltipDistribuzioneTokenInfoSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tokenInfo.email.tooltip.svg.pattern");
                                    break;
                                }
                                case TOKEN_ISSUER: {
                                    labelTooltipDistribuzioneTokenInfoSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tokenInfo.issuer.tooltip.svg.pattern");
                                    break;
                                }
                                case TOKEN_SUBJECT: {
                                    labelTooltipDistribuzioneTokenInfoSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tokenInfo.subject.tooltip.svg.pattern");
                                    break;
                                }
                                case TOKEN_USERNAME: {
                                    labelTooltipDistribuzioneTokenInfoSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tokenInfo.username.tooltip.svg.pattern");
                                    break;
                                }
                                case PDND_ORGANIZATION_NAME: {
                                    labelTooltipDistribuzioneTokenInfoSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tokenInfo.clientID.tooltip.svg.pattern");
                                    if (parent.get("0") == null) break;
                                    labelTooltipDistribuzioneTokenInfoSvgPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tokenInfo.pdndOrganizationName.tooltip.svg.pattern");
                                    sb.append(MessageFormat.format(labelTooltipDistribuzioneTokenInfoSvgPattern, labelValore, valore, risultato, parent.get("0"), parent.get("1"), parent.get("2")));
                                    append = false;
                                    break;
                                }
                            }
                        } else {
                            labelTooltipDistribuzioneTokenInfoSvgPattern = "ERROR";
                        }
                        if (!append) return sb.toString();
                        sb.append(MessageFormat.format(labelTooltipDistribuzioneTokenInfoSvgPattern, labelValore, valore, risultato));
                        return sb.toString();
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)form.getRiconoscimento())) return sb.toString();
                    if (form.getRiconoscimento().equals("applicativo")) {
                        String tooltipSectionApplicativo = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.sa.applicativo.pattern");
                        String tooltipSectionSoggetto = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.soggetto.pattern");
                        sb.append((String)labelValore).append(": ").append(valore).append(tooltipSectionApplicativo).append(risultato).append(tooltipSectionSoggetto).append(parent.get("0"));
                        if (!StringUtils.isNotBlank((CharSequence)form.getIdentificazione())) return sb.toString();
                        if (!"commons.identificazione.token.label".equals(form.getIdentificazione())) return sb.toString();
                        if (parent.get("1") == null) return sb.toString();
                        String tooltipClientId = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.sa.tokenInfo.clientID.pattern");
                        sb.append(tooltipClientId).append(parent.get("1"));
                        return sb.toString();
                    }
                    if (form.getRiconoscimento().equals("identificativoAutenticato")) {
                        String tooltipSectionIdentificativoAutenticato = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.sa.identificativoAutenticato.pattern");
                        String tooltipSectionAutenticazione = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.sa.identificativoAutenticato.autenticazione");
                        sb.append((String)labelValore).append(": ").append(valore).append(tooltipSectionIdentificativoAutenticato).append(risultato).append(tooltipSectionAutenticazione).append(parent.get("0"));
                        return sb.toString();
                    }
                    if (form.getRiconoscimento().equals("ip")) {
                        String tooltipSectionIndirizzoIP = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.sa.indirizzoIP.pattern");
                        sb.append((String)labelValore).append(": ").append(valore).append(tooltipSectionIndirizzoIP).append(risultato);
                        return sb.toString();
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)form.getTokenClaim())) return sb.toString();
                    tcm = null;
                    try {
                        tcm = TipoCredenzialeMittente.toEnumConstant((String)form.getTokenClaim(), (boolean)true);
                    }
                    catch (Exception e) {
                        Logger log = LoggerManager.getPddMonitorCoreLogger();
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    String tooltipSectionTokenInfo = null;
                    boolean append = true;
                    if (tcm != null) {
                        switch (tcm) {
                            case TOKEN_CLIENT_ID: {
                                tooltipSectionTokenInfo = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.sa.tokenInfo.clientID.pattern");
                                if (parent.get("0") == null || parent.get("1") == null) break;
                                String tooltipSectionApplicativo = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.sa.applicativo.pattern");
                                String tooltipSectionSoggetto = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.soggetto.pattern");
                                sb.append((String)labelValore).append(": ").append(valore).append(tooltipSectionTokenInfo).append(risultato).append(tooltipSectionApplicativo).append(parent.get("0")).append(tooltipSectionSoggetto).append(parent.get("1"));
                                append = false;
                                break;
                            }
                            case TOKEN_EMAIL: {
                                tooltipSectionTokenInfo = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.sa.tokenInfo.email.pattern");
                                break;
                            }
                            case TOKEN_ISSUER: {
                                tooltipSectionTokenInfo = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.sa.tokenInfo.issuer.pattern");
                                break;
                            }
                            case TOKEN_SUBJECT: {
                                tooltipSectionTokenInfo = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.sa.tokenInfo.subject.pattern");
                                break;
                            }
                            case TOKEN_USERNAME: {
                                tooltipSectionTokenInfo = MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tooltip.nosvg.sa.tokenInfo.username.pattern");
                                break;
                            }
                        }
                    } else {
                        tooltipSectionTokenInfo = "ERROR";
                    }
                    if (!append) return sb.toString();
                    sb.append((String)labelValore).append(": ").append(valore).append(tooltipSectionTokenInfo).append(risultato);
                    return sb.toString();
                }
            }
            sb.append(valore);
            return sb.toString();
        }
        if (value == null) return null;
        String string = String.valueOf(value);
        return string;
    }

    public static String getToolTextCategoriaAltri(StatsSearchForm form, Number value) {
        TipoVisualizzazione tipoVisualizzazione = null;
        if (form != null) {
            tipoVisualizzazione = form.getTipoVisualizzazione();
        }
        if (tipoVisualizzazione != null && value != null) {
            StringBuilder sb = new StringBuilder();
            String valore = null;
            Object labelValore = null;
            switch (tipoVisualizzazione) {
                case NUMERO_TRANSAZIONI: {
                    valore = Utility.numberConverter((Number)value);
                    labelValore = "Numero Transazioni";
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    valore = Utilities.convertSystemTimeIntoStringMillisecondi((long)value.longValue(), (boolean)true);
                    String tipoLatenzaLabel = StatsUtils.getTipoLatenzaServizioLabel(form);
                    labelValore = "Tempo Medio Risposta" + tipoLatenzaLabel;
                    break;
                }
                default: {
                    valore = Utility.fileSizeConverter((Number)value);
                    String tipoBandaLabel = StatsUtils.getTipoBandaLabel(form);
                    labelValore = "Occupazione Banda" + tipoBandaLabel;
                }
            }
            String labelTooltipCategoriaAltriPattern = MessageManager.getInstance().getMessage("stats.analisiStatistica.heatmap.tooltip.categoriaAltri.pattern");
            sb.append(MessageFormat.format(labelTooltipCategoriaAltriPattern, labelValore, valore));
            return sb.toString();
        }
        return value != null ? String.valueOf(value) : null;
    }

    public static String sommaColumnHeader(StatsSearchForm form, String suffix) {
        TipoVisualizzazione tipoVisualizzazione = form.getTipoVisualizzazione();
        switch (tipoVisualizzazione) {
            case NUMERO_TRANSAZIONI: {
                return "Totale " + suffix;
            }
            case TEMPO_MEDIO_RISPOSTA: {
                return "Tempo Medio Risposta";
            }
        }
        return "Dimensione " + suffix;
    }

    public static Number converToNumber(Object o) {
        if (o != null && o instanceof Number) {
            return (Number)o;
        }
        return null;
    }

    public static Number getMax(StatsSearchForm form, Number value, Number actualMax) {
        TipoVisualizzazione tipoVisualizzazione = null;
        if (form != null) {
            tipoVisualizzazione = form.getTipoVisualizzazione();
        }
        if (tipoVisualizzazione != null && value != null) {
            switch (tipoVisualizzazione) {
                case NUMERO_TRANSAZIONI: 
                case TEMPO_MEDIO_RISPOSTA: {
                    return Math.max(value.longValue(), actualMax.longValue());
                }
            }
            return Math.max(value.doubleValue(), actualMax.doubleValue());
        }
        return value != null ? (Number)Math.max(value.longValue(), actualMax.longValue()) : (Number)actualMax;
    }

    public static Number sum(StatsSearchForm form, Number value, Number actualSum) {
        TipoVisualizzazione tipoVisualizzazione = null;
        if (form != null) {
            tipoVisualizzazione = form.getTipoVisualizzazione();
        }
        if (tipoVisualizzazione != null && value != null) {
            switch (tipoVisualizzazione) {
                case NUMERO_TRANSAZIONI: 
                case TEMPO_MEDIO_RISPOSTA: {
                    return value.longValue() + actualSum.longValue();
                }
            }
            return value.doubleValue() + actualSum.doubleValue();
        }
        return value != null ? (Number)(value.longValue() + actualSum.longValue()) : (Number)actualSum;
    }

    public static Number avg(StatsSearchForm form, Number value, int numeroCategorie) {
        TipoVisualizzazione tipoVisualizzazione = null;
        if (form != null) {
            tipoVisualizzazione = form.getTipoVisualizzazione();
        }
        if (tipoVisualizzazione != null && value != null) {
            switch (tipoVisualizzazione) {
                case NUMERO_TRANSAZIONI: 
                case TEMPO_MEDIO_RISPOSTA: {
                    return value.longValue() / (long)numeroCategorie;
                }
            }
            return value.doubleValue() / (double)numeroCategorie;
        }
        return value != null ? value.longValue() / (long)numeroCategorie : 0L;
    }

    public static StatisticType checkStatisticType(StatsSearchForm form, boolean onlyForCount) {
        StatisticType tipologia = form.getModalitaTemporale();
        if (!form.isShowUnitaTempo() && form.isPeriodoPersonalizzato() && !form.isShowUnitaTempoPersonalizzato_periodoPersonalizzato()) {
            Date dInizio = form.getDataInizio();
            Date dFine = form.getDataFine();
            if (dInizio != null && dFine != null) {
                String format = "HH:mm";
                String inizio = DateUtils.getSimpleDateFormat((String)format).format(dInizio);
                String fine = DateUtils.getSimpleDateFormat((String)format).format(dFine);
                if ("00:00".equals(inizio) && "23:59".equals(fine)) {
                    String fineDay;
                    String formatDay;
                    String inizioDay;
                    tipologia = StatisticType.GIORNALIERA;
                    if (!onlyForCount && (inizioDay = DateUtils.getSimpleDateFormat((String)(formatDay = "yyyy-MM-dd")).format(dInizio)).equals(fineDay = DateUtils.getSimpleDateFormat((String)formatDay).format(dFine))) {
                        tipologia = StatisticType.ORARIA;
                    }
                } else {
                    tipologia = StatisticType.ORARIA;
                }
            }
            if (tipologia == null) {
                tipologia = StatisticType.GIORNALIERA;
            }
        }
        return tipologia;
    }

    public static String formatDate(StatsSearchForm form, Date date, boolean onlyForCount) {
        StatisticType tipologia = StatsUtils.checkStatisticType(form, onlyForCount);
        return StatsUtils.formatDate(tipologia, date);
    }

    public static String formatDate(StatisticType tipologia, Object value) {
        if (tipologia == null) {
            return null;
        }
        switch (tipologia) {
            case MENSILE: {
                SimpleDateFormat sdf = new SimpleDateFormat("MMM yyyy", ApplicationBean.getInstance().getLocale());
                return sdf.format(value);
            }
            case ORARIA: {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH", ApplicationBean.getInstance().getLocale());
                SimpleDateFormat sdfLastHour = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
                Calendar c = Calendar.getInstance();
                c.setTime((Date)value);
                c.add(10, 1);
                return sdf.format(value) + "-" + sdfLastHour.format(c.getTime());
            }
            case SETTIMANALE: {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd", ApplicationBean.getInstance().getLocale());
                SimpleDateFormat sdfLastHour = new SimpleDateFormat("yyyy/MM/dd", ApplicationBean.getInstance().getLocale());
                Calendar c = Calendar.getInstance();
                c.setTime((Date)value);
                c.add(4, 1);
                c.add(7, -1);
                return sdf.format(value) + "-" + sdfLastHour.format(c.getTime());
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd", ApplicationBean.getInstance().getLocale());
        return sdf.format(value);
    }

    public static String getLabel(DimensioneCustom numeroDimensioniCustom) {
        switch (numeroDimensioniCustom) {
            case TAG: {
                return MessageManager.getInstance().getMessage("commons.tag.label");
            }
            case API: {
                return MessageManager.getInstance().getMessage("commons.api.label");
            }
            case IMPLEMENTAZIONE_API: {
                return MessageManager.getInstance().getMessage("commons.servizio.label");
            }
            case OPERAZIONE: {
                return MessageManager.getInstance().getMessage("commons.azione.label");
            }
            case SOGGETTO_LOCALE: {
                return MessageManager.getInstance().getMessage("commons.soggettoLocale.label");
            }
            case SOGGETTO_REMOTO: {
                return MessageManager.getInstance().getMessage("commons.soggettoRemoto.label");
            }
            case SOGGETTO_FRUITORE: {
                return MessageManager.getInstance().getMessage("commons.fruitore.label");
            }
            case SOGGETTO_EROGATORE: {
                return MessageManager.getInstance().getMessage("commons.erogatore.label");
            }
            case TOKEN_ISSUER: {
                return MessageManager.getInstance().getMessage("commons.tokenInfo.issuer.label");
            }
            case TOKEN_SUBJECT: {
                return MessageManager.getInstance().getMessage("commons.tokenInfo.subject.label");
            }
            case TOKEN_CLIENT_ID: {
                return MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.label");
            }
            case TOKEN_USERNAME: {
                return MessageManager.getInstance().getMessage("commons.tokenInfo.username.label");
            }
            case TOKEN_EMAIL: {
                return MessageManager.getInstance().getMessage("commons.tokenInfo.email.label");
            }
            case TOKEN_PDND_ORGANIZATION: {
                return MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.label");
            }
            case TOKEN_PDND_ORGANIZATION_EXTERNAL_ID: {
                return MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.externalId.label");
            }
            case TOKEN_PDND_ORGANIZATION_CONSUMER_ID: {
                return MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.consumerId.label");
            }
            case PRINCIPAL: {
                return MessageManager.getInstance().getMessage("commons.identificativoAutenticato.label");
            }
            case APPLICATIVO_TRASPORTO: {
                return MessageManager.getInstance().getMessage("commons.applicativo.label");
            }
            case APPLICATIVO_TOKEN: {
                return MessageManager.getInstance().getMessage("commons.applicativoToken.label");
            }
            case INDIRIZZO_IP: {
                return MessageManager.getInstance().getMessage("commons.indirizzoIP.label");
            }
            case ESITO: {
                return MessageManager.getInstance().getMessage("commons.esito.label");
            }
        }
        return "N.D.";
    }
}

