/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.utils;

import be.quodlibet.boxable.HorizontalAlignment;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.statistiche.constants.TipoBanda;
import org.openspcoop2.core.statistiche.constants.TipoLatenza;
import org.openspcoop2.core.statistiche.constants.TipoStatistica;
import org.openspcoop2.core.statistiche.constants.TipoVisualizzazione;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.csv.Printer;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.converter.DurataConverter;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.datamodel.Res;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione3D;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione3DCustom;
import org.openspcoop2.web.monitor.core.report.Colonna;
import org.openspcoop2.web.monitor.core.report.ReportDataSource;
import org.openspcoop2.web.monitor.core.report.Templates;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.statistiche.bean.DimensioneCustom;
import org.openspcoop2.web.monitor.statistiche.bean.NumeroDimensioni;
import org.openspcoop2.web.monitor.statistiche.utils.StatsUtils;
import org.slf4j.Logger;

public class ExportUtils {
    private static final String HEADER_VALUE_CATEGORY_OK = "ok";
    private static final String HEADER_VALUE_LABEL_OK = "Ok";
    private static final String HEADER_VALUE_CATEGORY_FAULT_APPLICATIVO = "faultApplicativo";
    private static final String HEADER_VALUE_LABEL_FAULT_APPLICATIVO = "Fault Applicativo";
    private static final String HEADER_VALUE_CATEGORY_ERRORE = "errore";
    private static final String HEADER_VALUE_LABEL_ERRORE = "Fallite";
    private static final String HEADER_VALUE_CATEGORY_DATA_3D = "data_3d";
    private static final String HEADER_VALUE_CATEGORY_PARENT_0 = "parent_0";
    private static final String HEADER_VALUE_CATEGORY_PARENT_1 = "parent_1";
    private static final String HEADER_VALUE_CATEGORY_PARENT_2 = "parent_2";
    private static final String HEADER_VALUE_CATEGORY_PARENT_3 = "parent_3";
    private static final String HEADER_VALUE_CATEGORY_PARENT_4 = "parent_4";
    private static final String HEADER_VALUE_CATEGORY_PARENT_5 = "parent_5";
    private static final String HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_COMPLESSIVA = "occupazioneBandaComplessiva";
    private static final String HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_INTERNA = "occupazioneBandaInterna";
    private static final String HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_ESTERNA = "occupazioneBandaEsterna";
    private static final String HEADER_VALUE_CATEGORY_NUMERO_RICHIESTE = "numeroRichieste";
    private static final String HEADER_VALUE_LABEL_NUMERO_RICHIESTE = "Numero Transazioni";
    private static final String FORMAT_ANNO_MESE_GIORNO = "yyyy/MM/dd";
    private static final String FORMAT_MESE_ANNO = "MMM yyyy";
    private static final String FORMAT_ANNO_MESE_GIORNO_ORA = "yyyy/MM/dd HH";
    private static final String FORMAT_ORA = "HH";
    private static boolean isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato = false;

    private ExportUtils() {
    }

    public static void setDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato(boolean b) {
        isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato = b;
    }

    public static ReportDataSource creaReportAndamentoTemporale(List<Res> list, String titoloReport, Logger log, TipoVisualizzazione tipoVisualizzazione, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, StatisticType modalitaTemporale, boolean distribuzionePerEsiti, boolean convertRawData) throws CoreException {
        if (titoloReport != null) {
            // empty if block
        }
        return ExportUtils.getDatasourceAndamentoTemporale(list, log, tipoVisualizzazione, tipiBanda, tipiLatenza, modalitaTemporale, distribuzionePerEsiti, convertRawData);
    }

    public static ReportDataSource creaReportDistribuzione(List<ResDistribuzione> list, String titoloReport, Logger log, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, boolean convertRawData) {
        return ExportUtils.creaReportDistribuzione(list, titoloReport, log, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, null, null, null, convertRawData);
    }

    public static ReportDataSource creaReportDistribuzione(List<ResDistribuzione> list, String titoloReport, Logger log, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, boolean distribuzionePerImplementazioneApi, boolean convertRawData) {
        return ExportUtils.creaReportDistribuzione(list, titoloReport, log, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, null, null, null, distribuzionePerImplementazioneApi, convertRawData);
    }

    public static ReportDataSource creaReportDistribuzione(List<ResDistribuzione> list, String titoloReport, Logger log, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim, boolean convertRawData) {
        return ExportUtils.creaReportDistribuzione(list, titoloReport, log, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, tipoRiconoscimento, identificazione, tokenClaim, false, convertRawData);
    }

    private static ReportDataSource creaReportDistribuzione(List<ResDistribuzione> list, String titoloReport, Logger log, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim, boolean distribuzionePerImplementazioneApi, boolean convertRawData) {
        if (titoloReport != null) {
            // empty if block
        }
        return ExportUtils.getDatasourceDistribuzione(list, log, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, tipoRiconoscimento, identificazione, tokenClaim, distribuzionePerImplementazioneApi, convertRawData);
    }

    public static ReportDataSource creaReportAndamentoTemporalePersonalizzato(Map<String, List<Res>> results, String titoloReport, Logger log, TipoVisualizzazione tipoVisualizzazione, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, StatisticType modalitaTemporale, boolean convertRawData) throws CoreException {
        if (titoloReport != null) {
            // empty if block
        }
        return ExportUtils.getDatasourceAndamentoTemporalePersonalizzato(results, log, tipoVisualizzazione, tipiBanda, tipiLatenza, modalitaTemporale, convertRawData);
    }

    public static void esportaCsv(OutputStream outputStream, ReportDataSource datasource, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica) throws UtilsException {
        ExportUtils.esportaCsv(outputStream, datasource, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, null, null, null);
    }

    public static void esportaCsv(OutputStream outputStream, ReportDataSource datasource, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, boolean distribuzionePerImplementazioneApi) throws UtilsException {
        ExportUtils.esportaCsv(outputStream, datasource, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, null, null, null, false, distribuzionePerImplementazioneApi);
    }

    public static void esportaCsv(OutputStream outputStream, ReportDataSource datasource, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim) throws UtilsException {
        ExportUtils.esportaCsv(outputStream, datasource, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, tipoRiconoscimento, identificazione, tokenClaim, false);
    }

    public static void esportaCsv(OutputStream outputStream, ReportDataSource datasource, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim, boolean distribuzionePerEsiti) throws UtilsException {
        ExportUtils.esportaCsv(outputStream, datasource, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, tipoRiconoscimento, identificazione, tokenClaim, distribuzionePerEsiti, false);
    }

    private static void esportaCsv(OutputStream outputStream, ReportDataSource datasource, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim, boolean distribuzionePerEsiti, boolean distribuzionePerImplementazioneApi) throws UtilsException {
        boolean distribuzione3dCustom;
        if (titoloReport != null) {
            // empty if block
        }
        ArrayList<Colonna> colonne = new ArrayList<Colonna>();
        String headerValueLabel = "";
        String headerValueCategory = "";
        boolean distribuzione3d = numeroDimensioni != null && NumeroDimensioni.DIMENSIONI_3.equals(numeroDimensioni);
        boolean bl = distribuzione3dCustom = numeroDimensioni != null && NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(numeroDimensioni);
        if (distribuzione3d || distribuzione3dCustom) {
            switch (tipoStatistica) {
                case DISTRIBUZIONE_ERRORI: 
                case DISTRIBUZIONE_AZIONE: 
                case DISTRIBUZIONE_SERVIZIO: 
                case DISTRIBUZIONE_SERVIZIO_APPLICATIVO: 
                case DISTRIBUZIONE_SOGGETTO: 
                case STATISTICA_PERSONALIZZATA: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_DATA_3D;
                    headerValueLabel = distribuzione3d ? MessageManager.getInstance().getMessage("commons.data.label") : StatsUtils.getLabel(numeroDimensioniCustom);
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
            }
        }
        colonne.add(new Colonna("nome", headerLabel, HorizontalAlignment.CENTER));
        if (distribuzionePerEsiti) {
            headerValueCategory = HEADER_VALUE_CATEGORY_OK;
            headerValueLabel = HEADER_VALUE_LABEL_OK;
            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
            headerValueCategory = HEADER_VALUE_CATEGORY_FAULT_APPLICATIVO;
            headerValueLabel = HEADER_VALUE_LABEL_FAULT_APPLICATIVO;
            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
            headerValueCategory = HEADER_VALUE_CATEGORY_ERRORE;
            headerValueLabel = HEADER_VALUE_LABEL_ERRORE;
            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
        } else {
            switch (tipoStatistica) {
                case DISTRIBUZIONE_ERRORI: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.descrizione.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case DISTRIBUZIONE_AZIONE: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.api.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.erogatore.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case DISTRIBUZIONE_SERVIZIO: {
                    if (!distribuzionePerImplementazioneApi) break;
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.erogatore.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case DISTRIBUZIONE_SERVIZIO_APPLICATIVO: {
                    if (tipoRiconoscimento != null && tipoRiconoscimento.equals("applicativo")) {
                        headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                        headerValueLabel = MessageManager.getInstance().getMessage("commons.soggetto.label");
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                        if (!StringUtils.isNotBlank((CharSequence)identificazione) || !"commons.identificazione.token.label".equals(identificazione)) break;
                        headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                        headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.label");
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                        break;
                    }
                    if (tipoRiconoscimento != null && tipoRiconoscimento.equals("tokenInfo") && tokenClaim != null && StringUtils.isNotEmpty((CharSequence)tokenClaim)) {
                        try {
                            TipoCredenzialeMittente tcm = TipoCredenzialeMittente.toEnumConstant((String)tokenClaim, (boolean)true);
                            if (TipoCredenzialeMittente.TOKEN_CLIENT_ID.equals((Object)tcm)) {
                                headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                                headerValueLabel = MessageManager.getInstance().getMessage("commons.applicativo.label");
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                                headerValueLabel = MessageManager.getInstance().getMessage("commons.soggetto.label");
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                break;
                            }
                            if (!TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.equals((Object)tcm)) break;
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.externalId.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_2;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.categoria.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_3;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.id.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            if (!isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato) break;
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_4;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.applicativo.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_5;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.soggetto.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                        }
                        catch (Exception tcm) {}
                        break;
                    }
                    if (tipoRiconoscimento == null || !tipoRiconoscimento.equals("identificativoAutenticato")) break;
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.autenticazione.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
            }
            switch (tipoVisualizzazione) {
                case DIMENSIONE_TRANSAZIONI: {
                    block24: for (TipoBanda tipoBanda : tipiBanda) {
                        switch (tipoBanda) {
                            case COMPLESSIVA: {
                                headerValueCategory = HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_COMPLESSIVA;
                                headerValueLabel = "Occupazione Banda Complessiva [bytes]";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block24;
                            }
                            case INTERNA: {
                                headerValueCategory = HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_INTERNA;
                                headerValueLabel = "Occupazione Banda Interna [bytes]";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block24;
                            }
                        }
                        headerValueCategory = HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_ESTERNA;
                        headerValueLabel = "Occupazione Banda Esterna [bytes]";
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    }
                    break;
                }
                case NUMERO_TRANSAZIONI: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_NUMERO_RICHIESTE;
                    headerValueLabel = HEADER_VALUE_LABEL_NUMERO_RICHIESTE;
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    block25: for (TipoLatenza tipoLatenza : tipiLatenza) {
                        switch (tipoLatenza) {
                            case LATENZA_PORTA: {
                                headerValueCategory = "latenzaMediaPorta";
                                headerValueLabel = "Latenza Media Porta [ms]";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block25;
                            }
                            case LATENZA_SERVIZIO: {
                                headerValueCategory = "latenzaMediaServizio";
                                headerValueLabel = "Tempo Medio Risposta Servizio [ms]";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block25;
                            }
                        }
                        headerValueCategory = "latenzaMediaTotale";
                        headerValueLabel = "Latenza Media Totale [ms]";
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    }
                    break;
                }
            }
        }
        datasource.setColonne(colonne);
        Printer printer = Templates.getPrinter((OutputStream)outputStream);
        List labelColonna = datasource.getLabelColonne();
        List dati = datasource.getDati();
        Templates.writeDataIntoCsv((List)dati, (List)labelColonna, (Printer)printer);
        printer.close();
    }

    public static void esportaPdf(OutputStream outputStream, ReportDataSource report, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, boolean distribuzionePerImplementazioneApi) throws IOException, UtilsException {
        ExportUtils.esportaPdf(outputStream, report, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, null, null, null, false, distribuzionePerImplementazioneApi);
    }

    public static void esportaPdf(OutputStream outputStream, ReportDataSource report, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica) throws IOException, UtilsException {
        ExportUtils.esportaPdf(outputStream, report, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, null, null, null);
    }

    public static void esportaPdf(OutputStream outputStream, ReportDataSource report, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim) throws IOException, UtilsException {
        ExportUtils.esportaPdf(outputStream, report, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, tipoRiconoscimento, identificazione, tokenClaim, false);
    }

    public static void esportaPdf(OutputStream outputStream, ReportDataSource report, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim, boolean distribuzionePerEsiti) throws IOException, UtilsException {
        ExportUtils.esportaPdf(outputStream, report, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, tipoRiconoscimento, identificazione, tokenClaim, distribuzionePerEsiti, false);
    }

    private static void esportaPdf(OutputStream outputStream, ReportDataSource report, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim, boolean distribuzionePerEsiti, boolean distribuzionePerImplementazioneApi) throws IOException, UtilsException {
        boolean distribuzione3dCustom;
        String headerValueLabel = "";
        String headerValueCategory = "";
        ArrayList<Colonna> colonne = new ArrayList<Colonna>();
        boolean distribuzione3d = numeroDimensioni != null && NumeroDimensioni.DIMENSIONI_3.equals(numeroDimensioni);
        boolean bl = distribuzione3dCustom = numeroDimensioni != null && NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(numeroDimensioni);
        if (distribuzione3d || distribuzione3dCustom) {
            switch (tipoStatistica) {
                case DISTRIBUZIONE_ERRORI: 
                case DISTRIBUZIONE_AZIONE: 
                case DISTRIBUZIONE_SERVIZIO: 
                case DISTRIBUZIONE_SERVIZIO_APPLICATIVO: 
                case DISTRIBUZIONE_SOGGETTO: 
                case STATISTICA_PERSONALIZZATA: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_DATA_3D;
                    headerValueLabel = distribuzione3d ? MessageManager.getInstance().getMessage("commons.data.label") : StatsUtils.getLabel(numeroDimensioniCustom);
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
            }
        }
        colonne.add(new Colonna("nome", headerLabel, HorizontalAlignment.CENTER));
        if (distribuzionePerEsiti) {
            headerValueCategory = HEADER_VALUE_CATEGORY_OK;
            headerValueLabel = HEADER_VALUE_LABEL_OK;
            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
            headerValueCategory = HEADER_VALUE_CATEGORY_FAULT_APPLICATIVO;
            headerValueLabel = HEADER_VALUE_LABEL_FAULT_APPLICATIVO;
            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
            headerValueCategory = HEADER_VALUE_CATEGORY_ERRORE;
            headerValueLabel = HEADER_VALUE_LABEL_ERRORE;
            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
        } else {
            switch (tipoStatistica) {
                case DISTRIBUZIONE_ERRORI: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.descrizione.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case DISTRIBUZIONE_AZIONE: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.api.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.erogatore.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case DISTRIBUZIONE_SERVIZIO: {
                    if (!distribuzionePerImplementazioneApi) break;
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.erogatore.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case DISTRIBUZIONE_SERVIZIO_APPLICATIVO: {
                    if (tipoRiconoscimento != null && tipoRiconoscimento.equals("applicativo")) {
                        headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                        headerValueLabel = MessageManager.getInstance().getMessage("commons.soggetto.label");
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                        if (!StringUtils.isNotBlank((CharSequence)identificazione) || !"commons.identificazione.token.label".equals(identificazione)) break;
                        headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                        headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.label");
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                        break;
                    }
                    if (tipoRiconoscimento != null && tipoRiconoscimento.equals("tokenInfo") && tokenClaim != null && StringUtils.isNotEmpty((CharSequence)tokenClaim)) {
                        try {
                            TipoCredenzialeMittente tcm = TipoCredenzialeMittente.toEnumConstant((String)tokenClaim, (boolean)true);
                            if (TipoCredenzialeMittente.TOKEN_CLIENT_ID.equals((Object)tcm)) {
                                headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                                headerValueLabel = MessageManager.getInstance().getMessage("commons.applicativo.label");
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                                headerValueLabel = MessageManager.getInstance().getMessage("commons.soggetto.label");
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                break;
                            }
                            if (!TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.equals((Object)tcm)) break;
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.externalId.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_2;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.categoria.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_3;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.id.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            if (!isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato) break;
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_4;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.applicativo.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_5;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.soggetto.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                        }
                        catch (Exception tcm) {}
                        break;
                    }
                    if (tipoRiconoscimento == null || !tipoRiconoscimento.equals("identificativoAutenticato")) break;
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.autenticazione.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
            }
            switch (tipoVisualizzazione) {
                case DIMENSIONE_TRANSAZIONI: {
                    block24: for (TipoBanda tipoBanda : tipiBanda) {
                        switch (tipoBanda) {
                            case COMPLESSIVA: {
                                headerValueCategory = HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_COMPLESSIVA;
                                headerValueLabel = "Occupazione Banda Complessiva";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block24;
                            }
                            case INTERNA: {
                                headerValueCategory = HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_INTERNA;
                                headerValueLabel = "Occupazione Banda Interna";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block24;
                            }
                        }
                        headerValueCategory = HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_ESTERNA;
                        headerValueLabel = "Occupazione Banda Esterna";
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    }
                    break;
                }
                case NUMERO_TRANSAZIONI: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_NUMERO_RICHIESTE;
                    headerValueLabel = HEADER_VALUE_LABEL_NUMERO_RICHIESTE;
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    block25: for (TipoLatenza tipoLatenza : tipiLatenza) {
                        switch (tipoLatenza) {
                            case LATENZA_PORTA: {
                                headerValueCategory = "latenzaMediaPorta";
                                headerValueLabel = "Latenza Media Porta";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block25;
                            }
                            case LATENZA_SERVIZIO: {
                                headerValueCategory = "latenzaMediaServizio";
                                headerValueLabel = "Tempo Medio Risposta Servizio";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block25;
                            }
                        }
                        headerValueCategory = "latenzaMediaTotale";
                        headerValueLabel = "Latenza Media Totale";
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    }
                    break;
                }
            }
        }
        List dati = report.getDati();
        PDDocument document = new PDDocument();
        PDPage page = new PDPage(PDRectangle.A4);
        document.addPage(page);
        Templates.createTitleComponent((String)titoloReport, (String)"", (PDDocument)document);
        Templates.createTableComponent(colonne, (List)dati, (PDDocument)document);
        document.save(outputStream);
    }

    public static void esportaXls(OutputStream outputStream, ReportDataSource datasource, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica) throws IOException {
        ExportUtils.esportaXls(outputStream, datasource, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, null, null, null);
    }

    public static void esportaXls(OutputStream outputStream, ReportDataSource datasource, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, boolean distribuzionePerImplementazioneApi) throws IOException {
        ExportUtils.esportaXls(outputStream, datasource, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, null, null, null, false, distribuzionePerImplementazioneApi);
    }

    public static void esportaXls(OutputStream outputStream, ReportDataSource datasource, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim) throws IOException {
        ExportUtils.esportaXls(outputStream, datasource, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, tipoRiconoscimento, identificazione, tokenClaim, false);
    }

    public static void esportaXls(OutputStream outputStream, ReportDataSource datasource, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim, boolean distribuzionePerEsiti) throws IOException {
        ExportUtils.esportaXls(outputStream, datasource, titoloReport, headerLabel, tipoVisualizzazione, numeroDimensioni, numeroDimensioniCustom, tipiBanda, tipiLatenza, tipoStatistica, tipoRiconoscimento, identificazione, tokenClaim, distribuzionePerEsiti, false);
    }

    private static void esportaXls(OutputStream outputStream, ReportDataSource datasource, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim, boolean distribuzionePerEsiti, boolean distribuzionePerImplementazioneApi) throws IOException {
        boolean distribuzione3dCustom;
        if (titoloReport != null) {
            // empty if block
        }
        ArrayList<Colonna> colonne = new ArrayList<Colonna>();
        String headerValueLabel = "";
        String headerValueCategory = "";
        boolean distribuzione3d = numeroDimensioni != null && NumeroDimensioni.DIMENSIONI_3.equals(numeroDimensioni);
        boolean bl = distribuzione3dCustom = numeroDimensioni != null && NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(numeroDimensioni);
        if (distribuzione3d || distribuzione3dCustom) {
            switch (tipoStatistica) {
                case DISTRIBUZIONE_ERRORI: 
                case DISTRIBUZIONE_AZIONE: 
                case DISTRIBUZIONE_SERVIZIO: 
                case DISTRIBUZIONE_SERVIZIO_APPLICATIVO: 
                case DISTRIBUZIONE_SOGGETTO: 
                case STATISTICA_PERSONALIZZATA: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_DATA_3D;
                    headerValueLabel = distribuzione3d ? MessageManager.getInstance().getMessage("commons.data.label") : StatsUtils.getLabel(numeroDimensioniCustom);
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
            }
        }
        colonne.add(new Colonna("nome", headerLabel, HorizontalAlignment.CENTER));
        if (distribuzionePerEsiti) {
            headerValueCategory = HEADER_VALUE_CATEGORY_OK;
            headerValueLabel = HEADER_VALUE_LABEL_OK;
            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
            headerValueCategory = HEADER_VALUE_CATEGORY_FAULT_APPLICATIVO;
            headerValueLabel = HEADER_VALUE_LABEL_FAULT_APPLICATIVO;
            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
            headerValueCategory = HEADER_VALUE_CATEGORY_ERRORE;
            headerValueLabel = HEADER_VALUE_LABEL_ERRORE;
            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
        } else {
            switch (tipoStatistica) {
                case DISTRIBUZIONE_ERRORI: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.descrizione.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case DISTRIBUZIONE_AZIONE: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.api.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.erogatore.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case DISTRIBUZIONE_SERVIZIO: {
                    if (!distribuzionePerImplementazioneApi) break;
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.erogatore.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case DISTRIBUZIONE_SERVIZIO_APPLICATIVO: {
                    if (tipoRiconoscimento != null && tipoRiconoscimento.equals("applicativo")) {
                        headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                        headerValueLabel = MessageManager.getInstance().getMessage("commons.soggetto.label");
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                        if (!StringUtils.isNotBlank((CharSequence)identificazione) || !"commons.identificazione.token.label".equals(identificazione)) break;
                        headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                        headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.label");
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                        break;
                    }
                    if (tipoRiconoscimento != null && tipoRiconoscimento.equals("tokenInfo") && tokenClaim != null && StringUtils.isNotEmpty((CharSequence)tokenClaim)) {
                        try {
                            TipoCredenzialeMittente tcm = TipoCredenzialeMittente.toEnumConstant((String)tokenClaim, (boolean)true);
                            if (TipoCredenzialeMittente.TOKEN_CLIENT_ID.equals((Object)tcm)) {
                                headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                                headerValueLabel = MessageManager.getInstance().getMessage("commons.applicativo.label");
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                                headerValueLabel = MessageManager.getInstance().getMessage("commons.soggetto.label");
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                break;
                            }
                            if (!TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.equals((Object)tcm)) break;
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_1;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.externalId.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_2;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.categoria.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_3;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.tokenInfo.clientID.pdnd.id.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            if (!isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato) break;
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_4;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.applicativo.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                            headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_5;
                            headerValueLabel = MessageManager.getInstance().getMessage("commons.soggetto.label");
                            colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                        }
                        catch (Exception tcm) {}
                        break;
                    }
                    if (tipoRiconoscimento == null || !tipoRiconoscimento.equals("identificativoAutenticato")) break;
                    headerValueCategory = HEADER_VALUE_CATEGORY_PARENT_0;
                    headerValueLabel = MessageManager.getInstance().getMessage("commons.autenticazione.label");
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
            }
            switch (tipoVisualizzazione) {
                case DIMENSIONE_TRANSAZIONI: {
                    block29: for (TipoBanda tipoBanda : tipiBanda) {
                        switch (tipoBanda) {
                            case COMPLESSIVA: {
                                headerValueCategory = HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_COMPLESSIVA;
                                headerValueLabel = "Occupazione Banda Complessiva [bytes]";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block29;
                            }
                            case INTERNA: {
                                headerValueCategory = HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_INTERNA;
                                headerValueLabel = "Occupazione Banda Interna [bytes]";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block29;
                            }
                        }
                        headerValueCategory = HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_ESTERNA;
                        headerValueLabel = "Occupazione Banda Esterna [bytes]";
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    }
                    break;
                }
                case NUMERO_TRANSAZIONI: {
                    headerValueCategory = HEADER_VALUE_CATEGORY_NUMERO_RICHIESTE;
                    headerValueLabel = HEADER_VALUE_LABEL_NUMERO_RICHIESTE;
                    colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    block30: for (TipoLatenza tipoLatenza : tipiLatenza) {
                        switch (tipoLatenza) {
                            case LATENZA_PORTA: {
                                headerValueCategory = "latenzaMediaPorta";
                                headerValueLabel = "Latenza Media Porta [ms]";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block30;
                            }
                            case LATENZA_SERVIZIO: {
                                headerValueCategory = "latenzaMediaServizio";
                                headerValueLabel = "Tempo Medio Risposta Servizio [ms]";
                                colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                                continue block30;
                            }
                        }
                        headerValueCategory = "latenzaMediaTotale";
                        headerValueLabel = "Latenza Media Totale [ms]";
                        colonne.add(new Colonna(headerValueCategory, headerValueLabel, HorizontalAlignment.CENTER));
                    }
                    break;
                }
            }
        }
        datasource.setColonne(colonne);
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            List labelColonna = datasource.getLabelColonne();
            List dati = datasource.getDati();
            Templates.writeDataIntoXls((List)dati, (List)labelColonna, (XSSFWorkbook)workbook);
            workbook.write(outputStream);
        }
    }

    private static ReportDataSource getDatasourceAndamentoTemporale(List<Res> list, Logger log, TipoVisualizzazione tipoVisualizzazione, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, StatisticType modalitaTemporale, boolean distribuzionePerEsiti, boolean convertRawData) throws CoreException {
        ArrayList<String> header = new ArrayList<String>();
        header.add("nome");
        if (distribuzionePerEsiti) {
            header.add(HEADER_VALUE_CATEGORY_OK);
            header.add(HEADER_VALUE_CATEGORY_FAULT_APPLICATIVO);
            header.add(HEADER_VALUE_CATEGORY_ERRORE);
        }
        boolean isLatenzaTotale = false;
        boolean isLatenzaServizio = false;
        boolean isLatenzaPorta = false;
        boolean isNumeroRichieste = false;
        boolean isDimensioneComplessiva = false;
        boolean isDimensioneInterna = false;
        boolean isDimensioneEsterna = false;
        switch (tipoVisualizzazione) {
            case DIMENSIONE_TRANSAZIONI: {
                block22: for (TipoBanda tipoBanda : tipiBanda) {
                    switch (tipoBanda) {
                        case COMPLESSIVA: {
                            isDimensioneComplessiva = true;
                            if (distribuzionePerEsiti) continue block22;
                            header.add(HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_COMPLESSIVA);
                            continue block22;
                        }
                        case INTERNA: {
                            isDimensioneInterna = true;
                            if (distribuzionePerEsiti) continue block22;
                            header.add(HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_INTERNA);
                            continue block22;
                        }
                    }
                    isDimensioneEsterna = true;
                    if (distribuzionePerEsiti) continue;
                    header.add(HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_ESTERNA);
                }
                break;
            }
            case NUMERO_TRANSAZIONI: {
                isNumeroRichieste = true;
                if (distribuzionePerEsiti) break;
                header.add(HEADER_VALUE_CATEGORY_NUMERO_RICHIESTE);
                break;
            }
            case TEMPO_MEDIO_RISPOSTA: {
                block23: for (TipoLatenza tipoLatenza : tipiLatenza) {
                    switch (tipoLatenza) {
                        case LATENZA_PORTA: {
                            isLatenzaPorta = true;
                            if (distribuzionePerEsiti) continue block23;
                            header.add("latenzaMediaPorta");
                            continue block23;
                        }
                        case LATENZA_SERVIZIO: {
                            isLatenzaServizio = true;
                            if (distribuzionePerEsiti) continue block23;
                            header.add("latenzaMediaServizio");
                            continue block23;
                        }
                    }
                    isLatenzaTotale = true;
                    if (distribuzionePerEsiti) continue;
                    header.add("latenzaMediaTotale");
                }
                break;
            }
        }
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdfLastHour = null;
        switch (modalitaTemporale) {
            case MENSILE: {
                sdf = new SimpleDateFormat(FORMAT_MESE_ANNO, ApplicationBean.getInstance().getLocale());
                break;
            }
            case SETTIMANALE: {
                sdf = new SimpleDateFormat(FORMAT_ANNO_MESE_GIORNO, ApplicationBean.getInstance().getLocale());
                sdfLastHour = new SimpleDateFormat(FORMAT_ANNO_MESE_GIORNO, ApplicationBean.getInstance().getLocale());
                break;
            }
            case ORARIA: {
                sdf = new SimpleDateFormat(FORMAT_ANNO_MESE_GIORNO_ORA, ApplicationBean.getInstance().getLocale());
                sdfLastHour = new SimpleDateFormat(FORMAT_ORA, ApplicationBean.getInstance().getLocale());
                break;
            }
            default: {
                sdf = new SimpleDateFormat(FORMAT_ANNO_MESE_GIORNO, ApplicationBean.getInstance().getLocale());
            }
        }
        ReportDataSource dataSource = new ReportDataSource(header);
        for (int idx = 0; idx < list.size(); ++idx) {
            Res risultato = list.get(idx);
            ArrayList<Object> oneLine = new ArrayList<Object>();
            Object label = "";
            Calendar c = null;
            switch (modalitaTemporale) {
                case SETTIMANALE: {
                    c = Calendar.getInstance();
                    c.setTime(risultato.getRisultato());
                    c.add(4, 1);
                    c.add(7, -1);
                    if (sdfLastHour == null) {
                        throw new CoreException("sdf_last_hour undefined");
                    }
                    label = sdf.format(risultato.getRisultato()) + "-" + sdfLastHour.format(c.getTime());
                    break;
                }
                case ORARIA: {
                    sdf = new SimpleDateFormat(FORMAT_ANNO_MESE_GIORNO_ORA, ApplicationBean.getInstance().getLocale());
                    sdfLastHour = new SimpleDateFormat(FORMAT_ORA, ApplicationBean.getInstance().getLocale());
                    c = Calendar.getInstance();
                    c.setTime(risultato.getRisultato());
                    c.add(10, 1);
                    label = sdf.format(risultato.getRisultato()) + "-" + sdfLastHour.format(c.getTime());
                    break;
                }
                default: {
                    label = sdf.format(risultato.getRisultato());
                }
            }
            oneLine.add(label);
            if (isNumeroRichieste) {
                if (distribuzionePerEsiti) {
                    if (convertRawData) {
                        oneLine.add(Utility.numberConverter((Number)((Number)risultato.getObjectsMap().get("0")).longValue()));
                        oneLine.add(Utility.numberConverter((Number)((Number)risultato.getObjectsMap().get("1")).longValue()));
                        oneLine.add(Utility.numberConverter((Number)((Number)risultato.getObjectsMap().get("2")).longValue()));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("0")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("1")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("2")).longValue());
                    }
                } else if (convertRawData) {
                    oneLine.add(Utility.numberConverter((Number)risultato.getSomma()));
                } else {
                    oneLine.add(String.valueOf(risultato.getSomma()));
                }
            }
            int indexDimensione = 0;
            if (isDimensioneComplessiva) {
                if (distribuzionePerEsiti) {
                    if (convertRawData) {
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("0")).longValue()));
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("1")).longValue()));
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("2")).longValue()));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("0")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("1")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("2")).longValue());
                    }
                } else if (convertRawData) {
                    oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue()));
                } else {
                    oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue());
                }
                ++indexDimensione;
            }
            if (isDimensioneInterna) {
                if (distribuzionePerEsiti) {
                    if (convertRawData) {
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("0")).longValue()));
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("1")).longValue()));
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("2")).longValue()));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("0")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("1")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("2")).longValue());
                    }
                } else if (convertRawData) {
                    oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue()));
                } else {
                    oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue());
                }
                ++indexDimensione;
            }
            if (isDimensioneEsterna) {
                if (distribuzionePerEsiti) {
                    if (convertRawData) {
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("0")).longValue()));
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("1")).longValue()));
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("2")).longValue()));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("0")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("1")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("2")).longValue());
                    }
                } else if (convertRawData) {
                    oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue()));
                } else {
                    oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue());
                }
            }
            int indexLatenza = 0;
            if (isLatenzaTotale) {
                if (distribuzionePerEsiti) {
                    if (convertRawData) {
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("0")).longValue(), (boolean)true));
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("1")).longValue(), (boolean)true));
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("2")).longValue(), (boolean)true));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("0")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("1")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("2")).longValue());
                    }
                } else if (convertRawData) {
                    oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue(), (boolean)true));
                } else {
                    oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue());
                }
                ++indexLatenza;
            }
            if (isLatenzaServizio) {
                if (distribuzionePerEsiti) {
                    if (convertRawData) {
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("0")).longValue(), (boolean)true));
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("1")).longValue(), (boolean)true));
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("2")).longValue(), (boolean)true));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("0")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("1")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("2")).longValue());
                    }
                } else if (convertRawData) {
                    oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue(), (boolean)true));
                } else {
                    oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue());
                }
                ++indexLatenza;
            }
            if (isLatenzaPorta) {
                if (distribuzionePerEsiti) {
                    if (convertRawData) {
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("0")).longValue(), (boolean)true));
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("1")).longValue(), (boolean)true));
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("2")).longValue(), (boolean)true));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("0")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("1")).longValue());
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("2")).longValue());
                    }
                } else if (convertRawData) {
                    oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue(), (boolean)true));
                } else {
                    oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue());
                }
            }
            String msg = "Gruppo " + ((Object)oneLine).toString();
            log.debug(msg);
            dataSource.add(oneLine);
        }
        return dataSource;
    }

    public static void esportaCsvAndamentoTemporalePersonalizzato(OutputStream outputStream, ReportDataSource datasource, Map<String, List<Res>> results, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza) throws UtilsException {
        if (titoloReport != null) {
            // empty if block
        }
        if (tipiBanda != null) {
            // empty if block
        }
        if (tipoVisualizzazione != null) {
            // empty if block
        }
        if (tipiLatenza != null) {
            // empty if block
        }
        ArrayList<Colonna> colonne = new ArrayList<Colonna>();
        colonne.add(new Colonna("nome", headerLabel, HorizontalAlignment.CENTER));
        if (results != null && results.size() > 0) {
            Set<String> keys = results.keySet();
            Iterator<String> it = keys.iterator();
            int i = 0;
            while (it.hasNext()) {
                String key = it.next();
                colonne.add(new Colonna("r" + i, key, HorizontalAlignment.CENTER));
                ++i;
            }
        }
        datasource.setColonne(colonne);
        Printer printer = Templates.getPrinter((OutputStream)outputStream);
        List labelColonna = datasource.getLabelColonne();
        List dati = datasource.getDati();
        Templates.writeDataIntoCsv((List)dati, (List)labelColonna, (Printer)printer);
        printer.close();
    }

    public static void esportaXlsAndamentoTemporalePersonalizzato(OutputStream outputStream, ReportDataSource datasource, Map<String, List<Res>> results, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza) throws IOException {
        if (titoloReport != null) {
            // empty if block
        }
        if (tipoVisualizzazione != null) {
            // empty if block
        }
        if (tipiBanda != null) {
            // empty if block
        }
        if (tipiLatenza != null) {
            // empty if block
        }
        ArrayList<Colonna> colonne = new ArrayList<Colonna>();
        colonne.add(new Colonna("nome", headerLabel, HorizontalAlignment.CENTER));
        if (results != null && results.size() > 0) {
            Set<String> keys = results.keySet();
            Iterator<String> it = keys.iterator();
            int i = 0;
            while (it.hasNext()) {
                String key = it.next();
                colonne.add(new Colonna("r" + i, key, HorizontalAlignment.CENTER));
                ++i;
            }
        }
        datasource.setColonne(colonne);
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            List labelColonna = datasource.getLabelColonne();
            List dati = datasource.getDati();
            Templates.writeDataIntoXls((List)dati, (List)labelColonna, (XSSFWorkbook)workbook);
            workbook.write(outputStream);
        }
    }

    public static void esportaPdfAndamentoTemporalePersonalizzato(OutputStream outputStream, ReportDataSource report, Map<String, List<Res>> results, String titoloReport, String headerLabel, TipoVisualizzazione tipoVisualizzazione, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza) throws IOException {
        if (tipoVisualizzazione != null) {
            // empty if block
        }
        if (tipiBanda != null) {
            // empty if block
        }
        if (tipiLatenza != null) {
            // empty if block
        }
        ArrayList<Colonna> colonne = new ArrayList<Colonna>();
        colonne.add(new Colonna("nome", headerLabel, HorizontalAlignment.CENTER));
        if (results != null && results.size() > 0) {
            Set<String> keys = results.keySet();
            Iterator<String> it = keys.iterator();
            int i = 0;
            while (it.hasNext()) {
                String key = it.next();
                colonne.add(new Colonna("r" + i, key, HorizontalAlignment.CENTER));
                ++i;
            }
        }
        List dati = report.getDati();
        PDDocument document = new PDDocument();
        PDPage page = new PDPage(PDRectangle.A4);
        document.addPage(page);
        Templates.createTitleComponent((String)titoloReport, (String)"", (PDDocument)document);
        Templates.createTableComponent(colonne, (List)dati, (PDDocument)document);
        document.save(outputStream);
    }

    private static ReportDataSource getDatasourceAndamentoTemporalePersonalizzato(Map<String, List<Res>> results, Logger log, TipoVisualizzazione tipoVisualizzazione, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, StatisticType modalitaTemporale, boolean convertRawData) throws CoreException {
        ArrayList<Object> header = new ArrayList<Object>();
        boolean isLatenzaTotale = false;
        boolean isLatenzaServizio = false;
        boolean isLatenzaPorta = false;
        boolean isNumeroRichieste = false;
        boolean isDimensioneComplessiva = false;
        boolean isDimensioneInterna = false;
        boolean isDimensioneEsterna = false;
        switch (tipoVisualizzazione) {
            case DIMENSIONE_TRANSAZIONI: {
                block22: for (TipoBanda tipoBanda : tipiBanda) {
                    switch (tipoBanda) {
                        case COMPLESSIVA: {
                            isDimensioneComplessiva = true;
                            continue block22;
                        }
                        case INTERNA: {
                            isDimensioneInterna = true;
                            continue block22;
                        }
                    }
                    isDimensioneEsterna = true;
                }
                break;
            }
            case NUMERO_TRANSAZIONI: {
                isNumeroRichieste = true;
                break;
            }
            case TEMPO_MEDIO_RISPOSTA: {
                block23: for (TipoLatenza tipoLatenza : tipiLatenza) {
                    switch (tipoLatenza) {
                        case LATENZA_PORTA: {
                            isLatenzaPorta = true;
                            continue block23;
                        }
                        case LATENZA_SERVIZIO: {
                            isLatenzaServizio = true;
                            continue block23;
                        }
                    }
                    isLatenzaTotale = true;
                }
                break;
            }
        }
        int numeroRisultati = 0;
        if (results != null && results.size() > 0) {
            Set<String> keys = results.keySet();
            Iterator<String> it = keys.iterator();
            int i = 0;
            header.add("nome");
            while (it.hasNext()) {
                String key = it.next();
                List<Res> list = results.get(key);
                numeroRisultati = list.size();
                header.add("r" + i);
                ++i;
            }
        }
        String msg = "Header " + ((Object)header).toString();
        log.debug(msg);
        ReportDataSource dataSource = new ReportDataSource(header);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdfLastHour = null;
        switch (modalitaTemporale) {
            case MENSILE: {
                sdf = new SimpleDateFormat(FORMAT_MESE_ANNO, ApplicationBean.getInstance().getLocale());
                break;
            }
            case SETTIMANALE: {
                sdf = new SimpleDateFormat(FORMAT_ANNO_MESE_GIORNO, ApplicationBean.getInstance().getLocale());
                sdfLastHour = new SimpleDateFormat(FORMAT_ANNO_MESE_GIORNO, ApplicationBean.getInstance().getLocale());
                break;
            }
            case ORARIA: {
                sdf = new SimpleDateFormat(FORMAT_ANNO_MESE_GIORNO_ORA, ApplicationBean.getInstance().getLocale());
                sdfLastHour = new SimpleDateFormat(FORMAT_ORA, ApplicationBean.getInstance().getLocale());
                break;
            }
            default: {
                sdf = new SimpleDateFormat(FORMAT_ANNO_MESE_GIORNO, ApplicationBean.getInstance().getLocale());
            }
        }
        for (int idx = 0; idx < numeroRisultati; ++idx) {
            ArrayList<Object> oneLine = new ArrayList<Object>();
            Set<String> keys = results.keySet();
            Iterator<String> it = keys.iterator();
            int i = 0;
            while (it.hasNext()) {
                String key = it.next();
                List<Res> list = results.get(key);
                Res risultato = list.get(idx);
                if (i < 1) {
                    Object label = "";
                    Calendar c = null;
                    switch (modalitaTemporale) {
                        case SETTIMANALE: {
                            c = Calendar.getInstance();
                            c.setTime(risultato.getRisultato());
                            c.add(4, 1);
                            c.add(7, -1);
                            if (sdfLastHour == null) {
                                throw new CoreException("sdf_last_hour is null");
                            }
                            label = sdf.format(risultato.getRisultato()) + "-" + sdfLastHour.format(c.getTime());
                            break;
                        }
                        case ORARIA: {
                            sdf = new SimpleDateFormat(FORMAT_ANNO_MESE_GIORNO_ORA, ApplicationBean.getInstance().getLocale());
                            sdfLastHour = new SimpleDateFormat(FORMAT_ORA, ApplicationBean.getInstance().getLocale());
                            c = Calendar.getInstance();
                            c.setTime(risultato.getRisultato());
                            c.add(10, 1);
                            label = sdf.format(risultato.getRisultato()) + "-" + sdfLastHour.format(c.getTime());
                            break;
                        }
                        default: {
                            label = sdf.format(risultato.getRisultato());
                        }
                    }
                    oneLine.add(label);
                    msg = "Aggiunta Data " + (String)label + " ";
                    log.debug(msg);
                }
                msg = "Lista " + key + " Risultato Corrente " + String.valueOf(risultato.getSomma());
                log.debug(msg);
                if (isNumeroRichieste) {
                    if (convertRawData) {
                        oneLine.add(Utility.numberConverter((Number)risultato.getSomma()));
                    } else {
                        oneLine.add(String.valueOf(risultato.getSomma()));
                    }
                }
                int indexDimensione = 0;
                if (isDimensioneComplessiva) {
                    if (convertRawData) {
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue()));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue());
                    }
                    ++indexDimensione;
                }
                if (isDimensioneInterna) {
                    if (convertRawData) {
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue()));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue());
                    }
                    ++indexDimensione;
                }
                if (isDimensioneEsterna) {
                    if (convertRawData) {
                        oneLine.add(Utility.fileSizeConverter((Number)((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue()));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexDimensione)).longValue());
                    }
                }
                int indexLatenza = 0;
                if (isLatenzaTotale) {
                    if (convertRawData) {
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue(), (boolean)true));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue());
                    }
                    ++indexLatenza;
                }
                if (isLatenzaServizio) {
                    if (convertRawData) {
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue(), (boolean)true));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue());
                    }
                    ++indexLatenza;
                }
                if (isLatenzaPorta) {
                    if (convertRawData) {
                        oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue(), (boolean)true));
                    } else {
                        oneLine.add("" + ((Number)risultato.getObjectsMap().get("" + indexLatenza)).longValue());
                    }
                }
                ++i;
            }
            msg = "Gruppo " + ((Object)oneLine).toString();
            log.debug(msg);
            dataSource.add(oneLine);
        }
        return dataSource;
    }

    private static ReportDataSource getDatasourceDistribuzione(List<ResDistribuzione> list, Logger log, TipoVisualizzazione tipoVisualizzazione, NumeroDimensioni numeroDimensioni, DimensioneCustom numeroDimensioniCustom, List<TipoBanda> tipiBanda, List<TipoLatenza> tipiLatenza, TipoStatistica tipoStatistica, String tipoRiconoscimento, String identificazione, String tokenClaim, boolean distribuzionePerImplementazioneApi, boolean convertRawData) {
        boolean distribuzione3dCustom;
        boolean distribuzione3d = numeroDimensioni != null && NumeroDimensioni.DIMENSIONI_3.equals(numeroDimensioni);
        boolean bl = distribuzione3dCustom = numeroDimensioni != null && NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(numeroDimensioni);
        if (!distribuzione3dCustom || numeroDimensioniCustom != null) {
            // empty if block
        }
        ArrayList<String> header = new ArrayList<String>();
        if (distribuzione3d || distribuzione3dCustom) {
            switch (tipoStatistica) {
                case DISTRIBUZIONE_ERRORI: 
                case DISTRIBUZIONE_AZIONE: 
                case DISTRIBUZIONE_SERVIZIO: 
                case DISTRIBUZIONE_SERVIZIO_APPLICATIVO: 
                case DISTRIBUZIONE_SOGGETTO: 
                case STATISTICA_PERSONALIZZATA: {
                    header.add(HEADER_VALUE_CATEGORY_DATA_3D);
                    break;
                }
            }
        }
        header.add("nome");
        switch (tipoStatistica) {
            case DISTRIBUZIONE_ERRORI: {
                header.add(HEADER_VALUE_CATEGORY_PARENT_0);
                break;
            }
            case DISTRIBUZIONE_AZIONE: {
                header.add(HEADER_VALUE_CATEGORY_PARENT_0);
                header.add(HEADER_VALUE_CATEGORY_PARENT_1);
                break;
            }
            case DISTRIBUZIONE_SERVIZIO: {
                if (!distribuzionePerImplementazioneApi) break;
                header.add(HEADER_VALUE_CATEGORY_PARENT_0);
                break;
            }
            case DISTRIBUZIONE_SERVIZIO_APPLICATIVO: {
                if (tipoRiconoscimento != null && tipoRiconoscimento.equals("applicativo")) {
                    header.add(HEADER_VALUE_CATEGORY_PARENT_0);
                    if (!StringUtils.isNotBlank((CharSequence)identificazione) || !"commons.identificazione.token.label".equals(identificazione)) break;
                    header.add(HEADER_VALUE_CATEGORY_PARENT_1);
                    break;
                }
                if (tipoRiconoscimento != null && tipoRiconoscimento.equals("tokenInfo") && tokenClaim != null && StringUtils.isNotEmpty((CharSequence)tokenClaim)) {
                    try {
                        TipoCredenzialeMittente tcm = TipoCredenzialeMittente.toEnumConstant((String)tokenClaim, (boolean)true);
                        if (TipoCredenzialeMittente.TOKEN_CLIENT_ID.equals((Object)tcm)) {
                            header.add(HEADER_VALUE_CATEGORY_PARENT_0);
                            header.add(HEADER_VALUE_CATEGORY_PARENT_1);
                            break;
                        }
                        if (!TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.equals((Object)tcm)) break;
                        header.add(HEADER_VALUE_CATEGORY_PARENT_0);
                        header.add(HEADER_VALUE_CATEGORY_PARENT_1);
                        header.add(HEADER_VALUE_CATEGORY_PARENT_2);
                        header.add(HEADER_VALUE_CATEGORY_PARENT_3);
                        if (!isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato) break;
                        header.add(HEADER_VALUE_CATEGORY_PARENT_4);
                        header.add(HEADER_VALUE_CATEGORY_PARENT_5);
                    }
                    catch (Exception tcm) {}
                    break;
                }
                if (tipoRiconoscimento == null || !tipoRiconoscimento.equals("identificativoAutenticato")) break;
                header.add(HEADER_VALUE_CATEGORY_PARENT_0);
                break;
            }
        }
        boolean isLatenza = false;
        boolean isNumeroRichieste = false;
        boolean isDimensione = false;
        switch (tipoVisualizzazione) {
            case DIMENSIONE_TRANSAZIONI: {
                isDimensione = true;
                block27: for (TipoBanda tipoBanda : tipiBanda) {
                    switch (tipoBanda) {
                        case COMPLESSIVA: {
                            header.add(HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_COMPLESSIVA);
                            continue block27;
                        }
                        case INTERNA: {
                            header.add(HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_INTERNA);
                            continue block27;
                        }
                    }
                    header.add(HEADER_VALUE_CATEGORY_OCCUPAZIONE_BANDA_ESTERNA);
                }
                break;
            }
            case NUMERO_TRANSAZIONI: {
                isNumeroRichieste = true;
                header.add(HEADER_VALUE_CATEGORY_NUMERO_RICHIESTE);
                break;
            }
            case TEMPO_MEDIO_RISPOSTA: {
                isLatenza = true;
                block28: for (TipoLatenza tipoLatenza : tipiLatenza) {
                    switch (tipoLatenza) {
                        case LATENZA_PORTA: {
                            header.add("latenzaMediaPorta");
                            continue block28;
                        }
                        case LATENZA_SERVIZIO: {
                            header.add("latenzaMediaServizio");
                            continue block28;
                        }
                    }
                    header.add("latenzaMediaTotale");
                }
                break;
            }
        }
        ReportDataSource dataSource = new ReportDataSource(header);
        for (int idx = 0; idx < list.size(); ++idx) {
            ResDistribuzione risultato = list.get(idx);
            ResDistribuzione3D risultato3D = null;
            ResDistribuzione3DCustom risultato3Dcustom = null;
            if (distribuzione3d || distribuzione3dCustom) {
                switch (tipoStatistica) {
                    case DISTRIBUZIONE_ERRORI: 
                    case DISTRIBUZIONE_AZIONE: 
                    case DISTRIBUZIONE_SERVIZIO: 
                    case DISTRIBUZIONE_SERVIZIO_APPLICATIVO: 
                    case DISTRIBUZIONE_SOGGETTO: 
                    case STATISTICA_PERSONALIZZATA: {
                        if (distribuzione3d) {
                            risultato3D = (ResDistribuzione3D)risultato;
                            break;
                        }
                        risultato3Dcustom = (ResDistribuzione3DCustom)risultato;
                        break;
                    }
                }
            }
            ArrayList<Object> oneLine = new ArrayList<Object>();
            if (distribuzione3d) {
                oneLine.add(risultato3D != null ? risultato3D.getDataFormattata() : "N.D.");
            } else if (distribuzione3dCustom) {
                oneLine.add(risultato3Dcustom != null ? risultato3Dcustom.getDatoCustom() : "N.D.");
            }
            String label = risultato != null && risultato.getRisultato() != null ? risultato.getRisultato() : "";
            oneLine.add(label);
            if (risultato != null && risultato.getParentMap() != null && !risultato.getParentMap().isEmpty()) {
                Set keySet = risultato.getParentMap().keySet();
                for (String parentCol : keySet) {
                    oneLine.add((String)risultato.getParentMap().get(parentCol));
                }
            }
            if (isNumeroRichieste) {
                if (convertRawData) {
                    oneLine.add(Utility.numberConverter((Number)risultato.getSomma()));
                } else {
                    oneLine.add(String.valueOf(risultato.getSomma()));
                }
            }
            if (isDimensione) {
                if (convertRawData) {
                    oneLine.add(Utility.fileSizeConverter((Number)risultato.getSomma().longValue()));
                } else {
                    oneLine.add("" + risultato.getSomma().longValue());
                }
            }
            if (isLatenza) {
                if (convertRawData) {
                    oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)risultato.getSomma().longValue(), (boolean)true));
                } else {
                    oneLine.add("" + risultato.getSomma().longValue());
                }
            }
            String msg = "Gruppo " + ((Object)oneLine).toString();
            log.debug(msg);
            dataSource.add(oneLine);
        }
        return dataSource;
    }
}

