/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.ldif.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.ldif.support.LineIdentifier;
import org.springframework.util.StringUtils;

public class SeparatorPolicy {
    private static Logger log = LoggerFactory.getLogger(SeparatorPolicy.class);
    private static final String VERSION_IDENTIFIER = "^version: [0-9]+(\\.[0-9]*){0,1}$";
    private static final String CONTROL = "control:";
    private static final String CHANGE_TYPE = "changetype:";
    private static final String CONTINUATION = " ";
    private static final String COMMENT = "#";
    private static final String NEW_RECORD = "^dn:.*$";
    private boolean record = false;
    private boolean skip = false;

    public LineIdentifier assess(String line) {
        log.trace("Assessing --> [" + line + "]");
        if (this.record) {
            if (!StringUtils.hasLength((String)line)) {
                this.record = false;
                this.skip = false;
                return LineIdentifier.EndOfRecord;
            }
            if (this.skip) {
                return LineIdentifier.Void;
            }
            if (line.startsWith(CONTROL)) {
                this.skip = true;
                return LineIdentifier.Control;
            }
            if (line.startsWith(CHANGE_TYPE)) {
                this.skip = true;
                return LineIdentifier.ChangeType;
            }
            if (line.startsWith(COMMENT)) {
                return LineIdentifier.Comment;
            }
            if (line.startsWith(CONTINUATION)) {
                return LineIdentifier.Continuation;
            }
            return LineIdentifier.Attribute;
        }
        if (StringUtils.hasLength((String)line) && line.matches(VERSION_IDENTIFIER) && !this.skip) {
            return LineIdentifier.VersionIdentifier;
        }
        if (StringUtils.hasLength((String)line) && line.matches(NEW_RECORD)) {
            this.record = true;
            this.skip = false;
            return LineIdentifier.NewRecord;
        }
        return LineIdentifier.Void;
    }
}

