/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import jakarta.xml.soap.SOAPElement;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathException;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathNotValidException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AbstractXPathExpressionEngine {
    private static Logger logger = LoggerWrapperFactory.getLogger(AbstractXPathExpressionEngine.class);
    private static final Semaphore lockObjectForBugFWK005ParseXerces = new Semaphore("BugFWK005ParseXerces");
    private int _prefixIndex = 0;
    private static final String AUTO_PREFIX = "_op2PrefixAutoGeneratedIndex";

    public static void setLogger(Logger logger) {
        AbstractXPathExpressionEngine.logger = logger;
    }

    public String getStringMatchPattern(SOAPElement element, DynamicNamespaceContext dnc, String pattern) throws XPathException, XPathNotFoundException, XPathNotValidException {
        return (String)this.getMatchPattern(element, dnc, pattern, XPathReturnType.STRING);
    }

    public String getStringMatchPattern(Document document, DynamicNamespaceContext dnc, String pattern) throws XPathException, XPathNotFoundException, XPathNotValidException {
        return (String)this.getMatchPattern(document.getDocumentElement(), dnc, pattern, XPathReturnType.STRING);
    }

    public String getStringMatchPattern(Element element, DynamicNamespaceContext dnc, String pattern) throws XPathException, XPathNotFoundException, XPathNotValidException {
        return (String)this.getMatchPattern(element, dnc, pattern, XPathReturnType.STRING);
    }

    public String getStringMatchPattern(String contenuto, DynamicNamespaceContext dnc, String pattern) throws XPathException, XPathNotFoundException, XPathNotValidException {
        return (String)this.getMatchPattern(contenuto, dnc, pattern, XPathReturnType.STRING);
    }

    public abstract String getAsString(SOAPElement var1);

    public abstract AbstractXMLUtils getXMLUtils();

    public Object getMatchPattern(SOAPElement element, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws XPathException, XPathNotFoundException, XPathNotValidException {
        if (element == null) {
            throw new XPathException("element xml undefined");
        }
        return this._engine_getMatchPattern((Element)element, null, dnc, pattern, returnType);
    }

    public Object getMatchPattern(Document document, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws XPathException, XPathNotFoundException, XPathNotValidException {
        if (document == null) {
            throw new XPathException("document xml undefined");
        }
        if (document.getDocumentElement() == null) {
            throw new XPathException("document.element xml undefined");
        }
        return this._engine_getMatchPattern(document.getDocumentElement(), null, dnc, pattern, returnType);
    }

    public Object getMatchPattern(Element element, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws XPathException, XPathNotFoundException, XPathNotValidException {
        if (element == null) {
            throw new XPathException("element xml undefined");
        }
        return this._engine_getMatchPattern(element, null, dnc, pattern, returnType);
    }

    public Object getMatchPattern(String content, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws XPathException, XPathNotFoundException, XPathNotValidException {
        if (content == null) {
            throw new XPathException("content undefined");
        }
        return this._engine_getMatchPattern(null, content, dnc, pattern, returnType);
    }

    public abstract Element readXPathElement(Element var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _engine_getMatchPattern(Element contenutoAsElement, String contenutoAsString, DynamicNamespaceContext dncPrivate, String pattern, XPathReturnType returnType) throws XPathException, XPathNotFoundException, XPathNotValidException {
        if (pattern == null || pattern.length() == 0) {
            throw new XPathNotFoundException("Pattern di ricerca non fornito");
        }
        if (contenutoAsElement == null && contenutoAsString == null) {
            throw new XPathNotFoundException("Contenuto su cui effettuare la ricerca non fornito");
        }
        if (contenutoAsElement != null && contenutoAsString != null) {
            throw new XPathNotFoundException("Contenuto su cui effettuare la ricerca ambiguo");
        }
        pattern = pattern.trim();
        this.validate(pattern);
        try {
            Object result;
            StringReader reader;
            DynamicNamespaceContext dnc;
            block70: {
                XPathFactory factory = this.getXMLUtils().getXPathFactory();
                XPath xpath = factory.newXPath();
                if (xpath == null) {
                    throw new Exception("Costruzione xpath non riuscita");
                }
                dnc = null;
                if (dncPrivate != null) {
                    dnc = (DynamicNamespaceContext)dncPrivate.clone();
                }
                if (dnc != null) {
                    pattern = pattern.replaceAll("}:", "}");
                    pattern = this.convertNamespaces(pattern, dnc);
                }
                if (dnc != null) {
                    xpath.setNamespaceContext(dnc);
                }
                if (pattern.startsWith("concat_openspcoop") && pattern.endsWith(")")) {
                    if (!returnType.equals((Object)XPathReturnType.STRING)) {
                        throw new XPathException("Funzione concat_openspcoop non compatibile con un tipo di ritorno: " + returnType.toString());
                    }
                    String param = pattern.substring("concat_openspcoop(".length(), pattern.length() - 1);
                    String[] params = param.split(",");
                    StringBuilder bfResult = new StringBuilder();
                    for (int i = 0; i < params.length; ++i) {
                        String result2;
                        StringReader reader2;
                        block69: {
                            if (params[i].startsWith("\"") && params[i].endsWith("\"")) {
                                bfResult.append(params[i].substring(1, params[i].length() - 1));
                                continue;
                            }
                            reader2 = null;
                            if (contenutoAsString != null) {
                                try {
                                    reader2 = new StringReader(contenutoAsString);
                                }
                                catch (Exception e) {
                                    try {
                                        if (reader2 != null) {
                                            ((Reader)reader2).close();
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    throw e;
                                }
                            }
                            XPathExpression expression = null;
                            try {
                                expression = xpath.compile(params[i]);
                            }
                            catch (Exception e) {
                                if (Utilities.existsInnerMessageException(e, "Prefix must resolve to a namespace", true)) {
                                    throw new XPathNotFoundException("Espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") non applicabile al messaggio: " + String.valueOf(Utilities.getInnerMessageException(e, "Prefix must resolve to a namespace", true)));
                                }
                                if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                                    throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                                }
                                if (e.getCause() != null) {
                                    throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                                }
                                throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + e.getMessage() + ")", e);
                            }
                            if (expression == null) {
                                throw new Exception("Costruzione XPathExpression non riuscita per espressione contenuta in concat_openspcoop (" + params[i] + ")");
                            }
                            result2 = null;
                            try {
                                if (reader2 != null) {
                                    SemaphoreLock lock = lockObjectForBugFWK005ParseXerces.acquire("concat_openspcoopEvaluate");
                                    try {
                                        result2 = expression.evaluate(new InputSource(reader2));
                                        break block69;
                                    }
                                    finally {
                                        lockObjectForBugFWK005ParseXerces.release(lock, "concat_openspcoopEvaluate");
                                    }
                                }
                                result2 = expression.evaluate(this.readXPathElement(contenutoAsElement));
                            }
                            catch (Exception e) {
                                if (Utilities.existsInnerException((Throwable)e, "com.sun.org.apache.xpath.internal.XPathException")) {
                                    throw new Exception("Valutazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getInnerException((Throwable)e, "com.sun.org.apache.xpath.internal.XPathException").getMessage() + ")", e);
                                }
                                if (Utilities.existsInnerException((Throwable)e, org.apache.xpath.XPathException.class)) {
                                    throw new Exception("Valutazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getInnerException((Throwable)e, org.apache.xpath.XPathException.class).getMessage() + ")", e);
                                }
                                if (e.getCause() != null) {
                                    throw new Exception("Valutazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                                }
                                throw new Exception("Valutazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + e.getMessage() + ")", e);
                            }
                        }
                        if (reader2 != null) {
                            ((Reader)reader2).close();
                        }
                        if (result2 == null || "".equals(result2)) {
                            logger.debug("nessun match trovato per l'espressione xpath contenuta in concat_openspcoop (" + params[i] + ")");
                            throw new XPathNotFoundException("nessun match trovato per l'espressione xpath contenuta in concat_openspcoop (" + params[i] + ")");
                        }
                        bfResult.append(result2);
                    }
                    if (bfResult.length() <= 0) {
                        StringBuilder bfDNC = new StringBuilder();
                        Enumeration<?> en = dnc.getPrefixes();
                        while (en.hasMoreElements()) {
                            String prefix = (String)en.nextElement();
                            bfDNC.append("\n\t- ");
                            bfDNC.append("[").append(prefix).append("]=[").append(dnc.getNamespaceURI(prefix)).append("]");
                        }
                        throw new XPathNotFoundException("nessun match trovato per l'espressione xpath (concat_openspcoop) [" + pattern + "] DynamicNamespaceContext:" + bfDNC.toString());
                    }
                    return bfResult.toString();
                }
                reader = null;
                if (contenutoAsString != null) {
                    try {
                        reader = new StringReader(contenutoAsString);
                    }
                    catch (Exception e) {
                        try {
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                        }
                        catch (Exception bfResult) {
                            // empty catch block
                        }
                        throw e;
                    }
                }
                XPathExpression expression = null;
                try {
                    expression = xpath.compile(pattern);
                }
                catch (Exception e) {
                    if (Utilities.existsInnerMessageException(e, "Prefix must resolve to a namespace", true)) {
                        throw new XPathNotFoundException("Espressione XPATH non applicabile al messaggio: " + String.valueOf(Utilities.getInnerMessageException(e, "Prefix must resolve to a namespace", true)));
                    }
                    if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                        throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                    }
                    if (e.getCause() != null) {
                        throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                    }
                    throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + e.getMessage() + ")", e);
                }
                if (expression == null) {
                    throw new Exception("Costruzione XPathExpression non riuscita");
                }
                result = null;
                try {
                    if (reader != null) {
                        SemaphoreLock lock = lockObjectForBugFWK005ParseXerces.acquire("standardEvaluate");
                        try {
                            result = expression.evaluate(new InputSource(reader), returnType.getValore());
                            break block70;
                        }
                        finally {
                            lockObjectForBugFWK005ParseXerces.release(lock, "standardEvaluate");
                        }
                    }
                    result = expression.evaluate(this.readXPathElement(contenutoAsElement), returnType.getValore());
                }
                catch (Exception e) {
                    if (Utilities.existsInnerException((Throwable)e, "com.sun.org.apache.xpath.internal.XPathException")) {
                        throw new Exception("Valutazione dell'espressione XPATH ha causato un errore (" + Utilities.getInnerException((Throwable)e, "com.sun.org.apache.xpath.internal.XPathException").getMessage() + ")", e);
                    }
                    if (Utilities.existsInnerException((Throwable)e, org.apache.xpath.XPathException.class)) {
                        throw new Exception("Valutazione dell'espressione XPATH ha causato un errore (" + Utilities.getInnerException((Throwable)e, org.apache.xpath.XPathException.class).getMessage() + ")", e);
                    }
                    if (e.getCause() != null) {
                        throw new Exception("Valutazione dell'espressione XPATH ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                    }
                    throw new Exception("Valutazione dell'espressione XPATH ha causato un errore (" + e.getMessage() + ")", e);
                }
            }
            if (reader != null) {
                ((Reader)reader).close();
            }
            boolean notFound = false;
            if (result == null) {
                notFound = true;
            } else if (result instanceof String) {
                if ("".equals(result)) {
                    notFound = true;
                }
            } else if (XPathReturnType.NODESET.equals((Object)returnType) && result instanceof NodeList && ((NodeList)result).getLength() <= 0) {
                notFound = true;
            }
            if (notFound) {
                StringBuilder bfDNC = new StringBuilder();
                Enumeration<?> en = dnc.getPrefixes();
                while (en.hasMoreElements()) {
                    String prefix = (String)en.nextElement();
                    bfDNC.append("\n\t- ");
                    bfDNC.append("[").append(prefix).append("]=[").append(dnc.getNamespaceURI(prefix)).append("]");
                }
                throw new XPathNotFoundException("nessun match trovato per l'espressione xpath [" + pattern + "] DynamicNamespaceContext:" + bfDNC.toString());
            }
            return result;
        }
        catch (XPathNotFoundException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new XPathException("getMatchPattern pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
    }

    public void validate(String path) throws XPathNotValidException {
        block17: {
            try {
                path = path.trim();
                XPathFactory factory = this.getXMLUtils().getXPathFactory();
                XPath xpath = factory.newXPath();
                if (xpath == null) {
                    throw new Exception("Costruzione xpath non riuscita");
                }
                path = path.replaceAll("}:", "}");
                int index = 0;
                while (path.indexOf("{") != -1) {
                    int indexStart = path.indexOf("{");
                    int indexEnd = path.indexOf("}");
                    if (indexEnd == -1) {
                        throw new Exception("{ utilizzato senza la rispettiva chiusura }");
                    }
                    String namespace = path.substring(indexStart + "{".length(), indexEnd);
                    if (namespace == null || namespace.equals("")) {
                        throw new Exception("Namespace non indicato tra {}");
                    }
                    String prefix = "a" + index + ":";
                    ++index;
                    path = path.replace("{" + namespace + "}", prefix);
                }
                if (path.startsWith("concat_openspcoop")) {
                    String param = path.substring("concat_openspcoop(".length(), path.length() - 1);
                    String[] params = param.split(",");
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i].startsWith("\"") && params[i].endsWith("\"")) continue;
                        XPathExpression expression = null;
                        try {
                            expression = xpath.compile(params[i]);
                        }
                        catch (Exception e) {
                            if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                                throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                            }
                            if (e.getCause() != null) {
                                throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                            }
                            throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + e.getMessage() + ")", e);
                        }
                        if (expression != null) continue;
                        throw new Exception("Costruzione XPathExpression non riuscita per espressione contenuta in concat_openspcoop (" + params[i] + ")");
                    }
                    break block17;
                }
                XPathExpression expression = null;
                try {
                    expression = xpath.compile(path);
                }
                catch (Exception e) {
                    if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                        throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                    }
                    if (e.getCause() != null) {
                        throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                    }
                    throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + e.getMessage() + ")", e);
                }
                if (expression == null) {
                    throw new Exception("Costruzione XPathExpression non riuscita");
                }
            }
            catch (Exception e) {
                throw new XPathNotValidException("Validazione dell'xpath indicato [" + path + "] fallita: " + e.getMessage(), e);
            }
        }
    }

    public String toString(NodeList rootNode) {
        StringBuilder resultBuffer = new StringBuilder();
        this.toString(rootNode, resultBuffer, 1);
        return resultBuffer.toString();
    }

    public List<String> toList(NodeList rootNode) {
        return this.toList(rootNode, 1);
    }

    private synchronized int _getNextPrefixIndex() {
        ++this._prefixIndex;
        return this._prefixIndex;
    }

    private String convertNamespaces(String path, DynamicNamespaceContext dnc) throws UtilsException {
        while (path.indexOf("{") != -1) {
            int indexStart = path.indexOf("{");
            int indexEnd = path.indexOf("}");
            if (indexEnd == -1) {
                throw new UtilsException("Errore durante l'interpretazione del valore [" + path + "]: { utilizzato senza la rispettiva chiusura }");
            }
            String namespace = path.substring(indexStart + "{".length(), indexEnd);
            Object prefix = dnc.getPrefix(namespace);
            if (prefix != null && !"".equals(prefix)) {
                prefix = (String)prefix + ":";
            } else {
                prefix = AUTO_PREFIX + this._getNextPrefixIndex();
                dnc.addNamespace((String)prefix, namespace);
                prefix = (String)prefix + ":";
            }
            path = path.replace("{" + namespace + "}", (CharSequence)prefix);
        }
        return path;
    }

    private void toString(NodeList rootNode, StringBuilder resultBuffer, int livello) {
        if (rootNode.getLength() == 1 && (rootNode.item(0).getNodeType() == 3 || rootNode.item(0).getNodeType() == 2) && resultBuffer.length() == 0) {
            String textNodeValue = null;
            try {
                textNodeValue = this._getTextValue_fixEntityReferencies(rootNode.item(0));
            }
            catch (Throwable t) {
                textNodeValue = rootNode.item(0).getTextContent();
            }
            resultBuffer.append(textNodeValue);
            return;
        }
        boolean findElementoRisultatoMultiplo = false;
        for (int index = 0; index < rootNode.getLength(); ++index) {
            Node aNode = rootNode.item(index);
            if (aNode.getNodeType() == 1) {
                NodeList childNodes = aNode.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                boolean hasChildNodes = false;
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node n = childNodes.item(i);
                    if (!n.hasChildNodes()) continue;
                    hasChildNodes = true;
                    break;
                }
                if (hasChildNodes) {
                    resultBuffer.append("<" + aNode.getNodeName());
                    this.printAttributes(aNode, resultBuffer);
                    resultBuffer.append(">");
                    this.toString(aNode.getChildNodes(), resultBuffer, livello + 1);
                    resultBuffer.append("</" + aNode.getNodeName() + ">");
                    continue;
                }
                resultBuffer.append("<" + aNode.getNodeName());
                this.printAttributes(aNode, resultBuffer);
                String textNodeValue = null;
                try {
                    textNodeValue = this._getTextValue_fixEntityReferencies(aNode);
                }
                catch (Throwable t) {
                    textNodeValue = aNode.getTextContent();
                }
                resultBuffer.append(">").append(textNodeValue).append("</").append(aNode.getNodeName()).append(">");
                continue;
            }
            if (livello != 1 || aNode.getNodeType() != 3 && aNode.getNodeType() != 2) continue;
            if (findElementoRisultatoMultiplo) {
                resultBuffer.append(", ");
            } else {
                findElementoRisultatoMultiplo = true;
            }
            String textNodeValue = null;
            try {
                textNodeValue = this._getTextValue_fixEntityReferencies(aNode);
            }
            catch (Throwable t) {
                textNodeValue = aNode.getTextContent();
            }
            resultBuffer.append("[" + index + "]=" + textNodeValue);
        }
    }

    private String _getTextValue_fixEntityReferencies(Node valueEle) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (valueEle.getNodeType() == 3 || valueEle.getNodeType() == 2) {
            sb.append(this.getXMLUtils().toString(valueEle, true));
        } else {
            NodeList nl = valueEle.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node item = nl.item(i);
                if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
                sb.append(this.getXMLUtils().toString(item, true));
            }
        }
        return sb.toString();
    }

    private List<String> toList(NodeList rootNode, int livello) {
        ArrayList<String> l = new ArrayList<String>();
        if (rootNode.getLength() == 1 && rootNode.item(0).getNodeType() == 3) {
            l.add(rootNode.item(0).getTextContent());
            return l;
        }
        for (int index = 0; index < rootNode.getLength(); ++index) {
            Node aNode = rootNode.item(index);
            if (aNode.getNodeType() == 1) {
                NodeList childNodes = aNode.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                StringBuilder resultBuffer = new StringBuilder();
                boolean hasChildNodes = false;
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node n = childNodes.item(i);
                    if (!n.hasChildNodes()) continue;
                    hasChildNodes = true;
                    break;
                }
                if (hasChildNodes) {
                    resultBuffer.append("<" + aNode.getNodeName());
                    this.printAttributes(aNode, resultBuffer);
                    resultBuffer.append(">");
                    this.toString(aNode.getChildNodes(), resultBuffer, livello + 1);
                    resultBuffer.append("</" + aNode.getNodeName() + ">");
                } else {
                    resultBuffer.append("<" + aNode.getNodeName());
                    this.printAttributes(aNode, resultBuffer);
                    resultBuffer.append(">" + aNode.getTextContent() + "</" + aNode.getNodeName() + ">");
                }
                l.add(resultBuffer.toString());
                continue;
            }
            if (livello != 1 || aNode.getNodeType() != 3) continue;
            l.add(aNode.getTextContent());
        }
        return l;
    }

    private void printAttributes(Node aNode, StringBuilder resultBuffer) {
        NamedNodeMap attr = aNode.getAttributes();
        for (int i = 0; i < attr.getLength(); ++i) {
            Node item = attr.item(i);
            if (item instanceof Attr) {
                Attr attribute = (Attr)item;
                Object prefix = attribute.getPrefix();
                prefix = prefix != null && !"".equals(prefix) ? (String)prefix + ":" : "";
                String value = null;
                try {
                    value = this._getTextValue_fixEntityReferencies(attribute);
                }
                catch (Throwable t) {
                    value = attribute.getNodeValue();
                }
                resultBuffer.append(" " + (String)prefix + attribute.getLocalName() + "=\"" + value + "\"");
                continue;
            }
            resultBuffer.append(" " + item.toString());
        }
    }

    public static String extractAndConvertResultAsString(String contentAsString, DynamicNamespaceContext dnc, AbstractXPathExpressionEngine xPathEngine, String pattern, Logger log) throws Exception {
        return AbstractXPathExpressionEngine._extractAndConvertResultAsString(null, contentAsString, dnc, xPathEngine, pattern, log);
    }

    public static String extractAndConvertResultAsString(Element element, AbstractXPathExpressionEngine xPathEngine, String pattern, Logger log) throws Exception {
        DynamicNamespaceContext dnc = new DynamicNamespaceContext();
        dnc.findPrefixNamespace(element);
        return AbstractXPathExpressionEngine._extractAndConvertResultAsString(element, null, dnc, xPathEngine, pattern, log);
    }

    public static String extractAndConvertResultAsString(Element element, DynamicNamespaceContext dnc, AbstractXPathExpressionEngine xPathEngine, String pattern, Logger log) throws Exception {
        return AbstractXPathExpressionEngine._extractAndConvertResultAsString(element, null, dnc, xPathEngine, pattern, log);
    }

    private static String _extractAndConvertResultAsString(Element element, String contentAsString, DynamicNamespaceContext dnc, AbstractXPathExpressionEngine xPathEngine, String pattern, Logger log) throws Exception {
        NodeList nodeList = null;
        Exception exceptionNodeSet = null;
        String risultato = null;
        try {
            nodeList = element != null ? (NodeList)xPathEngine.getMatchPattern(element, dnc, pattern, XPathReturnType.NODESET) : (NodeList)xPathEngine.getMatchPattern(contentAsString, dnc, pattern, XPathReturnType.NODESET);
            if (nodeList != null) {
                risultato = xPathEngine.toString(nodeList);
            }
        }
        catch (Exception e) {
            exceptionNodeSet = e;
        }
        if (risultato == null || "".equals(risultato)) {
            try {
                risultato = element != null ? xPathEngine.getStringMatchPattern(element, dnc, pattern) : xPathEngine.getStringMatchPattern(contentAsString, dnc, pattern);
            }
            catch (Exception e) {
                if (exceptionNodeSet != null) {
                    log.debug("Errore avvenuto durante la getStringMatchPattern(" + pattern + ") (" + e.getMessage() + ") invocata in seguito all'errore dell'invocazione getMatchPattern(" + pattern + ",NODESET): " + exceptionNodeSet.getMessage(), (Throwable)exceptionNodeSet);
                }
                if (exceptionNodeSet != null) {
                    throw new UtilsMultiException(e, exceptionNodeSet);
                }
                throw e;
            }
        }
        if ((risultato == null || "".equals(risultato)) && exceptionNodeSet != null) {
            log.debug("Non sono stati trovati risultati tramite l'invocazione del metodo getStringMatchPattern(" + pattern + ") invocato in seguito all'errore dell'invocazione getMatchPattern(" + pattern + ",NODESET): " + exceptionNodeSet.getMessage(), (Throwable)exceptionNodeSet);
        }
        return risultato;
    }

    public static List<String> extractAndConvertResultAsList(String contentAsString, DynamicNamespaceContext dnc, AbstractXPathExpressionEngine xPathEngine, String pattern, Logger log) throws Exception {
        return AbstractXPathExpressionEngine._extractAndConvertResultAsList(null, contentAsString, dnc, xPathEngine, pattern, log);
    }

    public static List<String> extractAndConvertResultAsList(Element element, AbstractXPathExpressionEngine xPathEngine, String pattern, Logger log) throws Exception {
        DynamicNamespaceContext dnc = new DynamicNamespaceContext();
        dnc.findPrefixNamespace(element);
        return AbstractXPathExpressionEngine._extractAndConvertResultAsList(element, null, dnc, xPathEngine, pattern, log);
    }

    public static List<String> extractAndConvertResultAsList(Element element, DynamicNamespaceContext dnc, AbstractXPathExpressionEngine xPathEngine, String pattern, Logger log) throws Exception {
        return AbstractXPathExpressionEngine._extractAndConvertResultAsList(element, null, dnc, xPathEngine, pattern, log);
    }

    private static List<String> _extractAndConvertResultAsList(Element element, String contentAsString, DynamicNamespaceContext dnc, AbstractXPathExpressionEngine xPathEngine, String pattern, Logger log) throws Exception {
        NodeList nodeList = null;
        Exception exceptionNodeSet = null;
        List<String> risultato = new ArrayList<String>();
        try {
            nodeList = element != null ? (NodeList)xPathEngine.getMatchPattern(element, dnc, pattern, XPathReturnType.NODESET) : (NodeList)xPathEngine.getMatchPattern(contentAsString, dnc, pattern, XPathReturnType.NODESET);
            if (nodeList != null) {
                risultato = xPathEngine.toList(nodeList);
            }
        }
        catch (Exception e) {
            exceptionNodeSet = e;
        }
        if (risultato == null || risultato.isEmpty()) {
            try {
                String s = null;
                s = element != null ? xPathEngine.getStringMatchPattern(element, dnc, pattern) : xPathEngine.getStringMatchPattern(contentAsString, dnc, pattern);
                if (risultato == null) {
                    risultato = new ArrayList();
                }
                risultato.add(s);
            }
            catch (Exception e) {
                if (exceptionNodeSet != null) {
                    log.debug("Errore avvenuto durante la getStringMatchPattern(" + pattern + ") (" + e.getMessage() + ") invocata in seguito all'errore dell'invocazione getMatchPattern(" + pattern + ",NODESET): " + exceptionNodeSet.getMessage(), (Throwable)exceptionNodeSet);
                }
                if (exceptionNodeSet != null) {
                    throw new UtilsMultiException(e, exceptionNodeSet);
                }
                throw e;
            }
        }
        if ((risultato == null || risultato.isEmpty()) && exceptionNodeSet != null) {
            log.debug("Non sono stati trovati risultati tramite l'invocazione del metodo getStringMatchPattern(" + pattern + ") invocato in seguito all'errore dell'invocazione getMatchPattern(" + pattern + ",NODESET): " + exceptionNodeSet.getMessage(), (Throwable)exceptionNodeSet);
        }
        return risultato;
    }
}

