/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.transport.http.XPoweredByResponseProxy;

public class XPoweredByFilter
implements Filter {
    private boolean enabled = false;
    private String value = null;
    private static final String XPOWEREDBY_CONFIG_ENABLED = "xPoweredBy.enabled";
    private static final String XPOWEREDBY_CONFIG_VAUE = "xPoweredBy.value";

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig != null) {
            String tmp = filterConfig.getInitParameter(XPOWEREDBY_CONFIG_ENABLED);
            if (tmp != null && "true".equalsIgnoreCase(tmp.trim())) {
                this.enabled = true;
            }
            if ((tmp = filterConfig.getInitParameter(XPOWEREDBY_CONFIG_VAUE)) != null) {
                this.value = tmp.trim();
                if (StringUtils.isEmpty((CharSequence)this.value)) {
                    this.value = null;
                }
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.enabled) {
            chain.doFilter(request, response);
            return;
        }
        chain.doFilter(request, (ServletResponse)new XPoweredByResponseProxy((HttpServletResponse)response, this.value));
    }
}

