/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.transport.http.HttpBodyParameters;
import org.openspcoop2.utils.transport.http.HttpLibraryConnection;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.transport.http.OCSPTrustManager;
import org.openspcoop2.utils.transport.http.SSLHostNameVerifierDisabled;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.openspcoop2.utils.transport.http.WrappedLogSSLSocketFactory;

class UrlConnectionConnection
extends HttpLibraryConnection {
    UrlConnectionConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse send(HttpRequest request, SSLContext sslContext, OCSPTrustManager ocspTrustManager) throws UtilsException, IOException {
        Exception e3;
        boolean sendThrottling;
        String contentType;
        HttpURLConnection httpConn;
        InputStream is;
        ByteArrayOutputStream outResponse;
        block72: {
            if (request.getMethod() == null) {
                throw new UtilsException("HttpMethod required");
            }
            outResponse = null;
            is = null;
            try {
                Map<String, List<String>> requestHeaders;
                String apiKey;
                HttpsURLConnection httpsConn;
                URLConnection connection = null;
                URL url = URI.create(request.getUrl()).toURL();
                if (request.getProxyType() == null) {
                    if (request.isDebug()) {
                        request.logInfo("Creazione connessione alla URL [" + request.getUrl() + "]...");
                    }
                    connection = url.openConnection();
                } else {
                    if (request.isDebug()) {
                        request.logInfo("Creazione connessione alla URL [" + request.getUrl() + "] (via proxy " + request.getProxyHostname() + ":" + request.getProxyPort() + ") (username[" + request.getProxyUsername() + "] password[" + request.getProxyPassword() + "])...");
                    }
                    if (request.getProxyHostname() == null) {
                        throw new UtilsException("Proxy require a hostname");
                    }
                    Proxy proxy = new Proxy(request.getProxyType(), new InetSocketAddress(request.getProxyHostname(), request.getProxyPort()));
                    connection = url.openConnection(proxy);
                    if (request.getProxyUsername() != null && request.getProxyPassword() != null) {
                        String authentication = request.getProxyUsername() + ":" + request.getProxyPassword();
                        authentication = "Basic " + Base64Utilities.encodeAsString(authentication.getBytes());
                        connection.addRequestProperty("Proxy-Authorization", authentication);
                    }
                }
                httpConn = (HttpURLConnection)connection;
                if (sslContext != null) {
                    httpsConn = (HttpsURLConnection)httpConn;
                    sslSocketFactory = sslContext.getSocketFactory();
                    if (request.isDebug()) {
                        clientCertificateConfigurated = request.getKeyStorePath();
                        sslSocketFactory = new WrappedLogSSLSocketFactory(sslSocketFactory, request.getLog(), "", clientCertificateConfigurated);
                    }
                    httpsConn.setSSLSocketFactory(sslSocketFactory);
                    if (!request.isHostnameVerifier()) {
                        if (request.isDebug()) {
                            request.logInfo("HostName verifier disabilitato");
                        }
                        SSLHostNameVerifierDisabled disabilitato = new SSLHostNameVerifierDisabled(LoggerWrapperFactory.getLogger(HttpUtilities.class));
                        httpsConn.setHostnameVerifier(disabilitato);
                    } else if (request.isDebug()) {
                        request.logInfo("HostName verifier abilitato");
                    }
                } else if (request.isDebug() && httpConn instanceof HttpsURLConnection && (httpsConn = (HttpsURLConnection)httpConn).getSSLSocketFactory() != null) {
                    sslSocketFactory = httpsConn.getSSLSocketFactory();
                    clientCertificateConfigurated = SSLUtilities.getJvmHttpsClientCertificateConfigurated();
                    sslSocketFactory = new WrappedLogSSLSocketFactory(sslSocketFactory, request.getLog(), "", clientCertificateConfigurated);
                    httpsConn.setSSLSocketFactory(sslSocketFactory);
                }
                contentType = request.getContentType();
                if (contentType != null) {
                    if (request.isDebug()) {
                        request.logInfo("Impostazione Content-Type [" + contentType + "]");
                    }
                    httpConn.setRequestProperty("Content-Type", contentType);
                } else if (request.getContent() != null) {
                    String ct = request.getHeaderFirstValue("Content-Type");
                    if (ct == null || StringUtils.isEmpty((CharSequence)ct)) {
                        throw new UtilsException("Content require a Content Type");
                    }
                    contentType = ct;
                }
                if (request.isDebug()) {
                    request.logInfo("Impostazione http timeout CT[" + request.getConnectTimeout() + "] RT[" + request.getReadTimeout() + "]");
                }
                httpConn.setConnectTimeout(request.getConnectTimeout());
                httpConn.setReadTimeout(request.getReadTimeout());
                if (request.getFollowRedirects() != null) {
                    if (request.isDebug()) {
                        request.logInfo("Redirect strategy abilitato");
                    }
                    httpConn.setInstanceFollowRedirects(request.getFollowRedirects());
                } else {
                    if (request.isDebug()) {
                        request.logInfo("Redirect strategy disabilitato");
                    }
                    httpConn.setInstanceFollowRedirects(false);
                }
                if (request.getUsername() != null && request.getPassword() != null) {
                    String authentication = request.getUsername() + ":" + request.getPassword();
                    authentication = "Basic " + Base64Utilities.encodeAsString(authentication.getBytes());
                    if (request.isDebug()) {
                        request.logInfo("Impostazione autenticazione (username:" + request.getUsername() + " password:" + request.getPassword() + ") [" + authentication + "]");
                    }
                    httpConn.setRequestProperty("Authorization", authentication);
                }
                if (request.getBearerToken() != null) {
                    String authorizationHeader = "Bearer " + request.getBearerToken();
                    if (request.isDebug()) {
                        request.logInfo("Impostazione autenticazione bearer [" + authorizationHeader + "]");
                    }
                    httpConn.setRequestProperty("Authorization", authorizationHeader);
                }
                if ((apiKey = request.getApiKey()) != null && StringUtils.isNotEmpty((CharSequence)apiKey)) {
                    String appId;
                    String apiKeyHeader = request.getApiKeyHeader();
                    if (apiKeyHeader == null || StringUtils.isEmpty((CharSequence)apiKeyHeader)) {
                        apiKeyHeader = "X-API-KEY";
                    }
                    httpConn.setRequestProperty(apiKeyHeader, apiKey);
                    if (request.isDebug()) {
                        request.logInfo("Impostazione autenticazione api key [" + apiKeyHeader + "]=[" + apiKey + "]");
                    }
                    if ((appId = request.getAppId()) != null && StringUtils.isNotEmpty((CharSequence)appId)) {
                        String appIdHeader = request.getAppIdHeader();
                        if (appIdHeader == null || StringUtils.isEmpty((CharSequence)appIdHeader)) {
                            appIdHeader = "X-APP-ID";
                        }
                        httpConn.setRequestProperty(appIdHeader, appId);
                        if (request.isDebug()) {
                            request.logInfo("Impostazione autenticazione api key (app id) [" + appIdHeader + "]=[" + appId + "]");
                        }
                    }
                }
                if ((requestHeaders = request.getHeadersValues()) != null && requestHeaders.size() > 0) {
                    for (String key : requestHeaders.keySet()) {
                        List<String> values = requestHeaders.get(key);
                        if (values == null || values.isEmpty()) continue;
                        for (String value : values) {
                            if (request.isDebug()) {
                                request.logInfo("Aggiungo header [" + key + "]=[" + value + "]");
                            }
                            httpConn.addRequestProperty(key, value);
                        }
                    }
                }
                if (request.isCheckConnection()) {
                    if (request.isDebug()) {
                        request.logDebug("Connessione in corso ...");
                    }
                    httpConn.connect();
                    if (request.isDebug()) {
                        request.logDebug("Connessione effettuata con successo");
                    }
                    Iterator<String> itReq = null;
                    return itReq;
                }
                sendThrottling = false;
                if (request.getThrottlingSendByte() != null && request.getThrottlingSendByte() > 0 && request.getThrottlingSendMs() != null && request.getThrottlingSendMs() > 0) {
                    sendThrottling = true;
                }
                if (!sendThrottling && !request.isForceTransferEncodingChunked()) break block72;
                httpConn.setChunkedStreamingMode(0);
            }
            catch (IOException e2) {
                throw e2;
            }
            catch (Exception e3) {}
        }
        HttpUtilities.setStream(httpConn, request.getMethod(), contentType);
        HttpBodyParameters httpContent = new HttpBodyParameters(request.getMethod(), contentType);
        if (httpContent.isDoOutput() && request.getContent() != null) {
            out = httpConn.getOutputStream();
            if (sendThrottling) {
                int lengthSendContent = request.getContent().length;
                int length = 0;
                for (int i = 0; i < lengthSendContent; i += length) {
                    int remaining = lengthSendContent - i;
                    length = request.getThrottlingSendByte();
                    if (remaining < length) {
                        length = remaining;
                    }
                    out.write(request.getContent(), i, length);
                    out.flush();
                    Utilities.sleep(request.getThrottlingSendMs().intValue());
                }
            } else {
                out.write(request.getContent());
            }
            out.flush();
            out.close();
        } else if (httpContent.isDoOutput() && request.getContentStream() != null) {
            out = httpConn.getOutputStream();
            CopyStream.copy(request.getContentStream(), out);
        }
        HttpResponse response = new HttpResponse();
        Map<String, List<String>> mapHeaderHttpResponse = httpConn.getHeaderFields();
        if (mapHeaderHttpResponse != null && mapHeaderHttpResponse.size() > 0) {
            for (String keyHttpResponse : mapHeaderHttpResponse.keySet()) {
                List<String> valueHttpResponse = mapHeaderHttpResponse.get(keyHttpResponse);
                if (keyHttpResponse == null) {
                    keyHttpResponse = "ReturnCode";
                }
                response.addHeader(keyHttpResponse, valueHttpResponse);
            }
        }
        if (response.getHeadersValues() != null && !response.getHeadersValues().isEmpty()) {
            response.setContentType(response.getHeaderFirstValue("Content-Type"));
        }
        int resultHTTPOperation = httpConn.getResponseCode();
        response.setResultHTTPOperation(resultHTTPOperation);
        if (httpContent.isDoInput()) {
            outResponse = new ByteArrayOutputStream();
            if (resultHTTPOperation > 399) {
                is = httpConn.getErrorStream();
                if (is == null) {
                    is = httpConn.getInputStream();
                }
            } else {
                is = httpConn.getInputStream();
                if (is == null) {
                    is = httpConn.getErrorStream();
                }
            }
            CopyStream.copy(is, (OutputStream)outResponse);
            is.close();
            outResponse.flush();
            outResponse.close();
            response.setContent(outResponse.toByteArray());
        }
        httpConn.disconnect();
        if (ocspTrustManager != null) {
            response.setServerCertificate(ocspTrustManager.getPeerCertificates());
        }
        HttpResponse httpResponse = response;
        return httpResponse;
        {
            finally {
                this.safeDisconnect(httpConn);
            }
        }
        {
            throw new UtilsException(e3);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (outResponse != null) {
                outResponse.close();
            }
        }
    }

    private void safeDisconnect(HttpURLConnection httpConn) {
        try {
            httpConn.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

