/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public class SSLX509ManagerForcedClientAlias
extends X509ExtendedKeyManager {
    private String alias;
    private X509KeyManager wrappedX509KeyManager;

    public SSLX509ManagerForcedClientAlias(String alias, X509KeyManager x509KeyManager) {
        this.alias = alias;
        this.wrappedX509KeyManager = x509KeyManager;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.alias;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.alias;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.wrappedX509KeyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.wrappedX509KeyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.wrappedX509KeyManager.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (this.wrappedX509KeyManager instanceof X509ExtendedKeyManager) {
            return ((X509ExtendedKeyManager)this.wrappedX509KeyManager).chooseEngineServerAlias(keyType, issuers, engine);
        }
        return super.chooseEngineServerAlias(keyType, issuers, engine);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.wrappedX509KeyManager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.wrappedX509KeyManager.getPrivateKey(alias);
    }
}

