/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openspcoop2.utils.transport.http.MockServletOutputStream;

public class MockHttpServletResponse
implements HttpServletResponse {
    private String contentType;
    private Long contentLength;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private int status;
    private Integer bufferSize = 10;
    private String characterEncoding = null;
    private MockServletOutputStream outputStream = new MockServletOutputStream();
    private boolean committed = false;
    private Locale locale = null;
    private List<Cookie> cookies = new ArrayList<Cookie>();

    public void flushBuffer() throws IOException {
        this.committed = true;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter((OutputStream)((Object)this.outputStream));
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        this.resetBuffer();
        this.headers.clear();
        this.status = 0;
    }

    public void resetBuffer() {
        this.outputStream = new MockServletOutputStream();
    }

    public void setBufferSize(int arg0) {
        this.bufferSize = arg0;
    }

    public void setCharacterEncoding(String arg0) {
        this.characterEncoding = arg0;
    }

    public void setContentLength(int arg0) {
        this.contentLength = arg0;
    }

    public void setContentLengthLong(long arg0) {
        this.contentLength = arg0;
    }

    public void setContentType(String arg0) {
        this.contentType = arg0;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setLocale(Locale arg0) {
        this.locale = arg0;
    }

    public void addCookie(Cookie arg0) {
        this.cookies.add(arg0);
    }

    public void addDateHeader(String arg0, long arg1) {
        ((List)this.headers.getOrDefault(arg0, new ArrayList())).add(String.valueOf(arg1));
    }

    public void addHeader(String arg0, String arg1) {
        ((List)this.headers.getOrDefault(arg0, new ArrayList())).add(arg1);
    }

    public void addIntHeader(String arg0, int arg1) {
        ((List)this.headers.getOrDefault(arg0, new ArrayList())).add(String.valueOf(arg1));
    }

    public boolean containsHeader(String arg0) {
        return this.headers.containsKey(arg0);
    }

    public String encodeRedirectURL(String arg0) {
        return arg0;
    }

    public String encodeURL(String arg0) {
        return arg0;
    }

    public String getHeader(String arg0) {
        return String.join((CharSequence)",", this.headers.getOrDefault(arg0, List.of()));
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Collection<String> getHeaders(String arg0) {
        return this.headers.getOrDefault(arg0, List.of());
    }

    public int getStatus() {
        return this.status;
    }

    public void sendError(int code) throws IOException {
        this.status = code;
    }

    public void sendError(int code, String arg1) throws IOException {
        this.status = code;
    }

    public void sendRedirect(String arg0) throws IOException {
    }

    public void setDateHeader(String arg0, long arg1) {
        ((List)this.headers.getOrDefault(arg0, new ArrayList())).clear();
        ((List)this.headers.getOrDefault(arg0, new ArrayList())).add(String.valueOf(arg1));
    }

    public void setHeader(String arg0, String arg1) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(List.of(arg1.split(",")));
        this.headers.put(arg1, list);
    }

    public void setIntHeader(String arg0, int arg1) {
        this.headers.put(arg0, List.of(String.valueOf(arg1)));
    }

    public void setStatus(int arg0) {
        this.status = arg0;
    }
}

