/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.KeystoreUtils;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.mime.MimeTypes;
import org.openspcoop2.utils.random.RandomGenerator;
import org.openspcoop2.utils.regexp.RegExpUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpBodyParameters;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpLibraryConnection;
import org.openspcoop2.utils.transport.http.HttpOptions;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilsException;
import org.openspcoop2.utils.transport.http.IOCSPValidator;
import org.openspcoop2.utils.transport.http.IOCSPValidatorBuilder;
import org.openspcoop2.utils.transport.http.OCSPTrustManager;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.openspcoop2.utils.transport.http.SSLX509ManagerForcedClientAlias;
import org.slf4j.Logger;

public class HttpUtilities {
    public static final int HTTP_CONNECTION_TIMEOUT = 10000;
    public static final int HTTP_READ_CONNECTION_TIMEOUT = 120000;
    public static final HttpLibrary DEFAULT_HTTP_LIBRARY = HttpLibraryConnection.getDefaultLibrary();
    public static final String HEADER_X_DOWNLOAD = "application/x-download";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_ATTACH_FILE = "attachment; filename=";
    private static Class<?> classHttpsURLConnectionImpl = null;
    private static Boolean classHttpsURLConnectionImplRead = null;
    private static final String TEST_FILE_ORIGIN = "file://";

    private HttpUtilities() {
    }

    public static List<String> getClientAddressHeaders() {
        ArrayList<String> possibiliHeaders = new ArrayList<String>();
        possibiliHeaders.add("X-Forwarded-For");
        possibiliHeaders.add("Forwarded-For");
        possibiliHeaders.add("X-Forwarded");
        possibiliHeaders.add("Forwarded");
        possibiliHeaders.add("X-Client-IP");
        possibiliHeaders.add("Client-IP");
        possibiliHeaders.add("X-Cluster-Client-IP");
        possibiliHeaders.add("Cluster-Client-IP");
        return possibiliHeaders;
    }

    public static String getClientAddress(HttpServletRequest request) throws UtilsException {
        try {
            return HttpUtilities.getClientAddress(HttpUtilities.getClientAddressHeaders(), request);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String getClientAddressFirstValue(HttpServletRequest request) throws UtilsException {
        return HttpUtilities.getClientAddress(request);
    }

    private static String getClientAddress(List<String> headers, HttpServletRequest request) throws UtilsException {
        if (!headers.isEmpty()) {
            for (String header : headers) {
                List<String> l = TransportUtils.getHeaderValues(request, header);
                if (l == null || l.isEmpty()) continue;
                return l.get(0);
            }
        }
        return null;
    }

    @Deprecated
    public static String getClientAddress(Map<String, String> transportProperties) throws UtilsException {
        return HttpUtilities.getClientAddress(HttpUtilities.getClientAddressHeaders(), TransportUtils.convertToMapListValues(transportProperties));
    }

    public static String getClientAddressFirstValue(Map<String, List<String>> headers) throws UtilsException {
        return HttpUtilities.getClientAddress(HttpUtilities.getClientAddressHeaders(), headers);
    }

    private static String getClientAddress(List<String> headers, Map<String, List<String>> transportProperties) {
        if (!headers.isEmpty()) {
            for (String header : headers) {
                List<String> l = TransportUtils.getRawObject(transportProperties, header);
                if (l == null || l.isEmpty()) continue;
                return l.get(0);
            }
        }
        return null;
    }

    public static String getHttpReason(int status) {
        if (status == 100) {
            return "Continue";
        }
        if (status == 101) {
            return "Switching Protocols";
        }
        if (status == 102) {
            return "Processing";
        }
        if (status == 200) {
            return "OK";
        }
        if (status == 201) {
            return "Created";
        }
        if (status == 202) {
            return "Accepted";
        }
        if (status == 203) {
            return "Non-Authoritative Information";
        }
        if (status == 204) {
            return "No Content";
        }
        if (status == 205) {
            return "Reset Content";
        }
        if (status == 206) {
            return "Partial Content";
        }
        if (status == 207) {
            return "Multi-Status";
        }
        if (status == 208) {
            return "Already Reported";
        }
        if (status == 226) {
            return "IM Used";
        }
        if (status == 300) {
            return "Multiple Choices";
        }
        if (status == 301) {
            return "Moved Permanently";
        }
        if (status == 302) {
            return "Found";
        }
        if (status == 303) {
            return "See Other";
        }
        if (status == 304) {
            return "Not Modified";
        }
        if (status == 305) {
            return "Use Proxy";
        }
        if (status == 306) {
            return "Switch Proxy";
        }
        if (status == 307) {
            return "Temporary Redirect";
        }
        if (status == 308) {
            return "Permanent Redirect";
        }
        if (status == 400) {
            return "Bad Request";
        }
        if (status == 401) {
            return "Unauthorized";
        }
        if (status == 402) {
            return "Payment Required";
        }
        if (status == 403) {
            return "Forbidden";
        }
        if (status == 404) {
            return "Not Found";
        }
        if (status == 405) {
            return "Method Not Allowed";
        }
        if (status == 406) {
            return "Not Acceptable";
        }
        if (status == 407) {
            return "Proxy Authentication Required";
        }
        if (status == 408) {
            return "Request Timeout";
        }
        if (status == 409) {
            return "Conflict";
        }
        if (status == 410) {
            return "Gone";
        }
        if (status == 411) {
            return "Length Required";
        }
        if (status == 412) {
            return "Precondition Failed";
        }
        if (status == 413) {
            return "Payload Too Large";
        }
        if (status == 414) {
            return "URI Too Long";
        }
        if (status == 415) {
            return "Unsupported Media Type";
        }
        if (status == 416) {
            return "Range Not Satisfiable";
        }
        if (status == 417) {
            return "Expectation Failed";
        }
        if (status == 419) {
            return "Authentication Timeout";
        }
        if (status == 421) {
            return "Misdirected Request";
        }
        if (status == 422) {
            return "Unprocessable Entity";
        }
        if (status == 423) {
            return "Locked";
        }
        if (status == 424) {
            return "Failed Dependency";
        }
        if (status == 426) {
            return "Upgrade Required";
        }
        if (status == 428) {
            return "Precondition Required";
        }
        if (status == 429) {
            return "Too Many Requests";
        }
        if (status == 431) {
            return "Request Header Fields Too Large";
        }
        if (status == 451) {
            return "Unavailable For Legal Reasons";
        }
        if (status == 500) {
            return "Internal Server Error";
        }
        if (status == 501) {
            return "Not Implemented";
        }
        if (status == 502) {
            return "Bad Gateway";
        }
        if (status == 503) {
            return "Service Unavailable";
        }
        if (status == 504) {
            return "Gateway Timeout";
        }
        if (status == 505) {
            return "HTTP Version Not Supported";
        }
        if (status == 506) {
            return "Variant Also Negotiates";
        }
        if (status == 507) {
            return "Insufficient Storage";
        }
        if (status == 508) {
            return "Loop Detected";
        }
        if (status == 509) {
            return "Bandwidth Limit Exceeded";
        }
        if (status == 510) {
            return "Not Extended";
        }
        if (status == 511) {
            return "Network Authentication Required";
        }
        return null;
    }

    public static void setOutputFile(HttpServletResponse response, boolean noCache, String fileName) throws UtilsException {
        if (fileName == null) {
            throw new UtilsException("Param filename is null");
        }
        String mimeType = null;
        if (fileName.contains(".")) {
            String ext = null;
            try {
                ext = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MimeTypes mimeTypes = MimeTypes.getInstance();
            mimeType = ext != null && mimeTypes.existsExtension(ext) ? mimeTypes.getMimeType(ext) : HEADER_X_DOWNLOAD;
        } else {
            mimeType = HEADER_X_DOWNLOAD;
        }
        HttpUtilities.setOutputFile(response, noCache, fileName, mimeType);
    }

    public static void setOutputFile(HttpServletResponse response, boolean noCache, String fileName, String mimeType) throws UtilsException {
        if (response == null) {
            throw new UtilsException("Param response is null");
        }
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        response.setHeader(HEADER_CONTENT_DISPOSITION, "attachment; filename=\"" + fileName + "\"");
        if (noCache) {
            HttpUtilities.setNoCache(response);
        }
    }

    public static void setNoCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Vary", "*");
    }

    @Deprecated
    public static boolean isNoCache(Map<String, String> headers) throws UtilsException {
        return HttpUtilities.isDirectiveNoCache(TransportUtils.convertToMapListValues(headers));
    }

    public static boolean isDirectiveNoCache(Map<String, List<String>> headers) throws UtilsException {
        List<String> l = HttpUtilities.getCacheControlDirectives(headers);
        if (l.isEmpty()) {
            l = HttpUtilities.getPragmaDirectives(headers);
        }
        if (l.isEmpty()) {
            return false;
        }
        return l.contains("no-cache");
    }

    @Deprecated
    public static boolean isNoStore(Map<String, String> headers) throws UtilsException {
        return HttpUtilities.isDirectiveNoStore(TransportUtils.convertToMapListValues(headers));
    }

    public static boolean isDirectiveNoStore(Map<String, List<String>> headers) throws UtilsException {
        List<String> l = HttpUtilities.getCacheControlDirectives(headers);
        if (l.isEmpty()) {
            l = HttpUtilities.getPragmaDirectives(headers);
            if (l.isEmpty()) {
                return false;
            }
            return l.contains("no-cache");
        }
        return l.contains("no-store");
    }

    @Deprecated
    public static Integer getCacheMaxAge(Map<String, String> headers) {
        return HttpUtilities.getDirectiveCacheMaxAge(TransportUtils.convertToMapListValues(headers));
    }

    public static Integer getDirectiveCacheMaxAge(Map<String, List<String>> headers) {
        List<String> l = HttpUtilities.getCacheControlDirectives(headers);
        if (l.isEmpty()) {
            return null;
        }
        for (String direttiva : l) {
            if (direttiva == null || !direttiva.startsWith("max-age=") || direttiva.endsWith("=")) continue;
            try {
                String age = direttiva.substring("max-age=".length(), direttiva.length());
                return Integer.valueOf(age);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Deprecated
    public static List<String> getDirectiveCacheControl(Map<String, String> headers) {
        return HttpUtilities.getCacheControlDirectives(TransportUtils.convertToMapListValues(headers));
    }

    public static List<String> getCacheControlDirectives(Map<String, List<String>> headers) {
        List<String> l = TransportUtils.getRawObject(headers, "Cache-Control");
        String cacheControl = null;
        if (l != null && !l.isEmpty()) {
            cacheControl = l.get(0);
        }
        ArrayList<String> values = new ArrayList<String>();
        if (cacheControl != null) {
            if (cacheControl.contains(",")) {
                String[] tmp = cacheControl.split(",");
                for (int i = 0; i < tmp.length; ++i) {
                    values.add(tmp[i].trim());
                }
            } else {
                values.add(cacheControl);
            }
        }
        return values;
    }

    @Deprecated
    public static List<String> getDirectivePragma(Map<String, String> headers) {
        return HttpUtilities.getPragmaDirectives(TransportUtils.convertToMapListValues(headers));
    }

    public static List<String> getPragmaDirectives(Map<String, List<String>> headers) {
        List<String> l = TransportUtils.getRawObject(headers, "Pragma");
        String cacheControl = null;
        if (l != null && !l.isEmpty()) {
            cacheControl = l.get(0);
        }
        ArrayList<String> values = new ArrayList<String>();
        if (cacheControl != null) {
            if (cacheControl.contains(",")) {
                String[] tmp = cacheControl.split(",");
                for (int i = 0; i < tmp.length; ++i) {
                    values.add(tmp[i].trim());
                }
            } else {
                values.add(cacheControl);
            }
        }
        return values;
    }

    public static void enableHttpUrlConnectionForwardRestrictedHeaders() {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }

    public static void setChunkedStreamingMode(HttpURLConnection httpConn, int chunkLength, HttpRequestMethod httpMethod, String contentType) throws UtilsException {
        HttpBodyParameters params = new HttpBodyParameters(httpMethod, contentType);
        if (params.isDoOutput()) {
            httpConn.setChunkedStreamingMode(chunkLength);
        }
    }

    public static boolean isHttpBodyPermitted(boolean isRequest, HttpRequestMethod httpMethod, String contentType) throws UtilsException {
        HttpBodyParameters params = new HttpBodyParameters(httpMethod, contentType);
        if (isRequest) {
            return params.isDoOutput();
        }
        return params.isDoInput();
    }

    public static void setStream(HttpURLConnection httpConn, HttpRequestMethod httpMethod) throws UtilsException {
        HttpUtilities.setStream(httpConn, httpMethod, null);
    }

    public static void setStream(HttpURLConnection httpConn, HttpRequestMethod httpMethod, String contentType) throws UtilsException {
        try {
            HttpBodyParameters params = new HttpBodyParameters(httpMethod, contentType);
            HttpUtilities.setHttpMethod(httpConn, httpMethod);
            if (params.isDoOutput()) {
                httpConn.setDoOutput(params.isDoOutput());
            }
            if (params.isDoInput()) {
                httpConn.setDoInput(params.isDoInput());
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void setHttpMethod(HttpURLConnection httpConn, HttpRequestMethod httpMethod) throws UtilsException {
        block6: {
            try {
                if (httpMethod.isStandardMethod()) {
                    httpConn.setRequestMethod(httpMethod.name());
                    break block6;
                }
                try {
                    Object objectModifyMethodField = httpConn;
                    Class<?> classHttpsUrlConnectionImpl = HttpUtilities.getClassHttpsURLConnectionImpl();
                    if (classHttpsUrlConnectionImpl != null && httpConn.getClass().isAssignableFrom(classHttpsUrlConnectionImpl)) {
                        objectModifyMethodField = HttpUtilities.readDelegateHttpsURLConnection(classHttpsUrlConnectionImpl, httpConn);
                    }
                    HttpUtilities.setProtectedFieldValue(HttpURLConnection.class, "method", objectModifyMethodField, httpMethod.name());
                }
                catch (Throwable ex) {
                    throw new Exception("Unsupported Method '" + String.valueOf(httpMethod) + "' and set by reflection error: " + ex.getMessage(), ex);
                }
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    private static void setProtectedFieldValue(Class<?> clazz, String fieldName, Object object, Object newValue) throws Exception {
        Field field = HttpUtilities.getField(clazz, fieldName);
        field.setAccessible(true);
        field.set(object, newValue);
    }

    private static Field getField(Class<?> clazz, String fieldName) throws UtilsException {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            int i;
            Field[] f = clazz.getDeclaredFields();
            System.out.println("================= (size:" + f.length + " class:" + clazz.getName() + " fieldName:" + fieldName + ") ==========================");
            for (i = 0; i < f.length; ++i) {
                System.out.println("NOME[" + f[i].getName() + "] TIPO[" + String.valueOf(f[i].getType()) + "]");
            }
            f = clazz.getFields();
            System.out.println("================= (FIELDS size:" + f.length + " class:" + clazz.getName() + " fieldName:" + fieldName + ") ==========================");
            for (i = 0; i < f.length; ++i) {
                System.out.println("NOME[" + f[i].getName() + "] TIPO[" + String.valueOf(f[i].getType()) + "]");
            }
            throw new UtilsException(e.getMessage(), e);
        }
        return field;
    }

    private static synchronized void initClassHttpsURLConnectionImpl() {
        if (classHttpsURLConnectionImplRead == null) {
            try {
                classHttpsURLConnectionImpl = Class.forName("sun.net.www.protocol.https.HttpsURLConnectionImpl");
            }
            catch (Exception e) {
                System.out.println("Classe 'sun.net.www.protocol.https.HttpsURLConnectionImpl' non esistente: " + e.getMessage());
            }
            finally {
                classHttpsURLConnectionImplRead = true;
            }
        }
    }

    private static Class<?> getClassHttpsURLConnectionImpl() {
        if (classHttpsURLConnectionImplRead == null) {
            HttpUtilities.initClassHttpsURLConnectionImpl();
        }
        return classHttpsURLConnectionImpl;
    }

    private static Object readDelegateHttpsURLConnection(Class<?> classHttpsUrlConnectionImpl, HttpURLConnection httpConn) throws IllegalArgumentException, IllegalAccessException, UtilsException {
        Field field = HttpUtilities.getField(classHttpsUrlConnectionImpl, "delegate");
        field.setAccessible(true);
        Object fieldInstance = field.get(httpConn);
        return fieldInstance;
    }

    public static byte[] requestHTTPFile(String path) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, 120000, 10000, null, null, (HttpOptions[])null);
    }

    public static byte[] requestHTTPFile(String path, int readTimeout, int connectTimeout) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, readTimeout, connectTimeout, null, null, (HttpOptions[])null);
    }

    public static byte[] requestHTTPFile(String path, String username, String password) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, 120000, 10000, username, password, (HttpOptions[])null);
    }

    public static byte[] requestHTTPFile(String path, int readTimeout, int connectTimeout, String username, String password) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPResponse(path, readTimeout, connectTimeout, username, password, (HttpOptions[])null);
        return res.getContent();
    }

    public static HttpResponse getHTTPResponse(String path) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, 120000, 10000, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPResponse(String path, int readTimeout, int connectTimeout) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, readTimeout, connectTimeout, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPResponse(String path, String username, String password) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, 120000, 10000, username, password, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPResponse(String path, int readTimeout, int connectTimeout, String username, String password) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, readTimeout, connectTimeout, username, password, (HttpOptions[])null);
    }

    public static byte[] requestHTTPFile(String path, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, 120000, 10000, null, null, options);
    }

    public static byte[] requestHTTPFile(String path, int readTimeout, int connectTimeout, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, readTimeout, connectTimeout, null, null, options);
    }

    public static byte[] requestHTTPFile(String path, String username, String password, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, 120000, 10000, username, password, options);
    }

    public static byte[] requestHTTPFile(String path, int readTimeout, int connectTimeout, String username, String password, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPResponse(path, readTimeout, connectTimeout, username, password, options);
        return res.getContent();
    }

    public static HttpResponse getHTTPResponse(String path, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, 120000, 10000, null, null, options);
    }

    public static HttpResponse getHTTPResponse(String path, int readTimeout, int connectTimeout, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, readTimeout, connectTimeout, null, null, options);
    }

    public static HttpResponse getHTTPResponse(String path, String username, String password, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, 120000, 10000, username, password, options);
    }

    public static HttpResponse getHTTPResponse(String path, int readTimeout, int connectTimeout, String username, String password, HttpOptions ... options) throws UtilsException {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(path);
        httpRequest.setReadTimeout(readTimeout);
        httpRequest.setConnectTimeout(connectTimeout);
        httpRequest.setUsername(username);
        httpRequest.setPassword(password);
        httpRequest.setMethod(HttpRequestMethod.GET);
        if (options != null && options.length > 0) {
            for (HttpOptions httpOptions : options) {
                httpOptions.fill(httpRequest);
            }
        }
        HttpResponse response = null;
        try {
            response = HttpUtilities.httpInvoke(httpRequest);
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.requestHTTPFile error " + e.getMessage(), e);
        }
        if (response.getResultHTTPOperation() == 404) {
            throw new UtilsException("404");
        }
        return response;
    }

    public static byte[] requestHTTPSFile(String path, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, null, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, null, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, null, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static HttpResponse getHTTPSResponse(String path, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, (HttpOptions[])null);
    }

    public static byte[] requestHTTPSFile(String path, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, null, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, null, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, null, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, options);
        return res.getContent();
    }

    public static HttpResponse getHTTPSResponse(String path, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, null, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, null, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, null, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(path);
        httpRequest.setReadTimeout(readTimeout);
        httpRequest.setConnectTimeout(connectTimeout);
        httpRequest.setUsername(username);
        httpRequest.setPassword(password);
        httpRequest.setMethod(HttpRequestMethod.GET);
        httpRequest.setTrustStorePath(trustStore);
        httpRequest.setTrustStorePassword(trustStorePassword);
        httpRequest.setTrustStoreType(trustStoreType);
        httpRequest.setCrlPath(crlPath);
        httpRequest.setOcspValidator(ocspValidator);
        if (options != null && options.length > 0) {
            for (HttpOptions httpOptions : options) {
                httpOptions.fill(httpRequest);
            }
        }
        HttpResponse response = null;
        try {
            response = HttpUtilities.httpInvoke(httpRequest);
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.requestHTTPFile error " + e.getMessage(), e);
        }
        if (response.getResultHTTPOperation() == 404) {
            throw new UtilsException("404");
        }
        return response;
    }

    public static byte[] requestHTTPSFile(String path, KeyStore trustStore) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, null, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, KeyStore trustStore, CertStore crlStore) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, crlStore, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, KeyStore trustStore, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, null, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, crlStore, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, KeyStore trustStore) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, null, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, KeyStore trustStore, CertStore crlStore) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, crlStore, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, KeyStore trustStore, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, null, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, crlStore, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, KeyStore trustStore) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, null, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, KeyStore trustStore, CertStore crlStore) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, crlStore, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, KeyStore trustStore, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, null, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, crlStore, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, null, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, CertStore crlStore) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, crlStore, null, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, null, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, crlStore, ocspValidator, (HttpOptions[])null);
        return res.getContent();
    }

    public static HttpResponse getHTTPSResponse(String path, KeyStore trustStore) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, KeyStore trustStore, CertStore crlStore) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, crlStore, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, KeyStore trustStore, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, null, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, crlStore, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, KeyStore trustStore) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, KeyStore trustStore, CertStore crlStore) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, crlStore, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, KeyStore trustStore, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, null, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, crlStore, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, KeyStore trustStore) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, KeyStore trustStore, CertStore crlStore) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, crlStore, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, KeyStore trustStore, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, null, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, crlStore, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, CertStore crlStore) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, crlStore, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, null, ocspValidator, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, crlStore, ocspValidator, (HttpOptions[])null);
    }

    public static byte[] requestHTTPSFile(String path, KeyStore trustStore, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, null, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, crlStore, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, KeyStore trustStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, null, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, crlStore, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, KeyStore trustStore, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, null, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, crlStore, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, KeyStore trustStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, null, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, crlStore, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, KeyStore trustStore, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, null, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, crlStore, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, KeyStore trustStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, null, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, String username, String password, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, crlStore, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, null, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, crlStore, null, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, null, ocspValidator, options);
        return res.getContent();
    }

    public static byte[] requestHTTPSFile(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, crlStore, ocspValidator, options);
        return res.getContent();
    }

    public static HttpResponse getHTTPSResponse(String path, KeyStore trustStore, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, null, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, crlStore, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, KeyStore trustStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, null, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, null, null, trustStore, crlStore, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, KeyStore trustStore, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, null, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, crlStore, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, KeyStore trustStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, null, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, null, null, trustStore, crlStore, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, KeyStore trustStore, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, null, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, crlStore, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, KeyStore trustStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, null, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, String username, String password, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, 120000, 10000, username, password, trustStore, crlStore, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, null, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, crlStore, null, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse(path, readTimeout, connectTimeout, username, password, trustStore, null, ocspValidator, options);
    }

    public static HttpResponse getHTTPSResponse(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, CertStore crlStore, IOCSPValidator ocspValidator, HttpOptions ... options) throws UtilsException {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(path);
        httpRequest.setReadTimeout(readTimeout);
        httpRequest.setConnectTimeout(connectTimeout);
        httpRequest.setUsername(username);
        httpRequest.setPassword(password);
        httpRequest.setMethod(HttpRequestMethod.GET);
        httpRequest.setTrustStore(trustStore);
        httpRequest.setCrlStore(crlStore);
        httpRequest.setOcspValidator(ocspValidator);
        if (options != null && options.length > 0) {
            for (HttpOptions httpOptions : options) {
                httpOptions.fill(httpRequest);
            }
        }
        HttpResponse response = null;
        try {
            response = HttpUtilities.httpInvoke(httpRequest);
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.requestHTTPFile error " + e.getMessage(), e);
        }
        if (response.getResultHTTPOperation() == 404) {
            throw new UtilsException("404");
        }
        return response;
    }

    public static byte[] requestHTTPSFile_trustAllCerts(String path) throws UtilsException {
        return HttpUtilities.requestHTTPSFile_trustAllCerts(path, 120000, 10000, null, null, (HttpOptions[])null);
    }

    public static byte[] requestHTTPSFile_trustAllCerts(String path, int readTimeout, int connectTimeout) throws UtilsException {
        return HttpUtilities.requestHTTPSFile_trustAllCerts(path, readTimeout, connectTimeout, null, null, (HttpOptions[])null);
    }

    public static byte[] requestHTTPSFile_trustAllCerts(String path, String username, String password) throws UtilsException {
        return HttpUtilities.requestHTTPSFile_trustAllCerts(path, 120000, 10000, username, password, (HttpOptions[])null);
    }

    public static byte[] requestHTTPSFile_trustAllCerts(String path, int readTimeout, int connectTimeout, String username, String password) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse_trustAllCerts(path, readTimeout, connectTimeout, username, password, (HttpOptions[])null);
        return res.getContent();
    }

    public static HttpResponse getHTTPSResponse_trustAllCerts(String path) throws UtilsException {
        return HttpUtilities.getHTTPSResponse_trustAllCerts(path, 120000, 10000, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse_trustAllCerts(String path, int readTimeout, int connectTimeout) throws UtilsException {
        return HttpUtilities.getHTTPSResponse_trustAllCerts(path, readTimeout, connectTimeout, null, null, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse_trustAllCerts(String path, String username, String password) throws UtilsException {
        return HttpUtilities.getHTTPSResponse_trustAllCerts(path, 120000, 10000, username, password, (HttpOptions[])null);
    }

    public static HttpResponse getHTTPSResponse_trustAllCerts(String path, int readTimeout, int connectTimeout, String username, String password) throws UtilsException {
        return HttpUtilities.getHTTPSResponse_trustAllCerts(path, readTimeout, connectTimeout, username, password, (HttpOptions[])null);
    }

    public static byte[] requestHTTPSFile_trustAllCerts(String path, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.requestHTTPSFile_trustAllCerts(path, 120000, 10000, null, null, options);
    }

    public static byte[] requestHTTPSFile_trustAllCerts(String path, int readTimeout, int connectTimeout, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.requestHTTPSFile_trustAllCerts(path, readTimeout, connectTimeout, null, null, options);
    }

    public static byte[] requestHTTPSFile_trustAllCerts(String path, String username, String password, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.requestHTTPSFile_trustAllCerts(path, 120000, 10000, username, password, options);
    }

    public static byte[] requestHTTPSFile_trustAllCerts(String path, int readTimeout, int connectTimeout, String username, String password, HttpOptions ... options) throws UtilsException {
        HttpResponse res = HttpUtilities.getHTTPSResponse_trustAllCerts(path, readTimeout, connectTimeout, username, password, options);
        return res.getContent();
    }

    public static HttpResponse getHTTPSResponse_trustAllCerts(String path, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse_trustAllCerts(path, 120000, 10000, null, null, options);
    }

    public static HttpResponse getHTTPSResponse_trustAllCerts(String path, int readTimeout, int connectTimeout, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse_trustAllCerts(path, readTimeout, connectTimeout, null, null, options);
    }

    public static HttpResponse getHTTPSResponse_trustAllCerts(String path, String username, String password, HttpOptions ... options) throws UtilsException {
        return HttpUtilities.getHTTPSResponse_trustAllCerts(path, 120000, 10000, username, password, options);
    }

    public static HttpResponse getHTTPSResponse_trustAllCerts(String path, int readTimeout, int connectTimeout, String username, String password, HttpOptions ... options) throws UtilsException {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(path);
        httpRequest.setReadTimeout(readTimeout);
        httpRequest.setConnectTimeout(connectTimeout);
        httpRequest.setUsername(username);
        httpRequest.setPassword(password);
        httpRequest.setMethod(HttpRequestMethod.GET);
        httpRequest.setTrustAllCerts(true);
        if (options != null && options.length > 0) {
            for (HttpOptions httpOptions : options) {
                httpOptions.fill(httpRequest);
            }
        }
        HttpResponse response = null;
        try {
            response = HttpUtilities.httpInvoke(httpRequest);
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.requestHTTPFile error " + e.getMessage(), e);
        }
        if (response.getResultHTTPOperation() == 404) {
            throw new UtilsException("404");
        }
        return response;
    }

    public static HttpResponse httpInvoke(HttpRequest request) throws UtilsException {
        String path = request.getUrl();
        if (path != null && path.startsWith(TEST_FILE_ORIGIN)) {
            String filePath = path.substring(TEST_FILE_ORIGIN.length());
            File f = new File(filePath);
            if (!f.exists()) {
                throw new UtilsException("404");
            }
            if (!f.canRead()) {
                throw new UtilsException("404");
            }
            HttpResponse response = new HttpResponse();
            try {
                response.setContent(FileSystemUtilities.readBytesFromFile(f));
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
            response.setResultHTTPOperation(200);
            response.setContentType(MimeTypes.getInstance().getMimeType(f));
            return response;
        }
        InputStream finKeyStore = null;
        InputStream finTrustStore = null;
        try {
            SSLContext sslContext = null;
            OCSPTrustManager ocspTrustManager = null;
            if (request.isTrustAllCerts() || request.getTrustStore() != null || request.getTrustStorePath() != null) {
                HSMManager hsmManager;
                KeyManager[] km = null;
                TrustManager[] tm = null;
                if (request.getKeyStore() != null || request.getKeyStorePath() != null) {
                    String location = null;
                    try {
                        boolean oldMethodKeyAlias;
                        location = request.getKeyStorePath();
                        boolean hsmKeystore = false;
                        hsmManager = HSMManager.getInstance();
                        String hsmType = null;
                        if (hsmManager != null && (hsmType = request.getKeyStore() != null ? request.getKeyStore().getType() : request.getKeyStoreType()) != null && !(hsmKeystore = hsmManager.existsKeystoreType(hsmType))) {
                            hsmType = null;
                        }
                        KeyStore keystore = null;
                        KeyStore keystoreParam = null;
                        Provider keystoreProvider = null;
                        if (request.getKeyStore() != null) {
                            keystoreParam = request.getKeyStore();
                            if (hsmKeystore) {
                                keystoreProvider = keystoreParam.getProvider();
                            }
                        } else if (hsmKeystore) {
                            org.openspcoop2.utils.certificate.KeyStore ks = hsmManager.getKeystore(hsmType);
                            if (ks == null) {
                                throw new UtilsException("Keystore not found");
                            }
                            keystoreParam = ks.getKeystore();
                            keystoreProvider = keystoreParam.getProvider();
                        } else {
                            File file = new File(location);
                            finKeyStore = file.exists() ? new FileInputStream(file) : SSLUtilities.class.getResourceAsStream(location);
                            if (finKeyStore == null) {
                                throw new UtilsException("Keystore not found");
                            }
                            String tipo = request.getKeyStoreType() != null ? request.getKeyStoreType() : KeystoreType.JKS.getNome();
                            keystoreParam = KeystoreUtils.readKeystore(finKeyStore, tipo, request.getKeyStorePassword());
                        }
                        if ((oldMethodKeyAlias = false) && request.getKeyAlias() != null) {
                            Key key = keystoreParam.getKey(request.getKeyAlias(), request.getKeyPassword().toCharArray());
                            if (key == null) {
                                throw new UtilsException("Key with alias '" + request.getKeyAlias() + "' not found");
                            }
                            keystore = hsmKeystore ? KeyStore.getInstance(KeystoreType.JKS.getNome()) : KeyStore.getInstance(request.getKeyStoreType());
                            keystore.load(null);
                            keystore.setKeyEntry(request.getKeyAlias(), key, request.getKeyPassword().toCharArray() != null ? request.getKeyPassword().toCharArray() : "".toCharArray(), keystoreParam.getCertificateChain(request.getKeyAlias()));
                        } else {
                            keystore = keystoreParam;
                        }
                        KeyManagerFactory keyManagerFactory = null;
                        keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                        keyManagerFactory.init(keystore, request.getKeyPassword().toCharArray() != null ? request.getKeyPassword().toCharArray() : "".toCharArray());
                        km = keyManagerFactory.getKeyManagers();
                        if (!oldMethodKeyAlias && request.getKeyAlias() != null && km != null && km.length > 0 && km[0] != null && km[0] instanceof X509KeyManager) {
                            String alias = request.getKeyAlias();
                            Enumeration<String> enAliases = keystore.aliases();
                            if (enAliases != null) {
                                while (enAliases.hasMoreElements()) {
                                    String a = enAliases.nextElement();
                                    if (!a.equalsIgnoreCase(alias)) continue;
                                    alias = a;
                                    break;
                                }
                            }
                            SSLX509ManagerForcedClientAlias wrapperX509KeyManager = new SSLX509ManagerForcedClientAlias(alias, (X509KeyManager)km[0]);
                            km[0] = wrapperX509KeyManager;
                        }
                    }
                    catch (Throwable e) {
                        if (location != null) {
                            throw new UtilsException("[" + location + "] " + e.getMessage(), e);
                        }
                        throw new UtilsException(e.getMessage(), e);
                    }
                }
                KeyStore truststore = null;
                if (request.isTrustAllCerts()) {
                    tm = SSLUtilities.getTrustAllCertsManager();
                } else {
                    boolean hsmTruststore = false;
                    hsmManager = HSMManager.getInstance();
                    if (hsmManager != null) {
                        if (request.getTrustStore() != null) {
                            hsmTruststore = request.isTrustStoreHsm();
                        } else if (request.getTrustStoreType() != null && hsmManager.existsKeystoreType(request.getTrustStoreType())) {
                            hsmTruststore = true;
                        }
                    }
                    Provider truststoreProvider = null;
                    if (request.getTrustStore() != null) {
                        truststore = request.getTrustStore();
                        if (hsmTruststore) {
                            truststoreProvider = truststore.getProvider();
                        }
                    } else {
                        if (request.getTrustStoreType() == null) {
                            throw new UtilsException("Ssl TrustStore type required");
                        }
                        if (request.getTrustStorePassword() == null) {
                            throw new UtilsException("Ssl TrustStore password required");
                        }
                        if (hsmTruststore) {
                            org.openspcoop2.utils.certificate.KeyStore ks = hsmManager.getKeystore(request.getTrustStoreType());
                            if (ks == null) {
                                throw new UtilsException("Keystore not found");
                            }
                            truststore = ks.getKeystore();
                            truststoreProvider = truststore.getProvider();
                        } else {
                            File file = new File(request.getTrustStorePath());
                            finTrustStore = file.exists() ? new FileInputStream(file) : SSLUtilities.class.getResourceAsStream(request.getTrustStorePath());
                            if (finTrustStore == null) {
                                throw new UtilsException("Keystore [" + request.getTrustStorePath() + "] not found");
                            }
                            truststore = KeystoreUtils.readKeystore(finTrustStore, request.getTrustStoreType(), request.getTrustStorePassword());
                        }
                    }
                    TrustManagerFactory trustManagerFactory = null;
                    trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                    Provider sigProvider = null;
                    CertPathTrustManagerParameters params = SSLUtilities.buildCertPathTrustManagerParameters(truststore, request.getCrlStore(), request.getCrlPath(), sigProvider);
                    trustManagerFactory.init(params);
                    tm = trustManagerFactory.getTrustManagers();
                }
                IOCSPValidator ocspValidator = request.getOcspValidator();
                if (truststore != null && ocspValidator == null && request.getOcspPolicy() != null && StringUtils.isNotEmpty((CharSequence)request.getOcspPolicy())) {
                    Logger log = LoggerWrapperFactory.getLogger(HttpUtilities.class);
                    IOCSPValidatorBuilder builder = (IOCSPValidatorBuilder)new Loader().newInstance("org.openspcoop2.utils.certificate.ocsp.OCSPValidatorBuilderImpl");
                    ocspValidator = builder.newInstance(log, truststore, request.getCrlPath(), request.getOcspPolicy());
                }
                if (ocspValidator != null) {
                    tm = OCSPTrustManager.wrap(tm, ocspValidator);
                    ocspTrustManager = OCSPTrustManager.read(tm);
                    ocspValidator.setOCSPTrustManager(ocspTrustManager);
                }
                sslContext = SSLContext.getInstance(SSLUtilities.getSafeDefaultProtocol());
                if (request.isSecureRandom()) {
                    RandomGenerator randomGenerator = null;
                    randomGenerator = request.getSecureRandomAlgorithm() != null && !"".equals(request.getSecureRandomAlgorithm()) ? new RandomGenerator(true, request.getSecureRandomAlgorithm()) : new RandomGenerator(true);
                    SecureRandom secureRandom = (SecureRandom)randomGenerator.getRandomEngine();
                    sslContext.init(km, tm, secureRandom);
                } else {
                    sslContext.init(km, tm, null);
                }
            }
            if (request.getUrl() == null) {
                throw new UtilsException("Url required");
            }
            String connectionUrl = request.getUrl();
            if (request.getForwardProxyEndpoint() != null && request.getForwardProxyConfig() != null) {
                HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
                if (request.getForwardProxyConfig().getQuery() != null) {
                    if (request.getForwardProxyConfig().isQueryBase64()) {
                        base64Location = Base64Utilities.encodeAsString(connectionUrl.getBytes());
                        TransportUtils.addParameter(parameters, request.getForwardProxyConfig().getQuery(), base64Location);
                    } else {
                        TransportUtils.addParameter(parameters, request.getForwardProxyConfig().getQuery(), connectionUrl);
                    }
                } else if (request.getForwardProxyConfig().getHeader() != null) {
                    if (request.getForwardProxyConfig().isHeaderBase64()) {
                        base64Location = Base64Utilities.encodeAsString(connectionUrl.getBytes());
                        request.addHeader(request.getForwardProxyConfig().getHeader(), base64Location);
                    } else {
                        request.addHeader(request.getForwardProxyConfig().getHeader(), connectionUrl);
                    }
                }
                boolean encodeBaseLocation = true;
                connectionUrl = TransportUtils.buildUrlWithParameters(parameters, request.getForwardProxyEndpoint(), encodeBaseLocation, LoggerWrapperFactory.getLogger(HttpUtilities.class));
                if (connectionUrl != null) {
                    request.setUrl(connectionUrl);
                }
            }
            HttpLibraryConnection conn = HttpLibraryConnection.fromLibrary(request.getHttpLibrary());
            HttpResponse httpResponse = conn.send(request, sslContext, ocspTrustManager);
            return httpResponse;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (finKeyStore != null) {
                    finKeyStore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (finTrustStore != null) {
                    finTrustStore.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void check(String path) throws UtilsException, HttpUtilsException {
        HttpUtilities.check(path, 120000, 10000, null, null, (HttpOptions[])null);
    }

    public static void check(String path, int readTimeout, int connectTimeout) throws UtilsException, HttpUtilsException {
        HttpUtilities.check(path, readTimeout, connectTimeout, null, null, (HttpOptions[])null);
    }

    public static void check(String path, String username, String password) throws UtilsException, HttpUtilsException {
        HttpUtilities.check(path, 120000, 10000, username, password, (HttpOptions[])null);
    }

    public static void check(String path, int readTimeout, int connectTimeout, String username, String password) throws UtilsException, HttpUtilsException {
        HttpUtilities.check(path, readTimeout, connectTimeout, username, password, (HttpOptions[])null);
    }

    public static void check(String path, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.check(path, 120000, 10000, null, null, options);
    }

    public static void check(String path, int readTimeout, int connectTimeout, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.check(path, readTimeout, connectTimeout, null, null, options);
    }

    public static void check(String path, String username, String password, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.check(path, 120000, 10000, username, password, options);
    }

    public static void check(String path, int readTimeout, int connectTimeout, String username, String password, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(path);
        httpRequest.setReadTimeout(readTimeout);
        httpRequest.setConnectTimeout(connectTimeout);
        httpRequest.setUsername(username);
        httpRequest.setPassword(password);
        httpRequest.setMethod(HttpRequestMethod.GET);
        if (options != null && options.length > 0) {
            for (HttpOptions httpOptions : options) {
                httpOptions.fill(httpRequest);
            }
        }
        HttpUtilities.check(httpRequest);
    }

    public static void checkHTTPS(String path, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, null, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, null, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, null, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, null, options);
    }

    public static void checkHTTPS(String path, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, options);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, null, options);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, null, null, trustStore, trustStorePassword, trustStoreType, crlPath, options);
    }

    public static void checkHTTPS(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, null, options);
    }

    public static void checkHTTPS(String path, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, username, password, trustStore, trustStorePassword, trustStoreType, crlPath, options);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, username, password, trustStore, trustStorePassword, trustStoreType, null, options);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String username, String password, String trustStore, String trustStorePassword, String trustStoreType, String crlPath, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(path);
        httpRequest.setReadTimeout(readTimeout);
        httpRequest.setConnectTimeout(connectTimeout);
        httpRequest.setUsername(username);
        httpRequest.setPassword(password);
        httpRequest.setMethod(HttpRequestMethod.GET);
        httpRequest.setTrustStorePath(trustStore);
        httpRequest.setTrustStorePassword(trustStorePassword);
        httpRequest.setTrustStoreType(trustStoreType);
        httpRequest.setCrlPath(crlPath);
        if (options != null && options.length > 0) {
            for (HttpOptions httpOptions : options) {
                httpOptions.fill(httpRequest);
            }
        }
        HttpUtilities.check(httpRequest);
    }

    public static void checkHTTPS(String path, KeyStore trustStore) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, null, null, trustStore, null, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, KeyStore trustStore, CertStore crlStore) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, null, null, trustStore, crlStore, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, KeyStore trustStore) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, null, null, trustStore, null, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, KeyStore trustStore, CertStore crlStore) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, null, null, trustStore, crlStore, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, String username, String password, KeyStore trustStore) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, username, password, trustStore, null, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, String username, String password, KeyStore trustStore, CertStore crlStore) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, username, password, trustStore, crlStore, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, username, password, trustStore, null, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, CertStore crlStore) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, username, password, trustStore, crlStore, (HttpOptions[])null);
    }

    public static void checkHTTPS(String path, KeyStore trustStore, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, null, null, trustStore, null, options);
    }

    public static void checkHTTPS(String path, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, null, null, trustStore, crlStore, options);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, KeyStore trustStore, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, null, null, trustStore, null, options);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, null, null, trustStore, crlStore, options);
    }

    public static void checkHTTPS(String path, String username, String password, KeyStore trustStore, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, username, password, trustStore, null, options);
    }

    public static void checkHTTPS(String path, String username, String password, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, 120000, 10000, username, password, trustStore, crlStore, options);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS(path, readTimeout, connectTimeout, username, password, trustStore, null, options);
    }

    public static void checkHTTPS(String path, int readTimeout, int connectTimeout, String username, String password, KeyStore trustStore, CertStore crlStore, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(path);
        httpRequest.setReadTimeout(readTimeout);
        httpRequest.setConnectTimeout(connectTimeout);
        httpRequest.setUsername(username);
        httpRequest.setPassword(password);
        httpRequest.setMethod(HttpRequestMethod.GET);
        httpRequest.setTrustStore(trustStore);
        httpRequest.setCrlStore(crlStore);
        if (options != null && options.length > 0) {
            for (HttpOptions httpOptions : options) {
                httpOptions.fill(httpRequest);
            }
        }
        HttpUtilities.check(httpRequest);
    }

    public static void checkHTTPS_trustAllCerts(String path) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS_trustAllCerts(path, 120000, 10000, null, null, (HttpOptions[])null);
    }

    public static void checkHTTPS_trustAllCerts(String path, int readTimeout, int connectTimeout) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS_trustAllCerts(path, readTimeout, connectTimeout, null, null, (HttpOptions[])null);
    }

    public static void checkHTTPS_trustAllCerts(String path, String username, String password) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS_trustAllCerts(path, 120000, 10000, username, password, (HttpOptions[])null);
    }

    public static void checkHTTPS_trustAllCerts(String path, int readTimeout, int connectTimeout, String username, String password) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS_trustAllCerts(path, readTimeout, connectTimeout, username, password, (HttpOptions[])null);
    }

    public static void checkHTTPS_trustAllCerts(String path, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS_trustAllCerts(path, 120000, 10000, null, null, options);
    }

    public static void checkHTTPS_trustAllCerts(String path, int readTimeout, int connectTimeout, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS_trustAllCerts(path, readTimeout, connectTimeout, null, null, options);
    }

    public static void checkHTTPS_trustAllCerts(String path, String username, String password, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpUtilities.checkHTTPS_trustAllCerts(path, 120000, 10000, username, password, options);
    }

    public static void checkHTTPS_trustAllCerts(String path, int readTimeout, int connectTimeout, String username, String password, HttpOptions ... options) throws UtilsException, HttpUtilsException {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(path);
        httpRequest.setReadTimeout(readTimeout);
        httpRequest.setConnectTimeout(connectTimeout);
        httpRequest.setUsername(username);
        httpRequest.setPassword(password);
        httpRequest.setMethod(HttpRequestMethod.GET);
        httpRequest.setTrustAllCerts(true);
        if (options != null && options.length > 0) {
            for (HttpOptions httpOptions : options) {
                httpOptions.fill(httpRequest);
            }
        }
        HttpUtilities.check(httpRequest);
    }

    public static void check(HttpRequest httpRequest) throws UtilsException, HttpUtilsException {
        HttpResponse response = null;
        try {
            response = HttpUtilities.httpInvoke(httpRequest);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        HttpUtilities.check(response);
    }

    public static void check(HttpResponse response) throws HttpUtilsException {
        if (response.getResultHTTPOperation() != 200) {
            if (response.getContent() != null) {
                throw new HttpUtilsException(response.getResultHTTPOperation(), "Response Code (" + response.getResultHTTPOperation() + "): " + new String(response.getContent()));
            }
            throw new HttpUtilsException(response.getResultHTTPOperation(), "Response Code (" + response.getResultHTTPOperation() + ")");
        }
    }

    public static void validateUri(String uri, boolean checkEsistenzaFile) throws UtilsException, MalformedURLException, URISyntaxException {
        if (uri.startsWith("http://") || uri.startsWith(TEST_FILE_ORIGIN)) {
            if (checkEsistenzaFile) {
                HttpUtilities.requestHTTPFile(uri);
            } else {
                RegExpUtilities.validateUrl(uri);
            }
        } else {
            File f = new File(uri);
            if (checkEsistenzaFile) {
                if (!f.exists()) {
                    throw new UtilsException("File non esistente");
                }
                if (f.isDirectory()) {
                    throw new UtilsException("File e' una directory");
                }
                if (!f.canRead()) {
                    throw new UtilsException("File non accessibile");
                }
            }
        }
    }

    @Deprecated
    public static String getDigestHeaderValueByCommons(byte[] content, String algorithm) throws UtilsException {
        String digestValue = null;
        if (algorithm.equals("MD5")) {
            digestValue = DigestUtils.md5Hex((byte[])content);
        } else if (algorithm.equals("SHA-1") || algorithm.equals("SHA")) {
            digestValue = DigestUtils.sha1Hex((byte[])content);
        } else if (algorithm.equals("SHA-256")) {
            digestValue = DigestUtils.sha256Hex((byte[])content);
        } else if (algorithm.equals("SHA-384")) {
            digestValue = DigestUtils.sha384Hex((byte[])content);
        } else if (algorithm.equals("SHA-512")) {
            digestValue = DigestUtils.sha512Hex((byte[])content);
        } else {
            throw new UtilsException("Digest algorithm '" + algorithm + "' unsupported");
        }
        return algorithm + "=" + digestValue;
    }

    public static String getDigestHeaderValue(byte[] content, String algorithm) throws UtilsException {
        return HttpUtilities.getDigestHeaderValue(content, algorithm, DigestEncoding.BASE64);
    }

    public static String getDigestHeaderValue(byte[] content, String algorithm, DigestEncoding digestEncoding) throws UtilsException {
        boolean rfc3230 = true;
        return org.openspcoop2.utils.digest.DigestUtils.getDigestValue(content, algorithm, digestEncoding, rfc3230);
    }

    public static Map<DigestEncoding, String> getDigestHeaderValues(byte[] content, String algorithm, DigestEncoding ... digestEncoding) throws UtilsException {
        boolean rfc3230 = true;
        return org.openspcoop2.utils.digest.DigestUtils.getDigestValues(content, algorithm, rfc3230, digestEncoding);
    }
}

