/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.http.HttpCoreConnection;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.OCSPTrustManager;
import org.openspcoop2.utils.transport.http.UrlConnectionConnection;

public abstract class HttpLibraryConnection {
    private static HttpLibrary defaultLibrary = HttpLibrary.HTTP_CORE5;

    public abstract HttpResponse send(HttpRequest var1, SSLContext var2, OCSPTrustManager var3) throws UtilsException, IOException;

    public static HttpLibraryConnection fromLibrary(HttpLibrary lib) {
        if (lib == null) {
            return null;
        }
        switch (lib) {
            case HTTP_CORE5: {
                return new HttpCoreConnection();
            }
            case HTTP_URL_CONNECTION: {
                return new UrlConnectionConnection();
            }
        }
        return null;
    }

    public static HttpLibrary getDefaultLibrary() {
        return defaultLibrary;
    }

    public static void setDefaultLibrary(HttpLibrary defaultLibrary) {
        if (defaultLibrary != null) {
            HttpLibraryConnection.defaultLibrary = defaultLibrary;
        }
    }
}

