/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpCookie;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

class CookieSameSiteResponseProxy
extends HttpServletResponseWrapper {
    private final HttpServletResponse response;
    private Logger log;
    private String strictValue;

    public CookieSameSiteResponseProxy(HttpServletResponse resp, Logger log, String strictValue) {
        super(resp);
        this.response = resp;
        this.log = log;
        this.strictValue = strictValue;
    }

    public void sendError(int sc) throws IOException {
        this.processSameSiteCookie();
        super.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.processSameSiteCookie();
        super.sendError(sc, msg);
    }

    public void sendRedirect(String location) throws IOException {
        this.processSameSiteCookie();
        super.sendRedirect(location);
    }

    public PrintWriter getWriter() throws IOException {
        this.processSameSiteCookie();
        return super.getWriter();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.processSameSiteCookie();
        return super.getOutputStream();
    }

    private void processSameSiteCookie() {
        List<String> headers = TransportUtils.getHeaderValues(this.response, "Set-Cookie");
        if (headers == null || headers.isEmpty()) {
            return;
        }
        boolean firstHeader = true;
        for (String hdr : headers) {
            if (hdr == null || StringUtils.isEmpty((CharSequence)hdr.trim())) continue;
            try {
                List<HttpCookie> parsedCookies = HttpCookie.parse(hdr);
                if (parsedCookies != null && !parsedCookies.isEmpty()) {
                    this.set(hdr, firstHeader);
                }
                firstHeader = false;
            }
            catch (Exception e) {
                this.log.trace("Process cookie header '" + hdr + "' failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void set(String hdr, boolean firstHeader) {
        String newValue = hdr;
        if (!hdr.contains("SameSite")) {
            newValue = String.format("%s; %s", hdr, "SameSite=" + this.strictValue);
        }
        if (firstHeader) {
            this.response.setHeader("Set-Cookie", newValue);
        } else {
            this.response.addHeader("Set-Cookie", newValue);
        }
    }
}

