/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.transport.http.CookieSameSiteResponseProxy;
import org.slf4j.Logger;

public class CookieSameSiteFilter
implements Filter {
    private boolean enabled = false;
    private String strictValue = "Strict";
    private Logger log;
    private static final String SAME_SITE_CONFIG_ENABLED = "sameSite.enabled";
    private static final String SAME_SITE_CONFIG_VAUE = "sameSite.value";
    private static final String SAME_SITE_CONFIG_LOG = "sameSite.logCategory";

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig != null) {
            String tmp = filterConfig.getInitParameter(SAME_SITE_CONFIG_ENABLED);
            if (tmp != null && "true".equalsIgnoreCase(tmp.trim())) {
                this.enabled = true;
            }
            if ((tmp = filterConfig.getInitParameter(SAME_SITE_CONFIG_VAUE)) != null) {
                this.strictValue = tmp.trim();
            }
            this.log = (tmp = filterConfig.getInitParameter(SAME_SITE_CONFIG_LOG)) != null ? LoggerWrapperFactory.getLogger(tmp.trim()) : LoggerWrapperFactory.getLogger(CookieSameSiteFilter.class);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.enabled) {
            chain.doFilter(request, response);
            return;
        }
        chain.doFilter(request, (ServletResponse)new CookieSameSiteResponseProxy((HttpServletResponse)response, this.log, this.strictValue));
    }
}

