/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.CORSFilterConfiguration;
import org.openspcoop2.utils.transport.http.CORSRequestType;
import org.openspcoop2.utils.transport.http.HttpConstants;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public abstract class AbstractCORSFilter
implements Filter {
    public static final String CORS_REQUEST_TYPE = "CORSRequestType";

    protected abstract CORSFilterConfiguration getConfig() throws IOException;

    protected abstract Logger getLog();

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletReq, ServletResponse servletRes, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletReq;
        HttpServletResponse res = (HttpServletResponse)servletRes;
        this.doCORS(req, res);
        chain.doFilter(servletReq, servletRes);
    }

    public void doCORS(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Logger log = this.getLog();
        CORSFilterConfiguration config = this.getConfig();
        CORSRequestType requestType = this.getRequestType(req, log, config.isErrorAsDebug());
        this.doCORS(req, res, requestType, false);
    }

    /*
     * Unable to fully structure code
     */
    public void doCORS(HttpServletRequest req, HttpServletResponse res, CORSRequestType requestType, boolean newCheckForInvalidType) throws IOException {
        config = this.getConfig();
        log = this.getLog();
        errorAsDebug = config.isErrorAsDebug();
        if (newCheckForInvalidType) {
            errorAsDebug = true;
            log.debug("Ricevuta richiesta CORS di tipo [" + String.valueOf(requestType) + "], riverifico il tipo per vedere che non sia una richiesta non valida ...");
            requestTypeCheckInvalid = this.getRequestType(req, log, errorAsDebug);
            if (CORSRequestType.INVALID.equals(requestTypeCheckInvalid)) {
                log.debug("Ricevuta richiesta CORS di tipo [" + String.valueOf(requestType) + "]; \u00e8 stata rilevata una richiesta invalida");
                requestType = CORSRequestType.INVALID;
            } else {
                log.debug("Ricevuta richiesta CORS di tipo [" + String.valueOf(requestType) + "], dopo la verifica la richiesta risulta comunque valida");
            }
        }
        req.setAttribute("CORSRequestType", (Object)requestType);
        if (CORSRequestType.INVALID.equals(requestType) && (config.throwExceptionIfInvalid || config.terminateIfInvalid)) {
            msgError = "CORSE Configuration error: the request is invalid";
            if (errorAsDebug) {
                log.debug(msgError);
            } else {
                log.error(msgError);
            }
            if (config.throwExceptionIfInvalid) {
                throw new IOException(msgError);
            }
            return;
        }
        accessControlRequestOrigin = TransportUtils.getHeaderFirstValue(req, "Origin");
        if (accessControlRequestOrigin == null && (config.throwExceptionIfNotFoundOrigin || config.terminateIfNotFoundOrigin)) {
            msgError = "CORSE Configuration error: the request hasn't Origin header";
            if (errorAsDebug) {
                log.debug(msgError);
            } else {
                log.error(msgError);
            }
            if (config.throwExceptionIfNotFoundOrigin) {
                throw new IOException(msgError);
            }
            return;
        }
        allowOriginStar = false;
        if (accessControlRequestOrigin != null) {
            if (config.allowRequestOrigin != null && config.allowRequestOrigin.booleanValue()) {
                res.addHeader("Access-Control-Allow-Origin", accessControlRequestOrigin);
                res.addHeader("Vary", "Origin");
            } else {
                foundOrigin = false;
                if (!config.allowOrigins.isEmpty()) {
                    for (String originCheck : config.allowOrigins) {
                        if (!accessControlRequestOrigin.equals(originCheck)) continue;
                        foundOrigin = true;
                        break;
                    }
                }
                if (foundOrigin) {
                    res.addHeader("Access-Control-Allow-Origin", accessControlRequestOrigin);
                    res.addHeader("Vary", "Origin");
                } else if (config.allowAllOrigin != null && config.allowAllOrigin.booleanValue()) {
                    if (config.allowCredentials != null && config.allowCredentials.booleanValue() && !config.throwExceptionIfAllowCredentialAndAllowOrigin) {
                        res.addHeader("Access-Control-Allow-Origin", accessControlRequestOrigin);
                        res.addHeader("Vary", "Origin");
                    } else {
                        res.addHeader("Access-Control-Allow-Origin", "*");
                        allowOriginStar = true;
                    }
                } else if (config.throwExceptionIfNotMatchOrigin || config.terminateIfNotMatchOrigin) {
                    msgError = "CORSE Configuration error: the request has an Origin header, a response header 'Access-Control-Allow-Origin' is required";
                    if (errorAsDebug) {
                        log.debug(msgError);
                    } else {
                        log.error(msgError);
                    }
                    if (config.throwExceptionIfNotMatchOrigin) {
                        throw new IOException(msgError);
                    }
                    return;
                }
            }
        } else if (config.allowAllOrigin != null && config.allowAllOrigin.booleanValue()) {
            res.addHeader("Access-Control-Allow-Origin", "*");
            allowOriginStar = true;
        }
        if (config.allowCredentials != null && config.allowCredentials.booleanValue()) {
            if (allowOriginStar && config.throwExceptionIfAllowCredentialAndAllowOrigin) {
                msgError = "CORSE Configuration error: the response header 'Access-Control-Allow-Origin=*' cannot be used for a resource that supports credentials (Access-Control-Allow-Credentials=true)";
                if (errorAsDebug) {
                    log.debug(msgError);
                } else {
                    log.error(msgError);
                }
                throw new IOException(msgError);
            }
            res.addHeader("Access-Control-Allow-Credentials", "true");
        }
        if (!config.exposeHeaders.isEmpty()) {
            res.addHeader("Access-Control-Expose-Headers", this.convertList(config.exposeHeaders));
        }
        if (CORSRequestType.PRE_FLIGHT.equals(requestType)) {
            accessControlRequestMethod = TransportUtils.getHeaderFirstValue(req, "Access-Control-Request-Method");
            if (accessControlRequestMethod == null && (config.throwExceptionIfNotFoundRequestMethod || config.terminateIfNotFoundRequestMethod)) {
                msgError = "CORSE Configuration error: the request hasn't an Access-Control-Request-Method header";
                if (errorAsDebug) {
                    log.debug(msgError);
                } else {
                    log.error(msgError);
                }
                if (config.throwExceptionIfNotFoundRequestMethod) {
                    throw new IOException(msgError);
                }
                return;
            }
            accessControlRequestHeadersList = new ArrayList<String>();
            accessControlRequestHeaders = TransportUtils.getHeaderFirstValue(req, "Access-Control-Request-Headers");
            if (accessControlRequestHeaders != null && !StringUtils.isEmpty((String)accessControlRequestHeaders.trim())) {
                if ((accessControlRequestHeaders = accessControlRequestHeaders.trim()).contains(",")) {
                    try {
                        for (String hdr : tmp = accessControlRequestHeaders.split(",")) {
                            accessControlRequestHeadersList.add(hdr.trim());
                        }
                    }
                    catch (Exception e) {
                        if (!config.throwExceptionIfNotFoundRequestHeaders && !config.terminateIfNotFoundRequestHeaders) ** GOTO lbl114
                        msgError = "CORSE Configuration error: the request has an uncorrect Access-Control-Request-Headers header";
                        if (errorAsDebug) {
                            log.debug(msgError, (Throwable)e);
                        } else {
                            log.error(msgError, (Throwable)e);
                        }
                        if (config.throwExceptionIfNotFoundRequestHeaders) {
                            throw new IOException(msgError, e);
                        }
                        return;
                    }
                } else {
                    accessControlRequestHeadersList.add(accessControlRequestHeaders.trim());
                }
            }
lbl114:
            // 5 sources

            if (accessControlRequestMethod != null) {
                foundMethod = false;
                if (!config.allowMethods.isEmpty()) {
                    for (String methodCheck : config.allowMethods) {
                        if (!accessControlRequestMethod.equals(methodCheck)) continue;
                        foundMethod = true;
                        break;
                    }
                }
                if (foundMethod) {
                    res.addHeader("Access-Control-Allow-Methods", this.convertList(config.allowMethods));
                } else if (config.allowRequestMethod != null && config.allowRequestMethod.booleanValue()) {
                    res.addHeader("Access-Control-Allow-Methods", accessControlRequestMethod);
                } else {
                    if (config.isThrowExceptionIfNotMatchRequestMethod() || config.terminateIfNotMatchRequestMethod) {
                        msgError = "CORSE Configuration error: the request has an Access-Control-Request-Method header not permitted";
                        if (errorAsDebug) {
                            log.debug((String)msgError);
                        } else {
                            log.error((String)msgError);
                        }
                        if (config.isThrowExceptionIfNotMatchRequestMethod()) {
                            throw new IOException((String)msgError);
                        }
                        return;
                    }
                    if (config.isGenerateListAllowIfNotMatchRequestMethod() && !config.allowMethods.isEmpty()) {
                        res.addHeader("Access-Control-Allow-Methods", this.convertList(config.allowMethods));
                    }
                }
            } else if (config.isGenerateListAllowIfNotMatchRequestMethod() && !config.allowMethods.isEmpty()) {
                res.addHeader("Access-Control-Allow-Methods", this.convertList(config.allowMethods));
            }
            if (accessControlRequestHeadersList.size() > 0) {
                headerNotMatch = new ArrayList<String>();
                for (String headerRequest : accessControlRequestHeadersList) {
                    foundHeader = false;
                    if (!config.allowHeaders.isEmpty()) {
                        for (String headerCheck : config.allowHeaders) {
                            if (!headerRequest.equalsIgnoreCase(headerCheck)) continue;
                            foundHeader = true;
                            break;
                        }
                    }
                    if (foundHeader) continue;
                    headerNotMatch.add(headerRequest);
                }
                if (headerNotMatch.isEmpty()) {
                    res.addHeader("Access-Control-Allow-Headers", this.convertList(config.allowHeaders));
                    if (config.generateAllowHeader) {
                        res.addHeader("Allow", this.convertList(config.allowHeaders));
                    }
                } else if (config.allowRequestHeader != null && config.allowRequestHeader.booleanValue()) {
                    res.addHeader("Access-Control-Allow-Headers", accessControlRequestHeaders);
                    if (config.generateAllowHeader) {
                        res.addHeader("Allow", accessControlRequestHeaders);
                    }
                } else {
                    if (config.isThrowExceptionIfNotMatchRequestHeaders() || config.terminateIfNotMatchRequestHeaders) {
                        msgError = "CORSE Configuration error: the request has an header defined in Access-Control-Request-Headers not permitted: " + headerNotMatch.toString();
                        if (errorAsDebug) {
                            log.debug((String)msgError);
                        } else {
                            log.error((String)msgError);
                        }
                        if (config.isThrowExceptionIfNotMatchRequestHeaders()) {
                            throw new IOException((String)msgError);
                        }
                        return;
                    }
                    if (config.isGenerateListAllowIfNotMatchRequestHeaders() && !config.allowHeaders.isEmpty()) {
                        res.addHeader("Access-Control-Allow-Headers", this.convertList(config.allowHeaders));
                        if (config.generateAllowHeader) {
                            res.addHeader("Allow", this.convertList(config.allowHeaders));
                        }
                    }
                }
            } else if (config.isGenerateListAllowIfNotMatchRequestHeaders() && !config.allowHeaders.isEmpty()) {
                res.addHeader("Access-Control-Allow-Headers", this.convertList(config.allowHeaders));
                if (config.generateAllowHeader) {
                    res.addHeader("Allow", this.convertList(config.allowHeaders));
                }
            }
            if (config.cachingAccessControl_maxAgeSeconds != null) {
                res.addHeader("Access-Control-Max-Age", "" + config.cachingAccessControl_maxAgeSeconds);
            } else if (config.cachingAccessControl_disable != null && config.cachingAccessControl_disable.booleanValue()) {
                res.addHeader("Access-Control-Max-Age", "-1");
            }
        }
    }

    private String convertList(List<String> l) {
        StringBuilder sb = new StringBuilder();
        for (String s : l) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public CORSRequestType getRequestType(HttpServletRequest request, Logger log, boolean errorAsDebug) {
        CORSRequestType requestType = CORSRequestType.INVALID;
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest object is null");
        }
        String accessControlRequestOrigin = TransportUtils.getHeaderFirstValue(request, "Origin");
        if (accessControlRequestOrigin != null) {
            if (accessControlRequestOrigin.isEmpty()) {
                String msg = "Header 'Origin' is empty";
                if (errorAsDebug) {
                    log.debug(msg);
                } else {
                    log.error(msg);
                }
                requestType = CORSRequestType.INVALID;
            } else if (!AbstractCORSFilter.isValidOrigin(accessControlRequestOrigin)) {
                String msg = "Header 'Origin' with uncorrect origin value";
                if (errorAsDebug) {
                    log.debug(msg);
                } else {
                    log.error(msg);
                }
                requestType = CORSRequestType.INVALID;
            } else {
                Object msg;
                String method = request.getMethod();
                HttpRequestMethod requestMethod = null;
                try {
                    if (method == null) {
                        throw new Exception("Request method is null");
                    }
                    requestMethod = HttpRequestMethod.valueOf(method);
                }
                catch (Exception e) {
                    msg = "Method unknown '" + method + "': " + e.getMessage();
                    if (errorAsDebug) {
                        log.debug((String)msg, (Throwable)e);
                    } else {
                        log.error((String)msg, (Throwable)e);
                    }
                    requestType = CORSRequestType.INVALID;
                }
                if (requestMethod != null) {
                    if (HttpRequestMethod.OPTIONS.equals(requestMethod)) {
                        String accessControlRequestMethod = TransportUtils.getHeaderFirstValue(request, "Access-Control-Request-Method");
                        if (accessControlRequestMethod != null && !StringUtils.isEmpty((String)accessControlRequestMethod)) {
                            requestType = CORSRequestType.PRE_FLIGHT;
                        } else if (accessControlRequestMethod != null && StringUtils.isEmpty((String)accessControlRequestMethod)) {
                            msg = "Header 'Access-Control-Request-Method' with empty value";
                            if (errorAsDebug) {
                                log.debug((String)msg);
                            } else {
                                log.error((String)msg);
                            }
                            requestType = CORSRequestType.INVALID;
                        } else {
                            requestType = CORSRequestType.ACTUAL;
                        }
                    } else {
                        String contentType;
                        requestType = HttpRequestMethod.HEAD.equals(requestMethod) || HttpRequestMethod.GET.equals(requestMethod) ? CORSRequestType.SIMPLE : (HttpRequestMethod.POST.equals(requestMethod) ? ((contentType = request.getContentType()) != null ? (HttpConstants.ACCESS_CONTROL_SIMPLE_REQUEST_CONTENT_TYPES.contains(contentType = contentType.toLowerCase().trim()) ? CORSRequestType.SIMPLE : CORSRequestType.ACTUAL) : CORSRequestType.ACTUAL) : CORSRequestType.ACTUAL);
                    }
                }
            }
        } else {
            String msg = "Header 'Origin' not defined";
            if (errorAsDebug) {
                log.debug(msg);
            } else {
                log.error(msg);
            }
            requestType = CORSRequestType.INVALID;
        }
        return requestType;
    }

    private static boolean isValidOrigin(String origin) {
        URI originURI;
        if ("null".equals(origin)) {
            return true;
        }
        if (origin.startsWith("file://")) {
            return true;
        }
        if (origin.contains("%")) {
            return false;
        }
        try {
            originURI = new URI(origin);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return originURI.getScheme() != null;
    }
}

