/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.resources.Charset;
import org.slf4j.Logger;
import org.springframework.web.util.UriUtils;

public class TransportUtils {
    public static final String LDAP_PREFIX = "ldap://";
    public static final String HTTP_PREFIX = "http://";
    public static final String HTTPS_PREFIX = "https://";
    public static final String FILE_PREFIX = "file://";

    private TransportUtils() {
    }

    public static boolean isRemoteResource(String r) {
        return r != null && (r.trim().startsWith(LDAP_PREFIX) || r.trim().startsWith(HTTP_PREFIX) || r.trim().startsWith(HTTPS_PREFIX) || r.trim().startsWith(FILE_PREFIX));
    }

    public static boolean isLdapResource(String r) {
        return r != null && r.trim().startsWith(LDAP_PREFIX);
    }

    public static boolean isHttpResource(String r) {
        return r != null && r.trim().startsWith(HTTP_PREFIX);
    }

    public static boolean isHttpsResource(String r) {
        return r != null && r.trim().startsWith(HTTPS_PREFIX);
    }

    public static boolean isFileResource(String r) {
        return r != null && r.trim().startsWith(FILE_PREFIX);
    }

    public static boolean containsKey(Map<String, List<String>> p, String name) {
        return TransportUtils.hasKeyEngine(p, name);
    }

    @Deprecated
    public static boolean hasKey(Map<String, String> p, String name) {
        return TransportUtils.hasKeyEngine(p, name);
    }

    private static boolean hasKeyEngine(Map<String, ?> p, String name) {
        if (p == null || p.isEmpty()) {
            return false;
        }
        if (name == null) {
            return false;
        }
        if (p.containsKey(name)) {
            return true;
        }
        String lowerName = name.toLowerCase();
        if (p.containsKey(lowerName)) {
            return true;
        }
        if (p.containsKey(name.toUpperCase())) {
            return true;
        }
        for (String key : p.keySet()) {
            String keyCaseInsensitive = key.toLowerCase();
            if (!keyCaseInsensitive.equals(lowerName)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static String get(Map<String, String> p, String name) {
        String o = TransportUtils.propertiesEngine(p, name, true);
        return o instanceof String ? o : null;
    }

    @Deprecated
    public static Object remove(Map<String, String> p, String name) {
        return TransportUtils.propertiesEngine(p, name, false);
    }

    private static <T> T propertiesEngine(Map<String, T> p, String name, boolean get) {
        if (p == null || p.isEmpty()) {
            return null;
        }
        if (name == null) {
            return null;
        }
        T value = get ? p.get(name) : p.remove(name);
        String lowerName = null;
        if (value == null) {
            lowerName = name.toLowerCase();
            T t = value = get ? p.get(lowerName) : p.remove(lowerName);
        }
        if (value == null) {
            T t = value = get ? p.get(name.toUpperCase()) : p.remove(name.toUpperCase());
        }
        if (value == null) {
            ArrayList<String> keysFound = new ArrayList<String>();
            for (String key : p.keySet()) {
                String nameCaseInsensitive;
                String keyCaseInsensitive = key.toLowerCase();
                if (lowerName == null) {
                    lowerName = name.toLowerCase();
                }
                if (!keyCaseInsensitive.equals(nameCaseInsensitive = lowerName)) continue;
                keysFound.add(key);
            }
            if (!keysFound.isEmpty()) {
                for (String keyFound : keysFound) {
                    T v;
                    T t = v = get ? p.get(keyFound) : p.remove(keyFound);
                    if (value != null) continue;
                    value = v;
                }
            }
        }
        return value;
    }

    public static boolean mapHasKey(Map<String, Object> map, String name) {
        if (map == null || map.isEmpty()) {
            return false;
        }
        if (name == null) {
            return false;
        }
        if (map.containsKey(name)) {
            return true;
        }
        String lowerName = name.toLowerCase();
        if (map.containsKey(lowerName)) {
            return true;
        }
        if (map.containsKey(name.toUpperCase())) {
            return true;
        }
        for (String key : map.keySet()) {
            String keyCaseInsensitive;
            if (key == null || !(keyCaseInsensitive = key.toLowerCase()).equals(lowerName)) continue;
            return true;
        }
        return false;
    }

    public static String getObjectAsString(Map<String, ?> map, String name) {
        return (String)TransportUtils.mapEngine(map, name, true, true);
    }

    public static String removeObjectAsString(Map<String, ?> map, String name) {
        return (String)TransportUtils.mapEngine(map, name, false, true);
    }

    public static <T> T getRawObject(Map<String, T> map, String name) {
        return (T)TransportUtils.mapEngine(map, name, true, false);
    }

    public static <T> T removeRawObject(Map<String, T> map, String name) {
        return (T)TransportUtils.mapEngine(map, name, false, false);
    }

    public static void removeObject(Map<String, ?> map, String name) {
        TransportUtils.mapEngine(map, name, false, false);
    }

    private static Object mapEngine(Map<String, ?> map, String name, boolean get, boolean returnAsString) {
        Object value;
        if (map == null || map.isEmpty()) {
            return null;
        }
        if (name == null) {
            return null;
        }
        String lowerName = null;
        Object obj = value = get ? map.get(name) : map.remove(name);
        if (value == null) {
            lowerName = name.toLowerCase();
            Object obj2 = value = get ? map.get(lowerName) : map.remove(lowerName);
        }
        if (value == null) {
            Object obj3 = value = get ? map.get(name.toUpperCase()) : map.remove(name.toUpperCase());
        }
        if (value == null) {
            ArrayList<String> keysFound = new ArrayList<String>();
            for (String key : map.keySet()) {
                String nameCaseInsensitive;
                if (key == null) continue;
                String keyCaseInsensitive = key.toLowerCase();
                if (lowerName == null) {
                    lowerName = name.toLowerCase();
                }
                if (!keyCaseInsensitive.equals(nameCaseInsensitive = lowerName)) continue;
                keysFound.add(key);
            }
            if (!keysFound.isEmpty()) {
                for (String keyFound : keysFound) {
                    Object v;
                    Object obj4 = v = get ? map.get(keyFound) : map.remove(keyFound);
                    if (value != null) continue;
                    value = v;
                }
            }
        }
        if (value == null) {
            return null;
        }
        if (!returnAsString) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof List) {
            List l = (List)value;
            return TransportUtils.convertToSingleValue(l);
        }
        return value.toString();
    }

    @Deprecated
    public static String getParameter(HttpServletRequest request, String name) {
        return TransportUtils.getParameterFirstValue(request, name);
    }

    public static String getParameterFirstValue(HttpServletRequest request, String name) {
        List<String> l = TransportUtils.getParameterValues(request, name);
        if (l != null) {
            return l.get(0);
        }
        return null;
    }

    public static List<String> getParameterValues(HttpServletRequest request, String name) {
        List<String> lNullReturn = null;
        if (request == null) {
            return lNullReturn;
        }
        if (name == null) {
            return lNullReturn;
        }
        String lowerName = null;
        String exactKeyName = null;
        Enumeration keys = request.getParameterNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String nameCaseInsensitive;
                String key = (String)keys.nextElement();
                String keyCaseInsensitive = key.toLowerCase();
                if (lowerName == null) {
                    lowerName = name.toLowerCase();
                }
                if (!keyCaseInsensitive.equals(nameCaseInsensitive = lowerName)) continue;
                exactKeyName = key;
                break;
            }
        }
        if (exactKeyName == null) {
            return lNullReturn;
        }
        String[] s = request.getParameterValues(exactKeyName);
        ArrayList<String> values = new ArrayList<String>();
        if (s != null && s.length > 0) {
            for (int i = 0; i < s.length; ++i) {
                String value = s[i];
                values.add(value);
            }
        } else {
            values.add(request.getParameter(exactKeyName));
        }
        return values;
    }

    @Deprecated
    public static String getHeader(HttpServletRequest request, String name) {
        return TransportUtils.getHeaderFirstValue(request, name);
    }

    public static String getHeaderFirstValue(HttpServletRequest request, String name) {
        List<String> l = TransportUtils.getHeaderValues(request, name);
        if (l != null) {
            return l.get(0);
        }
        return null;
    }

    public static List<String> getHeaderValues(HttpServletRequest request, String name) {
        List<String> lNullReturn = null;
        if (request == null) {
            return lNullReturn;
        }
        if (name == null) {
            return lNullReturn;
        }
        String lowerName = null;
        String exactKeyName = null;
        Enumeration keys = request.getHeaderNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String nameCaseInsensitive;
                String key = (String)keys.nextElement();
                String keyCaseInsensitive = key.toLowerCase();
                if (lowerName == null) {
                    lowerName = name.toLowerCase();
                }
                if (!keyCaseInsensitive.equals(nameCaseInsensitive = lowerName)) continue;
                exactKeyName = key;
                break;
            }
        }
        if (exactKeyName == null) {
            return lNullReturn;
        }
        Enumeration enValues = request.getHeaders(exactKeyName);
        ArrayList<String> values = new ArrayList<String>();
        if (enValues != null) {
            int i = 0;
            while (enValues.hasMoreElements()) {
                String value = (String)enValues.nextElement();
                values.add(value);
                ++i;
            }
        }
        if (values.isEmpty()) {
            values.add(request.getHeader(exactKeyName));
        }
        return values;
    }

    @Deprecated
    public static String getHeader(HttpServletResponse response, String name) {
        return TransportUtils.getHeaderFirstValue(response, name);
    }

    public static String getHeaderFirstValue(HttpServletResponse response, String name) {
        List<String> l = TransportUtils.getHeaderValues(response, name);
        if (l != null) {
            return l.get(0);
        }
        return null;
    }

    public static List<String> getHeaderValues(HttpServletResponse response, String name) {
        Iterator keys;
        List<String> lNullReturn = null;
        if (response == null) {
            return lNullReturn;
        }
        if (name == null) {
            return lNullReturn;
        }
        String lowerName = null;
        String exactKeyName = null;
        if (response.getHeaderNames() != null && !response.getHeaderNames().isEmpty() && (keys = response.getHeaderNames().iterator()) != null) {
            while (keys.hasNext()) {
                String nameCaseInsensitive;
                String key = (String)keys.next();
                String keyCaseInsensitive = key.toLowerCase();
                if (lowerName == null) {
                    lowerName = name.toLowerCase();
                }
                if (!keyCaseInsensitive.equals(nameCaseInsensitive = lowerName)) continue;
                exactKeyName = key;
            }
        }
        if (exactKeyName == null) {
            return lNullReturn;
        }
        Collection enValues = response.getHeaders(exactKeyName);
        ArrayList<String> values = new ArrayList<String>();
        if (enValues != null && !enValues.isEmpty()) {
            int i = 0;
            for (String value : enValues) {
                values.add(value);
                ++i;
            }
        }
        if (values.isEmpty()) {
            values.add(response.getHeader(exactKeyName));
        }
        return values;
    }

    public static String getCookie(HttpServletRequest request, String name) {
        if (request == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        Cookie[] c = request.getCookies();
        if (c == null || c.length <= 0) {
            return null;
        }
        for (Cookie cookie : c) {
            if (cookie == null || cookie.getName() == null || !cookie.getName().equalsIgnoreCase(name)) continue;
            try {
                return URLDecoder.decode(cookie.getValue(), Charset.UTF_8.getValue());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    @Deprecated
    public static String buildLocationWithURLBasedParameter(Map<String, String> propertiesURLBased, String location) {
        return TransportUtils.buildLocationWithURLBasedParameter(propertiesURLBased, location, false, LoggerWrapperFactory.getLogger(TransportUtils.class));
    }

    @Deprecated
    public static String buildLocationWithURLBasedParameter(Map<String, String> propertiesURLBased, String location, Logger log) {
        return TransportUtils.buildLocationWithURLBasedParameter(propertiesURLBased, location, false, log);
    }

    @Deprecated
    public static String buildLocationWithURLBasedParameter(Map<String, String> propertiesURLBased, String location, boolean encodeLocation) {
        return TransportUtils.buildLocationWithURLBasedParameter(propertiesURLBased, location, encodeLocation, LoggerWrapperFactory.getLogger(TransportUtils.class));
    }

    @Deprecated
    public static String buildLocationWithURLBasedParameter(Map<String, String> propertiesURLBased, String location, boolean encodeLocation, Logger log) {
        Map<String, List<String>> parameters = TransportUtils.convertToMapListValues(propertiesURLBased);
        return TransportUtils.buildUrlWithParameters(parameters, location, encodeLocation, log);
    }

    public static String buildUrlWithParameters(Map<String, List<String>> parameters, String location) {
        return TransportUtils.buildUrlWithParameters(parameters, location, false, LoggerWrapperFactory.getLogger(TransportUtils.class));
    }

    public static String buildUrlWithParameters(Map<String, List<String>> parameters, String location, Logger log) {
        return TransportUtils.buildUrlWithParameters(parameters, location, false, log);
    }

    public static String buildUrlWithParameters(Map<String, List<String>> parameters, String location, boolean encodeLocation) {
        return TransportUtils.buildUrlWithParameters(parameters, location, encodeLocation, LoggerWrapperFactory.getLogger(TransportUtils.class));
    }

    public static String buildUrlWithParameters(Map<String, List<String>> parameters, String location, boolean encodeLocation, Logger log) {
        String locationEncoded = location;
        if (encodeLocation) {
            locationEncoded = UriUtils.encodeQuery((String)location, (String)Charset.UTF_8.getValue());
        }
        if (parameters != null && parameters.size() > 0) {
            StringBuilder urlBuilder = new StringBuilder(locationEncoded);
            for (String key : parameters.keySet()) {
                List<String> list = parameters.get(key);
                if (list == null || list.isEmpty()) continue;
                for (String value : list) {
                    if (!urlBuilder.toString().contains("?")) {
                        urlBuilder.append("?");
                    } else {
                        urlBuilder.append("&");
                    }
                    String encodedKey = key;
                    try {
                        encodedKey = TransportUtils.urlEncodeParam(key, Charset.UTF_8.getValue());
                    }
                    catch (Exception e) {
                        if (log != null) {
                            log.error("URLEncode key[" + key + "] error: " + e.getMessage(), (Throwable)e);
                        }
                        LoggerWrapperFactory.getLogger(TransportUtils.class).error("URLEncode key[" + key + "] error: " + e.getMessage(), (Throwable)e);
                    }
                    String encodedValue = value;
                    try {
                        encodedValue = TransportUtils.urlEncodeParam(value, Charset.UTF_8.getValue());
                    }
                    catch (Exception e) {
                        if (log != null) {
                            log.error("URLEncode value:[" + value + "] error: " + e.getMessage(), (Throwable)e);
                        }
                        LoggerWrapperFactory.getLogger(TransportUtils.class).error("URLEncode value:[" + value + "] error: " + e.getMessage(), (Throwable)e);
                    }
                    String keyValue = encodedKey + "=" + encodedValue;
                    urlBuilder.append(keyValue);
                }
            }
            return urlBuilder.toString();
        }
        return locationEncoded;
    }

    public static String limitLocation255Character(String location) {
        if (location.length() > 255) {
            return location.substring(0, 251) + " ...";
        }
        return location;
    }

    public static String urlEncodeParam(String value, String charset) {
        String p = UriUtils.encodeQueryParam((String)value, (String)charset);
        for (int index = 0; p.contains("+") && index < 1000; ++index) {
            p = p.replace("+", "%2B");
        }
        return p;
    }

    public static String urlEncodePath(String value, String charset) {
        return UriUtils.encode((String)value, (String)charset);
    }

    public static String convertToSingleValue(List<?> l) {
        if (l != null && !l.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Object value : l) {
                if (value == null) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(value);
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            return null;
        }
        return null;
    }

    public static Map<String, List<String>> convertToMapListValues(Map<String, String> mapSingleValue) {
        HashMap mapMultipleValues = null;
        if (mapSingleValue != null && !mapSingleValue.isEmpty()) {
            mapMultipleValues = new HashMap();
            for (String key : mapSingleValue.keySet()) {
                String value = mapSingleValue.get(key);
                ArrayList<String> l = new ArrayList<String>();
                l.add(value);
                mapMultipleValues.put(key, l);
            }
        }
        return mapMultipleValues;
    }

    public static Map<String, String> convertToMapSingleValue(Map<String, List<String>> mapMultipleValues) {
        HashMap<String, String> mapSingleValue = null;
        if (mapMultipleValues != null && !mapMultipleValues.isEmpty()) {
            mapSingleValue = new HashMap<String, String>();
            for (String key : mapMultipleValues.keySet()) {
                List<String> values = mapMultipleValues.get(key);
                String v = TransportUtils.convertToSingleValue(values);
                if (v == null) continue;
                mapSingleValue.put(key, v);
            }
        }
        return mapSingleValue;
    }

    public static void addHeader(Map<String, List<String>> headers, String name, String value) {
        TransportUtils.put(headers, name, value, true);
    }

    public static void setHeader(Map<String, List<String>> headers, String name, String value) {
        TransportUtils.put(headers, name, value, false);
    }

    public static void addParameter(Map<String, List<String>> parameters, String name, String value) {
        TransportUtils.put(parameters, name, value, true);
    }

    public static void setParameter(Map<String, List<String>> parameters, String name, String value) {
        TransportUtils.put(parameters, name, value, false);
    }

    public static void put(Map<String, List<String>> map, String name, String value, boolean add) {
        if (value == null) {
            return;
        }
        List<String> l = map.get(name);
        if (add) {
            if (l == null) {
                l = new ArrayList<String>();
                map.put(name, l);
            }
        } else if (l == null) {
            l = new ArrayList<String>();
            map.put(name, l);
        } else {
            l.clear();
        }
        l.add(value);
    }

    public static List<String> getValues(Map<String, List<String>> map, String key) {
        List<String> l;
        List<String> lReturn = null;
        if (map != null && !map.isEmpty() && (l = TransportUtils.getRawObject(map, key)) != null && !l.isEmpty()) {
            return l;
        }
        return lReturn;
    }

    public static String getFirstValue(Map<String, List<String>> map, String key) {
        List<String> l;
        if (map != null && !map.isEmpty() && (l = TransportUtils.getRawObject(map, key)) != null && !l.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    public static String getFirstValue(List<String> list) {
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }
}

