/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.threads;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MonitoredVirtualThreadExecutor
extends AbstractExecutorService {
    private final ExecutorService delegate;
    private final AtomicLong submitted = new AtomicLong();
    private final AtomicLong active = new AtomicLong();
    private final AtomicLong completed = new AtomicLong();

    public MonitoredVirtualThreadExecutor(String poolName) {
        this.delegate = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name(poolName + "-worker-", 0L).factory());
    }

    @Override
    public void execute(Runnable command) {
        this.submitted.incrementAndGet();
        this.delegate.execute(() -> {
            this.active.incrementAndGet();
            try {
                command.run();
            }
            finally {
                this.active.decrementAndGet();
                this.completed.incrementAndGet();
            }
        });
    }

    public long getSubmittedCount() {
        return this.submitted.get();
    }

    public long getActiveCount() {
        return this.active.get();
    }

    public long getCompletedCount() {
        return this.completed.get();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public String getStatus() {
        return String.format("(submitted: %d) Active: %d, Completed: %d, isShutdown: %s, isTerminated: %s", this.getSubmittedCount(), this.getActiveCount(), this.getCompletedCount(), this.isShutdown(), this.isTerminated());
    }

    public ExecutorService getDelegate() {
        return this.delegate;
    }
}

