/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.threads;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.threads.BaseThread;
import org.openspcoop2.utils.threads.IGestoreCodaRunnableInstance;
import org.openspcoop2.utils.threads.Runnable;
import org.openspcoop2.utils.threads.RunnableLogger;
import org.slf4j.Logger;

public class GestoreCodaRunnable
extends BaseThread {
    private RunnableLogger log = null;
    private ExecutorService threadsPool = null;
    private int poolSize = -1;
    private int queueSize = -1;
    private int limit = -1;
    private Map<String, Runnable> threads = new HashMap<String, Runnable>();
    private IGestoreCodaRunnableInstance gestoreRunnable;
    private String name;
    private long uniqueSerialNumber = 0L;

    public String getThreadsImage() {
        if (this.threadsPool instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.threadsPool;
            return String.format("(queue:%d) [%d/%d] Active: %d, Completed: %d, Task: %d, isShutdown: %s, isTerminated: %s", this.threads.size(), tpe.getPoolSize(), tpe.getCorePoolSize(), tpe.getActiveCount(), tpe.getCompletedTaskCount(), tpe.getTaskCount(), tpe.isShutdown(), tpe.isTerminated());
        }
        return null;
    }

    public GestoreCodaRunnable(String name, int poolSize, int queueSize, int limit, int timeoutNextCheck, IGestoreCodaRunnableInstance gestoreRunnable, Logger log) throws UtilsException {
        this.name = name;
        this.log = new RunnableLogger(name, log);
        this.gestoreRunnable = gestoreRunnable;
        try {
            if (this.gestoreRunnable != null) {
                this.gestoreRunnable.initialize(this.log);
            }
        }
        catch (Throwable t) {
            throw new UtilsException(t.getMessage(), t);
        }
        try {
            this.poolSize = poolSize;
            if (this.poolSize > 0) {
                this.threadsPool = Executors.newFixedThreadPool(this.poolSize);
                this.log.info("Inizializzato correttamente");
            } else {
                this.log.error("Non sono stati definiti threads");
            }
            this.queueSize = queueSize;
            if (this.queueSize <= 0) {
                this.log.error("Non \u00e8 stata definita la dimensione della coda");
            }
            this.limit = limit;
            if (this.limit <= 0) {
                this.log.error("Non \u00e8 stata definito il limite di quanti thread creare per volta");
            }
            this.setTimeout(timeoutNextCheck);
            if (this.limit <= 0) {
                this.log.error("Non \u00e8 stata definito il timeout di attesa prima di verificare la presenza di nuovi threads da attivare");
            }
        }
        catch (Exception e) {
            throw new UtilsException("Inizializzazione pool di threads non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public void process() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.threadsPool == null) {
                return;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.gestoreRunnable.logCheckInProgress(context);
            while (!this.isStop()) {
                this.log.info("Immagine prima del controllo sui threads terminati: " + this.getThreadsImage());
                if (!this.threads.isEmpty()) {
                    this.log.debug("Verifico se tra i threads registrati ve ne sono alcuni terminati ...");
                    ArrayList<String> ids = new ArrayList<String>();
                    ids.addAll(this.threads.keySet());
                    for (String id : ids) {
                        Runnable r = this.threads.get(id);
                        if (!r.isFinished()) continue;
                        this.log.debug("Elimino dalla coda thread '" + id + "' terminato");
                        this.threads.remove(id);
                    }
                }
                this.log.info("Immagine dopo il controllo sui threads terminati: " + this.getThreadsImage());
                int limit = this.queueSize - this.threads.size();
                boolean sleep = false;
                if (limit > 0) {
                    if (limit > this.limit) {
                        limit = this.limit;
                    }
                    this.log.info("Ricerco nuovi threads da attivare (limit: " + limit + ") ...");
                    List<Runnable> list_nextRunnable = null;
                    try {
                        list_nextRunnable = this.gestoreRunnable.nextRunnable(limit);
                    }
                    catch (Throwable t) {
                        this.log.error("Errore durante la ricerca di nuovi threads (limit: " + limit + "): " + t.getMessage(), t);
                    }
                    if (list_nextRunnable != null && !list_nextRunnable.isEmpty()) {
                        this.log.info("Trovati " + list_nextRunnable.size() + " threads da attivare");
                        for (Runnable thread : list_nextRunnable) {
                            String threadName = this.name + "-t" + this.getUniqueSerialNumber();
                            if (thread.getIdentifier() != null && !"".equals(thread.getIdentifier())) {
                                threadName = threadName + "-" + thread.getIdentifier();
                            }
                            try {
                                this.log.debug("Aggiungo in coda nuovo thread '" + threadName + "' ...");
                                thread.initialize(new RunnableLogger(threadName, this.log.getLog()));
                                this.threadsPool.execute(thread);
                                this.threads.put(threadName, thread);
                                this.log.info("Thread '" + threadName + "' aggiunto in coda");
                            }
                            catch (Throwable t) {
                                this.log.error("Errore durante l'aggiunta in coda del thread '" + threadName + "': " + t.getMessage(), t);
                            }
                        }
                        this.log.info("Immagine dopo l'inserimento in coda dei nuovi threads: " + this.getThreadsImage());
                        this.gestoreRunnable.logRegisteredThreads(context, list_nextRunnable.size());
                    } else {
                        this.log.info("Trovati 0 threads da attivare");
                        sleep = true;
                    }
                } else {
                    this.log.info("La coda dei threads ha raggiunto la capacit\u00e0 massima (size: " + this.queueSize + ")");
                    sleep = true;
                }
                if (!sleep) continue;
                this.gestoreRunnable.logCheckFinished(context);
                this.sleepForNextCheck(this.getTimeout(), 1000);
                context = new HashMap();
                this.gestoreRunnable.logCheckInProgress(context);
            }
            try {
                this.log.debug("Richiedo sospensione threads ...");
                Set<String> keySet = this.threads.keySet();
                for (String threadName : keySet) {
                    Runnable thread = this.threads.get(threadName);
                    thread.setStop(true);
                }
            }
            catch (Throwable t) {
                this.log.error("Errore durante lo stop dei threads: " + t.getMessage(), t);
            }
            try {
                int timeout = 10;
                boolean terminated = false;
                while (!terminated) {
                    this.log.info(this.threads.size() + " threads avviati correttamente, attendo terminazione (timeout " + timeout + "s) ...");
                    for (int i = 0; i < timeout * 4; ++i) {
                        boolean tmpTerminated = true;
                        Set<String> keySet = this.threads.keySet();
                        for (String threadName : keySet) {
                            Runnable thread = this.threads.get(threadName);
                            if (thread.isFinished()) continue;
                            tmpTerminated = false;
                            break;
                        }
                        if (!tmpTerminated) {
                            Utilities.sleep(250L);
                            continue;
                        }
                        terminated = true;
                    }
                }
                this.log.info(this.threads.size() + " threads avviati correttamente, attesa della terminazione (timeout " + timeout + "s) completata");
            }
            catch (Exception e) {
                this.log.error("Errore durante l'attesa della terminazione dei threads: " + e.getMessage(), e);
            }
        }
        finally {
            this.finished();
        }
    }

    private synchronized long getUniqueSerialNumber() {
        if (this.uniqueSerialNumber + 1L > Long.MAX_VALUE) {
            this.uniqueSerialNumber = 0L;
        }
        ++this.uniqueSerialNumber;
        return this.uniqueSerialNumber;
    }
}

