/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sonde;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sonde.ParametriSonda;
import org.openspcoop2.utils.sonde.Sonda;
import org.openspcoop2.utils.sonde.SondaException;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class SondaFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateConfSonda(String nome, long warn, long err, Connection connection, TipiDatabase tipoDatabase) throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        sqlQueryObject.addUpdateTable("sonde");
        sqlQueryObject.addUpdateField("soglia_warn", "?");
        sqlQueryObject.addUpdateField("soglia_error", "?");
        sqlQueryObject.addWhereCondition("nome = ?");
        String sql = sqlQueryObject.createSQLUpdate();
        PreparedStatement ps = connection.prepareStatement(sql);
        try {
            ps.setLong(1, warn);
            ps.setLong(2, err);
            ps.setString(3, nome);
            ps.executeUpdate();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateStatoSonda(String nome, Sonda sonda, Connection connection, TipiDatabase tipoDatabase) throws SondaException {
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
            sqlQueryObject.addUpdateTable("sonde");
            sqlQueryObject.addUpdateField("data_ok", "?");
            sqlQueryObject.addUpdateField("data_warn", "?");
            sqlQueryObject.addUpdateField("data_error", "?");
            sqlQueryObject.addUpdateField("data_ultimo_check", "?");
            sqlQueryObject.addUpdateField("dati_check", "?");
            sqlQueryObject.addUpdateField("stato_ultimo_check", "?");
            sqlQueryObject.addWhereCondition("nome = ?");
            String sql = sqlQueryObject.createSQLUpdate();
            PreparedStatement ps = null;
            try {
                ps = connection.prepareStatement(sql);
                int i = 1;
                if (sonda.getParam().getDataOk() != null) {
                    ps.setTimestamp(i++, new Timestamp(sonda.getParam().getDataOk().getTime()));
                } else {
                    ps.setNull(i++, 93);
                }
                if (sonda.getParam().getDataWarn() != null) {
                    ps.setTimestamp(i++, new Timestamp(sonda.getParam().getDataWarn().getTime()));
                } else {
                    ps.setNull(i++, 93);
                }
                if (sonda.getParam().getDataError() != null) {
                    ps.setTimestamp(i++, new Timestamp(sonda.getParam().getDataError().getTime()));
                } else {
                    ps.setNull(i++, 93);
                }
                ps.setTimestamp(i++, new Timestamp(sonda.getParam().getDataUltimoCheck().getTime()));
                ps.setString(i++, sonda.getParam().marshallDatiCheck());
                ps.setInt(i++, sonda.getParam().getStatoUltimoCheck());
                ps.setString(i++, nome);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new SondaException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Sonda get(String nome, Connection connection, TipiDatabase tipoDatabase) throws SondaException {
        try {
            ISQLQueryObject sqlQueryObject = SondaFactory.getSqlQueryObjectForGetSonda(tipoDatabase);
            sqlQueryObject.addWhereCondition("nome = ?");
            String sql = sqlQueryObject.createSQLQuery();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = connection.prepareStatement(sql);
                ps.setString(1, nome);
                rs = ps.executeQuery();
                if (!rs.next()) return null;
                Sonda sonda = SondaFactory.getSonda(rs);
                return sonda;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new SondaException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Sonda> findAll(Connection connection, TipiDatabase tipoDatabase) throws SondaException {
        try {
            ArrayList<Sonda> sondaLst = new ArrayList<Sonda>();
            ISQLQueryObject sqlQueryObject = SondaFactory.getSqlQueryObjectForGetSonda(tipoDatabase);
            String sql = sqlQueryObject.createSQLQuery();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = connection.prepareStatement(sql);
                rs = ps.executeQuery();
                while (rs.next()) {
                    Sonda sonda = SondaFactory.getSonda(rs);
                    sondaLst.add(sonda);
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return sondaLst;
        }
        catch (Exception e) {
            throw new SondaException(e);
        }
    }

    private static Sonda getSonda(ResultSet rs) throws SQLException, NoSuchMethodException, SondaException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String nome = rs.getString("nome");
        String classe = rs.getString("classe");
        Long soglia_warn = rs.getLong("soglia_warn");
        Long soglia_error = rs.getLong("soglia_error");
        Timestamp data_ok = rs.getTimestamp("data_ok");
        Timestamp data_warn = rs.getTimestamp("data_warn");
        Timestamp data_error = rs.getTimestamp("data_error");
        Timestamp data_ultimo_check = rs.getTimestamp("data_ultimo_check");
        String dati_check = rs.getString("dati_check");
        Integer stato_ultimo_check = rs.getInt("stato_ultimo_check");
        Class<?> className = null;
        try {
            className = Class.forName(classe);
        }
        catch (ClassNotFoundException e) {
            throw new SondaException("Classe di definizione della sonda [" + classe + "] non trovata");
        }
        if (!Sonda.class.isAssignableFrom(className)) {
            throw new SondaException("Classe di definizione della sonda [" + classe + "] deve essere un'estensione della classe [" + Sonda.class.getName() + "]");
        }
        Constructor<?> ctor = className.getDeclaredConstructor(ParametriSonda.class);
        ctor.setAccessible(true);
        ParametriSonda param = new ParametriSonda();
        param.setNome(nome);
        param.setDataUltimoCheck(data_ultimo_check);
        param.setDataError(data_error);
        param.setDataWarn(data_warn);
        param.setDataOk(data_ok);
        param.unmarshallDatiCheck(dati_check);
        param.setSogliaWarn(soglia_warn);
        param.setSogliaError(soglia_error);
        param.setStatoUltimoCheck(stato_ultimo_check);
        Sonda sonda = (Sonda)ctor.newInstance(param);
        return sonda;
    }

    private static ISQLQueryObject getSqlQueryObjectForGetSonda(TipiDatabase tipoDatabase) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        sqlQueryObject.addFromTable("sonde");
        sqlQueryObject.addSelectField("nome");
        sqlQueryObject.addSelectField("classe");
        sqlQueryObject.addSelectField("soglia_warn");
        sqlQueryObject.addSelectField("soglia_error");
        sqlQueryObject.addSelectField("data_ok");
        sqlQueryObject.addSelectField("data_warn");
        sqlQueryObject.addSelectField("data_error");
        sqlQueryObject.addSelectField("data_ultimo_check");
        sqlQueryObject.addSelectField("dati_check");
        sqlQueryObject.addSelectField("stato_ultimo_check");
        return sqlQueryObject;
    }
}

