/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.logger;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpReceivedMessageToFileSystemInterceptor
extends AbstractPhaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DumpReceivedMessageToFileSystemInterceptor.class);

    public DumpReceivedMessageToFileSystemInterceptor() {
        super("receive");
    }

    public void handleMessage(Message message) {
        String msgAsString = message.toString();
        String logMsg = String.format("RECEIVE message %s", msgAsString);
        log.info(logMsg);
        message.put((Object)Message.ENCODING, (Object)"UTF-8");
        InputStream paramInputStream = (InputStream)message.getContent(InputStream.class);
        if (paramInputStream != null) {
            File f = null;
            try {
                f = FileSystemUtilities.createTempFile("ReceivedMessage", ".dump");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(f);){
                int bytesRead;
                byte[] buffer = new byte[256];
                while ((bytesRead = paramInputStream.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                }
                fos.flush();
                paramInputStream.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return;
            }
            logMsg = String.format("Serialized in [%s]", f.getAbsolutePath());
            log.info(logMsg);
            try {
                message.setContent(InputStream.class, (Object)new FileInputStream(f));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

