/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.context.server;

import java.util.HashSet;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.apache.cxf.ext.logging.event.DefaultLogEventMapper;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.service.context.server.ServerConfig;
import org.openspcoop2.utils.service.context.server.ServerInfoInInterceptor;
import org.openspcoop2.utils.service.context.server.ServerInfoResponse;
import org.openspcoop2.utils.service.context.server.ServerInfoUtilities;

@NoJSR250Annotations
public class ServerInfoOutInterceptor
extends LoggingOutInterceptor {
    private ServerConfig serverConfig;
    private ServerInfoUtilities utilities;

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.utilities = new ServerInfoUtilities(this.serverConfig);
    }

    public void handleMessage(Message message) throws Fault {
        try {
            ServerInfoResponse response = new ServerInfoResponse();
            HashSet sensitiveProtocolHeaders = new HashSet();
            LogEvent event = new DefaultLogEventMapper().map(message, sensitiveProtocolHeaders);
            try {
                if (event.getResponseCode() != null) {
                    response.setResponseCode(Integer.parseInt(event.getResponseCode()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.utilities.processAfterSend(response);
        }
        catch (Throwable e) {
            LoggerWrapperFactory.getLogger(ServerInfoInInterceptor.class).error(e.getMessage(), e);
            throw new Fault(e);
        }
    }
}

