/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.context.server;

import java.util.HashSet;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.event.DefaultLogEventMapper;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.service.context.server.ServerConfig;
import org.openspcoop2.utils.service.context.server.ServerInfoRequest;
import org.openspcoop2.utils.service.context.server.ServerInfoUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

@NoJSR250Annotations
public class ServerInfoInInterceptor
extends LoggingInInterceptor {
    private ServerConfig serverConfig;
    private ServerInfoUtilities utilities;

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.utilities = new ServerInfoUtilities(this.serverConfig);
    }

    public void handleMessage(Message message) throws Fault {
        try {
            ServerInfoRequest request = new ServerInfoRequest();
            HashSet sensitiveProtocolHeaders = new HashSet();
            LogEvent event = new DefaultLogEventMapper().map(message, sensitiveProtocolHeaders);
            request.setAddress(event.getAddress());
            request.setHttpRequestMethod(HttpRequestMethod.valueOf(event.getHttpMethod().toUpperCase()));
            this.utilities.processBeforeSend(request);
        }
        catch (Throwable e) {
            LoggerWrapperFactory.getLogger(ServerInfoInInterceptor.class).error(e.getMessage(), e);
            throw new Fault(e);
        }
    }
}

