/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.context.dump;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.event.DefaultLogEventMapper;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.message.Message;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.service.context.dump.DumpConfig;
import org.openspcoop2.utils.service.context.dump.DumpRequest;
import org.openspcoop2.utils.service.context.dump.DumpUtilities;
import org.openspcoop2.utils.service.context.server.ServerConfig;

@NoJSR250Annotations
public class DumpInInterceptor
extends LoggingInInterceptor {
    private DumpConfig dumpConfig;
    private ServerConfig serverConfig;

    public DumpConfig getDumpConfig() {
        return this.dumpConfig;
    }

    public void setDumpConfig(DumpConfig dumpConfig) {
        this.dumpConfig = dumpConfig;
        if (dumpConfig.getLimit() != null) {
            super.setLimit(dumpConfig.getLimit().intValue());
        } else {
            super.setLimit(-1);
        }
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void handleMessage(Message message) throws Fault {
        try {
            HashSet sensitiveProtocolHeaders = new HashSet();
            LogEvent event = new DefaultLogEventMapper().map(message, sensitiveProtocolHeaders);
            if (this.shouldLogContent(event)) {
                this.internal_addContent(message, event);
            } else {
                event.setPayload("--- Content suppressed ---");
            }
            DumpUtilities utilities = null;
            if (this.serverConfig != null) {
                this.serverConfig.setDumpConfig(this.dumpConfig);
                utilities = new DumpUtilities(this.serverConfig);
            } else {
                utilities = new DumpUtilities(this.dumpConfig);
            }
            DumpRequest request = new DumpRequest();
            if (event.getPayload() != null) {
                request.setPayload(event.getPayload().getBytes());
            }
            request.setContentType(event.getContentType());
            request.setHeaders(event.getHeaders());
            utilities.processBeforeSend(request);
        }
        catch (Throwable e) {
            LoggerWrapperFactory.getLogger(DumpInInterceptor.class).error(e.getMessage(), e);
            throw new Fault(e);
        }
    }

    private void internal_addContent(Message message, LogEvent event) {
        try {
            CachedOutputStream cos = (CachedOutputStream)message.getContent(CachedOutputStream.class);
            if (cos != null) {
                this.internal_handleOutputStream(event, message, cos);
            } else {
                CachedWriter writer = (CachedWriter)message.getContent(CachedWriter.class);
                if (writer != null) {
                    this.internal_handleWriter(event, writer);
                }
            }
        }
        catch (IOException e) {
            throw new Fault((Throwable)e);
        }
    }

    private void internal_handleOutputStream(LogEvent event, Message message, CachedOutputStream cos) throws IOException {
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (StringUtils.isEmpty((String)encoding)) {
            encoding = StandardCharsets.UTF_8.name();
        }
        StringBuilder payload = new StringBuilder();
        cos.writeCacheTo(payload, encoding, (long)this.limit);
        cos.close();
        event.setPayload(payload.toString());
        boolean isTruncated = cos.size() > (long)this.limit && this.limit != -1;
        event.setTruncated(isTruncated);
        event.setFullContentFile(cos.getTempFile());
    }

    private void internal_handleWriter(LogEvent event, CachedWriter writer) throws IOException {
        boolean isTruncated = writer.size() > (long)this.limit && this.limit != -1;
        StringBuilder payload = new StringBuilder();
        writer.writeCacheTo(payload, (long)this.limit);
        event.setPayload(payload.toString());
        event.setTruncated(isTruncated);
        event.setFullContentFile(writer.getTempFile());
    }
}

