/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.beans.utils;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.utils.service.beans.ProfiloEnum;

public class ProfiloUtils {
    private static final Map<ProfiloEnum, String> MAP_PROFILO_TO_PROTOCOLLO = new EnumMap<ProfiloEnum, String>(ProfiloEnum.class);
    private static Map<String, ProfiloEnum> mapProtocolloToProfilo;

    private ProfiloUtils() {
    }

    public static Map<ProfiloEnum, String> getMapProfiloToProtocollo() {
        return MAP_PROFILO_TO_PROTOCOLLO;
    }

    public static Map<String, ProfiloEnum> getMapProtocolloToProfilo() {
        if (mapProtocolloToProfilo == null) {
            ProfiloUtils.initMapProtocolloToProfilo();
        }
        return mapProtocolloToProfilo;
    }

    private static synchronized void initMapProtocolloToProfilo() {
        if (mapProtocolloToProfilo == null) {
            mapProtocolloToProfilo = new HashMap<String, ProfiloEnum>();
            for (ProfiloEnum profiloEnum : MAP_PROFILO_TO_PROTOCOLLO.keySet()) {
                if (ProfiloEnum.MODIPA.equals((Object)profiloEnum)) continue;
                String protocollo = MAP_PROFILO_TO_PROTOCOLLO.get((Object)profiloEnum);
                mapProtocolloToProfilo.put(protocollo, profiloEnum);
            }
        }
    }

    public static String toProtocollo(ProfiloEnum profiloEnum) {
        return ProfiloUtils.getMapProfiloToProtocollo().get((Object)profiloEnum);
    }

    public static ProfiloEnum toProfilo(String protocollo) {
        ProfiloEnum out = ProfiloUtils.getMapProtocolloToProfilo().get(protocollo);
        return ProfiloEnum.MODIPA.equals((Object)out) ? ProfiloEnum.MODI : out;
    }

    static {
        MAP_PROFILO_TO_PROTOCOLLO.put(ProfiloEnum.APIGATEWAY, "trasparente");
        MAP_PROFILO_TO_PROTOCOLLO.put(ProfiloEnum.MODIPA, "modipa");
        MAP_PROFILO_TO_PROTOCOLLO.put(ProfiloEnum.MODI, "modipa");
        MAP_PROFILO_TO_PROTOCOLLO.put(ProfiloEnum.SPCOOP, "spcoop");
        MAP_PROFILO_TO_PROTOCOLLO.put(ProfiloEnum.FATTURAPA, "sdi");
        MAP_PROFILO_TO_PROTOCOLLO.put(ProfiloEnum.EDELIVERY, "as4");
        mapProtocolloToProfilo = null;
    }
}

