/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.serialization.IDeserializer;
import org.openspcoop2.utils.serialization.IOException;
import org.openspcoop2.utils.serialization.SerializationConfig;

public class JsonJacksonDeserializer
implements IDeserializer {
    private ObjectMapper mapper;

    public JsonJacksonDeserializer() {
        this(new SerializationConfig());
    }

    public JsonJacksonDeserializer(SerializationConfig config) {
        BeanDeserializerModifierForIgnorables modifier = new BeanDeserializerModifierForIgnorables(config.getExcludes());
        DeserializerFactory dFactory = BeanDeserializerFactory.instance.withDeserializerModifier((BeanDeserializerModifier)modifier);
        this.mapper = new ObjectMapper(null, null, (DefaultDeserializationContext)new DefaultDeserializationContext.Impl(dFactory));
        this.mapper.setAnnotationIntrospector((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)new JakartaXmlBindAnnotationIntrospector(TypeFactory.defaultInstance()), (AnnotationIntrospector)new JakartaXmlBindAnnotationIntrospector(TypeFactory.defaultInstance())));
        this.mapper.setDateFormat(config.getDf());
        if (config.isSerializeEnumAsString()) {
            this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        }
    }

    @Override
    public Object getObject(String s, Class<?> classType) throws IOException {
        try {
            return this.mapper.readValue(s, classType);
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object readObject(InputStream is, Class<?> classType) throws IOException {
        try {
            return this.mapper.readValue(is, classType);
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object readObject(Reader reader, Class<?> classType) throws IOException {
        try {
            return this.mapper.readValue(reader, classType);
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    private static class BeanDeserializerModifierForIgnorables
    extends BeanDeserializerModifier {
        private static final long serialVersionUID = 1L;
        private List<String> ignorables;

        public BeanDeserializerModifierForIgnorables(List<String> properties) {
            this.ignorables = properties != null ? properties : new ArrayList<String>();
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
            for (String ignorable : this.ignorables) {
                builder.addIgnorable(ignorable);
            }
            return builder;
        }

        public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
            ArrayList<BeanPropertyDefinition> newPropDefs = new ArrayList<BeanPropertyDefinition>();
            for (BeanPropertyDefinition propDef : propDefs) {
                if (this.ignorables.contains(propDef.getName())) continue;
                newPropDefs.add(propDef);
            }
            return newPropDefs;
        }
    }
}

