/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.semaphore.test;

import java.io.File;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.Level;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.SystemDate;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.openspcoop2.utils.semaphore.test.ClientTestThread;
import org.openspcoop2.utils.semaphore.test.EventGeneratorLog;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class ClientTest {
    private static boolean systemOut = true;
    static int CICLI_LOCK_PER_THREAD = 150;
    static int THREADS = 20;
    static boolean DEBUG = false;
    static Logger log = null;

    public static void main(String[] args) throws Exception {
        ClientTest.test(args, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(String[] args, boolean verificaLogFile) throws Exception {
        String timeWait;
        String debugParam;
        String cicliLockPerThread;
        String numThreads;
        String testIdleCustom;
        String driverJdbcCustom;
        String passwordCustom;
        String usernameCustom;
        String urlCustom;
        File fStatusCode = new File("statusCode");
        fStatusCode.delete();
        File logFile = File.createTempFile("runSemaphoreTest_", ".log");
        System.out.println("LogMessages write in " + logFile.getAbsolutePath());
        LoggerWrapperFactory.setDefaultLogConfiguration(Level.ALL, false, null, logFile, "%m %n");
        log = LoggerWrapperFactory.getLogger(ClientTest.class);
        DateManager.initializeDataManager(SystemDate.class.getName(), new Properties(), log);
        TipiDatabase tipoDatabase = null;
        if (args.length > 0 && !"${tipoDatabase}".equals(args[0].trim())) {
            tipoDatabase = TipiDatabase.toEnumConstant(args[0].trim());
        }
        if (tipoDatabase == null) {
            throw new Exception("TipoDatabase non fornito");
        }
        String url = null;
        String driver = null;
        String userName = null;
        String password = null;
        int timeWaitMs = 60000;
        boolean testIdle = true;
        switch (tipoDatabase) {
            case POSTGRESQL: {
                url = "jdbc:postgresql://localhost/prova";
                driver = "org.postgresql.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case MYSQL: {
                url = "jdbc:mysql://localhost/prova";
                driver = "com.mysql.jdbc.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case ORACLE: {
                url = "jdbc:oracle:thin:@localhost:1521:XE";
                driver = "oracle.jdbc.OracleDriver";
                userName = "prova";
                password = "prova";
                break;
            }
            case HSQL: {
                url = "jdbc:hsqldb:hsql://localhost:9001/";
                driver = "org.hsqldb.jdbcDriver";
                userName = "sa";
                password = "";
                break;
            }
            case SQLSERVER: {
                url = "jdbc:sqlserver://localhost:1433;databaseName=prova";
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case DB2: {
                url = "jdbc:db2://127.0.0.1:50000/prova";
                driver = "com.ibm.db2.jcc.DB2Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
        }
        if (args.length > 1 && !"${url}".equals(urlCustom = args[1].trim())) {
            url = urlCustom;
        }
        if (args.length > 2 && !"${username}".equals(usernameCustom = args[2].trim())) {
            userName = usernameCustom;
        }
        if (args.length > 3 && !"${password}".equals(passwordCustom = args[3].trim())) {
            password = passwordCustom;
        }
        if (args.length > 4 && !"${driverJdbc}".equals(driverJdbcCustom = args[4].trim())) {
            driver = driverJdbcCustom;
        }
        if (args.length > 5 && !"${testIdle}".equals(testIdleCustom = args[5].trim())) {
            testIdle = "true".equalsIgnoreCase(testIdleCustom);
        }
        if (args.length > 6 && !"${threads}".equals(numThreads = args[6].trim())) {
            try {
                THREADS = Integer.parseInt(numThreads);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'threads' with wrong format (value:" + numThreads + "): " + e.getMessage(), e);
            }
        }
        if (args.length > 7 && !"${lockForThread}".equals(cicliLockPerThread = args[7].trim())) {
            try {
                CICLI_LOCK_PER_THREAD = Integer.parseInt(cicliLockPerThread);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'lockForThread' with wrong format (value:" + cicliLockPerThread + "): " + e.getMessage(), e);
            }
        }
        if (args.length > 8 && !"${printDebug}".equals(debugParam = args[8].trim())) {
            try {
                DEBUG = Boolean.parseBoolean(debugParam);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'printDebug' with wrong format (value:" + debugParam + "): " + e.getMessage(), e);
            }
        }
        if (args.length > 9 && !"${timeWaitMs}".equals(timeWait = args[9].trim())) {
            try {
                timeWaitMs = Integer.parseInt(timeWait);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'timeWaitMs' with wrong format (value:" + timeWait + "): " + e.getMessage(), e);
            }
        }
        System.out.println("URL:" + url);
        System.out.println("UserName:" + userName);
        System.out.println("Password:" + password);
        System.out.println("DriverJDBC:" + driver);
        System.out.println("Threads:" + THREADS);
        System.out.println("Cicli lock per thread:" + CICLI_LOCK_PER_THREAD);
        System.out.println("Debug:" + DEBUG);
        System.out.println("TimeWaitMs:" + timeWaitMs);
        ClassLoaderUtilities.newInstance(driver);
        Connection con = null;
        ArrayList<Connection> conThreads = new ArrayList<Connection>();
        try {
            String logContent;
            con = DriverManager.getConnection(url, userName, password);
            InfoStatistics infoStat = new InfoStatistics();
            infoStat.clear();
            ClientTest.clear(con);
            for (int i = 0; i < THREADS; ++i) {
                conThreads.add(DriverManager.getConnection(url, userName, password));
            }
            ArrayList<String> listApplicativeId = new ArrayList<String>();
            boolean SERIALIZABLE = true;
            boolean READ_COMMITTED = false;
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 1. Idle:Infinito MaxLife:Infinito");
            String applicativeId = null;
            if (TipiDatabase.ORACLE.equals((Object)tipoDatabase)) {
                ClientTest.init(con, tipoDatabase, applicativeId);
            }
            ClientTest.test(infoStat, SemaphoreMapping.newInstance(applicativeId), tipoDatabase, conThreads, log, DEBUG, timeWaitMs, -1L, -1L, SERIALIZABLE);
            ClientTest.printInfos(infoStat);
            listApplicativeId.add(applicativeId);
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 2a. Idle:Infinito MaxLife:Infinito ApplicativeId:TestNumero2-NOSerializable");
            applicativeId = "TestNumero2-NOSerializable";
            ClientTest.init(con, tipoDatabase, applicativeId);
            ClientTest.test(infoStat, SemaphoreMapping.newInstance(applicativeId), tipoDatabase, conThreads, log, DEBUG, timeWaitMs, -1L, -1L, READ_COMMITTED);
            ClientTest.printInfos(infoStat);
            listApplicativeId.add(applicativeId);
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 2b. Idle:Infinito MaxLife:Infinito ApplicativeId:TestNumero2-Serializable");
            applicativeId = "TestNumero2-Serializable";
            if (TipiDatabase.ORACLE.equals((Object)tipoDatabase)) {
                ClientTest.init(con, tipoDatabase, applicativeId);
            }
            ClientTest.test(infoStat, SemaphoreMapping.newInstance(applicativeId), tipoDatabase, conThreads, log, DEBUG, timeWaitMs, -1L, -1L, SERIALIZABLE);
            ClientTest.printInfos(infoStat);
            listApplicativeId.add(applicativeId);
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 3a. Idle:Infinito MaxLife:Infinito ApplicativeId:TestNumero3-NOSerializable");
            applicativeId = "TestNumero3-NOSerializable";
            ClientTest.init(con, tipoDatabase, applicativeId);
            ClientTest.test(infoStat, SemaphoreMapping.newInstance(applicativeId), tipoDatabase, conThreads, log, DEBUG, timeWaitMs, -1L, -1L, READ_COMMITTED);
            ClientTest.printInfos(infoStat);
            listApplicativeId.add(applicativeId);
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 3b. Idle:Infinito MaxLife:Infinito ApplicativeId:TestNumero3-Serializable");
            applicativeId = "TestNumero3-Serializable";
            if (TipiDatabase.ORACLE.equals((Object)tipoDatabase)) {
                ClientTest.init(con, tipoDatabase, applicativeId);
            }
            ClientTest.test(infoStat, SemaphoreMapping.newInstance(applicativeId), tipoDatabase, conThreads, log, DEBUG, timeWaitMs, -1L, -1L, SERIALIZABLE);
            ClientTest.printInfos(infoStat);
            listApplicativeId.add(applicativeId);
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 4a. Idle:Infinito MaxLife:100ms ApplicativeId:TestNumero4-NoSerializable");
            applicativeId = "TestNumero4-NoSerializable";
            ClientTest.init(con, tipoDatabase, applicativeId);
            boolean foundError = false;
            try {
                ClientTest.test(infoStat, SemaphoreMapping.newInstance(applicativeId), tipoDatabase, conThreads, log, DEBUG, timeWaitMs, 100L, -1L, READ_COMMITTED);
            }
            catch (Throwable e) {
                foundError = true;
                ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
            }
            if (!foundError) {
                throw new Exception("Atteso errore di max life, errore non rilevato");
            }
            if (verificaLogFile && !(logContent = FileSystemUtilities.readFile(logFile)).contains("Max Life Time (100ms) exceeded")) {
                throw new Exception("Atteso errore di max life, errore non rilevato nel log file");
            }
            ClientTest.printInfos(infoStat);
            listApplicativeId.add(applicativeId);
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 4b. Idle:Infinito MaxLife:100ms ApplicativeId:TestNumero4-Serializable");
            applicativeId = "TestNumero4-Serializable";
            if (TipiDatabase.ORACLE.equals((Object)tipoDatabase)) {
                ClientTest.init(con, tipoDatabase, applicativeId);
            }
            foundError = false;
            try {
                ClientTest.test(infoStat, SemaphoreMapping.newInstance(applicativeId), tipoDatabase, conThreads, log, DEBUG, timeWaitMs, 105L, -1L, SERIALIZABLE);
            }
            catch (Throwable e) {
                foundError = true;
                ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
            }
            if (!foundError) {
                throw new Exception("Atteso errore di max life, errore non rilevato");
            }
            if (verificaLogFile && !(logContent = FileSystemUtilities.readFile(logFile)).contains("Max Life Time (105ms) exceeded")) {
                throw new Exception("Atteso errore di max life, errore non rilevato nel log file");
            }
            ClientTest.printInfos(infoStat);
            listApplicativeId.add(applicativeId);
            if (testIdle) {
                infoStat.clear();
                ClientTest.info(log, systemOut, "\n\n==========================================");
                ClientTest.info(log, systemOut, "Test 5a. Idle:38ms MaxLife:Infinito ApplicativeId:TestNumero5-NOSerializable");
                applicativeId = "TestNumero5-NOSerializable";
                ClientTest.init(con, tipoDatabase, applicativeId);
                foundError = false;
                try {
                    ClientTest.test(infoStat, SemaphoreMapping.newInstance(applicativeId), tipoDatabase, conThreads, log, DEBUG, timeWaitMs, -1L, 38L, READ_COMMITTED);
                }
                catch (Throwable e) {
                    foundError = true;
                    ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
                }
                if (!foundError) {
                    throw new Exception("Atteso errore di idle time, errore non rilevato");
                }
                if (verificaLogFile && !(logContent = FileSystemUtilities.readFile(logFile)).contains("Idle Time (38ms) exceeded")) {
                    throw new Exception("Atteso errore di idle time, errore non rilevato nel log file");
                }
                ClientTest.printInfos(infoStat);
                listApplicativeId.add(applicativeId);
                ClientTest.info(log, systemOut, "\n\n==========================================");
                ClientTest.info(log, systemOut, "Test 5b. Idle:42s MaxLife:Infinito ApplicativeId:TestNumero5-Serializable");
                applicativeId = "TestNumero5-Serializable";
                if (TipiDatabase.ORACLE.equals((Object)tipoDatabase)) {
                    ClientTest.init(con, tipoDatabase, applicativeId);
                }
                foundError = false;
                try {
                    ClientTest.test(infoStat, SemaphoreMapping.newInstance(applicativeId), tipoDatabase, conThreads, log, DEBUG, timeWaitMs, -1L, 42L, SERIALIZABLE);
                }
                catch (Throwable e) {
                    foundError = true;
                    ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
                }
                if (!foundError) {
                    throw new Exception("Atteso errore di idle time, errore non rilevato");
                }
                if (verificaLogFile && !(logContent = FileSystemUtilities.readFile(logFile)).contains("Idle Time (42ms) exceeded")) {
                    throw new Exception("Atteso errore di idle time, errore non rilevato nel log file");
                }
                ClientTest.printInfos(infoStat);
                listApplicativeId.add(applicativeId);
            }
            ClientTest.verificaFinale(con, tipoDatabase, listApplicativeId);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception infoStat) {}
            for (int i = 0; i < THREADS; ++i) {
                try {
                    ((Connection)conThreads.get(i)).close();
                    continue;
                }
                catch (Exception exception) {}
            }
        }
        try {
            FileSystemUtilities.writeFile(fStatusCode, "OK".getBytes());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void info(Logger log, boolean systemOut, String msg) {
        log.info(msg);
        if (systemOut) {
            System.out.println(msg);
        }
    }

    private static void printInfos(InfoStatistics infoStat) {
        ClientTest.info(log, systemOut, "Numero di errori 'access serializable': " + infoStat.getErrorSerializableAccess());
        for (int i = 0; i < infoStat.getExceptionOccurs().size(); ++i) {
            Throwable e = infoStat.getExceptionOccurs().get(i);
            ClientTest.info(log, systemOut, "Errore-" + (i + 1) + " (occurs:" + infoStat.getNumber(e) + "): " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clear(Connection con) throws Exception {
        Statement pstmt = null;
        try {
            SemaphoreMapping mapping = SemaphoreMapping.newInstance(null);
            String delete = "delete from " + mapping.getTable();
            pstmt = con.prepareStatement(delete);
            pstmt.execute();
            pstmt.close();
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(Connection con, TipiDatabase tipoDatabase, String applicativeId) throws Exception {
        Statement pstmt = null;
        try {
            SemaphoreMapping mapping = SemaphoreMapping.newInstance(null);
            ISQLQueryObject sqlQuery = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
            sqlQuery.addInsertTable(mapping.getTable());
            if (applicativeId == null) {
                sqlQuery.addInsertField(mapping.getUniqueConditionColumnName(0), "null");
            } else {
                sqlQuery.addInsertField(mapping.getUniqueConditionColumnName(0), "?");
            }
            String insert = sqlQuery.createSQLInsert();
            pstmt = con.prepareStatement(insert);
            if (applicativeId != null) {
                pstmt.setString(1, applicativeId);
            }
            pstmt.execute();
            pstmt.close();
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verificaFinale(Connection con, TipiDatabase tipoDatabase, List<String> listApplicativeId) throws Exception {
        ResultSet rs = null;
        Statement pstmt = null;
        try {
            SemaphoreMapping mapping = SemaphoreMapping.newInstance(null);
            ISQLQueryObject sqlQuery = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
            sqlQuery.addFromTable(mapping.getTable());
            sqlQuery.setANDLogicOperator(true);
            sqlQuery.addWhereIsNullCondition(mapping.getIdNode());
            sqlQuery.addWhereIsNullCondition(mapping.getLockDate());
            sqlQuery.addWhereIsNullCondition(mapping.getUpdateDate());
            sqlQuery.addWhereIsNullCondition(mapping.getDetails());
            sqlQuery.addSelectCountField("verifica");
            pstmt = con.prepareStatement(sqlQuery.createSQLQuery());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int v = rs.getInt("verifica");
                if (v != listApplicativeId.size()) {
                    throw new Exception("Entries trovate nel database (" + v + ") differenti da quelle attese (" + listApplicativeId.size() + ")");
                }
            } else {
                throw new Exception("Entries non trovate nel database");
            }
            rs.close();
            pstmt.close();
            for (String applicativeId : listApplicativeId) {
                sqlQuery = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
                sqlQuery.addFromTable(mapping.getTable());
                sqlQuery.setANDLogicOperator(true);
                sqlQuery.addWhereIsNullCondition(mapping.getIdNode());
                sqlQuery.addWhereIsNullCondition(mapping.getLockDate());
                sqlQuery.addWhereIsNullCondition(mapping.getUpdateDate());
                sqlQuery.addWhereIsNullCondition(mapping.getDetails());
                sqlQuery.addSelectCountField("verifica");
                if (applicativeId != null) {
                    sqlQuery.addWhereCondition(mapping.getUniqueConditionColumnName(0) + "=?");
                } else {
                    sqlQuery.addWhereIsNullCondition(mapping.getUniqueConditionColumnName(0));
                }
                pstmt = con.prepareStatement(sqlQuery.createSQLQuery());
                StringBuilder bf = new StringBuilder(sqlQuery.createSQLQuery());
                if (applicativeId != null) {
                    pstmt.setString(1, applicativeId);
                    String s = bf.toString();
                    bf.delete(0, s.length());
                    bf.append(s.replace("?", applicativeId));
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    int v = rs.getInt("verifica");
                    if (v > 1) {
                        throw new Exception("Entries trovate (" + v + ") per l'id applicativo (" + applicativeId + ") sono pi\u00f9 di una\nQuery: " + bf.toString());
                    }
                    if (v < 1) {
                        throw new Exception("Entries non trovate per l'id applicativo (\"+applicativeId+\")\nQuery: " + bf.toString());
                    }
                } else {
                    throw new Exception("Entries non trovate per l'id applicativo (\"+applicativeId+\")\nQuery: " + bf.toString());
                }
                rs.close();
                pstmt.close();
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(InfoStatistics infoStat, SemaphoreMapping mapping, TipiDatabase tipoDatabase, List<Connection> conThreads, Logger log, boolean debug, long timeWaitMs, long maxLife, long idleTime, boolean serializableLevel) throws Exception {
        String msg;
        Date inizio = DateManager.getDate();
        EventGeneratorLog eventGenerator = new EventGeneratorLog(log);
        ExecutorService threadsPool = Executors.newFixedThreadPool(conThreads.size());
        HashMap<CallSite, ClientTestThread> threads = new HashMap<CallSite, ClientTestThread>();
        boolean error = false;
        try {
            for (int i = 0; i < conThreads.size(); ++i) {
                SemaphoreConfiguration config = new SemaphoreConfiguration();
                config.setSerializableTimeWaitMs(timeWaitMs);
                config.setMaxLife(maxLife);
                config.setMaxIdleTime(idleTime);
                config.setEmitEvent(true);
                config.setEventGenerator(eventGenerator);
                config.setIdNode("Thread-" + i);
                config.setSerializableLevel(serializableLevel);
                ClientTestThread c = new ClientTestThread(infoStat, mapping, config, tipoDatabase, log, conThreads.get(i), i, debug);
                threadsPool.execute(c);
                if (debug) {
                    log.info("Lanciato thread " + i);
                }
                threads.put((CallSite)((Object)("Thread-" + i)), c);
            }
            boolean terminated = false;
            while (!terminated) {
                if (debug) {
                    log.info("Attendo terminazione ...");
                }
                boolean tmpTerminated = true;
                for (int i = 0; i < conThreads.size(); ++i) {
                    ClientTestThread c = (ClientTestThread)threads.get("Thread-" + i);
                    if (c.isError()) {
                        error = true;
                    }
                    if (c.isFinished()) continue;
                    tmpTerminated = false;
                    break;
                }
                if (!tmpTerminated) {
                    Utilities.sleep(250L);
                    continue;
                }
                terminated = true;
            }
        }
        finally {
            log.info("Shutdown pool ...");
            threadsPool.shutdown();
            log.info("Shutdown pool ok");
        }
        Date fine = DateManager.getDate();
        long diff = fine.getTime() - inizio.getTime();
        log.info("Tempo impiegato: " + Utilities.convertSystemTimeIntoStringMillisecondi(diff, true));
        int lockAcquisiti = 0;
        int lockAggiornati = 0;
        int lockRilasciati = 0;
        for (int i = 0; i < conThreads.size(); ++i) {
            ClientTestThread c = (ClientTestThread)threads.get("Thread-" + i);
            log.info("[Thread-" + i + "] acquisito:" + c.isLockAcquisito() + " aggiornamenti:" + c.getLockAggiornamenti() + " rilasciato:" + c.isLockRilasciato());
            lockAcquisiti += c.isLockAcquisito() ? 1 : 0;
            lockAggiornati += c.getLockAggiornamenti();
            lockRilasciati += c.isLockRilasciato() ? 1 : 0;
        }
        if (error) {
            throw new Exception("Error occurs in threads");
        }
        StringBuilder bf = new StringBuilder();
        if (lockAcquisiti != THREADS) {
            msg = "Riscontrata una differenza tra i lock acquisiti (" + lockAcquisiti + ") ed i threads (" + THREADS + ")";
            log.error(msg);
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append(msg);
        }
        if (lockAcquisiti != lockRilasciati) {
            msg = "Riscontrata una differenza tra i lock acquisiti (" + lockAcquisiti + ") e quelli rilasciati (" + lockRilasciati + ")";
            log.error(msg);
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append(msg);
        }
        if (lockAcquisiti * 5 != lockAggiornati) {
            msg = "Riscontrata una differenza tra i lock acquisiti (" + lockAcquisiti + ") e quelli aggiornati (" + lockAggiornati + ") (dovrebbero essere 5 volte tanto)";
            log.error(msg);
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append(msg);
        }
        if (eventGenerator.getAcquisiti().size() != lockAcquisiti) {
            msg = "Riscontrata una differenza tra i lock acquisiti (" + lockAcquisiti + ") e quelli notificati (" + eventGenerator.getAcquisiti().size() + ")";
            log.error(msg);
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append(msg);
        }
        if (eventGenerator.getRilasciati().size() != lockRilasciati) {
            msg = "Riscontrata una differenza tra i lock rilasciati (" + lockRilasciati + ") e quelli notificati (" + eventGenerator.getRilasciati().size() + ")";
            log.error(msg);
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append(msg);
        }
        if (eventGenerator.getAggiornati().size() != lockAggiornati) {
            msg = "Riscontrata una differenza tra i lock aggiornati (" + lockAggiornati + ") e quelli notificati (" + eventGenerator.getAggiornati().size() + ")";
            log.error(msg);
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append(msg);
        }
        if (eventGenerator.getErrori().size() > 0) {
            msg = "Riscontrati errori durante la notifica: " + eventGenerator.getErrori().toString();
            log.error(msg);
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append(msg);
        }
        if (bf.length() > 0) {
            throw new Exception(bf.toString());
        }
    }
}

