/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.openspcoop2.utils.security.JOSESerialization;

public class JWTOptions {
    private JOSESerialization serialization;
    private boolean permitUseHeaderX5C = true;
    private boolean permitUseHeaderX5U = true;
    private boolean permitUseHeaderX5T = true;
    private boolean permitUseHeaderX5T_256 = true;
    private boolean permitUseHeaderJWK = true;
    private boolean permitUseHeaderJKU = true;
    private boolean permitUseHeaderKID = true;

    public JWTOptions(JOSESerialization serialization) {
        this.serialization = serialization;
    }

    public JOSESerialization getSerialization() {
        return this.serialization;
    }

    public void setSerialization(JOSESerialization serialization) {
        this.serialization = serialization;
    }

    public boolean isPermitUseHeaderX5C() {
        return this.permitUseHeaderX5C;
    }

    public void setPermitUseHeaderX5C(boolean permitUseHeaderX5C) {
        this.permitUseHeaderX5C = permitUseHeaderX5C;
    }

    public boolean isPermitUseHeaderX5U() {
        return this.permitUseHeaderX5U;
    }

    public void setPermitUseHeaderX5U(boolean permitUseHeaderX5U) {
        this.permitUseHeaderX5U = permitUseHeaderX5U;
    }

    public boolean isPermitUseHeaderX5T() {
        return this.permitUseHeaderX5T;
    }

    public void setPermitUseHeaderX5T(boolean permitUseHeaderX5T) {
        this.permitUseHeaderX5T = permitUseHeaderX5T;
    }

    public boolean isPermitUseHeaderX5T_256() {
        return this.permitUseHeaderX5T_256;
    }

    public void setPermitUseHeaderX5T_256(boolean permitUseHeaderX5T_256) {
        this.permitUseHeaderX5T_256 = permitUseHeaderX5T_256;
    }

    public boolean isPermitUseHeaderJWK() {
        return this.permitUseHeaderJWK;
    }

    public void setPermitUseHeaderJWK(boolean permitUseHeaderJWK) {
        this.permitUseHeaderJWK = permitUseHeaderJWK;
    }

    public boolean isPermitUseHeaderJKU() {
        return this.permitUseHeaderJKU;
    }

    public void setPermitUseHeaderJKU(boolean permitUseHeaderJKU) {
        this.permitUseHeaderJKU = permitUseHeaderJKU;
    }

    public boolean isPermitUseHeaderKID() {
        return this.permitUseHeaderKID;
    }

    public void setPermitUseHeaderKID(boolean permitUseHeaderKID) {
        this.permitUseHeaderKID = permitUseHeaderKID;
    }

    public List<String> headersNotPermitted(JoseHeaders hdrs) {
        ArrayList<String> list = new ArrayList<String>();
        if (hdrs.getX509Chain() != null && !hdrs.getX509Chain().isEmpty() && !this.isPermitUseHeaderX5C()) {
            list.add("x5c");
        }
        if (hdrs.getJsonWebKey() != null && !this.isPermitUseHeaderJWK()) {
            list.add("jwk");
        }
        if (hdrs.getX509Url() != null && !this.isPermitUseHeaderX5U()) {
            list.add("x5u");
        }
        if (hdrs.getJsonWebKeysUrl() != null && !this.isPermitUseHeaderJKU()) {
            list.add("jku");
        }
        if (hdrs.getX509Thumbprint() != null && !this.isPermitUseHeaderX5T()) {
            list.add("x5t");
        }
        if (hdrs.getX509ThumbprintSHA256() != null && !this.isPermitUseHeaderX5T_256()) {
            list.add("x5t#S256");
        }
        if (hdrs.getKeyId() != null && !this.isPermitUseHeaderKID()) {
            list.add("kid");
        }
        return list;
    }
}

