/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.random.RandomUtilities;
import org.openspcoop2.utils.security.AbstractCipher;
import org.openspcoop2.utils.security.CipherInfo;
import org.openspcoop2.utils.security.OpenSSLEncryptionMode;

public class EncryptOpenSSLPass
extends AbstractCipher {
    private static final String AES_CBC_PKCS5PADDING = "AES/CBC/PKCS5Padding";
    private CipherInfo cipherInfo;
    private OpenSSLEncryptionMode mode;

    public static CipherInfo buildCipherInfo(String password, String digestAlgoParam, OpenSSLEncryptionMode mode) throws UtilsException {
        CipherInfo cipherInfo = new CipherInfo();
        cipherInfo.setSalt(EncryptOpenSSLPass.buildSalt());
        cipherInfo.setEncodedKey(EncryptOpenSSLPass.buildSecretKey(password, cipherInfo.getSalt(), digestAlgoParam, mode));
        cipherInfo.setKey(new SecretKeySpec(cipherInfo.getEncodedKey(), "AES"));
        cipherInfo.setIv(EncryptOpenSSLPass.buildIV(password, cipherInfo.getSalt(), cipherInfo.getEncodedKey(), digestAlgoParam));
        cipherInfo.setIvParameterSpec(EncryptOpenSSLPass.convertTo(cipherInfo.getIv()));
        return cipherInfo;
    }

    static byte[] buildSalt() throws UtilsException {
        try {
            byte[] salt = new byte[8];
            RandomUtilities.getSecureRandom().nextBytes(salt);
            return salt;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    static byte[] buildSecretKey(String password, byte[] salt, String digestAlgoParam, OpenSSLEncryptionMode modeParam) throws UtilsException {
        try {
            byte[] secretKeyClear = password.getBytes();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(secretKeyClear);
            bout.write(salt);
            bout.flush();
            bout.close();
            byte[] passAndSalt = bout.toByteArray();
            String digestAlgo = digestAlgoParam;
            if (digestAlgoParam == null || StringUtils.isEmpty((CharSequence)digestAlgoParam)) {
                digestAlgo = "SHA-256";
            }
            MessageDigest md = MessageDigest.getInstance(digestAlgo);
            byte[] key = md.digest(passAndSalt);
            OpenSSLEncryptionMode mode = modeParam != null ? modeParam : OpenSSLEncryptionMode.AES_256_CBC;
            switch (mode) {
                case AES_128_CBC: {
                    key = Arrays.copyOf(key, 16);
                    break;
                }
                case AES_192_CBC: {
                    key = Arrays.copyOf(key, 24);
                    break;
                }
                case AES_256_CBC: {
                    key = Arrays.copyOf(key, 32);
                }
            }
            return key;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    static byte[] buildIV(String password, byte[] salt, byte[] encodedKey, String digestAlgoParam) throws UtilsException {
        try {
            String digestAlgo = digestAlgoParam;
            if (digestAlgoParam == null || StringUtils.isEmpty((CharSequence)digestAlgoParam)) {
                digestAlgo = "SHA-256";
            }
            MessageDigest md = MessageDigest.getInstance(digestAlgo);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(encodedKey);
            bout.write(password.getBytes());
            bout.write(salt);
            bout.flush();
            bout.close();
            byte[] keyAndPassAndSalt = bout.toByteArray();
            return Arrays.copyOfRange(md.digest(keyAndPassAndSalt), 0, 16);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    static IvParameterSpec convertTo(byte[] iv) {
        return new IvParameterSpec(iv);
    }

    public static byte[] formatOutput(byte[] salt, byte[] cipherText) throws UtilsException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.writeBytes("Salted__".getBytes());
            bos.writeBytes(salt);
            bos.writeBytes(cipherText);
            bos.flush();
            bos.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public EncryptOpenSSLPass(String password) throws UtilsException {
        this(password, null);
    }

    public EncryptOpenSSLPass(String password, OpenSSLEncryptionMode modeParam) throws UtilsException {
        super(1);
        this.mode = modeParam != null ? modeParam : OpenSSLEncryptionMode.AES_256_CBC;
        this.cipherInfo = EncryptOpenSSLPass.buildCipherInfo(password, null, this.mode);
        this.key = this.cipherInfo.getKey();
        this.ivParameterSpec = this.cipherInfo.getIvParameterSpec();
    }

    static String getAlgorithm(OpenSSLEncryptionMode mode) throws UtilsException {
        switch (mode) {
            case AES_128_CBC: 
            case AES_192_CBC: 
            case AES_256_CBC: {
                return AES_CBC_PKCS5PADDING;
            }
        }
        throw new UtilsException("Unsupported mode");
    }

    public byte[] encrypt(String data, String charsetName) throws UtilsException {
        return EncryptOpenSSLPass.formatOutput(this.cipherInfo.getSalt(), super.process(data, charsetName, EncryptOpenSSLPass.getAlgorithm(this.mode)));
    }

    public byte[] encrypt(byte[] data) throws UtilsException {
        return EncryptOpenSSLPass.formatOutput(this.cipherInfo.getSalt(), super.process(data, EncryptOpenSSLPass.getAlgorithm(this.mode)));
    }

    public byte[] encryptBase64(String data, String charsetName) throws UtilsException {
        return Base64Utilities.encode(this.encrypt(data, charsetName));
    }

    public byte[] encryptBase64(byte[] data) throws UtilsException {
        return Base64Utilities.encode(this.encrypt(data));
    }

    public String encryptBase64AsString(String data, String charsetName) throws UtilsException {
        return Base64Utilities.encodeAsString(this.encrypt(data, charsetName));
    }

    public String encryptBase64AsString(byte[] data) throws UtilsException {
        return Base64Utilities.encodeAsString(this.encrypt(data));
    }

    public char[] encryptHexBinary(String data, String charsetName) throws UtilsException {
        return HexBinaryUtilities.encode(this.encrypt(data, charsetName));
    }

    public char[] encryptHexBinary(byte[] data) throws UtilsException {
        return HexBinaryUtilities.encode(this.encrypt(data));
    }

    public String encryptHexBinaryAsString(String data, String charsetName) throws UtilsException {
        return HexBinaryUtilities.encodeAsString(this.encrypt(data, charsetName));
    }

    public String encryptHexBinaryAsString(byte[] data) throws UtilsException {
        return HexBinaryUtilities.encodeAsString(this.encrypt(data));
    }

    @Override
    public void initIV(String algorithm) throws UtilsException {
    }
}

