/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.Key;
import java.security.cert.Certificate;
import javax.crypto.spec.IvParameterSpec;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.security.AbstractCipher;

public class Encrypt
extends AbstractCipher {
    public Encrypt(byte[] secretKey, String algorithm) {
        super(1, secretKey, algorithm);
    }

    public Encrypt(byte[] secretKey, String algorithm, IvParameterSpec ivParameterSpec) {
        super(1, secretKey, algorithm, ivParameterSpec);
    }

    public Encrypt(byte[] secretKey, String algorithm, byte[] ivParameterSpec) {
        super(1, secretKey, algorithm, ivParameterSpec);
    }

    public Encrypt(Certificate certificate) {
        super(1, certificate);
    }

    public Encrypt(Key key) {
        super(1, key);
    }

    public Encrypt(Key key, IvParameterSpec ivParameterSpec) {
        super(1, key, ivParameterSpec);
    }

    public Encrypt(Key key, byte[] ivParameterSpec) {
        super(1, key, ivParameterSpec);
    }

    public Encrypt(KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        super(1, keystore, alias, passwordPrivateKey);
    }

    public Encrypt(KeyStore keystore, String alias) throws UtilsException {
        super(1, keystore, alias);
    }

    public Encrypt(KeyStore keystore) throws UtilsException {
        super(1, keystore);
    }

    public byte[] encrypt(String data, String charsetName, String algorithm) throws UtilsException {
        return super.process(data, charsetName, algorithm);
    }

    public byte[] encrypt(byte[] data, String algorithm) throws UtilsException {
        return super.process(data, algorithm);
    }

    public byte[] encryptBase64(String data, String charsetName, String algorithm) throws UtilsException {
        return Base64Utilities.encode(super.process(data, charsetName, algorithm));
    }

    public byte[] encryptBase64(byte[] data, String algorithm) throws UtilsException {
        return Base64Utilities.encode(super.process(data, algorithm));
    }

    public String encryptBase64AsString(String data, String charsetName, String algorithm) throws UtilsException {
        return Base64Utilities.encodeAsString(super.process(data, charsetName, algorithm));
    }

    public String encryptBase64AsString(byte[] data, String algorithm) throws UtilsException {
        return Base64Utilities.encodeAsString(super.process(data, algorithm));
    }

    public char[] encryptHexBinary(String data, String charsetName, String algorithm) throws UtilsException {
        return HexBinaryUtilities.encode(super.process(data, charsetName, algorithm));
    }

    public char[] encryptHexBinary(byte[] data, String algorithm) throws UtilsException {
        return HexBinaryUtilities.encode(super.process(data, algorithm));
    }

    public String encryptHexBinaryAsString(String data, String charsetName, String algorithm) throws UtilsException {
        return HexBinaryUtilities.encodeAsString(super.process(data, charsetName, algorithm));
    }

    public String encryptHexBinaryAsString(byte[] data, String algorithm) throws UtilsException {
        return HexBinaryUtilities.encodeAsString(super.process(data, algorithm));
    }
}

