/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.security.AbstractCipher;
import org.openspcoop2.utils.security.CipherInfo;
import org.openspcoop2.utils.security.DecryptOpenSSLPass;
import org.openspcoop2.utils.security.EncryptOpenSSLPass;
import org.openspcoop2.utils.security.EncryptOpenSSLPassPBKDF2;
import org.openspcoop2.utils.security.OpenSSLEncryptionMode;

public class DecryptOpenSSLPassPBKDF2
extends AbstractCipher {
    private OpenSSLEncryptionMode mode;
    private String password;
    private Integer iterationCount;

    public static CipherInfo buildCipherInfo(byte[] cipherBytes, String password, Integer iterationCount, OpenSSLEncryptionMode mode) throws UtilsException {
        CipherInfo cipherInfo = new CipherInfo();
        cipherInfo.setSalt(DecryptOpenSSLPass.buildSalt(cipherBytes));
        EncryptOpenSSLPassPBKDF2.buildSecretKeyAndIV(password, cipherInfo.getSalt(), iterationCount, mode, cipherInfo);
        return cipherInfo;
    }

    public DecryptOpenSSLPassPBKDF2(String password) {
        this(password, null, null);
    }

    public DecryptOpenSSLPassPBKDF2(String password, Integer iterationCount) {
        this(password, iterationCount, null);
    }

    public DecryptOpenSSLPassPBKDF2(String password, OpenSSLEncryptionMode modeParam) {
        this(password, null, modeParam);
    }

    public DecryptOpenSSLPassPBKDF2(String password, Integer iterationCount, OpenSSLEncryptionMode modeParam) {
        super(2);
        this.mode = modeParam != null ? modeParam : OpenSSLEncryptionMode.AES_256_CBC;
        this.password = password;
        this.iterationCount = iterationCount;
    }

    public byte[] decrypt(byte[] data) throws UtilsException {
        CipherInfo cipherInfo = DecryptOpenSSLPassPBKDF2.buildCipherInfo(data, this.password, this.iterationCount, this.mode);
        this.key = cipherInfo.getKey();
        this.ivParameterSpec = cipherInfo.getIvParameterSpec();
        byte[] cipherBytes = DecryptOpenSSLPass.extractCipherBytes(data);
        return super.process(cipherBytes, EncryptOpenSSLPass.getAlgorithm(this.mode));
    }

    public byte[] decryptBase64(byte[] data) throws UtilsException {
        return this.decrypt(Base64Utilities.decode(data));
    }

    public byte[] decryptBase64(String data) throws UtilsException {
        return this.decrypt(Base64Utilities.decode(data));
    }

    public byte[] decryptHexBinary(char[] data) throws UtilsException {
        return this.decrypt(HexBinaryUtilities.decode(data));
    }

    public byte[] decryptHexBinary(String data) throws UtilsException {
        return this.decrypt(HexBinaryUtilities.decode(data));
    }

    @Override
    public void initIV(String algorithm) throws UtilsException {
    }
}

