/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.security.SymmetricKeyWrappedMode;

public abstract class AbstractXmlCipher {
    protected Provider provider;
    private Key keyWrapped;
    private Certificate certificateWrapped;
    protected SecretKey secretKeyWrapped;
    private int mode;
    private SymmetricKeyWrappedMode encryptedKeyMode;
    protected SecretKey secretKeyEncrypt;

    public boolean isEncryptedKey() throws UtilsException {
        if (this.encryptedKeyMode != null) {
            switch (this.encryptedKeyMode) {
                case SYM_ENC_KEY_NO_WRAPPED: {
                    return false;
                }
                case SYM_ENC_KEY_WRAPPED_SYMMETRIC_KEY: 
                case SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY: {
                    return true;
                }
            }
        }
        throw new UtilsException("Wrapped Key Mode undefined");
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey) throws UtilsException {
        this(mode, new org.openspcoop2.utils.certificate.KeyStore(keystore), symmetricKey, wrappedSymmetricKeyMode, alias, passwordPrivateKey, false);
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        this(mode, new org.openspcoop2.utils.certificate.KeyStore(keystore), symmetricKey, wrappedSymmetricKeyMode, alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, org.openspcoop2.utils.certificate.KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey) throws UtilsException {
        this(mode, keystore, symmetricKey, wrappedSymmetricKeyMode, alias, passwordPrivateKey, false);
    }

    protected AbstractXmlCipher(int mode, org.openspcoop2.utils.certificate.KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        if (symmetricKey) {
            SecretKey secretKey = keystore.getSecretKey(alias, passwordPrivateKey);
            this.initSymmetric(mode, wrappedSymmetricKeyMode, secretKey, addBouncyCastleProvider);
        } else {
            this.initPrivate(mode, keystore, alias, passwordPrivateKey, addBouncyCastleProvider);
        }
    }

    protected AbstractXmlCipher(int mode, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, Key key) throws UtilsException {
        this(mode, wrappedSymmetricKeyMode, key, false);
    }

    protected AbstractXmlCipher(int mode, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, Key key, boolean addBouncyCastleProvider) throws UtilsException {
        if (key instanceof SecretKey) {
            this.initSymmetric(mode, wrappedSymmetricKeyMode, (SecretKey)key, addBouncyCastleProvider);
        } else {
            this.mode = mode;
            this.keyWrapped = key;
            this.encryptedKeyMode = SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY;
            this.init(addBouncyCastleProvider);
        }
    }

    protected AbstractXmlCipher(int mode, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        this(mode, wrappedSymmetricKeyMode, new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, passwordPrivateKey, false);
    }

    protected AbstractXmlCipher(int mode, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, KeyStore keystore, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        this(mode, wrappedSymmetricKeyMode, new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        this(mode, wrappedSymmetricKeyMode, keystore, alias, passwordPrivateKey, false);
    }

    protected AbstractXmlCipher(int mode, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        if ("jceks".equalsIgnoreCase(keystore.getKeystore().getType())) {
            SecretKey secretKey = keystore.getSecretKey(alias, passwordPrivateKey);
            this.initSymmetric(mode, wrappedSymmetricKeyMode, secretKey, addBouncyCastleProvider);
        } else {
            this.initPrivate(mode, keystore, alias, passwordPrivateKey, addBouncyCastleProvider);
        }
    }

    protected AbstractXmlCipher(int mode, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, SecretKey secretKey) throws UtilsException {
        this(mode, wrappedSymmetricKeyMode, secretKey, false);
    }

    protected AbstractXmlCipher(int mode, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, SecretKey secretKey, boolean addBouncyCastleProvider) throws UtilsException {
        this.initSymmetric(mode, wrappedSymmetricKeyMode, secretKey, addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String keyAlgorithm) throws UtilsException {
        this(mode, wrappedSymmetricKeyMode, keyAlgorithm, false);
    }

    protected AbstractXmlCipher(int mode, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String keyAlgorithm, boolean addBouncyCastleProvider) throws UtilsException {
        this(mode, wrappedSymmetricKeyMode, AbstractXmlCipher.generateSecretKey(keyAlgorithm), addBouncyCastleProvider);
    }

    private void initSymmetric(int mode, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, SecretKey secretKey, boolean addBouncyCastleProvider) throws UtilsException {
        this.mode = mode;
        switch (wrappedSymmetricKeyMode) {
            case SYM_ENC_KEY_NO_WRAPPED: {
                this.secretKeyEncrypt = secretKey;
                break;
            }
            default: {
                this.secretKeyWrapped = secretKey;
            }
        }
        this.encryptedKeyMode = wrappedSymmetricKeyMode;
        this.init(addBouncyCastleProvider);
    }

    public SecretKey getSecretKeyEncryption() {
        return this.secretKeyEncrypt;
    }

    public static SecretKey generateSecretKey(String algorithm) throws UtilsException {
        return AbstractXmlCipher.generateSecretKey(algorithm, null);
    }

    public static SecretKey generateSecretKey(String algorithm, Provider provider) throws UtilsException {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = provider != null ? KeyGenerator.getInstance(algorithm, provider) : KeyGenerator.getInstance(algorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        return keyGenerator.generateKey();
    }

    private void initPrivate(int mode, org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        this.mode = mode;
        this.keyWrapped = keystore.getPrivateKey(alias, passwordPrivateKey);
        this.encryptedKeyMode = SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY;
        this.init(addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, Certificate certificate) throws UtilsException {
        this(mode, certificate, false);
    }

    protected AbstractXmlCipher(int mode, Certificate certificate, boolean addBouncyCastleProvider) throws UtilsException {
        this.mode = mode;
        this.certificateWrapped = certificate;
        this.encryptedKeyMode = SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY;
        this.init(addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore, String alias) throws UtilsException {
        this(mode, new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, false);
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        this(mode, new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, org.openspcoop2.utils.certificate.KeyStore keystore, String alias) throws UtilsException {
        this(mode, keystore, alias, false);
    }

    protected AbstractXmlCipher(int mode, org.openspcoop2.utils.certificate.KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        this.mode = mode;
        this.certificateWrapped = keystore.getCertificate(alias);
        this.encryptedKeyMode = SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY;
        this.init(addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore) throws UtilsException {
        this(mode, new org.openspcoop2.utils.certificate.KeyStore(keystore), false);
    }

    protected AbstractXmlCipher(int mode, KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        this(mode, new org.openspcoop2.utils.certificate.KeyStore(keystore), addBouncyCastleProvider);
    }

    protected AbstractXmlCipher(int mode, org.openspcoop2.utils.certificate.KeyStore keystore) throws UtilsException {
        this(mode, keystore, false);
    }

    protected AbstractXmlCipher(int mode, org.openspcoop2.utils.certificate.KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        this.mode = mode;
        this.certificateWrapped = keystore.getCertificate();
        this.encryptedKeyMode = SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY;
        this.init(addBouncyCastleProvider);
    }

    private void init(boolean addBouncyCastleProvider) throws UtilsException {
        try {
            if (addBouncyCastleProvider) {
                BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
                Security.addProvider((Provider)bouncyCastleProvider);
            }
            Init.init();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected XMLCipher getXMLCipher() throws UtilsException {
        try {
            XMLCipher xmlCipher = null;
            xmlCipher = this.provider != null ? XMLCipher.getInstance((String)this.provider.getName()) : XMLCipher.getInstance();
            xmlCipher.init(this.mode, null);
            return xmlCipher;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected XMLCipher getXMLCipher(String algorithm, String canon, String digest) throws UtilsException {
        try {
            XMLCipher xmlCipher = null;
            xmlCipher = canon != null || digest != null ? (this.provider != null ? XMLCipher.getProviderInstance((String)algorithm, (String)this.provider.getName(), (String)canon, (String)digest) : XMLCipher.getInstance((String)algorithm, (String)canon, (String)digest)) : (this.provider != null ? XMLCipher.getProviderInstance((String)algorithm, (String)this.provider.getName()) : XMLCipher.getInstance((String)algorithm));
            if (this.secretKeyEncrypt == null) {
                throw new UtilsException("Key for initialize cipher engine not found");
            }
            xmlCipher.init(this.mode, (Key)this.secretKeyEncrypt);
            return xmlCipher;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected XMLCipher getXMLCipherUnwrappedKey() throws UtilsException {
        return this.getXMLCipherWrappedKey(null);
    }

    protected XMLCipher getXMLCipherWrappedKey(String algorithm) throws UtilsException {
        try {
            XMLCipher xmlCipher = null;
            xmlCipher = algorithm != null ? (this.provider != null ? XMLCipher.getProviderInstance((String)algorithm, (String)this.provider.getName()) : XMLCipher.getInstance((String)algorithm)) : (this.provider != null ? XMLCipher.getProviderInstance((String)this.provider.getName()) : XMLCipher.getInstance());
            int wrapMode = -1;
            wrapMode = 1 == this.mode ? 3 : 4;
            if (this.secretKeyWrapped != null) {
                xmlCipher.init(wrapMode, (Key)this.secretKeyWrapped);
            } else if (this.keyWrapped != null) {
                xmlCipher.init(wrapMode, this.keyWrapped);
            } else if (this.certificateWrapped != null) {
                xmlCipher.init(wrapMode, (Key)this.certificateWrapped.getPublicKey());
            } else {
                throw new UtilsException("Key for initialize cipher engine 'wrapped key' not found");
            }
            return xmlCipher;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

