/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest.problem;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;

public class JsonSerializer {
    private boolean generateTypeBlank = false;
    private JSONUtils jsonUtils;

    public JsonSerializer() {
        this(false, false);
    }

    public JsonSerializer(boolean prettyPrint) {
        this(prettyPrint, false);
    }

    public JsonSerializer(boolean prettyPrint, boolean generateTypeBlank) {
        this.jsonUtils = JSONUtils.getInstance(prettyPrint);
        this.generateTypeBlank = generateTypeBlank;
    }

    public boolean isGenerateTypeBlank() {
        return this.generateTypeBlank;
    }

    public void setGenerateTypeBlank(boolean generateTypeBlank) {
        this.generateTypeBlank = generateTypeBlank;
    }

    public String toString(ProblemRFC7807 problem) throws UtilsException {
        ObjectNode jsonProblem = this.toNode(problem);
        return this.jsonUtils.toString((JsonNode)jsonProblem);
    }

    public byte[] toByteArray(ProblemRFC7807 problem) throws UtilsException {
        ObjectNode jsonProblem = this.toNode(problem);
        return this.jsonUtils.toByteArray((JsonNode)jsonProblem);
    }

    public ObjectNode toNode(ProblemRFC7807 problem) throws UtilsException {
        ObjectNode jsonProblem = this.jsonUtils.newObjectNode();
        if (problem.getType() != null) {
            jsonProblem.put("type", problem.getType());
        } else if (this.generateTypeBlank) {
            jsonProblem.put("type", "about:blank");
        }
        if (problem.getTitle() != null) {
            jsonProblem.put("title", problem.getTitle());
        }
        if (problem.getStatus() != null) {
            jsonProblem.put("status", problem.getStatus());
        }
        if (problem.getDetail() != null) {
            jsonProblem.put("detail", problem.getDetail());
        }
        if (problem.getInstance() != null) {
            jsonProblem.put("instance", problem.getInstance());
        }
        this.processCustom(problem, jsonProblem);
        return jsonProblem;
    }

    private void processCustom(ProblemRFC7807 problem, ObjectNode jsonProblem) throws UtilsException {
        if (problem.getCustom() != null && !problem.getCustom().isEmpty()) {
            for (String claimName : problem.getCustom().keySet()) {
                Object o = problem.getCustom().get(claimName);
                if (o == null) continue;
                if (o instanceof String) {
                    jsonProblem.put(claimName, (String)o);
                    continue;
                }
                if (o instanceof Integer) {
                    jsonProblem.put(claimName, (Integer)o);
                    continue;
                }
                if (o instanceof Long) {
                    jsonProblem.put(claimName, (Long)o);
                    continue;
                }
                if (o instanceof Boolean) {
                    jsonProblem.put(claimName, (Boolean)o);
                    continue;
                }
                throw new UtilsException("Custom claim with type [" + o.getClass().getName() + "] unsupported");
            }
        }
    }
}

