/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest.api;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.rest.ParseWarningException;
import org.openspcoop2.utils.rest.ProcessingException;
import org.openspcoop2.utils.rest.api.AbstractApiTypeParameter;
import org.openspcoop2.utils.rest.api.ApiBodyParameter;
import org.openspcoop2.utils.rest.api.ApiOperation;
import org.openspcoop2.utils.rest.api.ApiResponse;
import org.openspcoop2.utils.rest.api.ApiSchema;
import org.openspcoop2.utils.rest.api.ApiUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public abstract class Api
extends BaseBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private URL baseURL;
    private List<ApiSchema> schemas = new ArrayList<ApiSchema>();
    private Map<String, Serializable> mapSerializableVendorImpl = new HashMap<String, Serializable>();
    private List<ApiOperation> operations = new ArrayList<ApiOperation>();

    public Serializable getVendorImpl(String key) {
        return this.mapSerializableVendorImpl.get(key);
    }

    public void removeVendorImpl(String key) {
        this.mapSerializableVendorImpl.remove(key);
    }

    public void addVendorImpl(String key, Serializable serializable) {
        this.mapSerializableVendorImpl.put(key, serializable);
    }

    public boolean containsKey(String key) {
        return this.mapSerializableVendorImpl.containsKey(key);
    }

    public void addSchema(ApiSchema schema) {
        this.schemas.add(schema);
    }

    public ApiSchema getSchema(int index) {
        return this.schemas.get(index);
    }

    public ApiSchema removeSchema(int index) {
        return this.schemas.remove(index);
    }

    public List<ApiSchema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<ApiSchema> schemas) {
        this.schemas = schemas;
    }

    public int sizeSchemas() {
        return this.schemas.size();
    }

    public void addOperation(ApiOperation operation) {
        this.operations.add(operation);
    }

    public ApiOperation getOperation(int index) {
        return this.operations.get(index);
    }

    public ApiOperation removeOperation(int index) {
        return this.operations.remove(index);
    }

    public List<ApiOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<ApiOperation> operations) {
        this.operations = operations;
    }

    public int sizeOperations() {
        return this.operations.size();
    }

    public ApiOperation findOperation(HttpRequestMethod httpMethod, String url) throws ProcessingException {
        return ApiUtilities.findOperation(this, httpMethod, url, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public void validate() throws ProcessingException, ParseWarningException {
        this.validate(false);
    }

    public void validate(boolean validateBodyParameterElement) throws ProcessingException, ParseWarningException {
        this.validate(false, false);
    }

    public void validate(boolean usingFromSetProtocolInfo, boolean validateBodyParameterElement) throws ProcessingException, ParseWarningException {
        if (this.operations.size() <= 0) {
            throw new ProcessingException("Paths and Operations undefined");
        }
        for (int i = 0; i < this.operations.size(); ++i) {
            ApiOperation op = this.operations.get(i);
            String prefix = "Operation[" + i + "] ";
            if (op.getHttpMethod() == null) {
                throw new ProcessingException("HttpMethod is null");
            }
            if (op.getPath() == null) {
                throw new ProcessingException("Path is null");
            }
            prefix = "Operation[" + op.getHttpMethod().name() + " " + op.getPath() + "] ";
            if (op.getRequest() != null) {
                AbstractApiTypeParameter par;
                int j;
                String pRequest = prefix + "[request] ";
                for (j = 0; j < op.getRequest().sizeBodyParameters(); ++j) {
                    ApiBodyParameter bodyParm = op.getRequest().getBodyParameter(j);
                    if (bodyParm.getMediaType() == null) {
                        throw new ProcessingException(pRequest + "MediaType undefined in body parameter (position '" + j + "')");
                    }
                    if (!validateBodyParameterElement || bodyParm.getElement() != null) continue;
                    throw new ProcessingException(pRequest + "Element undefined in body parameter '" + bodyParm.getMediaType() + "'");
                }
                for (j = 0; j < op.getRequest().sizeCookieParameters(); ++j) {
                    par = op.getRequest().getCookieParameter(j);
                    if (par.getName() == null) {
                        throw new ProcessingException(pRequest + "Name undefined in cookie parameter (position '" + j + "')");
                    }
                    if (par.getApiParameterSchema() != null && par.getApiParameterSchema().isDefined()) continue;
                    throw new ProcessingException(pRequest + "Type undefined in cookie parameter '" + par.getName() + "'");
                }
                for (j = 0; j < op.getRequest().sizeDynamicPathParameters(); ++j) {
                    par = op.getRequest().getDynamicPathParameter(j);
                    if (par.getName() == null) {
                        throw new ProcessingException(pRequest + "Name undefined in dynamic path parameter (position '" + j + "')");
                    }
                    if (par.getApiParameterSchema() != null && par.getApiParameterSchema().isDefined()) continue;
                    throw new ProcessingException(pRequest + "Type undefined in dynamic path parameter '" + par.getName() + "'");
                }
                for (j = 0; j < op.getRequest().sizeFormParameters(); ++j) {
                    par = op.getRequest().getFormParameter(j);
                    if (par.getName() == null) {
                        throw new ProcessingException(pRequest + "Name undefined in form parameter (position '" + j + "')");
                    }
                    if (par.getApiParameterSchema() != null && par.getApiParameterSchema().isDefined()) continue;
                    throw new ProcessingException(pRequest + "Type undefined in form parameter '" + par.getName() + "'");
                }
                for (j = 0; j < op.getRequest().sizeHeaderParameters(); ++j) {
                    par = op.getRequest().getHeaderParameter(j);
                    if (par.getName() == null) {
                        throw new ProcessingException(pRequest + "Name undefined in header parameter (position '" + j + "')");
                    }
                    if (par.getApiParameterSchema() != null && par.getApiParameterSchema().isDefined()) continue;
                    throw new ProcessingException(pRequest + "Type undefined in header parameter '" + par.getName() + "'");
                }
                for (j = 0; j < op.getRequest().sizeQueryParameters(); ++j) {
                    par = op.getRequest().getQueryParameter(j);
                    if (par.getName() == null) {
                        throw new ProcessingException(pRequest + "Name undefined in query parameter (position '" + j + "')");
                    }
                    if (par.getApiParameterSchema() != null && par.getApiParameterSchema().isDefined()) continue;
                    throw new ProcessingException(pRequest + "Type undefined in query parameter '" + par.getName() + "'");
                }
            }
            boolean defaultResponse = false;
            for (int k = 0; k < op.sizeResponses(); ++k) {
                AbstractApiTypeParameter par;
                int j;
                String pResponse = prefix + "[response '" + k + "'] ";
                ApiResponse response = op.getResponse(k);
                if (response.isDefaultHttpReturnCode()) {
                    if (defaultResponse) {
                        throw new ProcessingException(pResponse + "Http Return Code Default already defined");
                    }
                    defaultResponse = true;
                }
                if (response.getHttpReturnCode() <= 0 && !response.isDefaultHttpReturnCode()) {
                    throw new ProcessingException(pResponse + "Http Return Code undefined");
                }
                pResponse = response.isDefaultHttpReturnCode() ? prefix + "[response status 'default'] " : prefix + "[response status '" + response.getHttpReturnCode() + "'] ";
                for (j = 0; j < response.sizeBodyParameters(); ++j) {
                    ApiBodyParameter bodyParm = response.getBodyParameter(j);
                    if (bodyParm.getMediaType() == null) {
                        throw new ProcessingException(pResponse + "MediaType undefined in body parameter (position '" + j + "')");
                    }
                    if (!validateBodyParameterElement || bodyParm.getElement() != null) continue;
                    throw new ProcessingException(pResponse + "Element undefined in body parameter '" + bodyParm.getMediaType() + "'");
                }
                for (j = 0; j < response.sizeCookieParameters(); ++j) {
                    par = response.getCookieParameter(j);
                    if (par.getName() == null) {
                        throw new ProcessingException(pResponse + "Name undefined in cookie parameter (position '" + j + "')");
                    }
                    if (par.getApiParameterSchema() != null && par.getApiParameterSchema().isDefined()) continue;
                    throw new ProcessingException(pResponse + "Type undefined in cookie parameter '" + par.getName() + "'");
                }
                for (j = 0; j < response.sizeHeaderParameters(); ++j) {
                    par = response.getHeaderParameter(j);
                    if (par.getName() == null) {
                        throw new ProcessingException(pResponse + "Name undefined in header parameter (position '" + j + "')");
                    }
                    if (par.getApiParameterSchema() != null && par.getApiParameterSchema().isDefined()) continue;
                    throw new ProcessingException(pResponse + "Type undefined in header parameter '" + par.getName() + "'");
                }
            }
        }
    }
}

