/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.rest.ApiParameterType;
import org.openspcoop2.utils.rest.ProcessingException;
import org.openspcoop2.utils.rest.ValidatorException;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiBodyParameter;
import org.openspcoop2.utils.rest.api.ApiCookieParameter;
import org.openspcoop2.utils.rest.api.ApiHeaderParameter;
import org.openspcoop2.utils.rest.api.ApiOperation;
import org.openspcoop2.utils.rest.api.ApiParameterSchema;
import org.openspcoop2.utils.rest.api.ApiParameterSchemaComplexType;
import org.openspcoop2.utils.rest.api.ApiParameterTypeSchema;
import org.openspcoop2.utils.rest.api.ApiRequestDynamicPathParameter;
import org.openspcoop2.utils.rest.api.ApiRequestFormParameter;
import org.openspcoop2.utils.rest.api.ApiRequestQueryParameter;
import org.openspcoop2.utils.rest.api.ApiResponse;
import org.openspcoop2.utils.rest.api.ApiSchemaTypeRestriction;
import org.openspcoop2.utils.rest.api.ApiUtilities;
import org.openspcoop2.utils.rest.entity.Cookie;
import org.openspcoop2.utils.rest.entity.HttpBaseEntity;
import org.openspcoop2.utils.rest.entity.HttpBaseRequestEntity;
import org.openspcoop2.utils.rest.entity.HttpBaseResponseEntity;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.springframework.web.util.UriUtils;

public abstract class AbstractApiValidator {
    public abstract void validatePreConformanceCheck(HttpBaseEntity<?> var1, ApiOperation var2, Object ... var3) throws ProcessingException, ValidatorException;

    public abstract void validatePostConformanceCheck(HttpBaseEntity<?> var1, ApiOperation var2, Object ... var3) throws ProcessingException, ValidatorException;

    public abstract void validateValueAsType(ApiParameterType var1, String var2, String var3, ApiSchemaTypeRestriction var4) throws ProcessingException, ValidatorException;

    public void validate(Api api, HttpBaseEntity<?> httpEntity, Object ... args) throws ProcessingException, ValidatorException {
        ApiOperation operation = api.findOperation(httpEntity.getMethod(), httpEntity.getUrl());
        if (operation == null) {
            throw new ProcessingException("Resource " + String.valueOf(httpEntity.getMethod()) + " '" + httpEntity.getUrl() + "' not found");
        }
        this.validatePreConformanceCheck(httpEntity, operation, args);
        this.validateConformanceCheck(httpEntity, operation, api.getBaseURL());
        this.validatePostConformanceCheck(httpEntity, operation, args);
    }

    /*
     * WARNING - void declaration
     */
    private void validateConformanceCheck(HttpBaseEntity<?> httpEntity, ApiOperation operation, URL baseUrl) throws ProcessingException, ValidatorException {
        try {
            if (httpEntity.getContentType() != null) {
                String baseTypeHttp = ContentTypeUtilities.readBaseTypeFromContentType(httpEntity.getContentType());
                boolean contentTypeSupported = false;
                List<ApiBodyParameter> requestBodyParametersList = null;
                List<ApiResponse> responses = null;
                if (operation.getRequest() != null && operation.getRequest().sizeBodyParameters() > 0) {
                    requestBodyParametersList = operation.getRequest().getBodyParameters();
                }
                if (operation.sizeResponses() > 0) {
                    responses = operation.getResponses();
                }
                int status = -1;
                if (httpEntity instanceof HttpBaseRequestEntity) {
                    if (requestBodyParametersList != null) {
                        for (ApiBodyParameter apiBodyParameter : requestBodyParametersList) {
                            if (!apiBodyParameter.isAllMediaType() && !ContentTypeUtilities.isMatch(null, baseTypeHttp, apiBodyParameter.getMediaType())) continue;
                            contentTypeSupported = true;
                            break;
                        }
                    }
                } else if (httpEntity instanceof HttpBaseResponseEntity) {
                    status = ((HttpBaseResponseEntity)httpEntity).getStatus();
                    if (responses != null) {
                        boolean bl;
                        Object outputDefault = null;
                        boolean bl2 = false;
                        block7: for (ApiResponse output : responses) {
                            if (status == output.getHttpReturnCode()) {
                                bl = true;
                                if (output.sizeBodyParameters() <= 0) continue;
                                for (ApiBodyParameter outputBodyParameter : output.getBodyParameters()) {
                                    if (!outputBodyParameter.isAllMediaType() && !ContentTypeUtilities.isMatch(null, baseTypeHttp, outputBodyParameter.getMediaType())) continue;
                                    contentTypeSupported = true;
                                    continue block7;
                                }
                                continue;
                            }
                            if (!output.isDefaultHttpReturnCode()) continue;
                            outputDefault = output;
                        }
                        if (!contentTypeSupported && !bl && outputDefault != null && ((ApiResponse)outputDefault).sizeBodyParameters() > 0) {
                            for (ApiBodyParameter outputBodyParameter : ((ApiResponse)outputDefault).getBodyParameters()) {
                                if (!outputBodyParameter.isAllMediaType() && !ContentTypeUtilities.isMatch(null, baseTypeHttp, outputBodyParameter.getMediaType())) continue;
                                contentTypeSupported = true;
                                break;
                            }
                        }
                    }
                }
                if (!contentTypeSupported) {
                    if (status > 0) {
                        throw new ValidatorException("Content-Type '" + baseTypeHttp + "' (http response status '" + status + "') unsupported");
                    }
                    throw new ValidatorException("Content-Type '" + baseTypeHttp + "' unsupported");
                }
            } else if (httpEntity instanceof HttpBaseRequestEntity && operation.getRequest() != null && operation.getRequest().sizeBodyParameters() > 0) {
                boolean required = false;
                for (ApiBodyParameter input : operation.getRequest().getBodyParameters()) {
                    if (!input.isRequired()) continue;
                    required = true;
                }
                if (required) {
                    throw new ValidatorException("Request without payload (Content-Type 'null') unsupported");
                }
            }
            if (httpEntity instanceof HttpBaseRequestEntity) {
                String name;
                HttpBaseRequestEntity request = (HttpBaseRequestEntity)httpEntity;
                if (operation.getRequest() != null && operation.getRequest().sizeHeaderParameters() > 0) {
                    for (ApiHeaderParameter paramHeader : operation.getRequest().getHeaderParameters()) {
                        name = paramHeader.getName();
                        List<String> values = TransportUtils.getRawObject(request.getHeaders(), name);
                        if (values == null || values.isEmpty()) {
                            if (!paramHeader.isRequired()) continue;
                            throw new ValidatorException("Required http header '" + name + "' not found");
                        }
                        for (String string : values) {
                            if (string == null) continue;
                            this.validate(paramHeader.getApiParameterSchema(), ApiParameterType.header, name, string, "http header");
                        }
                    }
                }
                if (operation.getRequest() != null && operation.getRequest().sizeCookieParameters() > 0) {
                    for (ApiCookieParameter paramCookie : operation.getRequest().getCookieParameters()) {
                        name = paramCookie.getName();
                        String value = null;
                        if (request.getCookies() != null) {
                            for (Cookie cookie : request.getCookies()) {
                                if (!name.equalsIgnoreCase(cookie.getName())) continue;
                                value = cookie.getValue();
                            }
                        }
                        if (value == null && paramCookie.isRequired()) {
                            throw new ValidatorException("Required Cookie '" + name + "' not found");
                        }
                        if (value == null) continue;
                        this.validate(paramCookie.getApiParameterSchema(), ApiParameterType.cookie, name, value, "cookie");
                    }
                }
                if (operation.getRequest() != null && operation.getRequest().sizeQueryParameters() > 0) {
                    for (ApiRequestQueryParameter paramQuery : operation.getRequest().getQueryParameters()) {
                        boolean parametriEsplosi = false;
                        if (paramQuery.getApiParameterSchema() != null && paramQuery.getApiParameterSchema().getSchemas() != null && !paramQuery.getApiParameterSchema().getSchemas().isEmpty()) {
                            for (ApiParameterTypeSchema schema : paramQuery.getApiParameterSchema().getSchemas()) {
                                if (schema.getSchema() == null || !schema.getSchema().isTypeObject() || (!schema.getSchema().isStyleQueryForm() || !schema.getSchema().isExplodeEnabled()) && !schema.getSchema().isStyleQueryDeepObject()) continue;
                                parametriEsplosi = true;
                                break;
                            }
                        }
                        if (parametriEsplosi) continue;
                        String name2 = paramQuery.getName();
                        List<String> values = TransportUtils.getRawObject(request.getParameters(), name2);
                        if (values == null || values.isEmpty()) {
                            if (!paramQuery.isRequired()) continue;
                            throw new ValidatorException("Required query parameter '" + name2 + "' not found");
                        }
                        for (String value : values) {
                            if (value == null) continue;
                            this.validate(paramQuery.getApiParameterSchema(), ApiParameterType.query, name2, value, "query parameter");
                        }
                    }
                }
                if (operation.getRequest() != null && operation.getRequest().sizeDynamicPathParameters() > 0) {
                    for (ApiRequestDynamicPathParameter paramDynamicPath : operation.getRequest().getDynamicPathParameters()) {
                        boolean find = false;
                        String valueFound = null;
                        if (operation.isDynamicPath()) {
                            for (int i = 0; i < operation.sizePath(); ++i) {
                                if (!operation.isDynamicPath()) continue;
                                String string = operation.getDynamicPathId(i);
                                if (!paramDynamicPath.getName().equals(string)) continue;
                                String[] urlList = ApiUtilities.extractUrlList(baseUrl, request.getUrl());
                                if (i >= urlList.length) {
                                    throw new ValidatorException("Dynamic path '" + paramDynamicPath.getName() + "' not found (position:" + i + ", urlLenght:" + urlList.length + ")");
                                }
                                find = true;
                                valueFound = urlList[i];
                                break;
                            }
                        }
                        if (!find && paramDynamicPath.isRequired()) {
                            throw new ValidatorException("Required dynamic path '" + paramDynamicPath.getName() + "' not found");
                        }
                        if (!find) continue;
                        String valueUrlDecoded = valueFound;
                        try {
                            valueUrlDecoded = UriUtils.decode(valueFound, (String)Charset.UTF_8.getValue());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.validate(paramDynamicPath.getApiParameterSchema(), ApiParameterType.path, paramDynamicPath.getName(), valueUrlDecoded, "dynamic path", valueUrlDecoded != null && !valueUrlDecoded.equals(valueFound) ? valueFound : null);
                    }
                }
                if (operation.getRequest() != null && operation.getRequest().sizeFormParameters() > 0) {
                    for (ApiRequestFormParameter paramForm : operation.getRequest().getFormParameters()) {
                        name = paramForm.getName();
                        List<String> values = TransportUtils.getRawObject(request.getParameters(), name);
                        if (values == null || values.isEmpty()) {
                            if (!paramForm.isRequired()) continue;
                            throw new ValidatorException("Required form parameter '" + name + "' not found");
                        }
                        for (String string : values) {
                            if (string == null) continue;
                            this.validate(paramForm.getApiParameterSchema(), ApiParameterType.form, name, string, "form parameter");
                        }
                    }
                }
            }
            if (httpEntity instanceof HttpBaseResponseEntity) {
                String name;
                HttpBaseResponseEntity response = (HttpBaseResponseEntity)httpEntity;
                ApiResponse apiResponseFound = null;
                ApiResponse apiResponseDefault = null;
                for (ApiResponse apiResponse : operation.getResponses()) {
                    if (apiResponse.isDefaultHttpReturnCode()) {
                        apiResponseDefault = apiResponse;
                    }
                    if (response.getStatus() != apiResponse.getHttpReturnCode()) continue;
                    apiResponseFound = apiResponse;
                    break;
                }
                if (apiResponseFound == null && apiResponseDefault != null) {
                    apiResponseFound = apiResponseDefault;
                }
                if (apiResponseFound == null) {
                    throw new ValidatorException("Http status code '" + response.getStatus() + "' unsupported");
                }
                if (apiResponseFound.sizeHeaderParameters() > 0) {
                    for (ApiHeaderParameter paramHeader : apiResponseFound.getHeaderParameters()) {
                        name = paramHeader.getName();
                        List<String> list = TransportUtils.getRawObject(response.getHeaders(), name);
                        if (list == null || list.isEmpty()) {
                            if (!paramHeader.isRequired()) continue;
                            throw new ValidatorException("Required http header '" + name + "' not found");
                        }
                        for (String value : list) {
                            if (value == null) continue;
                            this.validate(paramHeader.getApiParameterSchema(), ApiParameterType.header, name, value, "http header");
                        }
                    }
                }
                if (apiResponseFound.sizeCookieParameters() > 0) {
                    for (ApiCookieParameter paramCookie : apiResponseFound.getCookieParameters()) {
                        void var10_52;
                        name = paramCookie.getName();
                        Object var10_51 = null;
                        if (response.getCookies() != null) {
                            for (Cookie cookie : response.getCookies()) {
                                if (!name.equalsIgnoreCase(cookie.getName())) continue;
                                String string = cookie.getValue();
                            }
                        }
                        if (var10_52 == null && paramCookie.isRequired()) {
                            throw new ValidatorException("Required cookie '" + name + "' not found");
                        }
                        if (var10_52 == null) continue;
                        this.validate(paramCookie.getApiParameterSchema(), ApiParameterType.cookie, name, (String)var10_52, "cookie");
                    }
                }
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (ValidatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    private void validate(ApiParameterSchema apiParameterSchema, ApiParameterType type, String name, String value, String position) throws ValidatorException, ProcessingException {
        this.validate(apiParameterSchema, type, name, value, position, null);
    }

    private void validate(ApiParameterSchema apiParameterSchema, ApiParameterType type, String name, String value, String position, String valueUrlEncoded) throws ValidatorException, ProcessingException {
        if (apiParameterSchema != null && apiParameterSchema.getSchemas() != null && !apiParameterSchema.getSchemas().isEmpty()) {
            ApiParameterSchemaComplexType ct = apiParameterSchema.getComplexType();
            if (ct == null) {
                ct = ApiParameterSchemaComplexType.simple;
            }
            String prefixError = "Invalid value '" + value + "' in " + position + " '" + name + "'";
            if (valueUrlEncoded != null) {
                prefixError = "Invalid value '" + value + "' (urlEncoded: '" + valueUrlEncoded + "') in " + position + " '" + name + "'";
            }
            switch (ct) {
                case simple: 
                case allOf: {
                    StringBuilder sbException = new StringBuilder();
                    ArrayList<ValidatorException> listValidatorException = new ArrayList<ValidatorException>();
                    for (ApiParameterTypeSchema schema : apiParameterSchema.getSchemas()) {
                        try {
                            this.validateValueAsType(type, value, schema.getType(), schema.getSchema());
                        }
                        catch (ValidatorException val) {
                            String msgError = prefixError + " (expected type '" + schema.getType() + "'): " + val.getMessage();
                            if (sbException.length() > 0) {
                                sbException.append("\n");
                            }
                            sbException.append(msgError);
                            listValidatorException.add(new ValidatorException(msgError, val));
                        }
                    }
                    if (!listValidatorException.isEmpty()) {
                        UtilsMultiException multi = new UtilsMultiException(listValidatorException.toArray(new ValidatorException[1]));
                        throw new ValidatorException(sbException.toString(), multi);
                    }
                    return;
                }
                case anyOf: {
                    StringBuilder sbException = new StringBuilder();
                    ArrayList<ValidatorException> listValidatorException = new ArrayList<ValidatorException>();
                    for (ApiParameterTypeSchema schema : apiParameterSchema.getSchemas()) {
                        try {
                            this.validateValueAsType(type, value, schema.getType(), schema.getSchema());
                            return;
                        }
                        catch (ValidatorException val) {
                            String msgError = prefixError + " (expected type '" + schema.getType() + "'): " + val.getMessage();
                            if (sbException.length() > 0) {
                                sbException.append("\n");
                            }
                            sbException.append(msgError);
                            listValidatorException.add(new ValidatorException(msgError, val));
                        }
                    }
                    if (!listValidatorException.isEmpty()) {
                        UtilsMultiException multi = new UtilsMultiException(listValidatorException.toArray(new ValidatorException[1]));
                        throw new ValidatorException(sbException.toString(), multi);
                    }
                    return;
                }
                case oneOf: {
                    StringBuilder sbException = new StringBuilder();
                    ArrayList<ValidatorException> listValidatorException = new ArrayList<ValidatorException>();
                    int schemiValidi = 0;
                    for (ApiParameterTypeSchema schema : apiParameterSchema.getSchemas()) {
                        try {
                            this.validateValueAsType(type, value, schema.getType(), schema.getSchema());
                            ++schemiValidi;
                        }
                        catch (ValidatorException val) {
                            String msgError = prefixError + " (expected type '" + schema.getType() + "'): " + val.getMessage();
                            if (sbException.length() > 0) {
                                sbException.append("\n");
                            }
                            sbException.append(msgError);
                            listValidatorException.add(new ValidatorException(msgError, val));
                        }
                    }
                    if (schemiValidi == 0) {
                        if (!listValidatorException.isEmpty()) {
                            UtilsMultiException multi = new UtilsMultiException(listValidatorException.toArray(new ValidatorException[1]));
                            throw new ValidatorException(sbException.toString(), multi);
                        }
                        throw new ValidatorException(prefixError);
                    }
                    if (schemiValidi > 1) {
                        throw new ValidatorException(prefixError + ": expected validates the value against exactly one of the subschemas; founded valid in " + schemiValidi + " schemas");
                    }
                    return;
                }
            }
        }
    }
}

