/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.parser.ParseException;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.VelocityTemplateLoader;

public class VelocityTemplateUtils {
    public static VelocityEngine newTemplateEngine() {
        VelocityEngine engine = new VelocityEngine();
        engine.init();
        return engine;
    }

    public static VelocityEngine newTemplateEngine(String propsFileName) {
        VelocityEngine engine = new VelocityEngine();
        engine.init(propsFileName);
        return engine;
    }

    public static VelocityEngine newTemplateEngine(Properties p) {
        VelocityEngine engine = new VelocityEngine();
        engine.init(p);
        return engine;
    }

    public static Template getTemplate(VelocityEngine engine, String templateName) throws IOException {
        return engine.getTemplate(templateName);
    }

    public static Template getTemplate(VelocityEngine engine, String templateName, String encoding) throws IOException {
        return engine.getTemplate(templateName, encoding);
    }

    public static Template buildTemplate(String name, byte[] bytes) throws IOException, ParseException {
        return VelocityTemplateUtils.buildTemplate(name, bytes, Charset.UTF_8.getValue(), null);
    }

    public static Template buildTemplate(String name, byte[] bytes, String encoding) throws IOException, ParseException {
        return VelocityTemplateUtils.buildTemplate(name, bytes, encoding, null);
    }

    public static Template buildTemplate(String name, byte[] bytes, Map<String, byte[]> templateIncludes) throws IOException, ParseException {
        return VelocityTemplateUtils.buildTemplate(name, bytes, Charset.UTF_8.getValue(), templateIncludes);
    }

    public static Template buildTemplate(String name, byte[] bytes, String encoding, Map<String, byte[]> templateIncludes) throws IOException, ParseException {
        RuntimeInstance instance = new RuntimeInstance();
        String defaultTemplate = "_____DEFAULT_TEMPLATE___";
        if (templateIncludes == null) {
            templateIncludes = new HashMap<String, byte[]>();
        }
        VelocityTemplateLoader loader = new VelocityTemplateLoader(templateIncludes);
        templateIncludes.put(defaultTemplate, bytes);
        instance.setProperty("resource.loader", (Object)"govway_rl");
        instance.setProperty("govway_rl.resource.loader.instance", (Object)loader);
        instance.init();
        Template template = instance.getTemplate(defaultTemplate, encoding);
        return template;
    }

    public static VelocityContext toVelocityContext(Map<String, Object> map) {
        VelocityContext context = new VelocityContext(map);
        return context;
    }

    public static byte[] toByteArray(Template template, Map<String, Object> map) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(bout);
        template.merge((Context)VelocityTemplateUtils.toVelocityContext(map), (Writer)writer);
        writer.flush();
        writer.close();
        bout.flush();
        bout.close();
        return bout.toByteArray();
    }

    public static String toString(Template template, Map<String, Object> map) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(bout);
        template.merge((Context)VelocityTemplateUtils.toVelocityContext(map), (Writer)writer);
        writer.flush();
        writer.close();
        bout.flush();
        bout.close();
        return bout.toString();
    }

    public static void writeFile(Template template, Map<String, Object> map, File file, boolean overwrite) throws Exception {
        if (!overwrite && file.exists()) {
            System.out.println(": WARNING !! File [" + file.getAbsolutePath() + "] is already exist, it is not overwritten !!");
            return;
        }
        FileSystemUtilities.mkdirParentDirectory(file);
        FileSystemUtilities.writeFile(file, VelocityTemplateUtils.toByteArray(template, map));
    }
}

