/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class CharsetUtilities {
    public static void main(String[] args) throws Exception {
        System.out.println("defaultCharacterEncoding by property: " + CharsetUtilities.getDefaultCharsetByProperties());
        System.out.println("defaultCharacterEncoding by code: " + CharsetUtilities.getDefaultCharsetByCode());
        System.out.println("defaultCharacterEncoding by charSet: " + CharsetUtilities.getDefaultCharsetByCharset());
        System.setProperty("file.encoding", "ISO-8859-1");
        System.out.println("defaultCharacterEncoding by property: " + CharsetUtilities.getDefaultCharsetByProperties());
        System.out.println("defaultCharacterEncoding by code: " + CharsetUtilities.getDefaultCharsetByCode());
        System.out.println("defaultCharacterEncoding by charSet: " + CharsetUtilities.getDefaultCharsetByCharset());
    }

    public static String getDefaultCharsetByProperties() {
        String defaultCharacterEncoding = System.getProperty("file.encoding");
        return defaultCharacterEncoding;
    }

    public static String getDefaultCharsetByCode() throws IOException {
        byte[] bArray = new byte[]{119};
        try (ByteArrayInputStream is = new ByteArrayInputStream(bArray);){
            String string;
            try (InputStreamReader reader = new InputStreamReader(is);){
                String defaultCharacterEncoding;
                string = defaultCharacterEncoding = reader.getEncoding();
            }
            return string;
        }
    }

    public static String getDefaultCharsetByCharset() {
        return Charset.defaultCharset().toString();
    }
}

