/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import org.openspcoop2.utils.Utilities;

public abstract class AbstractBaseThread
extends Thread {
    private boolean stop = false;
    private int timeout = 10;
    private boolean finished = false;

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public void finished() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void waitShutdown() {
        this.waitShutdown(200, 60000);
    }

    public void waitShutdown(int checkMs, int maxMs) {
        for (int msWait = 0; !this.finished && msWait < maxMs; msWait += checkMs) {
            Utilities.sleep(checkMs);
        }
    }

    public void sleepForNextCheck(int maxLimitSleepCount, int sleepMs) {
        if (!this.stop) {
            for (int i = 0; i < maxLimitSleepCount; ++i) {
                Utilities.sleep(sleepMs);
                if (this.isStop()) break;
            }
        }
    }

    protected boolean initialize() {
        return true;
    }

    protected abstract void process();

    protected void close() {
    }

    @Override
    public void run() {
        try {
            if (!this.initialize()) {
                return;
            }
            while (!this.isStop()) {
                this.process();
                this.sleepForNextCheck(this.timeout, 1000);
            }
        }
        finally {
            this.finished();
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

