/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.regexp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

public class RegExpUtilities {
    private static final String oneAlpha = "(.)*((\\p{Alpha})|[-])(.)*";
    private static final String domainIdentifier = "((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})";
    private static final String domainNameRule = "(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum}))((\\.)(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})))*";

    public static boolean isDefinedByVariable(String value) {
        return value != null && value.contains("{") && value.contains("}");
    }

    public static boolean isUrlDefinedByVariable(String url) throws MalformedURLException {
        return RegExpUtilities.isDefinedByVariable(url);
    }

    public static void validateUrl(String url) throws MalformedURLException, URISyntaxException {
        RegExpUtilities.validateUrl(url, false);
    }

    public static void validateUrl(String url, boolean skipCheckUrlDefinedByVariable) throws MalformedURLException, URISyntaxException {
        boolean urlDefinedByVariable = RegExpUtilities.isUrlDefinedByVariable(url);
        if (!urlDefinedByVariable || !skipCheckUrlDefinedByVariable) {
            URL testUrl = new URI(url).toURL();
            testUrl.toString();
        }
    }

    public static void validateUri(String uri) throws UtilsException, MalformedURLException, URISyntaxException {
        RegExpUtilities.validateUri(uri, false);
    }

    public static void validateUri(String uri, boolean skipCheckUrlDefinedByVariable) throws UtilsException, MalformedURLException, URISyntaxException {
        if (uri.startsWith("http://") || uri.startsWith("file://")) {
            RegExpUtilities.validateUrl(uri);
        } else {
            File f = new File(uri);
            f.getAbsolutePath();
        }
    }

    public static boolean validateDomainName(String domainName) {
        if (domainName == null || domainName.length() > 63) {
            return false;
        }
        return domainName.matches(domainNameRule) && domainName.matches(oneAlpha);
    }

    public static boolean isIPOrHostname(String stringToCheck) {
        boolean ok = true;
        try {
            if (!RegularExpressionEngine.isMatch(stringToCheck, "^[0-9]+.[0-9]+.[0-9]+.[0-9]+$") && !RegExpUtilities.validateDomainName(stringToCheck)) {
                ok = false;
            }
        }
        catch (Exception e) {
            Date now = new Date();
            System.err.println(String.valueOf(now) + " Exception " + e.getMessage());
        }
        return ok;
    }
}

