/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.pdf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDXFAResource;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.mime.MimeTypes;
import org.openspcoop2.utils.pdf.AbstractPDFCore;
import org.openspcoop2.utils.pdf.XFADocument;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class PDFWriter
extends AbstractPDFCore {
    private static final String CONTENT_UNDEFINED = "content undefined";
    private static final String FILENAME_UNDEFINED = "fileName undefined";

    public static void writeTo(PDDocument doc, OutputStream os) throws UtilsException {
        PDFWriter writer = new PDFWriter(doc);
        writer.writeTo(os);
    }

    public static void writeTo(PDDocument doc, File file) throws UtilsException {
        PDFWriter writer = new PDFWriter(doc);
        writer.writeTo(file);
    }

    public PDFWriter(PDDocument doc) throws UtilsException {
        super(doc);
    }

    public PDFWriter(byte[] content) throws UtilsException {
        super(content, false);
    }

    public PDFWriter(File doc) throws UtilsException {
        super(doc, false);
    }

    public PDFWriter(InputStream is) throws UtilsException {
        super(is, false);
    }

    private void checkFile(File file) throws UtilsException {
        if (file == null) {
            throw new UtilsException("File undefined");
        }
    }

    public void writeTo(OutputStream os) throws UtilsException {
        if (os == null) {
            throw new UtilsException("OutputStream undefined");
        }
        try {
            this.document.save(os);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void writeTo(File file) throws UtilsException {
        if (file == null) {
            throw new UtilsException("OutputFile undefined");
        }
        try {
            this.document.save(file);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addEmbeddedFile(File file) throws UtilsException {
        this.addEmbeddedFile(file, null);
    }

    public void addEmbeddedFile(File file, String mediaType) throws UtilsException {
        this.checkFile(file);
        try (FileInputStream fin = new FileInputStream(file);){
            this.addEmbeddedFile(file.getName(), fin, (int)file.length(), mediaType);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addEmbeddedFile(String fileName, byte[] content) throws UtilsException {
        this.addEmbeddedFile(fileName, content, null);
    }

    public void addEmbeddedFile(String fileName, byte[] content, String mediaType) throws UtilsException {
        if (content == null) {
            throw new UtilsException(CONTENT_UNDEFINED);
        }
        try (ByteArrayInputStream bin = new ByteArrayInputStream(content);){
            this.addEmbeddedFile(fileName, bin, content.length, mediaType);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addEmbeddedFile(String fileName, InputStream content) throws UtilsException {
        this.addEmbeddedFile(fileName, content, -1);
    }

    public void addEmbeddedFile(String fileName, InputStream content, int size) throws UtilsException {
        this.addEmbeddedFile(fileName, content, size, null);
    }

    public void addEmbeddedFile(String fileName, InputStream content, String mediaType) throws UtilsException {
        this.addEmbeddedFile(fileName, content, -1, mediaType);
    }

    public void addEmbeddedFile(String fileName, InputStream content, int size, String mediaType) throws UtilsException {
        if (fileName == null) {
            throw new UtilsException(FILENAME_UNDEFINED);
        }
        if (content == null) {
            throw new UtilsException(CONTENT_UNDEFINED);
        }
        try {
            PDEmbeddedFilesNameTreeNode efTree;
            if (mediaType == null) {
                mediaType = MimeTypes.getInstance().getMimeType(new File(fileName));
            }
            this.checkDocumentCatalog();
            PDDocumentNameDictionary names = this.document.getDocumentCatalog().getNames();
            if (names == null) {
                names = new PDDocumentNameDictionary(this.document.getDocumentCatalog());
                this.document.getDocumentCatalog().setNames(names);
            }
            if ((efTree = names.getEmbeddedFiles()) == null) {
                efTree = new PDEmbeddedFilesNameTreeNode();
                names.setEmbeddedFiles(efTree);
            }
            PDComplexFileSpecification fs = new PDComplexFileSpecification();
            fs.setFile(fileName);
            PDEmbeddedFile ef = new PDEmbeddedFile(this.document, content);
            ef.setSubtype(mediaType);
            if (size > 0) {
                ef.setSize(size);
            }
            ef.setCreationDate((Calendar)new GregorianCalendar());
            fs.setEmbeddedFile(ef);
            Map efMapOrig = efTree.getNames();
            HashMap<String, PDComplexFileSpecification> efMap = new HashMap<String, PDComplexFileSpecification>();
            if (efMapOrig != null && !efMapOrig.isEmpty()) {
                for (Map.Entry entry : efMapOrig.entrySet()) {
                    String fName = (String)entry.getKey();
                    PDComplexFileSpecification orig = (PDComplexFileSpecification)entry.getValue();
                    efMap.put(fName, orig);
                }
            }
            efMap.put(fileName, fs);
            efTree.setNames(efMap);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addEmbeddedFileAsKid(File file) throws UtilsException {
        this.addEmbeddedFileAsKid(file, null);
    }

    public void addEmbeddedFileAsKid(File file, String mediaType) throws UtilsException {
        this.checkFile(file);
        try (FileInputStream fin = new FileInputStream(file);){
            this.addEmbeddedFileAsKid(file.getName(), fin, (int)file.length(), mediaType);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addEmbeddedFileAsKid(String fileName, byte[] content) throws UtilsException {
        this.addEmbeddedFileAsKid(fileName, content, null);
    }

    public void addEmbeddedFileAsKid(String fileName, byte[] content, String mediaType) throws UtilsException {
        if (content == null) {
            throw new UtilsException(CONTENT_UNDEFINED);
        }
        try (ByteArrayInputStream bin = new ByteArrayInputStream(content);){
            this.addEmbeddedFileAsKid(fileName, bin, content.length, mediaType);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addEmbeddedFileAsKid(String fileName, InputStream content) throws UtilsException {
        this.addEmbeddedFileAsKid(fileName, content, -1);
    }

    public void addEmbeddedFileAsKid(String fileName, InputStream content, int size) throws UtilsException {
        this.addEmbeddedFileAsKid(fileName, content, size, null);
    }

    public void addEmbeddedFileAsKid(String fileName, InputStream content, String mediaType) throws UtilsException {
        this.addEmbeddedFileAsKid(fileName, content, -1, mediaType);
    }

    public void addEmbeddedFileAsKid(String fileName, InputStream content, int size, String mediaType) throws UtilsException {
        if (fileName == null) {
            throw new UtilsException(FILENAME_UNDEFINED);
        }
        if (content == null) {
            throw new UtilsException(CONTENT_UNDEFINED);
        }
        try {
            PDEmbeddedFilesNameTreeNode efTree;
            if (mediaType == null) {
                mediaType = MimeTypes.getInstance().getMimeType(new File(fileName));
            }
            this.checkDocumentCatalog();
            PDDocumentNameDictionary names = this.document.getDocumentCatalog().getNames();
            if (names == null) {
                names = new PDDocumentNameDictionary(this.document.getDocumentCatalog());
                this.document.getDocumentCatalog().setNames(names);
            }
            if ((efTree = names.getEmbeddedFiles()) == null) {
                efTree = new PDEmbeddedFilesNameTreeNode();
                names.setEmbeddedFiles(efTree);
            }
            ArrayList<PDEmbeddedFilesNameTreeNode> kids = efTree.getKids();
            boolean kidsEmpty = false;
            if (kids == null) {
                kids = new ArrayList<PDEmbeddedFilesNameTreeNode>();
                kidsEmpty = true;
            }
            PDComplexFileSpecification fs = new PDComplexFileSpecification();
            fs.setFile(fileName);
            PDEmbeddedFile ef = new PDEmbeddedFile(this.document, content);
            ef.setSubtype(mediaType);
            if (size > 0) {
                ef.setSize(size);
            }
            ef.setCreationDate((Calendar)new GregorianCalendar());
            fs.setEmbeddedFile(ef);
            PDEmbeddedFilesNameTreeNode pdNameTreeeNodeKids = new PDEmbeddedFilesNameTreeNode();
            HashMap<String, PDComplexFileSpecification> efMap = new HashMap<String, PDComplexFileSpecification>();
            efMap.put(fileName, fs);
            pdNameTreeeNodeKids.setNames(efMap);
            kids.add(pdNameTreeeNodeKids);
            if (kidsEmpty) {
                efTree.setKids(kids);
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addAnnotationFile(File file) throws UtilsException {
        this.addAnnotationFile(file, null);
    }

    public void addAnnotationFile(File file, String mediaType) throws UtilsException {
        this.checkFile(file);
        try (FileInputStream fin = new FileInputStream(file);){
            this.addAnnotationFile(file.getName(), fin, (int)file.length(), mediaType);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addAnnotationFile(String fileName, byte[] content) throws UtilsException {
        this.addAnnotationFile(fileName, content, null);
    }

    public void addAnnotationFile(String fileName, byte[] content, String mediaType) throws UtilsException {
        if (content == null) {
            throw new UtilsException(CONTENT_UNDEFINED);
        }
        try (ByteArrayInputStream bin = new ByteArrayInputStream(content);){
            this.addAnnotationFile(fileName, bin, content.length, mediaType);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addAnnotationFile(String fileName, InputStream content) throws UtilsException {
        this.addAnnotationFile(fileName, content, -1);
    }

    public void addAnnotationFile(String fileName, InputStream content, int size) throws UtilsException {
        this.addAnnotationFile(fileName, content, size, null);
    }

    public void addAnnotationFile(String fileName, InputStream content, String mediaType) throws UtilsException {
        this.addAnnotationFile(fileName, content, -1, mediaType);
    }

    public void addAnnotationFile(String fileName, InputStream content, int size, String mediaType) throws UtilsException {
        if (fileName == null) {
            throw new UtilsException(FILENAME_UNDEFINED);
        }
        if (content == null) {
            throw new UtilsException(CONTENT_UNDEFINED);
        }
        try {
            if (mediaType == null) {
                mediaType = MimeTypes.getInstance().getMimeType(new File(fileName));
            }
            this.checkDocumentCatalog();
            if (this.document.getPages() == null || this.document.getNumberOfPages() <= 0) {
                throw new UtilsException("DocumentPage not found");
            }
            PDPage page = this.document.getPage(0);
            if (page == null) {
                throw new UtilsException("FirstDocumentPage undefined");
            }
            ArrayList<PDAnnotationFileAttachment> annotations = page.getAnnotations();
            if (annotations == null) {
                annotations = new ArrayList<PDAnnotationFileAttachment>();
            }
            PDComplexFileSpecification fs = new PDComplexFileSpecification();
            fs.setFile(fileName);
            PDEmbeddedFile ef = new PDEmbeddedFile(this.document, content);
            ef.setSubtype(mediaType);
            if (size > 0) {
                ef.setSize(size);
            }
            ef.setCreationDate((Calendar)new GregorianCalendar());
            fs.setEmbeddedFile(ef);
            PDAnnotationFileAttachment fa = new PDAnnotationFileAttachment();
            fa.setFile((PDFileSpecification)fs);
            annotations.add(fa);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void setXFAFile(File file, boolean addXfaDatasets) throws UtilsException {
        byte[] content = null;
        try {
            content = FileSystemUtilities.readBytesFromFile(file);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        this.setXFAFile(content, addXfaDatasets);
    }

    public void setXFAFile(InputStream content, boolean addXfaDatasets) throws UtilsException {
        this.setXFAFile(Utilities.getAsByteArray(content), addXfaDatasets);
    }

    public void setXFAFile(byte[] content, boolean addXfaDatasets) throws UtilsException {
        if (content == null) {
            throw new UtilsException(CONTENT_UNDEFINED);
        }
        try {
            this.checkDocumentCatalog();
            PDAcroForm pdAcroForm = this.document.getDocumentCatalog().getAcroForm();
            if (pdAcroForm == null) {
                pdAcroForm = new PDAcroForm(this.document);
                this.document.getDocumentCatalog().setAcroForm(pdAcroForm);
            }
            if (addXfaDatasets) {
                content = XFADocument.addXfaDatasets(content);
            }
            COSStream base = new COSStream();
            try (OutputStream os = base.createOutputStream();){
                os.write(content);
                os.flush();
            }
            PDXFAResource xfa = new PDXFAResource((COSBase)base);
            pdAcroForm.setXFA(xfa);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

