/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi.validator.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.text.StringEscapeUtils;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.v3.OpenApi3Validator;
import org.openapi4j.schema.validator.v3.FormatValidator;
import org.openapi4j.schema.validator.v3.ValidationOptions;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.mime.MimeMultipart;
import org.openspcoop2.utils.openapi.validator.MultipartUtilities;
import org.openspcoop2.utils.openapi.validator.OpenAPILibrary;
import org.openspcoop2.utils.openapi.validator.OpenapiApiValidatorConfig;
import org.openspcoop2.utils.openapi.validator.OpenapiLibraryValidatorConfig;
import org.openspcoop2.utils.rest.ApiFactory;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.ApiReaderConfig;
import org.openspcoop2.utils.rest.IApiReader;
import org.openspcoop2.utils.rest.IApiValidator;
import org.openspcoop2.utils.rest.ParseWarningException;
import org.openspcoop2.utils.rest.ProcessingException;
import org.openspcoop2.utils.rest.ValidatorException;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiOperation;
import org.openspcoop2.utils.rest.api.ApiSchema;
import org.openspcoop2.utils.rest.api.ApiSchemaType;
import org.openspcoop2.utils.rest.entity.BinaryHttpRequestEntity;
import org.openspcoop2.utils.rest.entity.BinaryHttpResponseEntity;
import org.openspcoop2.utils.rest.entity.Cookie;
import org.openspcoop2.utils.rest.entity.DocumentHttpResponseEntity;
import org.openspcoop2.utils.rest.entity.ElementHttpResponseEntity;
import org.openspcoop2.utils.rest.entity.HttpBaseRequestEntity;
import org.openspcoop2.utils.rest.entity.HttpBaseResponseEntity;
import org.openspcoop2.utils.rest.entity.InputStreamHttpRequestEntity;
import org.openspcoop2.utils.rest.entity.InputStreamHttpResponseEntity;
import org.openspcoop2.utils.rest.entity.TextHttpRequestEntity;
import org.openspcoop2.utils.rest.entity.TextHttpResponseEntity;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenApi3ExtendedTest {
    private static boolean logSystemOutError = true;
    private static boolean defaultDateTimeAllowLowerCaseTZ = false;
    private static boolean defaultDateTimeAllowSpaceSeparator = false;

    public static void main(String[] args) throws Exception {
        OpenAPILibrary openAPILibrary = OpenAPILibrary.openapi4j;
        if (args != null && args.length > 0) {
            openAPILibrary = OpenAPILibrary.valueOf(args[0]);
        }
        boolean mergeSpec = true;
        if (args != null && args.length > 1) {
            mergeSpec = Boolean.valueOf(args[1]);
        }
        logSystemOutError = !OpenAPILibrary.json_schema.equals(openAPILibrary);
        defaultDateTimeAllowLowerCaseTZ = DateUtils.isDateTimeAllowLowerCaseTZ();
        defaultDateTimeAllowSpaceSeparator = DateUtils.isDateTimeAllowSpaceSeparator();
        try {
            OpenApi3ExtendedTest.test(openAPILibrary, mergeSpec);
        }
        finally {
            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, defaultDateTimeAllowLowerCaseTZ, defaultDateTimeAllowSpaceSeparator);
        }
    }

    private static void setDateTimeOptions(OpenAPILibrary openAPILibrary, boolean allowLowerCaseTZ, boolean allowSpaceSeparator) {
        DateUtils.setDateTimeAllowLowerCaseTZ(allowLowerCaseTZ);
        DateUtils.setDateTimeAllowSpaceSeparator(allowSpaceSeparator);
        if (openAPILibrary == OpenAPILibrary.openapi4j) {
            FormatValidator.setDateTimeAllowLowerCaseTZ((boolean)allowLowerCaseTZ);
            FormatValidator.setDateTimeAllowSpaceSeparator((boolean)allowSpaceSeparator);
        }
        System.out.println("========== (case:" + allowLowerCaseTZ + " space:" + allowSpaceSeparator + ") DateUtils(case:" + DateUtils.isDateTimeAllowLowerCaseTZ() + " space:" + DateUtils.isDateTimeAllowSpaceSeparator() + ") FormatValidator(case:" + FormatValidator.isDateTimeAllowLowerCaseTZ() + " space:" + FormatValidator.isDateTimeAllowSpaceSeparator() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void test(OpenAPILibrary openAPILibrary, boolean mergeSpec) throws Exception {
        OpenapiApiValidatorConfig configO;
        IApiValidator apiValidatorOpenApi;
        Api apiOpenApi;
        ApiReaderConfig configOpenApi;
        IApiReader apiReaderOpenApi;
        URL url;
        block605: {
            block604: {
                System.out.println("Test Schema#1 (openapi.yaml) [Elementi aggiuntivi come 'allowEmptyValue'] ...");
                url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/openapi.yaml");
                apiReaderOpenApi = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
                configOpenApi = new ApiReaderConfig();
                configOpenApi.setProcessInclude(false);
                apiReaderOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi);
                apiOpenApi = apiReaderOpenApi.read();
                try {
                    apiOpenApi.validate();
                }
                catch (ProcessingException pe) {
                    pe.printStackTrace(System.out);
                    throw new Exception(" Documento contenente errori: " + pe.getMessage(), pe);
                }
                catch (ParseWarningException warning) {
                    System.out.println("Documento contenente anomalie: " + warning.getMessage());
                }
                apiValidatorOpenApi = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
                configO = new OpenapiApiValidatorConfig();
                configO.setEmitLogError(logSystemOutError);
                configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
                configO.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
                configO.getOpenApiValidatorConfig().setValidateAPISpec(true);
                configO.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
                apiValidatorOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi, configO);
                System.out.println("Test Schema#1 (openapi.yaml) [Elementi aggiuntivi come 'allowEmptyValue'] ok");
                System.out.println("Test Schema#2 (allegati.yaml) [Discriminator non presente o non required Step 1/2] ...");
                if (openAPILibrary == OpenAPILibrary.openapi4j) {
                    String msgErrore8;
                    String msgErrore7;
                    String msgErrore6;
                    String msgErrore5;
                    String msgErrore4;
                    String msgErrore3;
                    String msgErrore2;
                    String msgErrore1;
                    url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/parser.yaml");
                    apiReaderOpenApi = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
                    apiReaderOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi);
                    apiOpenApi = apiReaderOpenApi.read();
                    try {
                        apiOpenApi.validate();
                        throw new Exception("Atteso errore");
                    }
                    catch (ProcessingException e) {
                        msgErrore1 = "components.schemas.Pet.discriminator: The discriminator 'pet_type' is not a property of this schema (code: 134)";
                        if (!e.getMessage().contains(msgErrore1)) {
                            throw new Exception("Errore atteso '" + msgErrore1 + "' non rilevato", e);
                        }
                        msgErrore2 = "components.schemas.Pet.discriminator: The discriminator 'pet_type' is required in this schema (code: 135)";
                        if (!e.getMessage().contains(msgErrore2)) {
                            throw new Exception("Errore atteso '" + msgErrore2 + "' non rilevato", e);
                        }
                        msgErrore3 = "components.schemas.Pet2.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore3)) {
                            throw new Exception("Errore atteso '" + msgErrore3 + "' non rilevato", e);
                        }
                        msgErrore4 = "components.schemas.Pet3.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore4)) {
                            throw new Exception("Errore atteso '" + msgErrore4 + "' non rilevato", e);
                        }
                        msgErrore5 = "components.schemas.Pet5.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore5)) {
                            throw new Exception("Errore atteso '" + msgErrore5 + "' non rilevato", e);
                        }
                        msgErrore6 = "components.schemas.Pet6.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore6)) {
                            throw new Exception("Errore atteso '" + msgErrore6 + "' non rilevato", e);
                        }
                        msgErrore7 = "components.schemas.Pet7.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore7)) {
                            throw new Exception("Errore atteso '" + msgErrore7 + "' non rilevato", e);
                        }
                        msgErrore8 = "components.schemas.Pet8.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore8)) {
                            throw new Exception("Errore atteso '" + msgErrore8 + "' non rilevato", e);
                        }
                    }
                    catch (ParseWarningException warning) {
                        System.out.println("Documento contenente anomalie: " + warning.getMessage());
                    }
                    apiValidatorOpenApi = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
                    try {
                        apiValidatorOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi, configO);
                        throw new Exception("Atteso errore");
                    }
                    catch (Exception e) {
                        msgErrore1 = "components.schemas.Pet.discriminator: The discriminator 'pet_type' is not a property of this schema (code: 134)";
                        if (!e.getMessage().contains(msgErrore1)) {
                            throw new Exception("Errore atteso '" + msgErrore1 + "' non rilevato", e);
                        }
                        msgErrore2 = "components.schemas.Pet.discriminator: The discriminator 'pet_type' is required in this schema (code: 135)";
                        if (!e.getMessage().contains(msgErrore2)) {
                            throw new Exception("Errore atteso '" + msgErrore2 + "' non rilevato", e);
                        }
                        msgErrore3 = "components.schemas.Pet2.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore3)) {
                            throw new Exception("Errore atteso '" + msgErrore3 + "' non rilevato", e);
                        }
                        msgErrore4 = "components.schemas.Pet3.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore4)) {
                            throw new Exception("Errore atteso '" + msgErrore4 + "' non rilevato", e);
                        }
                        msgErrore5 = "components.schemas.Pet5.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore5)) {
                            throw new Exception("Errore atteso '" + msgErrore5 + "' non rilevato", e);
                        }
                        msgErrore6 = "components.schemas.Pet6.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore6)) {
                            throw new Exception("Errore atteso '" + msgErrore6 + "' non rilevato", e);
                        }
                        msgErrore7 = "components.schemas.Pet7.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore7)) {
                            throw new Exception("Errore atteso '" + msgErrore7 + "' non rilevato", e);
                        }
                        msgErrore8 = "components.schemas.Pet8.properties.pet.discriminator: The discriminator 'pet_type' is not required or not a property of the allOf schemas (code: 133)";
                        if (!e.getMessage().contains(msgErrore8)) {
                            throw new Exception("Errore atteso '" + msgErrore8 + "' non rilevato", e);
                        }
                        break block604;
                    }
                }
                System.out.println("Skipped test per libreria " + String.valueOf(openAPILibrary));
            }
            System.out.println("Test Schema#2 (allegati.yaml) [Discriminator non presente o non required Step 1/2] ok");
            System.out.println("Test Schema#3 (parser2.yaml) [Discriminator non presente o non required Step 2/2] ...");
            if (openAPILibrary == OpenAPILibrary.openapi4j) {
                String msgErrore;
                url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/parser2.yaml");
                apiReaderOpenApi = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
                apiReaderOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi);
                apiOpenApi = apiReaderOpenApi.read();
                try {
                    apiOpenApi.validate();
                    throw new Exception("Atteso errore");
                }
                catch (ProcessingException e) {
                    msgErrore = "components.schemas.Pet4.properties.pet.discriminator: The discriminator 'pet_type' is required in this schema (code: 135)";
                    if (!e.getMessage().contains(msgErrore)) {
                        throw new Exception("Errore atteso '" + msgErrore + "' non rilevato", e);
                    }
                }
                catch (ParseWarningException warning) {
                    System.out.println("Documento contenente anomalie: " + warning.getMessage());
                }
                apiValidatorOpenApi = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
                try {
                    apiValidatorOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi, configO);
                    throw new Exception("Atteso errore");
                }
                catch (Exception e) {
                    msgErrore = "components.schemas.Pet4.properties.pet.discriminator: The discriminator 'pet_type' is required in this schema (code: 135)";
                    if (!e.getMessage().contains(msgErrore)) {
                        throw new Exception("Errore atteso '" + msgErrore + "' non rilevato", e);
                    }
                    break block605;
                }
            }
            System.out.println("Skipped test per libreria " + String.valueOf(openAPILibrary));
        }
        System.out.println("Test Schema#3 (parser2.yaml) [Discriminator non presente o non required Step 2/2] ok");
        System.out.println("Test Schema#4 (default.yaml) [Valori default non coerenti con il tipo] ...");
        if (openAPILibrary == OpenAPILibrary.openapi4j) {
            url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/default.yaml");
            apiReaderOpenApi = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
            apiReaderOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi);
            apiOpenApi = apiReaderOpenApi.read();
            try {
                apiOpenApi.validate();
            }
            catch (ProcessingException pe) {
                pe.printStackTrace(System.out);
                throw new Exception(" Documento contenente errori: " + pe.getMessage(), pe);
            }
            catch (ParseWarningException warning) {
                System.out.println("Documento contenente anomalie: " + warning.getMessage());
            }
            apiValidatorOpenApi = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
            try {
                apiValidatorOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi, configO);
            }
            catch (Exception e) {
                throw new Exception("Errore non atteso (org.openapi4j.parser.validation.ValidationContext.convertDefaultStringValueInPrimitiveType=" + ValidationContext.convertDefaultStringValueInPrimitiveType + "): " + e.getMessage(), e);
            }
            ValidationContext.convertDefaultStringValueInPrimitiveType = false;
            try {
                apiReaderOpenApi = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
                apiReaderOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi);
                apiOpenApi = apiReaderOpenApi.read();
                apiValidatorOpenApi = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
                try {
                    apiValidatorOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi, configO);
                    throw new Exception("Atteso errore");
                }
                catch (Exception e) {
                    HttpRequestMethod[] erroreInteger1 = "default: Value '1' is incompatible with schema type 'integer' (code: 138)";
                    String erroreInteger2 = "default: Value '32' is incompatible with schema type 'integer/int32' (code: 138)";
                    String erroreInteger3 = "default: Value '3147483647' is incompatible with schema type 'integer/int64' (code: 138)";
                    String erroreNumber1 = "default: Value '1.2' is incompatible with schema type 'number' (code: 138)";
                    String erroreNumber2 = "default: Value '2.3' is incompatible with schema type 'number/double' (code: 138)";
                    String erroreNumber3 = "default: Value '2.3' is incompatible with schema type 'number/float' (code: 138)";
                    String erroreBoolean = "default: Value 'true' is incompatible with schema type 'boolean' (code: 138)";
                    if (!e.getMessage().contains((CharSequence)erroreInteger1)) {
                        throw new Exception("Errore atteso '" + (String)erroreInteger1 + "' non rilevato in :" + e.getMessage(), e);
                    }
                    if (!e.getMessage().contains(erroreInteger2)) {
                        throw new Exception("Errore atteso '" + erroreInteger2 + "' non rilevato in :" + e.getMessage(), e);
                    }
                    if (!e.getMessage().contains(erroreInteger3)) {
                        throw new Exception("Errore atteso '" + erroreInteger3 + "' non rilevato in :" + e.getMessage(), e);
                    }
                    if (!e.getMessage().contains(erroreNumber1)) {
                        throw new Exception("Errore atteso '" + erroreNumber1 + "' non rilevato in :" + e.getMessage(), e);
                    }
                    if (!e.getMessage().contains(erroreNumber2)) {
                        throw new Exception("Errore atteso '" + erroreNumber2 + "' non rilevato in :" + e.getMessage(), e);
                    }
                    if (!e.getMessage().contains(erroreNumber3)) {
                        throw new Exception("Errore atteso '" + erroreNumber3 + "' non rilevato in :" + e.getMessage(), e);
                    }
                    if (!e.getMessage().contains(erroreBoolean)) {
                        throw new Exception("Errore atteso '" + erroreBoolean + "' non rilevato in :" + e.getMessage(), e);
                    }
                    ValidationContext.convertDefaultStringValueInPrimitiveType = true;
                }
            }
            catch (Throwable throwable) {
                ValidationContext.convertDefaultStringValueInPrimitiveType = true;
                throw throwable;
            }
        }
        System.out.println("Skipped test per libreria " + String.valueOf(openAPILibrary));
        System.out.println("Test Schema#4 (default.yaml) [Valori default non coerenti con il tipo] ok");
        System.out.println("Test Schema#5 (info.yaml) [Elementi Info] ...");
        if (openAPILibrary == OpenAPILibrary.openapi4j) {
            OpenApi3Validator.VALIDATE_URI_REFERENCE_AS_URL = false;
            url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/info.yaml");
            apiReaderOpenApi = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
            configOpenApi = new ApiReaderConfig();
            configOpenApi.setProcessInclude(false);
            apiReaderOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi);
            apiOpenApi = apiReaderOpenApi.read();
            try {
                apiOpenApi.validate();
            }
            catch (ProcessingException pe) {
                pe.printStackTrace(System.out);
                throw new Exception(" Documento contenente errori: " + pe.getMessage(), pe);
            }
            catch (ParseWarningException warning) {
                System.out.println("Documento contenente anomalie: " + warning.getMessage());
            }
            apiValidatorOpenApi = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
            apiValidatorOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi, configO);
        }
        System.out.println("Test Schema#5 (info.yaml) [Elementi Info] ok");
        System.out.println("Test Schema#6 (openapi_all_methods.yaml) [Verifica che tutti i metodi HTTP siano caricati] ...");
        url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/openapi_all_methods.yaml");
        apiReaderOpenApi = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        configOpenApi = new ApiReaderConfig();
        configOpenApi.setProcessInclude(false);
        apiReaderOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi);
        apiOpenApi = apiReaderOpenApi.read();
        try {
            apiOpenApi.validate();
        }
        catch (ProcessingException pe) {
            pe.printStackTrace(System.out);
            throw new Exception(" Documento contenente errori: " + pe.getMessage(), pe);
        }
        catch (ParseWarningException warning) {
            System.out.println("Documento contenente anomalie: " + warning.getMessage());
        }
        apiValidatorOpenApi = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
        apiValidatorOpenApi.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi, configO);
        ArrayList<HttpRequestMethod> metodiHttpd = new ArrayList<HttpRequestMethod>();
        for (ApiOperation op : apiOpenApi.getOperations()) {
            metodiHttpd.add(op.getHttpMethod());
        }
        System.out.println("Metodi: " + String.valueOf(metodiHttpd));
        for (HttpRequestMethod httpRequestMethod : HttpRequestMethod.values()) {
            if (HttpRequestMethod.LINK.equals(httpRequestMethod) || HttpRequestMethod.UNLINK.equals(httpRequestMethod) || metodiHttpd.contains(httpRequestMethod)) continue;
            throw new Exception("Metodo '" + String.valueOf(httpRequestMethod) + "' non rilevato");
        }
        System.out.println("Test Schema#6 (openapi_all_methods.yaml) [Verifica che tutti i metodi HTTP siano caricati] ok");
        url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/allegati.yaml");
        ApiSchema apiSchemaYaml = new ApiSchema("teamdigitale-openapi_definitions.yaml", Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/service/schemi/standard/teamdigitale-openapi_definitions.yaml")), ApiSchemaType.YAML);
        String baseUri = "";
        IApiReader apiReaderOpenApi2 = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        ApiReaderConfig configOpenApi2 = new ApiReaderConfig();
        configOpenApi2.setProcessInclude(false);
        apiReaderOpenApi2.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi2, apiSchemaYaml);
        Api apiOpenApi2 = apiReaderOpenApi2.read();
        try {
            apiOpenApi2.validate();
        }
        catch (ProcessingException pe) {
            pe.printStackTrace(System.out);
            throw new Exception(" Documento contenente errori: " + pe.getMessage(), pe);
        }
        catch (ParseWarningException warning) {
            System.out.println("Documento contenente anomalie: " + warning.getMessage());
        }
        IApiValidator apiValidatorOpenApi2 = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
        OpenapiApiValidatorConfig configO2 = new OpenapiApiValidatorConfig();
        configO2.setEmitLogError(logSystemOutError);
        configO2.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
        configO2.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
        configO2.getOpenApiValidatorConfig().setValidateAPISpec(true);
        configO2.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
        apiValidatorOpenApi2.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi2, configO2);
        byte[] pdf = Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/openapi/test/test.pdf"));
        String xml = "<prova>Hello World</prova>";
        Document docXml = XMLUtils.getInstance().newDocument(xml.getBytes());
        Element elementXml = docXml.getDocumentElement();
        System.out.println("Test #1 (Richiesta POST con parametro /documenti/mixed/send)");
        String testUrl1 = baseUri + "/documenti/mixed/send";
        TextHttpRequestEntity httpEntity = new TextHttpRequestEntity();
        httpEntity.setMethod(HttpRequestMethod.POST);
        httpEntity.setUrl(testUrl1);
        HashMap<String, List<String>> parametersTrasporto = new HashMap<String, List<String>>();
        TransportUtils.addHeader(parametersTrasporto, "api_key", "aaa");
        TransportUtils.addHeader(parametersTrasporto, "Content-Type", "application/json");
        httpEntity.setHeaders(parametersTrasporto);
        httpEntity.setContentType("application/json");
        String json = "{\"mittente\":\"Mittente\",\"destinatario\":\"EnteDestinatario\",\"procedimento\":\"DescrizioneGenerica ...\",\"allegati\":[{\"nome\":\"HelloWorld.pdf\",\"descrizione\":\"File di esempio 'HelloWorld.pdf'\",\"tipoMIME\":\"application/pdf\",\"dataDocumento\":\"2020-04-24T13:06:18.823+02:00\",\"documento\":{\"tipoDocumento\":\"riferimento-uri\",\"uri\":\"https://api.agenziaentrate.it/retrieve-document/0.1//documenti/f6892e27-5cbd-4789-b875-bdcb18f4557f\",\"impronta\":\"KNdo5OCzZu8Hh7FwKxfpqPMTAHsC2ZRxOds5WTiu4QA=\"}},{\"nome\":\"PROVA.txt\",\"descrizione\":\"File di esempio 'PROVA.txt'\",\"tipoMIME\":\"text/plain\",\"dataDocumento\":\"2020-04-24T13:06:18.851+02:00\",\"documento\":{\"tipoDocumento\":\"inline\",\"contenuto\":\"SGVsbG8gV29ybGQhCg==\"}}]}";
        httpEntity.setContent(json);
        apiValidatorOpenApi2.validate(httpEntity);
        System.out.println("Test #1 completato\n\n");
        System.out.println("Test #2 (Richiesta POST con parametro /documenti/mixed/send) errata (elemento mancante)");
        String jsonErrato2 = "{\"mittente\":\"Mittente\",\"destinatario\":\"EnteDestinatario\",\"procedimento\":\"DescrizioneGenerica ...\",\"allegati\":[{\"nome\":\"HelloWorld.pdf\",\"descrizione\":\"File di esempio 'HelloWorld.pdf'\",\"tipoMIME\":\"application/pdf\",\"dataDocumento\":\"2020-04-24T13:06:18.823+02:00\",\"documento\":{\"tipoDocumento\":\"riferimento-uri\",\"uriERRATO\":\"https://api.agenziaentrate.it/retrieve-document/0.1//documenti/f6892e27-5cbd-4789-b875-bdcb18f4557f\",\"impronta\":\"KNdo5OCzZu8Hh7FwKxfpqPMTAHsC2ZRxOds5WTiu4QA=\"}},{\"nome\":\"PROVA.txt\",\"descrizione\":\"File di esempio 'PROVA.txt'\",\"tipoMIME\":\"text/plain\",\"dataDocumento\":\"2020-04-24T13:06:18.851+02:00\",\"documento\":{\"tipoDocumento\":\"inline\",\"contenuto\":\"SGVsbG8gV29ybGQhCg==\"}}]}";
        httpEntity.setContent(jsonErrato2);
        try {
            apiValidatorOpenApi2.validate(httpEntity);
            throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
        }
        catch (ValidatorException e) {
            System.out.println("Test #2 Errore trovato: " + e.getMessage());
            String msgErroreAtteso = null;
            switch (openAPILibrary) {
                case json_schema: {
                    msgErroreAtteso = "$.allegati[0].documento: must be valid to one and only one schema, but 0 are valid\n1028 $.allegati[0].documento: required property 'contenuto' not found\n1028 $.allegati[0].documento: required property 'uri' not found";
                    break;
                }
                case openapi4j: {
                    msgErroreAtteso = "body.allegati.0.documento: Field 'uri' is required.";
                    break;
                }
                case swagger_request_validator: {
                    msgErroreAtteso = "- [ERROR][] [Path '/allegati/0/documento'] Object has missing required properties ([\"uri\"])";
                    break;
                }
            }
            if (msgErroreAtteso != null && !e.getMessage().contains(msgErroreAtteso)) {
                throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
            }
            System.out.println("Test #2 completato\n\n");
            System.out.println("Test #3 (Richiesta POST con parametro /documenti/mixed/send) errata (enumeration discriminator errata)");
            String jsonErrato3 = "{\"mittente\":\"Mittente\",\"destinatario\":\"EnteDestinatario\",\"procedimento\":\"DescrizioneGenerica ...\",\"allegati\":[{\"nome\":\"HelloWorld.pdf\",\"descrizione\":\"File di esempio 'HelloWorld.pdf'\",\"tipoMIME\":\"application/pdf\",\"dataDocumento\":\"2020-04-24T13:06:18.823+02:00\",\"documento\":{\"tipoDocumento\":\"riferimento-uriERRATA\",\"uri\":\"https://api.agenziaentrate.it/retrieve-document/0.1//documenti/f6892e27-5cbd-4789-b875-bdcb18f4557f\",\"impronta\":\"KNdo5OCzZu8Hh7FwKxfpqPMTAHsC2ZRxOds5WTiu4QA=\"}},{\"nome\":\"PROVA.txt\",\"descrizione\":\"File di esempio 'PROVA.txt'\",\"tipoMIME\":\"text/plain\",\"dataDocumento\":\"2020-04-24T13:06:18.851+02:00\",\"documento\":{\"tipoDocumento\":\"inline\",\"contenuto\":\"SGVsbG8gV29ybGQhCg==\"}}]}";
            httpEntity.setContent(jsonErrato3);
            try {
                apiValidatorOpenApi2.validate(httpEntity);
                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
            }
            catch (ValidatorException e2) {
                System.out.println("Test #3 Errore trovato: " + e2.getMessage());
                String msgErroreAtteso2 = null;
                switch (openAPILibrary) {
                    case json_schema: {
                        msgErroreAtteso2 = "$.allegati[0].documento: must be valid to one and only one schema, but 0 are valid\n1008 $.allegati[0].documento.tipoDocumento: does not have a value in the enumeration [\"inline\", \"riferimento-uri\"]\n1028 $.allegati[0].documento: required property 'contenuto' not found\n1008 $.allegati[0].documento.tipoDocumento: does not have a value in the enumeration [\"inline\", \"riferimento-uri\"]";
                        break;
                    }
                    case openapi4j: {
                        msgErroreAtteso2 = "body.allegati.0.documento: Schema selection can't be made for discriminator 'tipoDocumento' with value 'riferimento-uriERRATA'.";
                        break;
                    }
                    case swagger_request_validator: {
                        msgErroreAtteso2 = "[ERROR][] [Path '/allegati/0/documento/tipoDocumento'] Instance value (\"riferimento-uriERRATA\") not found in enum (possible values: [\"inline\",\"riferimento-uri\"])";
                        break;
                    }
                }
                if (msgErroreAtteso2 != null && !e2.getMessage().contains(msgErroreAtteso2)) {
                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso2 + "'");
                }
                System.out.println("Test #3 completato\n\n");
                System.out.println("Test #4 (Richiesta POST con parametro /documenti/mixed/send) errata (enumeration discriminator non presente)");
                String jsonErrato4 = "{\"mittente\":\"Mittente\",\"destinatario\":\"EnteDestinatario\",\"procedimento\":\"DescrizioneGenerica ...\",\"allegati\":[{\"nome\":\"HelloWorld.pdf\",\"descrizione\":\"File di esempio 'HelloWorld.pdf'\",\"tipoMIME\":\"application/pdf\",\"dataDocumento\":\"2020-04-24T13:06:18.823+02:00\",\"documento\":{\"tipoDocumento\":\"riferimento-uri\",\"uri\":\"https://api.agenziaentrate.it/retrieve-document/0.1//documenti/f6892e27-5cbd-4789-b875-bdcb18f4557f\",\"impronta\":\"KNdo5OCzZu8Hh7FwKxfpqPMTAHsC2ZRxOds5WTiu4QA=\"}},{\"nome\":\"PROVA.txt\",\"descrizione\":\"File di esempio 'PROVA.txt'\",\"tipoMIME\":\"text/plain\",\"dataDocumento\":\"2020-04-24T13:06:18.851+02:00\",\"documento\":{\"contenuto\":\"SGVsbG8gV29ybGQhCg==\"}}]}";
                httpEntity.setContent(jsonErrato4);
                try {
                    apiValidatorOpenApi2.validate(httpEntity);
                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                }
                catch (ValidatorException e3) {
                    String testYaml;
                    ArrayList<String> path_test20;
                    ArrayList<String> tipoTest_test20;
                    ArrayList<Boolean> esito_test20;
                    ArrayList<Object> valori_test20;
                    String baseTestUrl20;
                    Object msgErroreAtteso3;
                    Object error;
                    TextHttpResponseEntity httpEntityResponseTest14;
                    Object msgErroreAtteso4;
                    String tipoTest;
                    Object json14;
                    TextHttpRequestEntity httpEntity14;
                    int i;
                    String valueUpperCase;
                    int i2;
                    void var70_184;
                    Object error2;
                    TextHttpResponseEntity httpEntityResponseTest13;
                    Object msgErroreAtteso5;
                    String tipoTest2;
                    Object json13;
                    int i3;
                    int sizeTest13Originali;
                    ArrayList<Boolean> esiti_test13;
                    ArrayList<String> valori_test13;
                    String testUrl13;
                    block607: {
                        String tipoTest3;
                        boolean esito;
                        Iterator iterator;
                        HashMap<String, List<String>> parametersTrasporto12_required;
                        TextHttpRequestEntity httpEntity12_required;
                        HashMap<String, List<String>> parametersTrasporto12_optional;
                        TextHttpRequestEntity httpEntity12_optional;
                        HashMap<String, List<String>> parametersTrasporto12_default;
                        TextHttpRequestEntity httpEntity12_default;
                        String testUrl12_default;
                        Iterator i42;
                        HashMap<String, List<String>> parametersTrasportoRispostaTest11;
                        TextHttpResponseEntity httpEntityResponseTest11;
                        Iterator esito22;
                        HashMap<String, List<String>> parametersTrasportoTest11;
                        TextHttpRequestEntity httpEntityTest11;
                        String jsonTest11;
                        ArrayList<String> contentTypeTest11List;
                        String testUrl11;
                        Iterator msgErroreAtteso6;
                        System.out.println("Test #4 Errore trovato: " + e3.getMessage());
                        String msgErroreAtteso7 = null;
                        switch (openAPILibrary) {
                            case json_schema: {
                                msgErroreAtteso7 = "$.allegati[1].documento: must be valid to one and only one schema, but 0 are valid\n1028 $.allegati[1].documento: required property 'tipoDocumento' not found\n1028 $.allegati[1].documento: required property 'impronta' not found\n1028 $.allegati[1].documento: required property 'tipoDocumento' not found\n1028 $.allegati[1].documento: required property 'uri' not found";
                                break;
                            }
                            case openapi4j: {
                                msgErroreAtteso7 = "body.allegati.1.documento: Property name in content 'tipoDocumento' is not set.";
                                break;
                            }
                            case swagger_request_validator: {
                                msgErroreAtteso7 = "[ERROR][] [Path '/allegati/1/documento'] Object has missing required properties ([\"tipoDocumento\"])";
                                break;
                            }
                        }
                        if (msgErroreAtteso7 != null && !e3.getMessage().contains(msgErroreAtteso7)) {
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso7 + "'");
                        }
                        switch (openAPILibrary) {
                            case json_schema: {
                                msgErroreAtteso7 = "allegati[1].documento: must be valid to one and only one schema, but 0 are valid\n1028 $.allegati[1].documento: required property 'tipoDocumento' not found\n1028 $.allegati[1].documento: required property 'impronta' not found\n1028 $.allegati[1].documento: required property 'tipoDocumento' not found\n1028 $.allegati[1].documento: required property 'uri' not found";
                                break;
                            }
                            case openapi4j: {
                                msgErroreAtteso7 = "From: body.<allOf>.allegati.1.<items>.<#/components/schemas/AllegatoRiferimentoMixed>.<allOf>.documento.<discriminator>";
                                break;
                            }
                            case swagger_request_validator: {
                                msgErroreAtteso7 = "* /allOf/1/properties/allegati/items/allOf/1: Discriminator field 'tipoDocumento' is required";
                                break;
                            }
                        }
                        if (msgErroreAtteso7 != null && !e3.getMessage().contains(msgErroreAtteso7)) {
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso7 + "'");
                        }
                        System.out.println("Test #4 completato\n\n");
                        System.out.println("Test #5 (Richiesta POST con parametro dinamico /documenti/XYZ)");
                        String testUrl5 = baseUri + "/documenti/test/" + UUID.randomUUID().toString();
                        TextHttpRequestEntity httpEntityDynamicPath = new TextHttpRequestEntity();
                        httpEntityDynamicPath.setMethod(HttpRequestMethod.POST);
                        httpEntityDynamicPath.setUrl(testUrl5);
                        HashMap<String, List<String>> parametersTrasportoDynamicPath = new HashMap<String, List<String>>();
                        TransportUtils.addHeader(parametersTrasportoDynamicPath, "api_key", "aaa");
                        TransportUtils.addHeader(parametersTrasportoDynamicPath, "Content-Type", "application/json");
                        httpEntityDynamicPath.setHeaders(parametersTrasportoDynamicPath);
                        httpEntityDynamicPath.setContentType("application/json");
                        httpEntityDynamicPath.setContent(json);
                        apiValidatorOpenApi2.validate(httpEntityDynamicPath);
                        System.out.println("Test #5 completato\n\n");
                        System.out.println("Test #6 (Risposta GET con parametro dinamico /documenti/XYZ)");
                        testUrl5 = baseUri + "/documenti/" + UUID.randomUUID().toString();
                        TextHttpRequestEntity httpEntityGET = new TextHttpRequestEntity();
                        httpEntityGET.setMethod(HttpRequestMethod.GET);
                        httpEntityGET.setUrl(testUrl5);
                        apiValidatorOpenApi2.validate(httpEntityGET);
                        ArrayList<String> contentTypes_test5 = new ArrayList<String>();
                        contentTypes_test5.add("application/json");
                        contentTypes_test5.add("jsonUncorrect");
                        contentTypes_test5.add("text/plain");
                        contentTypes_test5.add("application/xml");
                        contentTypes_test5.add("xmlUncorrect");
                        contentTypes_test5.add("text/xml");
                        contentTypes_test5.add("application/octet-stream");
                        contentTypes_test5.add("application/pdf");
                        contentTypes_test5.add("application/zip");
                        for (String ct : contentTypes_test5) {
                            HttpBaseResponseEntity httpEntityResponse;
                            block606: {
                                block615: {
                                    HashMap<String, List<String>> parametersTrasportoRisposta;
                                    block614: {
                                        httpEntityResponse = null;
                                        httpEntityResponse = ct.contains("json") || ct.contains("plain") || ct.contains("Uncorrect") ? new TextHttpResponseEntity() : (ct.contains("xml") ? ("application/xml".equals(ct) ? new DocumentHttpResponseEntity() : new ElementHttpResponseEntity()) : new BinaryHttpResponseEntity());
                                        httpEntityResponse.setStatus(200);
                                        httpEntityResponse.setMethod(HttpRequestMethod.GET);
                                        httpEntityResponse.setUrl(testUrl5);
                                        parametersTrasportoRisposta = new HashMap<String, List<String>>();
                                        TransportUtils.addHeader(parametersTrasportoRisposta, "api_key", "aaa");
                                        TransportUtils.addHeader(parametersTrasportoRisposta, "Content-Type", ct);
                                        httpEntityResponse.setHeaders(parametersTrasportoRisposta);
                                        httpEntityResponse.setContentType(ct);
                                        if (!ct.contains("json") && !ct.contains("plain")) break block614;
                                        if (ct.contains("Uncorrect")) {
                                            ((TextHttpResponseEntity)httpEntityResponse).setContent("{ a }");
                                            parametersTrasportoRisposta.remove("Content-Type");
                                            TransportUtils.setHeader(parametersTrasportoRisposta, "Content-Type", "application/json");
                                            httpEntityResponse.setContentType("application/json");
                                            break block606;
                                        } else if (ct.contains("plain")) {
                                            ((TextHttpResponseEntity)httpEntityResponse).setContent("Hello World!");
                                            break block606;
                                        } else {
                                            ((TextHttpResponseEntity)httpEntityResponse).setContent(json);
                                        }
                                        break block606;
                                    }
                                    if (!ct.contains("xml")) break block615;
                                    if (ct.contains("Uncorrect")) {
                                        ((TextHttpResponseEntity)httpEntityResponse).setContent("<prova>aaaprova>");
                                        parametersTrasportoRisposta.remove("Content-Type");
                                        TransportUtils.setHeader(parametersTrasportoRisposta, "Content-Type", "application/xml");
                                        httpEntityResponse.setContentType("application/xml");
                                        break block606;
                                    } else if ("application/xml".equals(ct)) {
                                        ((DocumentHttpResponseEntity)httpEntityResponse).setContent(docXml);
                                        break block606;
                                    } else {
                                        ((ElementHttpResponseEntity)httpEntityResponse).setContent(elementXml);
                                    }
                                    break block606;
                                }
                                ((BinaryHttpResponseEntity)httpEntityResponse).setContent(pdf);
                            }
                            String tipoTest4 = "ContentType:" + ct + " ";
                            tipoTest4 = tipoTest4 + "[" + String.valueOf(openAPILibrary) + "]";
                            try {
                                System.out.println("\t " + tipoTest4 + " validate response ...");
                                if (ct.contains("xml") && openAPILibrary == OpenAPILibrary.swagger_request_validator) {
                                    System.out.println("\t Content-Type " + ct + ": funzionalit\u00e0 non supportata dalla libreria swagger-request-validator");
                                    continue;
                                }
                                apiValidatorOpenApi2.validate(httpEntityResponse);
                                System.out.println("\t " + tipoTest4 + " validate response ok");
                                if (openAPILibrary == OpenAPILibrary.json_schema || !ct.contains("Uncorrect")) continue;
                                throw new Exception("Attesa eccezione");
                            }
                            catch (Throwable e4) {
                                Object error3 = e4.getMessage();
                                if (((String)error3).length() > 500) {
                                    error3 = ((String)error3).substring(0, 498) + " ...";
                                }
                                if (!ct.contains("Uncorrect")) {
                                    System.out.println("\t " + tipoTest4 + " rilevato errore di validazione non atteso: " + (String)error3);
                                    throw new Exception(tipoTest4 + " rilevato errore di validazione non atteso: " + e4.getMessage(), e4);
                                }
                                String erroreAtteso = null;
                                erroreAtteso = ct.contains("json") ? "Unexpected character ('a' (code 97))" : "Unclosed tag prova at 16 [character 17 line 1]";
                                if (e4.getMessage().contains(erroreAtteso)) continue;
                                System.out.println("\t " + tipoTest4 + " rilevato errore di validazione diverso da quello atteso (" + erroreAtteso + ") : " + (String)error3);
                                throw new Exception(tipoTest4 + " rilevato errore di validazione diverso da quello atteso (" + erroreAtteso + ") : " + e4.getMessage(), e4);
                            }
                        }
                        System.out.println("Test #6 completato\n\n");
                        System.out.println("Test #7 (Richiesta POST con parametro /documenti/mixed/send e elemento null)");
                        String testUrl7 = baseUri + "/documenti/mixed/send";
                        TextHttpRequestEntity httpEntity7 = new TextHttpRequestEntity();
                        httpEntity7.setMethod(HttpRequestMethod.POST);
                        httpEntity7.setUrl(testUrl7);
                        HashMap<String, List<String>> parametersTrasporto7 = new HashMap<String, List<String>>();
                        TransportUtils.addHeader(parametersTrasporto7, "api_key", "aaa");
                        TransportUtils.addHeader(parametersTrasporto7, "Content-Type", "application/json");
                        httpEntity7.setHeaders(parametersTrasporto7);
                        httpEntity7.setContentType("application/json");
                        String json7 = "{\"mittente\":\"Mittente\",\"destinatario\":\"EnteDestinatario\",\"procedimento\":\"DescrizioneGenerica ...\",\"string_nullable\":null,\"number_nullable\":null,\"enum_nullable\":null,\"allegati\":[{\"nome\":\"HelloWorld.pdf\",\"descrizione\":\"File di esempio 'HelloWorld.pdf'\",\"tipoMIME\":\"application/pdf\",\"dataDocumento\":\"2020-04-24T13:06:18.823+02:00\",\"documento\":{\"tipoDocumento\":\"riferimento-uri\",\"uri\":\"https://api.agenziaentrate.it/retrieve-document/0.1//documenti/f6892e27-5cbd-4789-b875-bdcb18f4557f\",\"impronta\":\"KNdo5OCzZu8Hh7FwKxfpqPMTAHsC2ZRxOds5WTiu4QA=\"}},{\"nome\":\"PROVA.txt\",\"descrizione\":\"File di esempio 'PROVA.txt'\",\"tipoMIME\":\"text/plain\",\"dataDocumento\":\"2020-04-24T13:06:18.851+02:00\",\"documento\":{\"tipoDocumento\":\"inline\",\"contenuto\":\"SGVsbG8gV29ybGQhCg==\"}}]}";
                        httpEntity7.setContent(json7);
                        apiValidatorOpenApi2.validate(httpEntity7);
                        System.out.println("Test #7 completato\n\n");
                        System.out.println("Test #8 (Richiesta POST con parametro /documenti/mixed/send e elemento valido/nonValido secondo il pattern)");
                        String testUrl8 = baseUri + "/documenti/mixed/send";
                        ArrayList<String> valori_test8 = new ArrayList<String>();
                        ArrayList<Boolean> esiti_test8 = new ArrayList<Boolean>();
                        valori_test8.add("234567");
                        esiti_test8.add(true);
                        valori_test8.add("2345676");
                        esiti_test8.add(false);
                        valori_test8.add("23456");
                        esiti_test8.add(false);
                        valori_test8.add("");
                        esiti_test8.add(false);
                        valori_test8.add("234A67");
                        esiti_test8.add(false);
                        valori_test8.add("234567A");
                        esiti_test8.add(false);
                        valori_test8.add("234-67");
                        esiti_test8.add(false);
                        valori_test8.add("234.67");
                        esiti_test8.add(false);
                        valori_test8.add("234867\\n");
                        esiti_test8.add(false);
                        valori_test8.add("234867\\r\\n");
                        esiti_test8.add(false);
                        valori_test8.add("234867\\t");
                        esiti_test8.add(false);
                        for (int i5 = 0; i5 < valori_test8.size(); ++i5) {
                            String valore = (String)valori_test8.get(i5);
                            boolean esito3 = (Boolean)esiti_test8.get(i5);
                            TextHttpRequestEntity httpEntity8 = new TextHttpRequestEntity();
                            httpEntity8.setMethod(HttpRequestMethod.POST);
                            httpEntity8.setUrl(testUrl8);
                            HashMap<String, List<String>> parametersTrasporto8 = new HashMap<String, List<String>>();
                            TransportUtils.addHeader(parametersTrasporto8, "api_key", "aaa");
                            TransportUtils.addHeader(parametersTrasporto8, "Content-Type", "application/json");
                            httpEntity8.setHeaders(parametersTrasporto8);
                            httpEntity8.setContentType("application/json");
                            String json8 = "{\"mittente\":\"Mittente\",\"destinatario\":\"EnteDestinatario\",\"procedimento\":\"DescrizioneGenerica ...\",\"allegati\":[{\"nome\":\"HelloWorld.pdf\",\"descrizione\":\"File di esempio 'HelloWorld.pdf'\",\"tipoMIME\":\"application/pdf\",\"dataDocumento\":\"2020-04-24T13:06:18.823+02:00\",\"codiceOpzionaleNumerico\":\"" + valore + "\",\"documento\":{\"tipoDocumento\":\"riferimento-uri\",\"uri\":\"https://api.agenziaentrate.it/retrieve-document/0.1//documenti/f6892e27-5cbd-4789-b875-bdcb18f4557f\",\"impronta\":\"KNdo5OCzZu8Hh7FwKxfpqPMTAHsC2ZRxOds5WTiu4QA=\"}},{\"nome\":\"PROVA.txt\",\"descrizione\":\"File di esempio 'PROVA.txt'\",\"tipoMIME\":\"text/plain\",\"dataDocumento\":\"2020-04-24T13:06:18.851+02:00\",\"documento\":{\"tipoDocumento\":\"inline\",\"contenuto\":\"SGVsbG8gV29ybGQhCg==\"}}]}";
                            httpEntity8.setContent(json8);
                            try {
                                System.out.println("\t (Valore:" + valore + ") validate ...");
                                if (valore.endsWith("\\n") && openAPILibrary == OpenAPILibrary.json_schema) {
                                    System.out.println("\t (Valore:" + valore + ") test skipped; validazione json non individua l'errore di un ritorno a capo");
                                    continue;
                                }
                                apiValidatorOpenApi2.validate(httpEntity8);
                                if (!esito3) {
                                    System.out.println("\t (Valore:" + valore + ") ERRORE!");
                                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                }
                                System.out.println("\t (Valore:" + valore + ") validate ok");
                                continue;
                            }
                            catch (ValidatorException e5) {
                                if (esito3) {
                                    System.out.println("\t (Valore:" + valore + ") rilevato errore di validazione non atteso: " + e5.getMessage());
                                    throw new Exception("(Valore:" + valore + ") rilevato errore di validazione non atteso: " + e5.getMessage(), e5);
                                }
                                System.out.println("\t (Valore:" + valore + ") atteso errore di validazione, rilevato: " + e5.getMessage());
                                Object msgErroreAtteso8 = null;
                                switch (openAPILibrary) {
                                    case json_schema: {
                                        msgErroreAtteso8 = "1023 $.allegati[0].codiceOpzionaleNumerico: does not match the regex pattern ^\\d{6}$";
                                        break;
                                    }
                                    case openapi4j: {
                                        msgErroreAtteso8 = "body.allegati.0.codiceOpzionaleNumerico: '" + valore + "' does not respect pattern '^\\d{6}$'.";
                                        break;
                                    }
                                    case swagger_request_validator: {
                                        msgErroreAtteso8 = "- [ERROR][] [Path '/allegati/0/codiceOpzionaleNumerico'] ECMA 262 regex \"^\\d{6}$\" does not match input string \"" + StringEscapeUtils.unescapeJava((String)valore);
                                        break;
                                    }
                                }
                                if (msgErroreAtteso8 != null && !e5.getMessage().contains((CharSequence)msgErroreAtteso8)) {
                                    System.out.println("\t (Valore:" + valore + ") ERRORE!");
                                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso8 + "'\nTrovato invece: '" + e5.getMessage() + "'");
                                }
                                msgErroreAtteso8 = null;
                                switch (openAPILibrary) {
                                    case json_schema: {
                                        msgErroreAtteso8 = "1023 $.allegati[0].codiceOpzionaleNumerico: does not match the regex pattern ^\\d{6}$";
                                        break;
                                    }
                                    case openapi4j: {
                                        msgErroreAtteso8 = "From: body.<allOf>.allegati.0.<items>.<#/components/schemas/AllegatoRiferimentoMixed>.<allOf>.<#/components/schemas/Allegato>.codiceOpzionaleNumerico.<pattern>";
                                        break;
                                    }
                                    case swagger_request_validator: {
                                        msgErroreAtteso8 = "* /allOf/1/properties/allegati/items/allOf/0";
                                        break;
                                    }
                                }
                                if (msgErroreAtteso8 == null || e5.getMessage().contains((CharSequence)msgErroreAtteso8)) continue;
                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso8 + "'");
                            }
                        }
                        System.out.println("Test #8 completato\n\n");
                        System.out.println("Test #9 (Richiesta POST con parametro /documenti/mixed/send e elemento valido/nonValido secondo il pattern definito in OR)");
                        String testUrl9 = baseUri + "/documenti/mixed/send";
                        ArrayList<String> valori_test9 = new ArrayList<String>();
                        ArrayList<Boolean> esiti_test9 = new ArrayList<Boolean>();
                        valori_test9.add("NGRLLI04L54D969B");
                        esiti_test9.add(true);
                        valori_test9.add("brtBGI06c16d612D");
                        esiti_test9.add(true);
                        valori_test9.add("ABC323");
                        esiti_test9.add(true);
                        valori_test9.add("345323");
                        esiti_test9.add(true);
                        valori_test9.add("A2C323");
                        esiti_test9.add(true);
                        valori_test9.add("3GRLLI04L54D969B");
                        esiti_test9.add(false);
                        valori_test9.add("GRLLI04L54D969B");
                        esiti_test9.add(false);
                        valori_test9.add("NGRLLI04L54D969BA");
                        esiti_test9.add(false);
                        valori_test9.add("NGRLLI04L54D969B\\r\\n");
                        esiti_test9.add(false);
                        valori_test9.add("NGRLLI04L54D969B\\n");
                        esiti_test9.add(false);
                        valori_test9.add("NGRLLI04L54D969B\\t");
                        esiti_test9.add(false);
                        valori_test9.add("NGRLLIA4L54D969B");
                        esiti_test9.add(false);
                        valori_test9.add("AABC323");
                        esiti_test9.add(false);
                        valori_test9.add("ABC32");
                        esiti_test9.add(false);
                        valori_test9.add("ABC32A");
                        esiti_test9.add(false);
                        valori_test9.add("abC323");
                        esiti_test9.add(false);
                        for (int i6 = 0; i6 < valori_test9.size(); ++i6) {
                            String valore = (String)valori_test9.get(i6);
                            boolean esito4 = (Boolean)esiti_test9.get(i6);
                            TextHttpRequestEntity httpEntity9 = new TextHttpRequestEntity();
                            httpEntity9.setMethod(HttpRequestMethod.POST);
                            httpEntity9.setUrl(testUrl9);
                            HashMap<String, List<String>> parametersTrasporto9 = new HashMap<String, List<String>>();
                            TransportUtils.addHeader(parametersTrasporto9, "api_key", "aaa");
                            TransportUtils.addHeader(parametersTrasporto9, "Content-Type", "application/json");
                            httpEntity9.setHeaders(parametersTrasporto9);
                            httpEntity9.setContentType("application/json");
                            String json9 = "{\"mittente\":\"Mittente\",\"destinatario\":\"EnteDestinatario\",\"procedimento\":\"DescrizioneGenerica ...\",\"allegati\":[{\"nome\":\"HelloWorld.pdf\",\"descrizione\":\"File di esempio 'HelloWorld.pdf'\",\"tipoMIME\":\"application/pdf\",\"dataDocumento\":\"2020-04-24T13:06:18.823+02:00\",\"codiceOpzionaleCodiceFiscaleOrCodiceEsterno\":\"" + valore + "\",\"documento\":{\"tipoDocumento\":\"riferimento-uri\",\"uri\":\"https://api.agenziaentrate.it/retrieve-document/0.1//documenti/f6892e27-5cbd-4789-b875-bdcb18f4557f\",\"impronta\":\"KNdo5OCzZu8Hh7FwKxfpqPMTAHsC2ZRxOds5WTiu4QA=\"}},{\"nome\":\"PROVA.txt\",\"descrizione\":\"File di esempio 'PROVA.txt'\",\"tipoMIME\":\"text/plain\",\"dataDocumento\":\"2020-04-24T13:06:18.851+02:00\",\"documento\":{\"tipoDocumento\":\"inline\",\"contenuto\":\"SGVsbG8gV29ybGQhCg==\"}}]}";
                            httpEntity9.setContent(json9);
                            try {
                                System.out.println("\t (Valore:" + valore + ") validate ...");
                                if (valore.endsWith("\\n") && openAPILibrary == OpenAPILibrary.json_schema) {
                                    System.out.println("\t (Valore:" + valore + ") test skipped; validazione json non individua l'errore di un ritorno a capo");
                                    continue;
                                }
                                apiValidatorOpenApi2.validate(httpEntity9);
                                if (!esito4) {
                                    System.out.println("\t (Valore:" + valore + ") ERRORE!");
                                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                }
                                System.out.println("\t (Valore:" + valore + ") validate ok");
                                continue;
                            }
                            catch (ValidatorException e6) {
                                if (esito4) {
                                    System.out.println("\t (Valore:" + valore + ") rilevato errore di validazione non atteso: " + e6.getMessage());
                                    throw new Exception("(Valore:" + valore + ") rilevato errore di validazione non atteso: " + e6.getMessage(), e6);
                                }
                                System.out.println("\t (Valore:" + valore + ") atteso errore di validazione, rilevato: " + e6.getMessage());
                                msgErroreAtteso6 = null;
                                switch (openAPILibrary) {
                                    case json_schema: {
                                        msgErroreAtteso6 = "1023 $.allegati[0].codiceOpzionaleCodiceFiscaleOrCodiceEsterno: does not match the regex pattern ^[a-zA-Z]{6}[0-9]{2}[a-zA-Z0-9]{3}[a-zA-Z0-9]{5}$|^[A-Z0-9]{3}\\d{3}$";
                                        break;
                                    }
                                    case openapi4j: {
                                        msgErroreAtteso6 = "body.allegati.0.codiceOpzionaleCodiceFiscaleOrCodiceEsterno: '" + valore + "' does not respect pattern '^[a-zA-Z]{6}[0-9]{2}[a-zA-Z0-9]{3}[a-zA-Z0-9]{5}$|^[A-Z0-9]{3}\\d{3}$'.";
                                        break;
                                    }
                                    case swagger_request_validator: {
                                        msgErroreAtteso6 = "- [ERROR][] [Path '/allegati/0/codiceOpzionaleCodiceFiscaleOrCodiceEsterno'] ECMA 262 regex \"^[a-zA-Z]{6}[0-9]{2}[a-zA-Z0-9]{3}[a-zA-Z0-9]{5}$|^[A-Z0-9]{3}\\d{3}$\" does not match input string \"" + StringEscapeUtils.unescapeJava((String)valore);
                                        break;
                                    }
                                }
                                if (msgErroreAtteso6 != null && !e6.getMessage().contains((CharSequence)((Object)msgErroreAtteso6))) {
                                    System.out.println("\t (Valore:" + valore + ") ERRORE!");
                                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)((Object)msgErroreAtteso6) + "'");
                                }
                                msgErroreAtteso6 = null;
                                switch (openAPILibrary) {
                                    case json_schema: {
                                        msgErroreAtteso6 = "1023 $.allegati[0].codiceOpzionaleCodiceFiscaleOrCodiceEsterno: does not match the regex pattern ^[a-zA-Z]{6}[0-9]{2}[a-zA-Z0-9]{3}[a-zA-Z0-9]{5}$|^[A-Z0-9]{3}\\d{3}$";
                                        break;
                                    }
                                    case openapi4j: {
                                        msgErroreAtteso6 = "From: body.<allOf>.allegati.0.<items>.<#/components/schemas/AllegatoRiferimentoMixed>.<allOf>.<#/components/schemas/Allegato>.codiceOpzionaleCodiceFiscaleOrCodiceEsterno.<pattern>";
                                        break;
                                    }
                                    case swagger_request_validator: {
                                        msgErroreAtteso6 = "* /allOf/1/properties/allegati/items/allOf/0:";
                                        break;
                                    }
                                }
                                if (msgErroreAtteso6 == null || e6.getMessage().contains((CharSequence)((Object)msgErroreAtteso6))) continue;
                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)((Object)msgErroreAtteso6) + "'");
                            }
                        }
                        System.out.println("Test #9 completato\n\n");
                        System.out.println("Test #10 (Richiesta POST con parametro /documenti/noresponse/send)");
                        String testUrl10 = baseUri + "/documenti/noresponse/send";
                        TextHttpRequestEntity httpEntityTest10 = new TextHttpRequestEntity();
                        httpEntityTest10.setMethod(HttpRequestMethod.POST);
                        httpEntityTest10.setUrl(testUrl10);
                        HashMap<String, List<String>> parametersTrasportoTest10 = new HashMap<String, List<String>>();
                        TransportUtils.addHeader(parametersTrasportoTest10, "api_key", "aaa");
                        TransportUtils.addHeader(parametersTrasportoTest10, "Content-Type", "application/json");
                        httpEntityTest10.setHeaders(parametersTrasportoTest10);
                        httpEntityTest10.setContentType("application/json");
                        String jsonTest10 = "{\"mittente\":\"Mittente\",\"destinatario\":\"EnteDestinatario\",\"procedimento\":\"DescrizioneGenerica ...\",\"allegati\":[{\"nome\":\"HelloWorld.pdf\",\"descrizione\":\"File di esempio 'HelloWorld.pdf'\",\"tipoMIME\":\"application/pdf\",\"dataDocumento\":\"2020-04-24T13:06:18.823+02:00\",\"documento\":{\"tipoDocumento\":\"riferimento-uri\",\"uri\":\"https://api.agenziaentrate.it/retrieve-document/0.1//documenti/f6892e27-5cbd-4789-b875-bdcb18f4557f\",\"impronta\":\"KNdo5OCzZu8Hh7FwKxfpqPMTAHsC2ZRxOds5WTiu4QA=\"}},{\"nome\":\"PROVA.txt\",\"descrizione\":\"File di esempio 'PROVA.txt'\",\"tipoMIME\":\"text/plain\",\"dataDocumento\":\"2020-04-24T13:06:18.851+02:00\",\"documento\":{\"tipoDocumento\":\"inline\",\"contenuto\":\"SGVsbG8gV29ybGQhCg==\"}}]}";
                        httpEntityTest10.setContent(jsonTest10);
                        apiValidatorOpenApi2.validate(httpEntityTest10);
                        TextHttpResponseEntity httpEntityResponseTest10 = new TextHttpResponseEntity();
                        httpEntityResponseTest10.setStatus(201);
                        httpEntityResponseTest10.setMethod(HttpRequestMethod.POST);
                        httpEntityResponseTest10.setUrl(testUrl10);
                        HashMap<String, List<String>> parametersTrasportoRispostaTest10 = new HashMap<String, List<String>>();
                        TransportUtils.addHeader(parametersTrasportoRispostaTest10, "api_key", "aaa");
                        httpEntityResponseTest10.setHeaders(parametersTrasportoRispostaTest10);
                        System.out.println("\t Validazione senza content-type ...");
                        apiValidatorOpenApi2.validate(httpEntityResponseTest10);
                        System.out.println("\t Validazione senza content-type ok");
                        ArrayList<String> contentTypeTest10List = new ArrayList<String>();
                        contentTypeTest10List.add("text/plain");
                        contentTypeTest10List.add("text/xml");
                        contentTypeTest10List.add("application/problem+xml");
                        contentTypeTest10List.add("application/json");
                        contentTypeTest10List.add("application/problem+json");
                        msgErroreAtteso6 = contentTypeTest10List.iterator();
                        block267: while (true) {
                            if (!msgErroreAtteso6.hasNext()) {
                                System.out.println("Test #10 completato\n\n");
                                System.out.println("Test #11 (Richiesta POST con parametro /documenti/norequestresponse/send)");
                                testUrl11 = baseUri + "/documenti/norequestresponse/send";
                                contentTypeTest11List = new ArrayList<String>();
                                contentTypeTest11List.add("text/plain");
                                contentTypeTest11List.add("text/xml");
                                contentTypeTest11List.add("application/problem+xml");
                                contentTypeTest11List.add("application/json");
                                contentTypeTest11List.add("application/problem+json");
                                jsonTest11 = "{\"mittente\":\"Mittente\",\"destinatario\":\"EnteDestinatario\",\"procedimento\":\"DescrizioneGenerica ...\",\"allegati\":[{\"nome\":\"HelloWorld.pdf\",\"descrizione\":\"File di esempio 'HelloWorld.pdf'\",\"tipoMIME\":\"application/pdf\",\"dataDocumento\":\"2020-04-24T13:06:18.823+02:00\",\"documento\":{\"tipoDocumento\":\"riferimento-uri\",\"uri\":\"https://api.agenziaentrate.it/retrieve-document/0.1//documenti/f6892e27-5cbd-4789-b875-bdcb18f4557f\",\"impronta\":\"KNdo5OCzZu8Hh7FwKxfpqPMTAHsC2ZRxOds5WTiu4QA=\"}},{\"nome\":\"PROVA.txt\",\"descrizione\":\"File di esempio 'PROVA.txt'\",\"tipoMIME\":\"text/plain\",\"dataDocumento\":\"2020-04-24T13:06:18.851+02:00\",\"documento\":{\"tipoDocumento\":\"inline\",\"contenuto\":\"SGVsbG8gV29ybGQhCg==\"}}]}";
                                httpEntityTest11 = new TextHttpRequestEntity();
                                httpEntityTest11.setMethod(HttpRequestMethod.POST);
                                httpEntityTest11.setUrl(testUrl11);
                                parametersTrasportoTest11 = new HashMap<String, List<String>>();
                                TransportUtils.addHeader(parametersTrasportoTest11, "api_key", "aaa");
                                httpEntityTest11.setHeaders(parametersTrasportoTest11);
                                System.out.println("\t Validazione richiesta senza content-type ...");
                                apiValidatorOpenApi2.validate(httpEntityTest11);
                                System.out.println("\t Validazione richiesta senza content-type ok");
                                esito22 = contentTypeTest11List.iterator();
                                break;
                            }
                            String contentTypeTest10 = (String)msgErroreAtteso6.next();
                            int i7 = 0;
                            while (true) {
                                if (i7 >= 2) continue block267;
                                boolean addContenuto = i7 == 1;
                                Object tipoTest5 = "senza";
                                if (addContenuto) {
                                    tipoTest5 = "con";
                                }
                                tipoTest5 = "[" + String.valueOf(openAPILibrary) + "] " + (String)tipoTest5;
                                System.out.println("\t Validazione con content-type '" + contentTypeTest10 + "' " + (String)tipoTest5 + " contenuto ...");
                                TransportUtils.setHeader(parametersTrasportoRispostaTest10, "Content-Type", contentTypeTest10);
                                httpEntityResponseTest10.setContentType(contentTypeTest10);
                                httpEntityResponseTest10.setHeaders(parametersTrasportoRispostaTest10);
                                if (addContenuto) {
                                    httpEntityResponseTest10.setContent(jsonTest10);
                                } else {
                                    httpEntityResponseTest10.setContent(null);
                                }
                                boolean esito22 = false;
                                try {
                                    apiValidatorOpenApi2.validate(httpEntityResponseTest10);
                                    esito22 = true;
                                }
                                catch (Exception e7) {
                                    String msg = e7.getMessage();
                                    Object atteso = null;
                                    switch (openAPILibrary) {
                                        case json_schema: {
                                            atteso = "Content-Type '" + contentTypeTest10 + "' (http response status '201') unsupported";
                                            break;
                                        }
                                        case openapi4j: {
                                            atteso = "Content type '" + contentTypeTest10 + "' is not allowed for body content. (code: 203)";
                                            break;
                                        }
                                        case swagger_request_validator: {
                                            if (addContenuto) {
                                                atteso = "[ERROR][RESPONSE][] No response body is expected but one was found.";
                                                break;
                                            }
                                            atteso = "Content-Type '" + contentTypeTest10 + "' (http response status '201') unsupported";
                                            break;
                                        }
                                    }
                                    if (atteso != null && !msg.contains((CharSequence)atteso)) {
                                        String checkErrore = "Validazione con content-type '" + contentTypeTest10 + "' " + (String)tipoTest5 + " contenuto terminato con un errore diverso da quello atteso: '" + msg + "'";
                                        System.out.println("\t " + checkErrore);
                                        throw new Exception(checkErrore);
                                    }
                                    System.out.println("\t Validazione con content-type '" + contentTypeTest10 + "' " + (String)tipoTest5 + " contenuto terminato con l'errore atteso: " + msg);
                                }
                                if (esito22) {
                                    System.out.println("\t Validazione con content-type '" + contentTypeTest10 + "' " + (String)tipoTest5 + " contenuto: atteso errore");
                                    throw new Exception("Validazione con content-type '" + contentTypeTest10 + "' " + (String)tipoTest5 + " contenuto: atteso errore");
                                }
                                ++i7;
                            }
                            break;
                        }
                        block269: while (true) {
                            if (!esito22.hasNext()) {
                                httpEntityResponseTest11 = new TextHttpResponseEntity();
                                httpEntityResponseTest11.setStatus(201);
                                httpEntityResponseTest11.setMethod(HttpRequestMethod.POST);
                                httpEntityResponseTest11.setUrl(testUrl11);
                                parametersTrasportoRispostaTest11 = new HashMap<String, List<String>>();
                                TransportUtils.addHeader(parametersTrasportoRispostaTest11, "api_key", "aaa");
                                httpEntityResponseTest11.setHeaders(parametersTrasportoRispostaTest11);
                                System.out.println("\t Validazione risposta senza content-type ...");
                                apiValidatorOpenApi2.validate(httpEntityResponseTest11);
                                System.out.println("\t Validazione risposta senza content-type ok");
                                i42 = contentTypeTest11List.iterator();
                                break;
                            }
                            String contentTypeTest11 = (String)esito22.next();
                            int i42 = 0;
                            while (true) {
                                if (i42 >= 2) continue block269;
                                boolean addContenuto = i42 == 1;
                                Object tipoTest6 = "senza";
                                if (addContenuto) {
                                    tipoTest6 = "con";
                                }
                                tipoTest6 = "[" + String.valueOf(openAPILibrary) + "] " + (String)tipoTest6;
                                System.out.println("\t Validazione richiesta con content-type '" + contentTypeTest11 + "' " + (String)tipoTest6 + " contenuto ...");
                                TransportUtils.setHeader(parametersTrasportoTest11, "Content-Type", contentTypeTest11);
                                httpEntityTest11.setContentType(contentTypeTest11);
                                if (addContenuto) {
                                    httpEntityTest11.setContent(jsonTest11);
                                } else {
                                    httpEntityTest11.setContent(null);
                                }
                                boolean esito5 = false;
                                try {
                                    apiValidatorOpenApi2.validate(httpEntityTest11);
                                    esito5 = true;
                                }
                                catch (Exception e8) {
                                    String msg = e8.getMessage();
                                    Object atteso = null;
                                    switch (openAPILibrary) {
                                        case json_schema: {
                                            atteso = "Content-Type '" + contentTypeTest11 + "' unsupported";
                                            break;
                                        }
                                        case openapi4j: {
                                            atteso = "Content-Type '" + contentTypeTest11 + "' unsupported";
                                            break;
                                        }
                                        case swagger_request_validator: {
                                            if (httpEntityTest11.getContent() != null) {
                                                atteso = "[ERROR][REQUEST][POST /documenti/norequestresponse/send] No request body is expected but one was found.";
                                                break;
                                            }
                                            atteso = "Content-Type '" + contentTypeTest11 + "' unsupported";
                                            break;
                                        }
                                    }
                                    if (atteso != null && !msg.contains((CharSequence)atteso)) {
                                        String checkErrore = "Validazione richiesta con content-type '" + contentTypeTest11 + "' " + (String)tipoTest6 + " contenuto terminato con un errore diverso da quello atteso: '" + msg + "'";
                                        System.out.println("\t " + checkErrore);
                                        System.out.println("\tatteso: " + (String)atteso);
                                        throw new Exception(checkErrore);
                                    }
                                    System.out.println("\t Validazione richiesta con content-type '" + contentTypeTest11 + "' " + (String)tipoTest6 + " contenuto terminato con l'errore atteso: " + msg);
                                }
                                if (esito5) {
                                    System.out.println("\t Validazione richiesta con content-type '" + contentTypeTest11 + "' " + (String)tipoTest6 + " contenuto: atteso errore");
                                    throw new Exception("Validazione richiesta con content-type '" + contentTypeTest11 + "' " + (String)tipoTest6 + " contenuto: atteso errore");
                                }
                                ++i42;
                            }
                            break;
                        }
                        block271: while (true) {
                            if (!i42.hasNext()) {
                                System.out.println("Test #11 completato\n\n");
                                System.out.println("Test #12 (Richiesta POST senza contenuto /documenti/in-line/send[Optional/Required]  (Request Body 'required'))");
                                testUrl12_default = baseUri + "/documenti/in-line/send";
                                httpEntity12_default = new TextHttpRequestEntity();
                                httpEntity12_default.setMethod(HttpRequestMethod.POST);
                                httpEntity12_default.setUrl(testUrl12_default);
                                parametersTrasporto12_default = new HashMap<String, List<String>>();
                                httpEntity12_default.setHeaders(parametersTrasporto12_default);
                                String testUrl12_optional = baseUri + "/documenti/in-line/sendOptional";
                                httpEntity12_optional = new TextHttpRequestEntity();
                                httpEntity12_optional.setMethod(HttpRequestMethod.POST);
                                httpEntity12_optional.setUrl(testUrl12_optional);
                                parametersTrasporto12_optional = new HashMap<String, List<String>>();
                                httpEntity12_optional.setHeaders(parametersTrasporto12_optional);
                                String testUrl12_required = baseUri + "/documenti/in-line/sendRequired";
                                httpEntity12_required = new TextHttpRequestEntity();
                                httpEntity12_required.setMethod(HttpRequestMethod.POST);
                                httpEntity12_required.setUrl(testUrl12_required);
                                parametersTrasporto12_required = new HashMap<String, List<String>>();
                                httpEntity12_required.setHeaders(parametersTrasporto12_required);
                                ArrayList<String> contentTypeTest12List = new ArrayList<String>();
                                contentTypeTest12List.add(null);
                                contentTypeTest12List.add("text/plain");
                                contentTypeTest12List.add("application/json");
                                iterator = contentTypeTest12List.iterator();
                                break;
                            }
                            String contentTypeTest11 = (String)i42.next();
                            int i8 = 0;
                            while (true) {
                                if (i8 >= 2) continue block271;
                                boolean addContenuto = i8 == 1;
                                Object tipoTest7 = "senza";
                                if (addContenuto) {
                                    tipoTest7 = "con";
                                }
                                tipoTest7 = "[" + String.valueOf(openAPILibrary) + "] " + (String)tipoTest7;
                                System.out.println("\t Validazione risposta con content-type '" + contentTypeTest11 + "' " + (String)tipoTest7 + " contenuto ...");
                                TransportUtils.setHeader(parametersTrasportoRispostaTest11, "Content-Type", contentTypeTest11);
                                httpEntityResponseTest11.setContentType(contentTypeTest11);
                                httpEntityResponseTest11.setHeaders(parametersTrasportoRispostaTest11);
                                if (addContenuto) {
                                    httpEntityResponseTest11.setContent(jsonTest11);
                                } else {
                                    httpEntityResponseTest11.setContent(null);
                                }
                                boolean esito6 = false;
                                try {
                                    apiValidatorOpenApi2.validate(httpEntityResponseTest11);
                                    esito6 = true;
                                }
                                catch (Exception e9) {
                                    String msg = e9.getMessage();
                                    Object atteso = null;
                                    switch (openAPILibrary) {
                                        case json_schema: {
                                            atteso = "Content-Type '" + contentTypeTest11 + "' (http response status '201') unsupported";
                                            break;
                                        }
                                        case openapi4j: {
                                            atteso = "Content type '" + contentTypeTest11 + "' is not allowed for body content. (code: 203)";
                                            break;
                                        }
                                        case swagger_request_validator: {
                                            if (addContenuto) {
                                                atteso = "[ERROR][RESPONSE][] No response body is expected but one was found.";
                                                break;
                                            }
                                            atteso = "Content-Type '" + contentTypeTest11 + "' (http response status '201') unsupported";
                                            break;
                                        }
                                    }
                                    if (atteso != null && !msg.contains((CharSequence)atteso)) {
                                        String checkErrore = "Atteso errore: '" + (String)atteso + "'\nValidazione risposta con content-type '" + contentTypeTest11 + "' " + (String)tipoTest7 + " contenuto terminato con un errore diverso da quello atteso: '" + msg + "'";
                                        System.out.println("\t " + checkErrore);
                                        throw new Exception(checkErrore);
                                    }
                                    System.out.println("\t Validazione risposta con content-type '" + contentTypeTest11 + "' " + (String)tipoTest7 + " contenuto terminato con l'errore atteso: " + msg);
                                }
                                if (esito6) {
                                    System.out.println("\t Validazione risposta con content-type '" + contentTypeTest11 + "' " + (String)tipoTest7 + " contenuto: atteso errore");
                                    throw new Exception("Validazione risposta con content-type '" + contentTypeTest11 + "' " + (String)tipoTest7 + " contenuto: atteso errore");
                                }
                                ++i8;
                            }
                            break;
                        }
                        do {
                            if (!iterator.hasNext()) {
                                System.out.println("Test #12 completato\n\n");
                                System.out.println("Test #13 (Richiesta POST con parametro /documenti/datetest e elemento valido/nonValido secondo il pattern definito per la data in RFC 3339, section 5.6)");
                                testUrl13 = baseUri + "/documenti/datetest/";
                                valori_test13 = new ArrayList<String>();
                                esiti_test13 = new ArrayList<Boolean>();
                                valori_test13.add("2020-07-22");
                                esiti_test13.add(true);
                                valori_test13.add("2020 07 21");
                                esiti_test13.add(false);
                                valori_test13.add("2020/07/21");
                                esiti_test13.add(false);
                                valori_test13.add("20200721");
                                esiti_test13.add(false);
                                valori_test13.add("2020-07");
                                esiti_test13.add(false);
                                valori_test13.add("2017-07-21T17:32:28");
                                esiti_test13.add(false);
                                valori_test13.add("2017-07-21T17:32:28Z");
                                esiti_test13.add(false);
                                valori_test13.add("2017-07-21T17:32:28+01:00");
                                esiti_test13.add(false);
                                sizeTest13Originali = valori_test13.size();
                                break block607;
                            }
                            String contentTypeTest12 = (String)iterator.next();
                            String tipoTestPrefix = "Content-Type:'" + contentTypeTest12 + "' ";
                            TransportUtils.setHeader(parametersTrasporto12_default, "Content-Type", contentTypeTest12);
                            httpEntity12_default.setContentType(contentTypeTest12);
                            TransportUtils.setHeader(parametersTrasporto12_optional, "Content-Type", contentTypeTest12);
                            httpEntity12_optional.setContentType(contentTypeTest12);
                            TransportUtils.setHeader(parametersTrasporto12_required, "Content-Type", contentTypeTest12);
                            httpEntity12_required.setContentType(contentTypeTest12);
                            for (int i9 = 0; i9 < 3; ++i9) {
                                String tipoTest8 = tipoTestPrefix;
                                tipoTest8 = tipoTest8 + "[" + String.valueOf(openAPILibrary) + "]";
                                TextHttpRequestEntity httpEntity12 = null;
                                boolean required = false;
                                if (i9 == 0) {
                                    httpEntity12 = httpEntity12_default;
                                    tipoTest8 = tipoTest8 + " (required:default)";
                                } else if (i9 == 1) {
                                    httpEntity12 = httpEntity12_optional;
                                    tipoTest8 = tipoTest8 + " (required:false)";
                                } else if (i9 == 2) {
                                    httpEntity12 = httpEntity12_required;
                                    required = true;
                                    tipoTest8 = tipoTest8 + " (required:true)";
                                }
                                System.out.println("\t Validazione richiesta senza contenuto " + tipoTest8 + "  ...");
                                boolean esito7 = false;
                                try {
                                    apiValidatorOpenApi2.validate(httpEntity12);
                                    esito7 = true;
                                }
                                catch (Exception e10) {
                                    void var70_162;
                                    String msg = e10.getMessage();
                                    if (msg == null || "null".equals(msg)) {
                                        e10.printStackTrace(System.out);
                                    }
                                    if (!required && contentTypeTest12 == null) {
                                        String string = "Validazione richiesta " + tipoTest8 + " senza contenuto terminato con un errore non atteso: '" + msg + "'";
                                        System.out.println("\t " + string);
                                        throw new Exception(string);
                                    }
                                    Object var70_164 = null;
                                    switch (openAPILibrary) {
                                        case json_schema: {
                                            String string = "Required body undefined";
                                            if (required || contentTypeTest12 == null) break;
                                            String string2 = "Content-Type '" + contentTypeTest12 + "' unsupported";
                                            if (!"application/json".equals(contentTypeTest12)) break;
                                            String string3 = "Content undefined";
                                            break;
                                        }
                                        case openapi4j: {
                                            String string = "Body is required but none provided. (code: 200)";
                                            if (required || contentTypeTest12 == null) break;
                                            String string4 = "Content-Type '" + contentTypeTest12 + "' unsupported";
                                            break;
                                        }
                                        case swagger_request_validator: {
                                            if (httpEntity12.getContentType() == null) {
                                                String string = "Required Content-Type is missing";
                                            } else {
                                                String string = "A request body is required but none found.";
                                            }
                                            if (required || contentTypeTest12 == null) break;
                                            String string = "Request Content-Type header '[text/plain]' does not match any allowed types. Must be one of: [application/json].";
                                            break;
                                        }
                                    }
                                    if (var70_162 != null && !msg.contains((CharSequence)var70_162)) {
                                        String string = "Validazione richiesta " + tipoTest8 + " senza contenuto terminato con un errore diverso da quello atteso: '" + msg + "'";
                                        System.out.println("\t " + string);
                                        throw new Exception(string);
                                    }
                                    System.out.println("\t Validazione richiesta " + tipoTest8 + " senza contenuto terminato con l'errore atteso: " + msg);
                                }
                                if (required) {
                                    if (!esito7) continue;
                                    System.out.println("\t Validazione richiesta " + tipoTest8 + " senza contenuto: atteso errore");
                                    throw new Exception("Validazione richiesta " + tipoTest8 + " senza contenuto: atteso errore");
                                }
                                System.out.println("\t Validazione richiesta senza contenuto " + tipoTest8 + " ok");
                            }
                            TextHttpResponseEntity httpEntityResponseTest12 = new TextHttpResponseEntity();
                            httpEntityResponseTest12.setStatus(200);
                            httpEntityResponseTest12.setMethod(HttpRequestMethod.POST);
                            httpEntityResponseTest12.setUrl(testUrl12_default);
                            HashMap<String, List<String>> parametersTrasportoRispostaTest12 = new HashMap<String, List<String>>();
                            httpEntityResponseTest12.setHeaders(parametersTrasportoRispostaTest12);
                            tipoTest3 = tipoTestPrefix;
                            tipoTest3 = tipoTest3 + "[" + String.valueOf(openAPILibrary) + "]";
                            System.out.println("\t Validazione risposta senza contenuto " + tipoTest3 + "  " + httpEntityResponseTest12.getUrl() + " ...");
                            esito = false;
                            try {
                                apiValidatorOpenApi2.validate(httpEntityResponseTest12);
                                esito = true;
                            }
                            catch (Exception e11) {
                                String msg = e11.getMessage();
                                String atteso = null;
                                switch (openAPILibrary) {
                                    case json_schema: {
                                        atteso = "Required body undefined";
                                        break;
                                    }
                                    case openapi4j: {
                                        atteso = "Content type 'null' is not allowed for body content. (code: 203)";
                                        break;
                                    }
                                    case swagger_request_validator: {
                                        atteso = "Required Content-Type is missing";
                                        break;
                                    }
                                }
                                if (atteso != null && !msg.contains(atteso)) {
                                    String string = "Validazione " + tipoTest3 + " senza contenuto terminato con un errore diverso da quello atteso: '" + msg + "'";
                                    System.out.println("\t " + string);
                                    throw new Exception(string);
                                }
                                System.out.println("\t Validazione risposta " + tipoTest3 + " senza contenuto terminato con l'errore atteso: " + msg);
                            }
                        } while (!esito);
                        System.out.println("\t Validazione risposta " + tipoTest3 + " senza contenuto: atteso errore");
                        throw new Exception("Validazione risposta " + tipoTest3 + " senza contenuto: atteso errore");
                    }
                    for (int i10 = 0; i10 < sizeTest13Originali; ++i10) {
                        String valueUpperCase2 = (String)valori_test13.get(i10);
                        if (!valueUpperCase2.contains("Z")) continue;
                        String valueLowerCase = valueUpperCase2.replace("Z", "z");
                        boolean esito = (Boolean)esiti_test13.get(i10);
                        if (openAPILibrary == OpenAPILibrary.swagger_request_validator) {
                            valori_test13.add(valueLowerCase);
                            esiti_test13.add(esito);
                            continue;
                        }
                        valori_test13.add(valueLowerCase);
                        esiti_test13.add(false);
                    }
                    int indiceDoveAbilitareCaseInsensitiveTest13 = Integer.MAX_VALUE;
                    int indiceDoveAbilitareCaseInsensitiveAndSpaceTest13 = Integer.MAX_VALUE;
                    if (openAPILibrary != OpenAPILibrary.swagger_request_validator) {
                        String valueLowerCase;
                        int i11;
                        indiceDoveAbilitareCaseInsensitiveTest13 = valori_test13.size();
                        for (i11 = 0; i11 < sizeTest13Originali; ++i11) {
                            String valueUpperCase3 = (String)valori_test13.get(i11);
                            if (!valueUpperCase3.contains("Z")) continue;
                            valueLowerCase = valueUpperCase3.replace("Z", "z");
                            boolean esito = (Boolean)esiti_test13.get(i11);
                            valori_test13.add(valueLowerCase);
                            esiti_test13.add(esito);
                        }
                        indiceDoveAbilitareCaseInsensitiveAndSpaceTest13 = valori_test13.size();
                        for (i11 = 0; i11 < sizeTest13Originali; ++i11) {
                            String valueUpperCase4 = (String)valori_test13.get(i11);
                            if (!valueUpperCase4.contains("Z")) continue;
                            valueLowerCase = valueUpperCase4.replace("Z", "z");
                            boolean esito = (Boolean)esiti_test13.get(i11);
                            valori_test13.add(valueLowerCase);
                            esiti_test13.add(esito);
                        }
                    }
                    for (i3 = 0; i3 < valori_test13.size(); ++i3) {
                        boolean esito;
                        String valore;
                        block608: {
                            if (i3 >= indiceDoveAbilitareCaseInsensitiveAndSpaceTest13) {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, true);
                            } else if (i3 >= indiceDoveAbilitareCaseInsensitiveTest13) {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, false);
                            } else {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, defaultDateTimeAllowLowerCaseTZ, defaultDateTimeAllowSpaceSeparator);
                            }
                            valore = (String)valori_test13.get(i3);
                            esito = (Boolean)esiti_test13.get(i3);
                            TextHttpRequestEntity httpEntity13 = new TextHttpRequestEntity();
                            httpEntity13.setMethod(HttpRequestMethod.POST);
                            httpEntity13.setUrl(testUrl13 + "2020-07-21");
                            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                            TransportUtils.setParameter(hashMap, "data_documento_query", "2020-07-19");
                            httpEntity13.setParameters(hashMap);
                            HashMap<String, List<String>> hashMap2 = new HashMap<String, List<String>>();
                            TransportUtils.setHeader(hashMap2, "Content-Type", "application/json");
                            TransportUtils.setHeader(hashMap2, "data_documento_header", "2020-07-23");
                            httpEntity13.setHeaders(hashMap2);
                            httpEntity13.setContentType("application/json");
                            json13 = "{\"data\": \"" + valore + "\"}";
                            httpEntity13.setContent(json13);
                            tipoTest2 = esito ? "[body con valore ok '" + valore + "']" : "[body con valore errato '" + valore + "']";
                            tipoTest2 = tipoTest2 + "[" + String.valueOf(openAPILibrary) + "]";
                            try {
                                System.out.println("\t " + tipoTest2 + " validate ...");
                                apiValidatorOpenApi2.validate(httpEntity13);
                                if (!esito) {
                                    System.out.println("\t " + tipoTest2 + " ERRORE!");
                                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                }
                                System.out.println("\t " + tipoTest2 + " validate ok");
                            }
                            catch (ValidatorException e12) {
                                void var75_214;
                                String string = e12.getMessage();
                                if (string.length() > 200) {
                                    String string5 = string.substring(0, 198) + " ...";
                                }
                                if (esito) {
                                    System.out.println("\t " + tipoTest2 + " rilevato errore di validazione non atteso: " + (String)var75_214);
                                    throw new Exception(tipoTest2 + " rilevato errore di validazione non atteso: " + e12.getMessage(), e12);
                                }
                                System.out.println("\t " + tipoTest2 + " atteso errore di validazione, rilevato: " + (String)var75_214);
                                msgErroreAtteso5 = null;
                                switch (openAPILibrary) {
                                    case json_schema: {
                                        msgErroreAtteso5 = "1009 $.data: does not match the date pattern must be a valid RFC 3339 full-date";
                                        break;
                                    }
                                    case openapi4j: {
                                        msgErroreAtteso5 = "body.data: Value '" + valore + "' does not match format 'date'. (code: 1007)";
                                        break;
                                    }
                                    case swagger_request_validator: {
                                        msgErroreAtteso5 = "[ERROR][REQUEST][POST /documenti/datetest/2020-07-21 @body] [Path '/data'] String \"" + valore + "\" is invalid against requested date format(s) yyyy-MM-dd";
                                        break;
                                    }
                                }
                                if (msgErroreAtteso5 == null || e12.getMessage().contains((CharSequence)msgErroreAtteso5)) break block608;
                                System.out.println("\t " + tipoTest2 + " ERRORE!");
                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso5 + "'");
                            }
                        }
                        httpEntityResponseTest13 = new TextHttpResponseEntity();
                        httpEntityResponseTest13.setStatus(200);
                        httpEntityResponseTest13.setMethod(HttpRequestMethod.POST);
                        httpEntityResponseTest13.setUrl(testUrl13 + "2020-07-21");
                        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                        httpEntityResponseTest13.setHeaders(hashMap);
                        TransportUtils.setHeader(hashMap, "Content-Type", "application/json");
                        TransportUtils.setHeader(hashMap, "data_documento_risposta_header", "2020-07-23");
                        httpEntityResponseTest13.setContentType("application/json");
                        httpEntityResponseTest13.setContent(json13);
                        tipoTest2 = esito ? "[body response con valore ok '" + valore + "']" : "[body response con valore errato '" + valore + "']";
                        tipoTest2 = tipoTest2 + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest2 + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntityResponseTest13);
                            if (!esito) {
                                System.out.println("\t " + tipoTest2 + " ERRORE!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            System.out.println("\t " + tipoTest2 + " validate ok");
                            continue;
                        }
                        catch (ValidatorException e13) {
                            void var78_261;
                            error2 = e13.getMessage();
                            if (((String)error2).length() > 200) {
                                error2 = ((String)error2).substring(0, 198) + " ...";
                            }
                            if (esito) {
                                System.out.println("\t " + tipoTest2 + " rilevato errore di validazione non atteso: " + (String)error2);
                                throw new Exception(tipoTest2 + " rilevato errore di validazione non atteso: " + e13.getMessage(), e13);
                            }
                            System.out.println("\t " + tipoTest2 + " atteso errore di validazione, rilevato: " + (String)error2);
                            Object var78_262 = null;
                            switch (openAPILibrary) {
                                case json_schema: {
                                    String string = "1009 $.data: does not match the date pattern must be a valid RFC 3339 full-date";
                                    break;
                                }
                                case openapi4j: {
                                    String string = "body.data: Value '" + valore + "' does not match format 'date'. (code: 1007)";
                                    break;
                                }
                                case swagger_request_validator: {
                                    String string = "[ERROR][RESPONSE][] [Path '/data'] String \"" + valore + "\" is invalid against requested date format(s) yyyy-MM-dd";
                                    break;
                                }
                            }
                            if (var78_261 == null || e13.getMessage().contains((CharSequence)var78_261)) continue;
                            System.out.println("\t " + tipoTest2 + " ERRORE!");
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)var78_261 + "'");
                        }
                    }
                    for (i3 = 0; i3 < valori_test13.size(); ++i3) {
                        boolean esito;
                        String valore;
                        block609: {
                            if (i3 >= indiceDoveAbilitareCaseInsensitiveAndSpaceTest13) {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, true);
                            } else if (i3 >= indiceDoveAbilitareCaseInsensitiveTest13) {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, false);
                            } else {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, defaultDateTimeAllowLowerCaseTZ, defaultDateTimeAllowSpaceSeparator);
                            }
                            valore = (String)valori_test13.get(i3);
                            esito = (Boolean)esiti_test13.get(i3);
                            TextHttpRequestEntity httpEntity13 = new TextHttpRequestEntity();
                            httpEntity13.setMethod(HttpRequestMethod.POST);
                            httpEntity13.setUrl(testUrl13 + "2020-07-21");
                            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                            TransportUtils.setParameter(hashMap, "data_documento_query", "2020-07-19");
                            httpEntity13.setParameters(hashMap);
                            HashMap<String, List<String>> hashMap3 = new HashMap<String, List<String>>();
                            TransportUtils.setHeader(hashMap3, "Content-Type", "application/json");
                            TransportUtils.setHeader(hashMap3, "data_documento_header", valore);
                            httpEntity13.setHeaders(hashMap3);
                            httpEntity13.setContentType("application/json");
                            json13 = "{\"data\": \"2020-07-20\"}";
                            httpEntity13.setContent(json13);
                            tipoTest2 = esito ? "[header con valore ok '" + valore + "']" : "[header con valore errato '" + valore + "']";
                            tipoTest2 = tipoTest2 + "[" + String.valueOf(openAPILibrary) + "]";
                            try {
                                System.out.println("\t " + tipoTest2 + " validate ...");
                                apiValidatorOpenApi2.validate(httpEntity13);
                                if (!esito) {
                                    System.out.println("\t " + tipoTest2 + " ERRORE!");
                                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                }
                                System.out.println("\t " + tipoTest2 + " validate ok");
                            }
                            catch (ValidatorException e14) {
                                void var75_219;
                                String string = e14.getMessage();
                                if (string.length() > 200) {
                                    String string6 = string.substring(0, 198) + " ...";
                                }
                                if (esito) {
                                    System.out.println("\t " + tipoTest2 + " rilevato errore di validazione non atteso: " + (String)var75_219);
                                    throw new Exception(tipoTest2 + " rilevato errore di validazione non atteso: " + e14.getMessage(), e14);
                                }
                                System.out.println("\t " + tipoTest2 + " atteso errore di validazione, rilevato: " + (String)var75_219);
                                msgErroreAtteso5 = null;
                                switch (openAPILibrary) {
                                    case json_schema: {
                                        msgErroreAtteso5 = "Invalid value '" + valore + "' in http header 'data_documento_header' (expected type 'date'): Found date '" + valore + "' has wrong format (see RFC 3339, section 5.6): Uncorrect format";
                                        break;
                                    }
                                    case openapi4j: {
                                        msgErroreAtteso5 = "data_documento_header: Value '" + valore + "' does not match format 'date'. (code: 1007)";
                                        break;
                                    }
                                    case swagger_request_validator: {
                                        msgErroreAtteso5 = "[ERROR][REQUEST][POST /documenti/datetest/2020-07-21 @header.data_documento_header] String \"" + valore + "\" is invalid against requested date format(s)";
                                        break;
                                    }
                                }
                                if (msgErroreAtteso5 == null || e14.getMessage().contains((CharSequence)msgErroreAtteso5)) break block609;
                                System.out.println("\t " + tipoTest2 + " ERRORE!");
                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso5 + "'");
                            }
                        }
                        httpEntityResponseTest13 = new TextHttpResponseEntity();
                        httpEntityResponseTest13.setStatus(200);
                        httpEntityResponseTest13.setMethod(HttpRequestMethod.POST);
                        httpEntityResponseTest13.setUrl(testUrl13 + "2020-07-21");
                        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                        httpEntityResponseTest13.setHeaders(hashMap);
                        TransportUtils.setHeader(hashMap, "Content-Type", "application/json");
                        TransportUtils.setHeader(hashMap, "data_documento_risposta_header", valore);
                        httpEntityResponseTest13.setContentType("application/json");
                        httpEntityResponseTest13.setContent(json13);
                        tipoTest2 = esito ? "[header response con valore ok '" + valore + "']" : "[header response con valore errato '" + valore + "']";
                        tipoTest2 = tipoTest2 + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest2 + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntityResponseTest13);
                            if (!esito) {
                                System.out.println("\t " + tipoTest2 + " ERRORE!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            System.out.println("\t " + tipoTest2 + " validate ok");
                            continue;
                        }
                        catch (ValidatorException e15) {
                            void var78_271;
                            error2 = e15.getMessage();
                            if (((String)error2).length() > 200) {
                                error2 = ((String)error2).substring(0, 198) + " ...";
                            }
                            if (esito) {
                                System.out.println("\t " + tipoTest2 + " rilevato errore di validazione non atteso: " + (String)error2);
                                throw new Exception(tipoTest2 + " rilevato errore di validazione non atteso: " + e15.getMessage(), e15);
                            }
                            System.out.println("\t " + tipoTest2 + " atteso errore di validazione, rilevato: " + (String)error2);
                            Object var78_267 = null;
                            switch (openAPILibrary) {
                                case json_schema: {
                                    String string = "Invalid value '" + valore + "' in http header 'data_documento_risposta_header' (expected type 'date'): Found date '" + valore + "' has wrong format (see RFC 3339, section 5.6): Uncorrect format";
                                    break;
                                }
                                case openapi4j: {
                                    String string = "data_documento_risposta_header: Value '" + valore + "' does not match format 'date'. (code: 1007)";
                                    break;
                                }
                                case swagger_request_validator: {
                                    String string = "[ERROR][RESPONSE][] String \"" + valore + "\" is invalid against requested date format(s) yyyy-MM-dd";
                                    break;
                                }
                            }
                            if (var78_271 == null || e15.getMessage().contains((CharSequence)var78_271)) continue;
                            System.out.println("\t " + tipoTest2 + " ERRORE!");
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)var78_271 + "'");
                        }
                    }
                    for (i3 = 0; i3 < valori_test13.size(); ++i3) {
                        if (i3 >= indiceDoveAbilitareCaseInsensitiveAndSpaceTest13) {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, true);
                        } else if (i3 >= indiceDoveAbilitareCaseInsensitiveTest13) {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, false);
                        } else {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, defaultDateTimeAllowLowerCaseTZ, defaultDateTimeAllowSpaceSeparator);
                        }
                        String valore = (String)valori_test13.get(i3);
                        boolean esito = (Boolean)esiti_test13.get(i3);
                        TextHttpRequestEntity httpEntity13 = new TextHttpRequestEntity();
                        httpEntity13.setMethod(HttpRequestMethod.POST);
                        httpEntity13.setUrl(testUrl13 + "2020-07-21");
                        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                        TransportUtils.setParameter(hashMap, "data_documento_query", valore);
                        httpEntity13.setParameters(hashMap);
                        HashMap<String, List<String>> hashMap4 = new HashMap<String, List<String>>();
                        TransportUtils.setHeader(hashMap4, "Content-Type", "application/json");
                        TransportUtils.setHeader(hashMap4, "data_documento_header", "2020-07-19");
                        httpEntity13.setHeaders(hashMap4);
                        httpEntity13.setContentType("application/json");
                        json13 = "{\"data\": \"2020-07-20\"}";
                        httpEntity13.setContent(json13);
                        tipoTest2 = esito ? "[query parameter con valore ok '" + valore + "']" : "[query parameter con valore errato '" + valore + "']";
                        tipoTest2 = tipoTest2 + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest2 + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntity13);
                            if (!esito) {
                                System.out.println("\t " + tipoTest2 + " ERRORE!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            System.out.println("\t " + tipoTest2 + " validate ok");
                            continue;
                        }
                        catch (ValidatorException e16) {
                            void var75_225;
                            String string = e16.getMessage();
                            if (string.length() > 200) {
                                String string7 = string.substring(0, 198) + " ...";
                            }
                            if (esito) {
                                System.out.println("\t " + tipoTest2 + " rilevato errore di validazione non atteso: " + (String)var75_225);
                                throw new Exception(tipoTest2 + " rilevato errore di validazione non atteso: " + e16.getMessage(), e16);
                            }
                            System.out.println("\t " + tipoTest2 + " atteso errore di validazione, rilevato: " + (String)var75_225);
                            msgErroreAtteso5 = null;
                            switch (openAPILibrary) {
                                case json_schema: {
                                    msgErroreAtteso5 = "Invalid value '" + valore + "' in query parameter 'data_documento_query' (expected type 'date'): Found date '" + valore + "' has wrong format (see RFC 3339, section 5.6): Uncorrect format";
                                    break;
                                }
                                case openapi4j: {
                                    msgErroreAtteso5 = "data_documento_query: Value '" + valore + "' does not match format 'date'. (code: 1007)";
                                    break;
                                }
                                case swagger_request_validator: {
                                    msgErroreAtteso5 = "[ERROR][REQUEST][POST /documenti/datetest/2020-07-21 @query.data_documento_query] String \"" + valore + "\" is invalid against requested date format(s) ";
                                    break;
                                }
                            }
                            if (msgErroreAtteso5 == null || e16.getMessage().contains((CharSequence)msgErroreAtteso5)) continue;
                            System.out.println("\t " + tipoTest2 + " ERRORE!");
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso5 + "'");
                        }
                    }
                    for (i3 = 0; i3 < valori_test13.size(); ++i3) {
                        if (i3 >= indiceDoveAbilitareCaseInsensitiveAndSpaceTest13) {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, true);
                        } else if (i3 >= indiceDoveAbilitareCaseInsensitiveTest13) {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, false);
                        } else {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, defaultDateTimeAllowLowerCaseTZ, defaultDateTimeAllowSpaceSeparator);
                        }
                        String valore = (String)valori_test13.get(i3);
                        boolean esito = (Boolean)esiti_test13.get(i3);
                        if (valore.contains(" ") || valore.contains("/")) continue;
                        TextHttpRequestEntity httpEntity13 = new TextHttpRequestEntity();
                        httpEntity13.setMethod(HttpRequestMethod.POST);
                        httpEntity13.setUrl(testUrl13 + valore);
                        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                        TransportUtils.setParameter(hashMap, "data_documento_query", "2020-07-21");
                        httpEntity13.setParameters(hashMap);
                        HashMap<String, List<String>> hashMap5 = new HashMap<String, List<String>>();
                        TransportUtils.setHeader(hashMap5, "Content-Type", "application/json");
                        TransportUtils.setHeader(hashMap5, "data_documento_header", "2020-07-19");
                        httpEntity13.setHeaders(hashMap5);
                        httpEntity13.setContentType("application/json");
                        json13 = "{\"data\": \"2020-07-20\"}";
                        httpEntity13.setContent(json13);
                        tipoTest2 = esito ? "[path parameter con valore ok '" + valore + "']" : "[path parameter con valore errato '" + valore + "']";
                        tipoTest2 = tipoTest2 + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest2 + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntity13);
                            if (!esito) {
                                System.out.println("\t " + tipoTest2 + " ERRORE!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            System.out.println("\t " + tipoTest2 + " validate ok");
                            continue;
                        }
                        catch (ValidatorException e17) {
                            void var75_229;
                            String string = e17.getMessage();
                            if (string.length() > 200) {
                                String string8 = string.substring(0, 198) + " ...";
                            }
                            if (esito) {
                                System.out.println("\t " + tipoTest2 + " rilevato errore di validazione non atteso: " + (String)var75_229);
                                throw new Exception(tipoTest2 + " rilevato errore di validazione non atteso: " + e17.getMessage(), e17);
                            }
                            System.out.println("\t " + tipoTest2 + " atteso errore di validazione, rilevato: " + (String)var75_229);
                            msgErroreAtteso5 = null;
                            switch (openAPILibrary) {
                                case json_schema: {
                                    msgErroreAtteso5 = "Invalid value '" + valore + "' in dynamic path 'data_documento_path' (expected type 'date'): Found date '" + valore + "' has wrong format (see RFC 3339, section 5.6): Uncorrect format";
                                    break;
                                }
                                case openapi4j: {
                                    msgErroreAtteso5 = "data_documento_path: Value '" + valore + "' does not match format 'date'. (code: 1007)\nFrom: data_documento_path.<format>";
                                    break;
                                }
                                case swagger_request_validator: {
                                    msgErroreAtteso5 = "Invalid value '" + valore + "' in dynamic path 'data_documento_path' (expected type 'date'): Found date '" + valore + "' has wrong format (see RFC 3339, section 5.6): Uncorrect format";
                                    break;
                                }
                            }
                            if (msgErroreAtteso5 == null || e17.getMessage().contains((CharSequence)msgErroreAtteso5)) continue;
                            System.out.println("\t " + tipoTest2 + " ERRORE!");
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso5 + "'");
                        }
                    }
                    OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, defaultDateTimeAllowLowerCaseTZ, defaultDateTimeAllowSpaceSeparator);
                    System.out.println("Test #13 completato\n\n");
                    System.out.println("Test #14 (Richiesta POST con parametro /documenti/datetimetest e elemento valido/nonValido secondo il pattern definito per la data in RFC 3339, section 5.6)");
                    String testUrl14 = baseUri + "/documenti/datetimetest/";
                    ArrayList<String> valori_test14 = new ArrayList<String>();
                    ArrayList<Boolean> esiti_test14 = new ArrayList<Boolean>();
                    valori_test14.add("2017-07-21T17:32:28");
                    esiti_test14.add(false);
                    valori_test14.add("2017-07-21T17:32:28.000");
                    esiti_test14.add(false);
                    valori_test14.add("2017-07-21T17:32:28+0100");
                    esiti_test14.add(false);
                    valori_test14.add("2017-07-21T17:32:28Z");
                    esiti_test14.add(true);
                    valori_test14.add("2017-07-21T17:32:28+01:00");
                    esiti_test14.add(true);
                    valori_test14.add("2017-07-21T17:32:27-02:00");
                    esiti_test14.add(true);
                    valori_test14.add("2017-07-21T17:32:28.303Z");
                    esiti_test14.add(true);
                    valori_test14.add("2017-07-21T17:32:28.929+01:00");
                    esiti_test14.add(true);
                    valori_test14.add("2017-07-21T17:32:27.123-02:00");
                    esiti_test14.add(true);
                    valori_test14.add("2020-07-22");
                    esiti_test14.add(false);
                    valori_test14.add("2017-07-21 17:32:28");
                    esiti_test14.add(false);
                    valori_test14.add("2017/07/21T17:32:28");
                    esiti_test14.add(false);
                    valori_test14.add("2017 07 21T17:32:28");
                    esiti_test14.add(false);
                    valori_test14.add("2017-07-21T17 32 28");
                    esiti_test14.add(false);
                    valori_test14.add("2017-07-21T173228");
                    esiti_test14.add(false);
                    valori_test14.add("2017-07-21T17:32:28 01:00");
                    esiti_test14.add(false);
                    valori_test14.add("2017-07-21T17:32:28+01");
                    esiti_test14.add(false);
                    int sizeTest14Originali = valori_test14.size();
                    boolean bl = false;
                    while (var70_184 < sizeTest14Originali) {
                        String valueLowerCase;
                        String string = (String)valori_test14.get((int)var70_184);
                        if (string.contains("T")) {
                            valueLowerCase = string.replace("T", "t");
                            valori_test14.add(valueLowerCase);
                            esiti_test14.add(false);
                        }
                        if (string.contains("Z")) {
                            valueLowerCase = string.replace("Z", "z");
                            valori_test14.add(valueLowerCase);
                            esiti_test14.add(false);
                        }
                        if (string.contains("T")) {
                            valueLowerCase = string.replace("T", " ");
                            valori_test14.add(valueLowerCase);
                            esiti_test14.add(false);
                        }
                        ++var70_184;
                    }
                    int n = Integer.MAX_VALUE;
                    int n2 = Integer.MAX_VALUE;
                    int indiceDoveAbilitareCaseInsensitiveAndSpaceTest14 = Integer.MAX_VALUE;
                    int n3 = valori_test14.size();
                    for (i2 = 0; i2 < sizeTest14Originali; ++i2) {
                        boolean esito;
                        valueUpperCase = (String)valori_test14.get(i2);
                        if (valueUpperCase.contains("T")) {
                            String string = valueUpperCase.replace("T", "t");
                            esito = (Boolean)esiti_test14.get(i2);
                            valori_test14.add(string);
                            esiti_test14.add(esito);
                        }
                        if (!valueUpperCase.contains("Z")) continue;
                        String string = valueUpperCase.replace("Z", "z");
                        esito = (Boolean)esiti_test14.get(i2);
                        valori_test14.add(string);
                        esiti_test14.add(esito);
                    }
                    int n4 = valori_test14.size();
                    for (i2 = 0; i2 < sizeTest14Originali; ++i2) {
                        valueUpperCase = (String)valori_test14.get(i2);
                        if (!valueUpperCase.contains("T")) continue;
                        String string = valueUpperCase.replace("T", " ");
                        boolean esito = (Boolean)esiti_test14.get(i2);
                        valori_test14.add(string);
                        esiti_test14.add(esito);
                    }
                    indiceDoveAbilitareCaseInsensitiveAndSpaceTest14 = valori_test14.size();
                    for (i2 = 0; i2 < sizeTest14Originali; ++i2) {
                        boolean esito;
                        valueUpperCase = (String)valori_test14.get(i2);
                        if (valueUpperCase.contains("T")) {
                            String string = valueUpperCase.replace("T", "t");
                            esito = (Boolean)esiti_test14.get(i2);
                            valori_test14.add(string);
                            esiti_test14.add(esito);
                        }
                        if (valueUpperCase.contains("Z")) {
                            String string = valueUpperCase.replace("Z", "z");
                            esito = (Boolean)esiti_test14.get(i2);
                            valori_test14.add(string);
                            esiti_test14.add(esito);
                        }
                        if (!valueUpperCase.contains("T")) continue;
                        String string = valueUpperCase.replace("T", " ");
                        esito = (Boolean)esiti_test14.get(i2);
                        valori_test14.add(string);
                        esiti_test14.add(esito);
                    }
                    Set<String> swagger_validator_fallimenti_datetime = Set.of("2017-07-21T17:32:28+0100", "2017-07-21T17:32:28+01", "2017-07-21t17:32:28+0100", "2017-07-21t17:32:28+01", "2017-07-21 17:32:28+0100", "2017-07-21 17:32:28+01");
                    for (i = 0; i < valori_test14.size(); ++i) {
                        boolean esito;
                        String string;
                        block610: {
                            if (i >= indiceDoveAbilitareCaseInsensitiveAndSpaceTest14) {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, true);
                            } else if (i >= n4) {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, false, true);
                            } else if (i >= n3) {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, false);
                            } else {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, defaultDateTimeAllowLowerCaseTZ, defaultDateTimeAllowSpaceSeparator);
                            }
                            string = (String)valori_test14.get(i);
                            esito = (Boolean)esiti_test14.get(i);
                            httpEntity14 = new TextHttpRequestEntity();
                            httpEntity14.setMethod(HttpRequestMethod.POST);
                            httpEntity14.setUrl(testUrl14 + "2020-07-21T17:32:28Z");
                            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                            TransportUtils.setParameter(hashMap, "datetime_documento_query", "2020-07-19T17:32:28Z");
                            httpEntity14.setParameters(hashMap);
                            HashMap<String, List<String>> hashMap6 = new HashMap<String, List<String>>();
                            TransportUtils.setHeader(hashMap6, "Content-Type", "application/json");
                            TransportUtils.setHeader(hashMap6, "datetime_documento_header", "2020-07-23T17:32:28Z");
                            httpEntity14.setHeaders(hashMap6);
                            httpEntity14.setContentType("application/json");
                            json14 = "{\"data\": \"" + string + "\"}";
                            httpEntity14.setContent(json14);
                            tipoTest = esito ? "[body con valore ok '" + string + "']" : "[body con valore errato '" + string + "']";
                            tipoTest = tipoTest + "[" + String.valueOf(openAPILibrary) + "]";
                            try {
                                System.out.println("\t " + tipoTest + " validate ...");
                                apiValidatorOpenApi2.validate(httpEntity14);
                                if (esito) {
                                    System.out.println("\t " + tipoTest + " validate ok");
                                    break block610;
                                }
                                if ((i < 3 || i >= sizeTest14Originali && (string.contains(" ") || string.contains("t") || string.contains("z"))) && openAPILibrary == OpenAPILibrary.json_schema) {
                                    System.out.println("\t " + tipoTest + " validate, la validazione " + String.valueOf(OpenAPILibrary.json_schema) + " non rileva l'accezione!!!!");
                                    continue;
                                }
                                if (openAPILibrary == OpenAPILibrary.swagger_request_validator && swagger_validator_fallimenti_datetime.contains(string)) {
                                    System.out.println("\t " + tipoTest + " validate, la validazione " + String.valueOf(OpenAPILibrary.swagger_request_validator) + " non rileva l'accezione!!!!");
                                    continue;
                                }
                                if (openAPILibrary == OpenAPILibrary.swagger_request_validator && (string.contains("t") || string.contains("z"))) {
                                    System.out.println("\t " + tipoTest + " validate, la validazione " + String.valueOf(OpenAPILibrary.swagger_request_validator) + " accetta i caratteri minuscoli e non \u00e8 possibile disabilitarlo");
                                    continue;
                                }
                                System.out.println("\t " + tipoTest + " ERRORE [" + i + "]!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            catch (ValidatorException e18) {
                                String string9 = e18.getMessage();
                                if (string9.length() > 200) {
                                    String string10 = string9.substring(0, 198) + " ...";
                                }
                                if (!esito) {
                                    System.out.println("\t " + tipoTest + " atteso errore di validazione, rilevato: " + (String)var83_301);
                                } else if (openAPILibrary != OpenAPILibrary.swagger_request_validator) {
                                    System.out.println("\t " + tipoTest + " rilevato errore di validazione non atteso [" + i + "]: " + (String)var83_301);
                                    throw new Exception(tipoTest + " rilevato errore di validazione non atteso [" + i + "] case[" + DateUtils.isDateTimeAllowLowerCaseTZ() + "/" + FormatValidator.isDateTimeAllowLowerCaseTZ() + "] space[" + DateUtils.isDateTimeAllowSpaceSeparator() + "/" + FormatValidator.isDateTimeAllowSpaceSeparator() + "]: " + e18.getMessage(), e18);
                                }
                                msgErroreAtteso4 = null;
                                switch (openAPILibrary) {
                                    case json_schema: {
                                        msgErroreAtteso4 = "$.data: does not match the date-time pattern must be a valid RFC 3339 date-time";
                                        break;
                                    }
                                    case openapi4j: {
                                        msgErroreAtteso4 = "body.data: Value '" + string + "' does not match format 'date-time'. (code: 1007)";
                                        break;
                                    }
                                    case swagger_request_validator: {
                                        msgErroreAtteso4 = "[ERROR][REQUEST][POST /documenti/datetimetest/2020-07-21T17:32:28Z @body] [Path '/data'] String \"" + string + "\" is invalid against requested ";
                                        break;
                                    }
                                }
                                if (msgErroreAtteso4 == null || e18.getMessage().contains((CharSequence)msgErroreAtteso4)) break block610;
                                System.out.println("\t " + tipoTest + " ERRORE!");
                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso4 + "'");
                            }
                        }
                        httpEntityResponseTest14 = new TextHttpResponseEntity();
                        httpEntityResponseTest14.setStatus(200);
                        httpEntityResponseTest14.setMethod(HttpRequestMethod.POST);
                        httpEntityResponseTest14.setUrl(testUrl14 + "2020-07-21T17:32:28Z");
                        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                        httpEntityResponseTest14.setHeaders(hashMap);
                        TransportUtils.setHeader(hashMap, "Content-Type", "application/json");
                        TransportUtils.setHeader(hashMap, "data_documento_risposta_header", "2020-07-23T17:32:28Z");
                        httpEntityResponseTest14.setContentType("application/json");
                        httpEntityResponseTest14.setContent(json14);
                        tipoTest = esito ? "[body response con valore ok '" + string + "']" : "[body response con valore errato '" + string + "']";
                        tipoTest = tipoTest + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntityResponseTest14);
                            if (esito) {
                                System.out.println("\t " + tipoTest + " validate ok");
                                continue;
                            }
                            if (i < 3 && openAPILibrary == OpenAPILibrary.json_schema) {
                                System.out.println("\t " + tipoTest + " validate, la validazione " + String.valueOf(OpenAPILibrary.json_schema) + " non rileva l'accezione!!!!");
                                continue;
                            }
                            if (openAPILibrary == OpenAPILibrary.swagger_request_validator && swagger_validator_fallimenti_datetime.contains(string)) {
                                System.out.println("\t " + tipoTest + " validate, la validazione " + String.valueOf(OpenAPILibrary.swagger_request_validator) + " non rileva l'accezione!!!!");
                                continue;
                            }
                            System.out.println("\t " + tipoTest + " ERRORE!");
                            throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                        }
                        catch (ValidatorException e19) {
                            error = e19.getMessage();
                            if (((String)error).length() > 200) {
                                error = ((String)error).substring(0, 198) + " ...";
                            }
                            if (!esito) {
                                System.out.println("\t " + tipoTest + " atteso errore di validazione, rilevato: " + (String)error);
                            } else if (openAPILibrary != OpenAPILibrary.swagger_request_validator) {
                                System.out.println("\t " + tipoTest + " rilevato errore di validazione non atteso: " + (String)error);
                                throw new Exception(tipoTest + " rilevato errore di validazione non atteso: " + e19.getMessage(), e19);
                            }
                            msgErroreAtteso3 = null;
                            switch (openAPILibrary) {
                                case json_schema: {
                                    msgErroreAtteso3 = "$.data: does not match the date-time pattern must be a valid RFC 3339 date-time";
                                    break;
                                }
                                case openapi4j: {
                                    msgErroreAtteso3 = "body.data: Value '" + string + "' does not match format 'date-time'. (code: 1007)";
                                    break;
                                }
                                case swagger_request_validator: {
                                    msgErroreAtteso3 = "[ERROR][RESPONSE][] [Path '/data'] String \"" + string + "\" is invalid against requested date format(s) [yyyy-MM-dd'T'HH:mm:ssZ, yyyy-MM-dd'T'HH:mm:ss.[0-9]{1,12}Z]";
                                    break;
                                }
                            }
                            if (msgErroreAtteso3 == null || e19.getMessage().contains((CharSequence)msgErroreAtteso3)) continue;
                            System.out.println("\t " + tipoTest + " ERRORE!");
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso3 + "'");
                        }
                    }
                    block287: for (i = 0; i < valori_test14.size(); ++i) {
                        boolean esito;
                        String string;
                        block611: {
                            if (i >= indiceDoveAbilitareCaseInsensitiveAndSpaceTest14) {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, true);
                            } else if (i >= n4) {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, false, true);
                            } else if (i >= n3) {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, false);
                            } else {
                                OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, defaultDateTimeAllowLowerCaseTZ, defaultDateTimeAllowSpaceSeparator);
                            }
                            string = (String)valori_test14.get(i);
                            esito = (Boolean)esiti_test14.get(i);
                            httpEntity14 = new TextHttpRequestEntity();
                            httpEntity14.setMethod(HttpRequestMethod.POST);
                            httpEntity14.setUrl(testUrl14 + "2020-07-21T17:32:28Z");
                            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                            TransportUtils.setParameter(hashMap, "datetime_documento_query", "2020-07-19T17:32:28Z");
                            httpEntity14.setParameters(hashMap);
                            HashMap<String, List<String>> hashMap7 = new HashMap<String, List<String>>();
                            TransportUtils.setHeader(hashMap7, "Content-Type", "application/json");
                            TransportUtils.setHeader(hashMap7, "datetime_documento_header", string);
                            httpEntity14.setHeaders(hashMap7);
                            httpEntity14.setContentType("application/json");
                            json14 = "{\"data\": \"2020-07-20T17:32:28Z\"}";
                            httpEntity14.setContent(json14);
                            tipoTest = esito ? "[header con valore ok '" + string + "']" : "[header con valore errato '" + string + "']";
                            tipoTest = tipoTest + "[" + String.valueOf(openAPILibrary) + "]";
                            try {
                                System.out.println("\t " + tipoTest + " validate ...");
                                apiValidatorOpenApi2.validate(httpEntity14);
                                if (!esito) {
                                    System.out.println("\t " + tipoTest + " ERRORE!");
                                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                }
                                System.out.println("\t " + tipoTest + " validate ok");
                            }
                            catch (ValidatorException e20) {
                                String string11 = e20.getMessage();
                                if (string11.length() > 200) {
                                    String string12 = string11.substring(0, 198) + " ...";
                                }
                                if (!esito) {
                                    System.out.println("\t " + tipoTest + " atteso errore di validazione, rilevato: " + (String)var83_306);
                                } else if (openAPILibrary != OpenAPILibrary.swagger_request_validator) {
                                    System.out.println("\t " + tipoTest + " rilevato errore di validazione non atteso: " + (String)var83_306);
                                    throw new Exception(tipoTest + " rilevato errore di validazione non atteso: " + e20.getMessage(), e20);
                                }
                                msgErroreAtteso4 = null;
                                switch (openAPILibrary) {
                                    case json_schema: {
                                        msgErroreAtteso4 = "Invalid value '" + string + "' in http header 'datetime_documento_header' (expected type 'date-time'): Found dateTime '" + string + "' has wrong format (see RFC 3339, section 5.6): ";
                                        if (!string.contains("T")) {
                                            if (string.contains("t")) {
                                                if (DateUtils.isDateTimeAllowLowerCaseTZ()) {
                                                    msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                                    break;
                                                }
                                                msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'T' separator";
                                                break;
                                            }
                                            if (string.contains(" ")) {
                                                if (string.split(" ").length > 2 && !string.contains(":") && !string.contains("17 32")) {
                                                    if (DateUtils.isDateTimeAllowSpaceSeparator()) {
                                                        msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                                        break;
                                                    }
                                                    msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'full-date T full-time' format";
                                                    break;
                                                }
                                                if (DateUtils.isDateTimeAllowSpaceSeparator()) {
                                                    if (string.split(" ").length > 2) {
                                                        msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'full-date T full-time' format";
                                                        break;
                                                    }
                                                    msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                                    break;
                                                }
                                                msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'T' separator";
                                                break;
                                            }
                                            msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'T' separator";
                                            break;
                                        }
                                        msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                        break;
                                    }
                                    case openapi4j: {
                                        msgErroreAtteso4 = "datetime_documento_header: Value '" + string + "' does not match format 'date-time'. (code: 1007)";
                                        break;
                                    }
                                    case swagger_request_validator: {
                                        if (swagger_validator_fallimenti_datetime.contains(string)) {
                                            System.out.println("\t " + tipoTest + " validate, lo swagger-request-validator non rileva l'accezione!!!!");
                                            continue block287;
                                        }
                                        msgErroreAtteso4 = string.contains("t") && !DateUtils.isDateTimeAllowLowerCaseTZ() && (string.contains("Z") || string.contains("+") || string.contains("-02:00")) ? "Expected 'T' separator" : (string.contains("z") && !DateUtils.isDateTimeAllowLowerCaseTZ() && string.contains("T") ? "Uncorrect format" : "[ERROR][REQUEST][POST /documenti/datetimetest/2020-07-21T17:32:28Z @header.datetime_documento_header] String \"" + string + "\" is invalid against requested date format(s) [yyyy-MM-dd'T'HH:mm:ssZ, yyyy-MM-dd'T'HH:mm:ss.[0-9]{1,12}Z]");
                                    }
                                }
                                if (msgErroreAtteso4 == null || e20.getMessage().contains((CharSequence)msgErroreAtteso4)) break block611;
                                System.out.println("\t " + tipoTest + " ERRORE case[" + DateUtils.isDateTimeAllowLowerCaseTZ() + "] space[" + DateUtils.isDateTimeAllowSpaceSeparator() + "] [" + e20.getMessage() + "]");
                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso4 + "'");
                            }
                        }
                        httpEntityResponseTest14 = new TextHttpResponseEntity();
                        httpEntityResponseTest14.setStatus(200);
                        httpEntityResponseTest14.setMethod(HttpRequestMethod.POST);
                        httpEntityResponseTest14.setUrl(testUrl14 + "2020-07-21T17:32:28Z");
                        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                        httpEntityResponseTest14.setHeaders(hashMap);
                        TransportUtils.setHeader(hashMap, "Content-Type", "application/json");
                        TransportUtils.setHeader(hashMap, "datetime_documento_risposta_header", string);
                        httpEntityResponseTest14.setContentType("application/json");
                        httpEntityResponseTest14.setContent(json14);
                        tipoTest = esito ? "[header response con valore ok '" + string + "']" : "[header response con valore errato '" + string + "']";
                        tipoTest = tipoTest + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntityResponseTest14);
                            if (!esito) {
                                System.out.println("\t " + tipoTest + " ERRORE!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            System.out.println("\t " + tipoTest + " validate ok");
                            continue;
                        }
                        catch (ValidatorException e21) {
                            error = e21.getMessage();
                            if (((String)error).length() > 200) {
                                error = ((String)error).substring(0, 198) + " ...";
                            }
                            if (!esito) {
                                System.out.println("\t " + tipoTest + " atteso errore di validazione, rilevato: " + (String)error);
                            } else if (openAPILibrary != OpenAPILibrary.swagger_request_validator) {
                                System.out.println("\t " + tipoTest + " rilevato errore di validazione non atteso: " + (String)error);
                                throw new Exception(tipoTest + " rilevato errore di validazione non atteso: " + e21.getMessage(), e21);
                            }
                            msgErroreAtteso3 = null;
                            switch (openAPILibrary) {
                                case json_schema: {
                                    msgErroreAtteso3 = "Invalid value '" + string + "' in http header 'datetime_documento_risposta_header' (expected type 'date-time'): Found dateTime '" + string + "' has wrong format (see RFC 3339, section 5.6): ";
                                    if (!string.contains("T")) {
                                        if (string.contains("t")) {
                                            if (DateUtils.isDateTimeAllowLowerCaseTZ()) {
                                                msgErroreAtteso3 = (String)msgErroreAtteso3 + "Uncorrect format";
                                                break;
                                            }
                                            msgErroreAtteso3 = (String)msgErroreAtteso3 + "Expected 'T' separator";
                                            break;
                                        }
                                        if (string.contains(" ")) {
                                            if (string.split(" ").length > 2 && !string.contains(":") && !string.contains("17 32")) {
                                                if (DateUtils.isDateTimeAllowSpaceSeparator()) {
                                                    msgErroreAtteso3 = (String)msgErroreAtteso3 + "Uncorrect format";
                                                    break;
                                                }
                                                msgErroreAtteso3 = (String)msgErroreAtteso3 + "Expected 'full-date T full-time' format";
                                                break;
                                            }
                                            if (DateUtils.isDateTimeAllowSpaceSeparator()) {
                                                if (string.split(" ").length > 2) {
                                                    msgErroreAtteso3 = (String)msgErroreAtteso3 + "Expected 'full-date T full-time' format";
                                                    break;
                                                }
                                                msgErroreAtteso3 = (String)msgErroreAtteso3 + "Uncorrect format";
                                                break;
                                            }
                                            msgErroreAtteso3 = (String)msgErroreAtteso3 + "Expected 'T' separator";
                                            break;
                                        }
                                        msgErroreAtteso3 = (String)msgErroreAtteso3 + "Expected 'T' separator";
                                        break;
                                    }
                                    msgErroreAtteso3 = (String)msgErroreAtteso3 + "Uncorrect format";
                                    break;
                                }
                                case openapi4j: {
                                    msgErroreAtteso3 = "datetime_documento_risposta_header: Value '" + string + "' does not match format 'date-time'. (code: 1007)";
                                    break;
                                }
                                case swagger_request_validator: {
                                    if (swagger_validator_fallimenti_datetime.contains(string)) {
                                        System.out.println("\t " + tipoTest + " validate, lo swagger-request-validator non rileva l'accezione!!!!");
                                        continue block287;
                                    }
                                    msgErroreAtteso3 = string.contains("t") && !DateUtils.isDateTimeAllowLowerCaseTZ() && (string.contains("Z") || string.contains("+") || string.contains("-02:00")) ? "Expected 'T' separator" : (string.contains("z") && !DateUtils.isDateTimeAllowLowerCaseTZ() && string.contains("T") ? "Uncorrect format" : "[ERROR][RESPONSE][] String \"" + string + "\" is invalid against requested date format(s) [yyyy-MM-dd'T'HH:mm:ssZ, yyyy-MM-dd'T'HH:mm:ss.[0-9]{1,12}Z]");
                                }
                            }
                            if (msgErroreAtteso3 == null || e21.getMessage().contains((CharSequence)msgErroreAtteso3)) continue;
                            System.out.println("\t " + tipoTest + " ERRORE!");
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso3 + "'");
                        }
                    }
                    block288: for (i = 0; i < valori_test14.size(); ++i) {
                        if (i >= indiceDoveAbilitareCaseInsensitiveAndSpaceTest14) {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, true);
                        } else if (i >= n4) {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, false, true);
                        } else if (i >= n3) {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, false);
                        } else {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, defaultDateTimeAllowLowerCaseTZ, defaultDateTimeAllowSpaceSeparator);
                        }
                        String string = (String)valori_test14.get(i);
                        boolean esito = (Boolean)esiti_test14.get(i);
                        httpEntity14 = new TextHttpRequestEntity();
                        httpEntity14.setMethod(HttpRequestMethod.POST);
                        httpEntity14.setUrl(testUrl14 + "2020-07-21T17:32:28Z");
                        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                        TransportUtils.setParameter(hashMap, "datetime_documento_query", string);
                        httpEntity14.setParameters(hashMap);
                        HashMap<String, List<String>> hashMap8 = new HashMap<String, List<String>>();
                        TransportUtils.setHeader(hashMap8, "Content-Type", "application/json");
                        TransportUtils.setHeader(hashMap8, "datetime_documento_header", "2020-07-19T17:32:28Z");
                        httpEntity14.setHeaders(hashMap8);
                        httpEntity14.setContentType("application/json");
                        json14 = "{\"data\": \"2020-07-20T17:32:28Z\"}";
                        httpEntity14.setContent(json14);
                        tipoTest = esito ? "[query parameter con valore ok '" + string + "']" : "[query parameter con valore errato '" + string + "']";
                        tipoTest = tipoTest + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntity14);
                            if (!esito) {
                                System.out.println("\t " + tipoTest + " ERRORE!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            System.out.println("\t " + tipoTest + " validate ok");
                            continue;
                        }
                        catch (ValidatorException e22) {
                            String string13 = e22.getMessage();
                            if (string13.length() > 200) {
                                String string14 = string13.substring(0, 198) + " ...";
                            }
                            if (!esito) {
                                System.out.println("\t " + tipoTest + " atteso errore di validazione, rilevato: " + (String)var83_312);
                            } else if (openAPILibrary != OpenAPILibrary.swagger_request_validator) {
                                System.out.println("\t " + tipoTest + " rilevato errore di validazione non atteso: " + (String)var83_312);
                                throw new Exception(tipoTest + " rilevato errore di validazione non atteso: " + e22.getMessage(), e22);
                            }
                            msgErroreAtteso4 = null;
                            switch (openAPILibrary) {
                                case json_schema: {
                                    msgErroreAtteso4 = "Invalid value '" + string + "' in query parameter 'datetime_documento_query' (expected type 'date-time'): Found dateTime '" + string + "' has wrong format (see RFC 3339, section 5.6): ";
                                    if (!string.contains("T")) {
                                        if (string.contains("t")) {
                                            if (DateUtils.isDateTimeAllowLowerCaseTZ()) {
                                                msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                                break;
                                            }
                                            msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'T' separator";
                                            break;
                                        }
                                        if (string.contains(" ")) {
                                            if (string.split(" ").length > 2 && !string.contains(":") && !string.contains("17 32")) {
                                                if (DateUtils.isDateTimeAllowSpaceSeparator()) {
                                                    msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                                    break;
                                                }
                                                msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'full-date T full-time' format";
                                                break;
                                            }
                                            if (DateUtils.isDateTimeAllowSpaceSeparator()) {
                                                if (string.split(" ").length > 2) {
                                                    msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'full-date T full-time' format";
                                                    break;
                                                }
                                                msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                                break;
                                            }
                                            msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'T' separator";
                                            break;
                                        }
                                        msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'T' separator";
                                        break;
                                    }
                                    msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                    break;
                                }
                                case openapi4j: {
                                    msgErroreAtteso4 = "datetime_documento_query: Value '" + string + "' does not match format 'date-time'. (code: 1007)";
                                    break;
                                }
                                case swagger_request_validator: {
                                    if (swagger_validator_fallimenti_datetime.contains(string)) {
                                        System.out.println("\t " + tipoTest + " validate, lo swagger-request-validator non rileva l'accezione!!!!");
                                        continue block288;
                                    }
                                    msgErroreAtteso4 = string.contains("t") && !DateUtils.isDateTimeAllowLowerCaseTZ() && (string.contains("Z") || string.contains("+") || string.contains("-02:00")) ? "Expected 'T' separator" : (string.contains("z") && !DateUtils.isDateTimeAllowLowerCaseTZ() && string.contains("T") ? "Uncorrect format" : "[ERROR][REQUEST][POST /documenti/datetimetest/2020-07-21T17:32:28Z @query.datetime_documento_query] String \"" + string + "\" is invalid against r");
                                }
                            }
                            if (msgErroreAtteso4 == null || e22.getMessage().contains((CharSequence)msgErroreAtteso4)) continue;
                            System.out.println("\t " + tipoTest + " ERRORE!");
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso4 + "'");
                        }
                    }
                    for (i = 0; i < valori_test14.size(); ++i) {
                        if (i >= indiceDoveAbilitareCaseInsensitiveAndSpaceTest14) {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, true);
                        } else if (i >= n4) {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, false, true);
                        } else if (i >= n3) {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, true, false);
                        } else {
                            OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, defaultDateTimeAllowLowerCaseTZ, defaultDateTimeAllowSpaceSeparator);
                        }
                        String string = (String)valori_test14.get(i);
                        boolean esito = (Boolean)esiti_test14.get(i);
                        if (string.contains(" ") || string.contains("/")) continue;
                        httpEntity14 = new TextHttpRequestEntity();
                        httpEntity14.setMethod(HttpRequestMethod.POST);
                        httpEntity14.setUrl(testUrl14 + string);
                        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                        TransportUtils.setParameter(hashMap, "datetime_documento_query", "2020-07-21T17:32:28Z");
                        httpEntity14.setParameters(hashMap);
                        HashMap<String, List<String>> hashMap9 = new HashMap<String, List<String>>();
                        TransportUtils.setHeader(hashMap9, "Content-Type", "application/json");
                        TransportUtils.setHeader(hashMap9, "datetime_documento_header", "2020-07-19T17:32:28Z");
                        httpEntity14.setHeaders(hashMap9);
                        httpEntity14.setContentType("application/json");
                        json14 = "{\"data\": \"2020-07-20T17:32:28Z\"}";
                        httpEntity14.setContent(json14);
                        tipoTest = esito ? "[path parameter con valore ok '" + string + "']" : "[path parameter con valore errato '" + string + "']";
                        tipoTest = tipoTest + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntity14);
                            if (!esito) {
                                System.out.println("\t " + tipoTest + " ERRORE!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            System.out.println("\t " + tipoTest + " validate ok");
                            continue;
                        }
                        catch (ValidatorException e23) {
                            String string15 = e23.getMessage();
                            if (string15.length() > 200) {
                                String string16 = string15.substring(0, 198) + " ...";
                            }
                            if (!esito) {
                                System.out.println("\t " + tipoTest + " atteso errore di validazione, rilevato: " + (String)var83_316);
                            } else if (openAPILibrary != OpenAPILibrary.swagger_request_validator) {
                                System.out.println("\t " + tipoTest + " rilevato errore di validazione non atteso: " + (String)var83_316);
                                throw new Exception(tipoTest + " rilevato errore di validazione non atteso: " + e23.getMessage(), e23);
                            }
                            msgErroreAtteso4 = null;
                            switch (openAPILibrary) {
                                case json_schema: {
                                    msgErroreAtteso4 = "Invalid value '" + string + "' in dynamic path 'datetime_documento_path' (expected type 'date-time'): Found dateTime '" + string + "' has wrong format (see RFC 3339, section 5.6): ";
                                    if (!string.contains("T")) {
                                        if (string.contains("t")) {
                                            if (DateUtils.isDateTimeAllowLowerCaseTZ()) {
                                                msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                                break;
                                            }
                                            msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'T' separator";
                                            break;
                                        }
                                        if (string.contains(" ")) {
                                            if (string.split(" ").length > 2 && !string.contains(":") && !string.contains("17 32")) {
                                                if (DateUtils.isDateTimeAllowSpaceSeparator()) {
                                                    msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                                    break;
                                                }
                                                msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'full-date T full-time' format";
                                                break;
                                            }
                                            if (DateUtils.isDateTimeAllowSpaceSeparator()) {
                                                if (string.split(" ").length > 2) {
                                                    msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'full-date T full-time' format";
                                                    break;
                                                }
                                                msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                                break;
                                            }
                                            msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'T' separator";
                                            break;
                                        }
                                        msgErroreAtteso4 = (String)msgErroreAtteso4 + "Expected 'T' separator";
                                        break;
                                    }
                                    msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                    break;
                                }
                                case openapi4j: {
                                    msgErroreAtteso4 = "datetime_documento_path: Value '" + string + "' does not match format 'date-time'. (code: 1007)\nFrom: datetime_documento_path.<format>";
                                    break;
                                }
                                case swagger_request_validator: {
                                    msgErroreAtteso4 = "Invalid value '" + string + "' in dynamic path 'datetime_documento_path' (expected type 'date-time'): Found dateTime '" + string + "' has wrong format (see RFC 3339, section 5.6): ";
                                    if (string.contains("t") && !DateUtils.isDateTimeAllowLowerCaseTZ()) {
                                        msgErroreAtteso4 = "Expected 'T' separator";
                                        break;
                                    }
                                    if (string.contains("z") && !DateUtils.isDateTimeAllowLowerCaseTZ() && string.contains("T")) {
                                        msgErroreAtteso4 = "Uncorrect format";
                                        break;
                                    }
                                    if ("2020-07-22".equals(string)) {
                                        msgErroreAtteso4 = "Expected 'T' separator";
                                        break;
                                    }
                                    msgErroreAtteso4 = (String)msgErroreAtteso4 + "Uncorrect format";
                                    break;
                                }
                            }
                            if (msgErroreAtteso4 == null || e23.getMessage().contains((CharSequence)msgErroreAtteso4)) continue;
                            System.out.println("\t " + tipoTest + " ERRORE [" + e23.getMessage() + "]!");
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso4 + "'");
                        }
                    }
                    OpenApi3ExtendedTest.setDateTimeOptions(openAPILibrary, defaultDateTimeAllowLowerCaseTZ, defaultDateTimeAllowSpaceSeparator);
                    System.out.println("Test #14 completato\n\n");
                    System.out.println("Test #15 (Risposte che mappano il default)");
                    String json15RispostaOK = "{\"esito\": \"OK\"}";
                    String string = "{\n\"type\": \"https://example.com/probs/out-of-credit\",\"title\": \"You do not have enough credit.\",\"detail\": \"Your current balance is 30, but that costs 50.\"}";
                    String json15RispostaOK_completamente_diversa = "{\n\"altro\": \"https://example.com/probs/out-of-credit\",\"altro2\": \"discorso casuale.\",\"altro3\": 23,\"oggetto\": {\"esito\": \"OK\",\"desc\": \"descr\"}}";
                    String testUrl15 = baseUri + "/oggetti/" + UUID.randomUUID().toString();
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    ArrayList<String> ct_test15 = new ArrayList<String>();
                    ArrayList<Boolean> esiti_test15 = new ArrayList<Boolean>();
                    arrayList.add(200);
                    arrayList2.add(json15RispostaOK);
                    ct_test15.add("application/json");
                    esiti_test15.add(true);
                    arrayList.add(200);
                    arrayList2.add(string);
                    ct_test15.add("application/problem+json");
                    esiti_test15.add(false);
                    arrayList.add(200);
                    arrayList2.add(json15RispostaOK_completamente_diversa);
                    ct_test15.add("application/problem+json");
                    esiti_test15.add(false);
                    arrayList.add(200);
                    arrayList2.add(string);
                    ct_test15.add("application/json");
                    esiti_test15.add(false);
                    arrayList.add(200);
                    arrayList2.add(json15RispostaOK_completamente_diversa);
                    ct_test15.add("application/json");
                    esiti_test15.add(false);
                    arrayList.add(200);
                    arrayList2.add(null);
                    ct_test15.add(null);
                    esiti_test15.add(false);
                    arrayList.add(201);
                    arrayList2.add(string);
                    ct_test15.add("application/problem+json");
                    esiti_test15.add(true);
                    arrayList.add(201);
                    arrayList2.add(json15RispostaOK);
                    ct_test15.add("application/problem+json");
                    esiti_test15.add(false);
                    arrayList.add(201);
                    arrayList2.add(json15RispostaOK_completamente_diversa);
                    ct_test15.add("application/problem+json");
                    esiti_test15.add(false);
                    arrayList.add(201);
                    arrayList2.add(json15RispostaOK);
                    ct_test15.add("application/json");
                    esiti_test15.add(false);
                    arrayList.add(201);
                    arrayList2.add(string);
                    ct_test15.add("application/json");
                    esiti_test15.add(false);
                    arrayList.add(201);
                    arrayList2.add(null);
                    ct_test15.add(null);
                    esiti_test15.add(false);
                    arrayList.add(401);
                    arrayList2.add(string);
                    ct_test15.add("application/problem+json");
                    esiti_test15.add(true);
                    arrayList.add(401);
                    arrayList2.add(json15RispostaOK);
                    ct_test15.add("application/problem+json");
                    esiti_test15.add(false);
                    arrayList.add(401);
                    arrayList2.add(json15RispostaOK_completamente_diversa);
                    ct_test15.add("application/problem+json");
                    esiti_test15.add(false);
                    arrayList.add(401);
                    arrayList2.add(json15RispostaOK);
                    ct_test15.add("application/json");
                    esiti_test15.add(false);
                    arrayList.add(401);
                    arrayList2.add(string);
                    ct_test15.add("application/json");
                    esiti_test15.add(false);
                    arrayList.add(401);
                    arrayList2.add(null);
                    ct_test15.add(null);
                    esiti_test15.add(false);
                    arrayList.add(400);
                    arrayList2.add(string);
                    ct_test15.add("application/problem+json");
                    esiti_test15.add(true);
                    arrayList.add(400);
                    arrayList2.add(json15RispostaOK);
                    ct_test15.add("application/problem+json");
                    esiti_test15.add(true);
                    arrayList.add(400);
                    arrayList2.add(json15RispostaOK_completamente_diversa);
                    ct_test15.add("application/problem+json");
                    esiti_test15.add(true);
                    arrayList.add(400);
                    arrayList2.add(json15RispostaOK);
                    ct_test15.add("application/json");
                    esiti_test15.add(false);
                    arrayList.add(400);
                    arrayList2.add(string);
                    ct_test15.add("application/json");
                    esiti_test15.add(false);
                    arrayList.add(400);
                    arrayList2.add(null);
                    ct_test15.add(null);
                    esiti_test15.add(false);
                    for (int i12 = 0; i12 < arrayList.size(); ++i12) {
                        Integer n5 = (Integer)arrayList.get(i12);
                        boolean esito = (Boolean)esiti_test15.get(i12);
                        String msg = (String)arrayList2.get(i12);
                        String ct = (String)ct_test15.get(i12);
                        TextHttpResponseEntity httpEntityResponseTest15 = new TextHttpResponseEntity();
                        httpEntityResponseTest15.setStatus(n5);
                        httpEntityResponseTest15.setMethod(HttpRequestMethod.GET);
                        httpEntityResponseTest15.setUrl(testUrl15);
                        HashMap<String, List<String>> parametersTrasportoRispostaTest15 = new HashMap<String, List<String>>();
                        if (ct != null) {
                            TransportUtils.setHeader(parametersTrasportoRispostaTest15, "Content-Type", ct);
                        }
                        httpEntityResponseTest15.setHeaders(parametersTrasportoRispostaTest15);
                        httpEntityResponseTest15.setContentType(ct);
                        httpEntityResponseTest15.setContent(msg);
                        String msgRisposta = "RispostaOk";
                        if (msg == null) {
                            msgRisposta = "EmptyResponse";
                        } else if (string.equals(msg)) {
                            msgRisposta = "ProblemDetail";
                        } else if (json15RispostaOK_completamente_diversa.equals(msg)) {
                            msgRisposta = "RispostaCompletamenteDiversa";
                        }
                        String tipoTest9 = "AttesoEsitoOk:" + esito + " Risposta:" + msgRisposta + " ContentType:" + ct + " ReturnCode:" + n5;
                        tipoTest9 = tipoTest9 + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest9 + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntityResponseTest15);
                            if (!esito) {
                                System.out.println("\t " + tipoTest9 + " ERRORE!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            System.out.println("\t " + tipoTest9 + " validate ok");
                            continue;
                        }
                        catch (ValidatorException e24) {
                            Object error4 = e24.getMessage();
                            if (((String)error4).length() > 200) {
                                error4 = ((String)error4).substring(0, 198) + " ...";
                            }
                            if (esito) {
                                System.out.println("\t " + tipoTest9 + " rilevato errore di validazione non atteso: " + (String)error4);
                                throw new Exception(tipoTest9 + " rilevato errore di validazione non atteso: " + e24.getMessage(), e24);
                            }
                            System.out.println("\t " + tipoTest9 + " atteso errore di validazione, rilevato: " + (String)error4);
                            Object msgErroreAtteso9 = null;
                            String msgErroreAtteso22 = null;
                            switch (openAPILibrary) {
                                case json_schema: {
                                    if (ct == null) {
                                        msgErroreAtteso9 = "Required body undefined";
                                        break;
                                    }
                                    msgErroreAtteso9 = "Content-Type '" + ct + "' (http response status '" + n5 + "') unsupported";
                                    msgErroreAtteso22 = "$: required property 'esito' not found";
                                    if (n5 == 200) break;
                                    msgErroreAtteso22 = "$: required property 'type' not found";
                                    break;
                                }
                                case openapi4j: {
                                    msgErroreAtteso9 = "Content type '" + ct + "' is not allowed for body content. (code: 203)";
                                    msgErroreAtteso22 = "body: Field 'esito' is required. (code: 1026)";
                                    if (!"application/problem+json".equals(ct) || n5 == 200) break;
                                    msgErroreAtteso22 = "body: Field 'type' is required. (code: 1026)";
                                    break;
                                }
                                case swagger_request_validator: {
                                    msgErroreAtteso9 = "[ERROR][RESPONSE][] Response Content-Type header '" + ct + "' does not match any allowed types. Must be one of: [application/";
                                    msgErroreAtteso22 = "[ERROR][RESPONSE][] Object has missing required properties ([\"esito\"])";
                                    if (ct == null) {
                                        msgErroreAtteso9 = "Required Content-Type is missing";
                                    }
                                    if (!"application/problem+json".equals(ct) || n5 == 200) break;
                                    msgErroreAtteso22 = "[ERROR][RESPONSE][] Object has missing required properties ([\"type\"])";
                                    break;
                                }
                            }
                            if (msgErroreAtteso22 == null) {
                                if (msgErroreAtteso9 == null || e24.getMessage().contains((CharSequence)msgErroreAtteso9)) continue;
                                System.out.println("\t " + tipoTest9 + " ERRORE!");
                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso9 + "'");
                            }
                            if (e24.getMessage().contains((CharSequence)msgErroreAtteso9) || e24.getMessage().contains(msgErroreAtteso22)) continue;
                            System.out.println("\t " + tipoTest9 + " ERRORE!");
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso9 + "' o '" + msgErroreAtteso22 + "'");
                        }
                    }
                    System.out.println("Test #15 completato\n\n");
                    System.out.println("Test #16 (Risposte con '/' come casi speciali)");
                    String json16RispostaOK = "{\"esito\": \"OK\"}";
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    ArrayList<Boolean> esiti_test16 = new ArrayList<Boolean>();
                    arrayList3.add("/oggettislashfinale/");
                    esiti_test16.add(true);
                    arrayList3.add("/oggettislashfinale");
                    esiti_test16.add(true);
                    arrayList3.add("/");
                    esiti_test16.add(true);
                    for (int i13 = 0; i13 < arrayList3.size(); ++i13) {
                        String urltest = (String)arrayList3.get(i13);
                        boolean esito = (Boolean)esiti_test16.get(i13);
                        String msg = json16RispostaOK;
                        String ct = "application/json";
                        int code = 200;
                        TextHttpResponseEntity httpEntityResponseTest16 = new TextHttpResponseEntity();
                        httpEntityResponseTest16.setStatus(code);
                        httpEntityResponseTest16.setMethod(HttpRequestMethod.GET);
                        httpEntityResponseTest16.setUrl(urltest);
                        HashMap<String, List<String>> parametersTrasportoRispostaTest16 = new HashMap<String, List<String>>();
                        TransportUtils.setHeader(parametersTrasportoRispostaTest16, "Content-Type", ct);
                        httpEntityResponseTest16.setHeaders(parametersTrasportoRispostaTest16);
                        httpEntityResponseTest16.setContentType(ct);
                        httpEntityResponseTest16.setContent(msg);
                        String tipoTest10 = "Url '" + urltest + "'";
                        tipoTest10 = tipoTest10 + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest10 + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntityResponseTest16);
                            if (!esito) {
                                System.out.println("\t " + tipoTest10 + " ERRORE!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            System.out.println("\t " + tipoTest10 + " validate ok");
                            continue;
                        }
                        catch (ValidatorException e25) {
                            Object error5 = e25.getMessage();
                            if (((String)error5).length() > 200) {
                                error5 = ((String)error5).substring(0, 198) + " ...";
                            }
                            if (!esito) {
                                System.out.println("\t " + tipoTest10 + " atteso errore di validazione, rilevato: " + (String)error5);
                                throw new Exception(tipoTest10 + " rilevato errore di validazione atteso: " + e25.getMessage(), e25);
                            }
                            System.out.println("\t " + tipoTest10 + " rilevato errore di validazione non atteso: " + (String)error5);
                            throw new Exception(tipoTest10 + " rilevato errore di validazione non atteso: " + e25.getMessage(), e25);
                        }
                    }
                    System.out.println("Test #16 completato\n\n");
                    System.out.println("Test #17 (Problem Detail)");
                    String json17_fault_type = "{\n\"type\": \"https://example.com/probs/out-of-credit\",\"altro\": \"You do not have enough credit.\",\"detail\": \"Your current balance is 30, but that costs 50.\"}";
                    String json17_fault_title = "{\n\"codice\": \"https://example.com/probs/out-of-credit\",\"title\": \"You do not have enough credit.\",\"detail\": \"Your current balance is 30, but that costs 50.\"}";
                    String json17_fault_status = "{\n\"altro\": \"https://example.com/probs/out-of-credit\",\"status\": 200,\"detail\": \"Your current balance is 30, but that costs 50.\"}";
                    String json17_fault_type_title = "{\n\"type\": \"https://example.com/probs/out-of-credit\",\"title\": \"You do not have enough credit.\",\"detail\": \"Your current balance is 30, but that costs 50.\"}";
                    String json17_fault_type_status = "{\n\"type\": \"https://example.com/probs/out-of-credit\",\"status\": 200,\"detail\": \"Your current balance is 30, but that costs 50.\"}";
                    String json17_fault_title_status = "{\n\"altro\": \"https://example.com/probs/out-of-credit\",\"title\": \"You do not have enough credit.\",\"status\": 200,\"detail\": \"Your current balance is 30, but that costs 50.\"}";
                    String json17_fault_type_title_status = "{\n\"type\": \"https://example.com/probs/out-of-credit\",\"title\": \"You do not have enough credit.\",\"status\": 200,\"detail\": \"Your current balance is 30, but that costs 50.\"}";
                    String json17_fault_none = "{\n\"altro\": \"https://example.com/probs/out-of-credit\",\"error\": 200,\"detail\": \"Your current balance is 30, but that costs 50.\"}";
                    String testUrl17 = baseUri + "/problem/" + UUID.randomUUID().toString();
                    ArrayList<Integer> valori_test17 = new ArrayList<Integer>();
                    ArrayList<String> msg_test17 = new ArrayList<String>();
                    ArrayList<Boolean> esiti_test17 = new ArrayList<Boolean>();
                    valori_test17.add(400);
                    msg_test17.add(json17_fault_type);
                    esiti_test17.add(true);
                    valori_test17.add(400);
                    msg_test17.add(json17_fault_title);
                    esiti_test17.add(true);
                    valori_test17.add(400);
                    msg_test17.add(json17_fault_status);
                    esiti_test17.add(true);
                    valori_test17.add(400);
                    msg_test17.add(json17_fault_type_title);
                    esiti_test17.add(true);
                    valori_test17.add(400);
                    msg_test17.add(json17_fault_type_status);
                    esiti_test17.add(true);
                    valori_test17.add(400);
                    msg_test17.add(json17_fault_title_status);
                    esiti_test17.add(true);
                    valori_test17.add(400);
                    msg_test17.add(json17_fault_type_title_status);
                    esiti_test17.add(true);
                    valori_test17.add(400);
                    msg_test17.add(json17_fault_none);
                    esiti_test17.add(false);
                    valori_test17.add(404);
                    msg_test17.add(json17_fault_type);
                    esiti_test17.add(true);
                    valori_test17.add(404);
                    msg_test17.add(json17_fault_title);
                    esiti_test17.add(true);
                    valori_test17.add(404);
                    msg_test17.add(json17_fault_status);
                    esiti_test17.add(true);
                    valori_test17.add(404);
                    msg_test17.add(json17_fault_type_title);
                    esiti_test17.add(true);
                    valori_test17.add(404);
                    msg_test17.add(json17_fault_type_status);
                    esiti_test17.add(true);
                    valori_test17.add(404);
                    msg_test17.add(json17_fault_title_status);
                    esiti_test17.add(true);
                    valori_test17.add(404);
                    msg_test17.add(json17_fault_type_title_status);
                    esiti_test17.add(true);
                    valori_test17.add(404);
                    msg_test17.add(json17_fault_none);
                    esiti_test17.add(true);
                    for (int i14 = 0; i14 < valori_test17.size(); ++i14) {
                        Integer code = (Integer)valori_test17.get(i14);
                        boolean esito = (Boolean)esiti_test17.get(i14);
                        String msg = (String)msg_test17.get(i14);
                        String ct = "application/problem+json";
                        TextHttpResponseEntity httpEntityResponseTest17 = new TextHttpResponseEntity();
                        httpEntityResponseTest17.setStatus(code);
                        httpEntityResponseTest17.setMethod(HttpRequestMethod.GET);
                        httpEntityResponseTest17.setUrl(testUrl17);
                        HashMap<String, List<String>> parametersTrasportoRispostaTest17 = new HashMap<String, List<String>>();
                        TransportUtils.setHeader(parametersTrasportoRispostaTest17, "Content-Type", ct);
                        httpEntityResponseTest17.setHeaders(parametersTrasportoRispostaTest17);
                        httpEntityResponseTest17.setContentType(ct);
                        httpEntityResponseTest17.setContent(msg);
                        String msgRisposta = "None";
                        if (json17_fault_type.equals(msg)) {
                            msgRisposta = "Type";
                        } else if (json17_fault_status.equals(msg)) {
                            msgRisposta = "Status";
                        } else if (json17_fault_type_title.equals(msg)) {
                            msgRisposta = "Type e Title";
                        } else if (json17_fault_type_status.equals(msg)) {
                            msgRisposta = "Type e Status";
                        } else if (json17_fault_title_status.equals(msg)) {
                            msgRisposta = "Title e Status";
                        } else if (json17_fault_type_title_status.equals(msg)) {
                            msgRisposta = "Type e Title e Status";
                        }
                        String tipoTest11 = "Code:" + code + " " + msgRisposta;
                        tipoTest11 = tipoTest11 + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest11 + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntityResponseTest17);
                            if (!esito) {
                                System.out.println("\t " + tipoTest11 + " ERRORE!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            System.out.println("\t " + tipoTest11 + " validate ok");
                            continue;
                        }
                        catch (ValidatorException e26) {
                            Object error6 = e26.getMessage();
                            if (((String)error6).length() > 500) {
                                error6 = ((String)error6).substring(0, 498) + " ...";
                            }
                            if (esito) {
                                System.out.println("\t " + tipoTest11 + " rilevato errore di validazione non atteso: " + (String)error6);
                                throw new Exception(tipoTest11 + " rilevato errore di validazione non atteso: " + e26.getMessage(), e26);
                            }
                            System.out.println("\t " + tipoTest11 + " atteso errore di validazione, rilevato: " + (String)error6);
                            String msgErroreAtteso10 = null;
                            String msgErroreAtteso23 = null;
                            String msgErroreAtteso32 = null;
                            switch (openAPILibrary) {
                                case json_schema: {
                                    msgErroreAtteso10 = "$: required property 'type' not found";
                                    msgErroreAtteso23 = "$: required property 'title' not found";
                                    msgErroreAtteso32 = "$: required property 'status' not found";
                                    break;
                                }
                                case openapi4j: {
                                    msgErroreAtteso10 = "body: Field 'type' is required. (code: 1026)";
                                    msgErroreAtteso23 = "body: Field 'title' is required. (code: 1026)";
                                    msgErroreAtteso32 = "body: Field 'status' is required. (code: 1026)";
                                    break;
                                }
                                case swagger_request_validator: {
                                    msgErroreAtteso10 = "* /allOf/0/anyOf/0: Object has missing required properties ([\"type\"])";
                                    msgErroreAtteso23 = "* /allOf/0/anyOf/1: Object has missing required properties ([\"title\"])";
                                    msgErroreAtteso32 = "* /allOf/0/anyOf/2: Object has missing required properties ([\"status\"])";
                                    break;
                                }
                            }
                            if (!(msgErroreAtteso10 != null && !e26.getMessage().contains(msgErroreAtteso10) || msgErroreAtteso23 != null && !e26.getMessage().contains(msgErroreAtteso23)) && (msgErroreAtteso32 == null || e26.getMessage().contains(msgErroreAtteso32))) continue;
                            System.out.println("\t " + tipoTest11 + " ERRORE!");
                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso10 + "' o '" + msgErroreAtteso23 + "' o '" + msgErroreAtteso32 + "'");
                        }
                    }
                    System.out.println("Test #17 completato\n\n");
                    System.out.println("Test #18 (Risposta GET con parametro dinamico /documenti/XYZ)");
                    String testUrl18 = baseUri + "/documenti/qualsiasi/" + UUID.randomUUID().toString();
                    ArrayList<Integer> valori_test18 = new ArrayList<Integer>();
                    valori_test18.add(200);
                    valori_test18.add(201);
                    valori_test18.add(202);
                    valori_test18.add(203);
                    valori_test18.add(204);
                    valori_test18.add(400);
                    valori_test18.add(401);
                    valori_test18.add(500);
                    valori_test18.add(501);
                    ArrayList<String> contentTypes_test18 = new ArrayList<String>();
                    contentTypes_test18.add("application/json");
                    contentTypes_test18.add("jsonUncorrect");
                    contentTypes_test18.add("text/plain");
                    contentTypes_test18.add("application/zip");
                    int i15 = 0;
                    while (true) {
                        if (i15 >= valori_test18.size()) break;
                        Integer code = (Integer)valori_test18.get(i15);
                        String tipoTest12 = "Code:" + code + " ";
                        tipoTest12 = tipoTest12 + "[" + String.valueOf(openAPILibrary) + "]";
                        TextHttpRequestEntity httpEntityGET_test18 = new TextHttpRequestEntity();
                        httpEntityGET_test18.setMethod(HttpRequestMethod.GET);
                        httpEntityGET_test18.setUrl(testUrl18);
                        try {
                            System.out.println("\t " + tipoTest12 + " validate request ...");
                            apiValidatorOpenApi2.validate(httpEntityGET_test18);
                            System.out.println("\t " + tipoTest12 + " validate request ok");
                        }
                        catch (ValidatorException e27) {
                            Iterator error7 = e27.getMessage();
                            if (((String)((Object)error7)).length() > 500) {
                                error7 = ((String)((Object)error7)).substring(0, 498) + " ...";
                            }
                            System.out.println("\t " + tipoTest12 + " rilevato errore di validazione non atteso: " + (String)((Object)error7));
                            throw new Exception(tipoTest12 + " rilevato errore di validazione non atteso: " + e27.getMessage(), e27);
                        }
                        String oldTipoTest = tipoTest12;
                        for (String ct : contentTypes_test18) {
                            HttpBaseResponseEntity httpEntityResponse_test18;
                            block612: {
                                block616: {
                                    tipoTest12 = oldTipoTest + " Content-Type:" + ct;
                                    httpEntityResponse_test18 = null;
                                    httpEntityResponse_test18 = ct.contains("json") || ct.contains("plain") || ct.contains("Uncorrect") ? new TextHttpResponseEntity() : new BinaryHttpResponseEntity();
                                    httpEntityResponse_test18.setStatus(code);
                                    httpEntityResponse_test18.setMethod(HttpRequestMethod.GET);
                                    httpEntityResponse_test18.setUrl(testUrl18);
                                    HashMap<String, List<String>> parametersTrasportoRisposta_test18 = new HashMap<String, List<String>>();
                                    TransportUtils.setHeader(parametersTrasportoRisposta_test18, "api_key", "aaa");
                                    TransportUtils.setHeader(parametersTrasportoRisposta_test18, "Content-Type", ct);
                                    httpEntityResponse_test18.setHeaders(parametersTrasportoRisposta_test18);
                                    httpEntityResponse_test18.setContentType(ct);
                                    if (!ct.contains("json") && !ct.contains("plain")) break block616;
                                    if (ct.contains("Uncorrect")) {
                                        ((TextHttpResponseEntity)httpEntityResponse_test18).setContent("{ a }");
                                        parametersTrasportoRisposta_test18.remove("Content-Type");
                                        TransportUtils.setHeader(parametersTrasportoRisposta_test18, "Content-Type", "application/json");
                                        httpEntityResponse_test18.setContentType("application/json");
                                        break block612;
                                    } else if (ct.contains("plain")) {
                                        ((TextHttpResponseEntity)httpEntityResponse_test18).setContent("Hello World!");
                                        break block612;
                                    } else {
                                        ((TextHttpResponseEntity)httpEntityResponse_test18).setContent(json);
                                    }
                                    break block612;
                                }
                                ((BinaryHttpResponseEntity)httpEntityResponse_test18).setContent(pdf);
                            }
                            try {
                                System.out.println("\t " + tipoTest12 + " validate response ...");
                                apiValidatorOpenApi2.validate(httpEntityResponse_test18);
                                System.out.println("\t " + tipoTest12 + " validate response ok");
                                if (openAPILibrary == OpenAPILibrary.json_schema || !ct.contains("Uncorrect") && ct.contains("json")) continue;
                                throw new Exception("Attesa eccezione");
                            }
                            catch (ValidatorException e28) {
                                Object error8 = e28.getMessage();
                                if (((String)error8).length() > 500) {
                                    error8 = ((String)error8).substring(0, 498) + " ...";
                                }
                                String erroreAtteso = null;
                                if (ct.contains("Uncorrect")) {
                                    erroreAtteso = "Unexpected character ('a' (code 97))";
                                } else if (!ct.contains("json")) {
                                    erroreAtteso = null;
                                    switch (openAPILibrary) {
                                        case json_schema: {
                                            break;
                                        }
                                        case openapi4j: {
                                            erroreAtteso = "body: Type expected 'object', found 'string'. (code: 1027)";
                                            break;
                                        }
                                        case swagger_request_validator: {
                                            erroreAtteso = "[ERROR] Unable to parse JSON";
                                            break;
                                        }
                                    }
                                }
                                if (erroreAtteso == null) {
                                    System.out.println("\t " + tipoTest12 + " rilevato errore di validazione non atteso: " + (String)error8);
                                    throw new Exception(tipoTest12 + " rilevato errore di validazione non atteso: " + e28.getMessage(), e28);
                                }
                                if (!e28.getMessage().contains(erroreAtteso)) {
                                    System.out.println("\t " + tipoTest12 + " rilevato errore di validazione diverso da quello atteso (" + erroreAtteso + ") : " + (String)error8);
                                    throw new Exception(tipoTest12 + " rilevato errore di validazione diverso da quello atteso (" + erroreAtteso + ") : " + e28.getMessage(), e28);
                                }
                                System.out.println("\t " + tipoTest12 + " rilevato errore di validazione atteso: " + (String)error8);
                            }
                        }
                        ++i15;
                    }
                    System.out.println("Test #18 completato\n\n");
                    System.out.println("Test #19 (Enumeration con valori NO, YES ...) ...");
                    String testUrl19 = baseUri + "/test-enum-no-yes";
                    ArrayList<Object> valori_test19 = new ArrayList<Object>();
                    ArrayList<Boolean> esito_test19 = new ArrayList<Boolean>();
                    valori_test19.add("SI");
                    esito_test19.add(true);
                    valori_test19.add("NO");
                    esito_test19.add(true);
                    valori_test19.add("YES");
                    esito_test19.add(true);
                    valori_test19.add("S");
                    esito_test19.add(true);
                    valori_test19.add("N");
                    esito_test19.add(true);
                    valori_test19.add("Y");
                    esito_test19.add(true);
                    valori_test19.add("0");
                    esito_test19.add(true);
                    valori_test19.add("1");
                    esito_test19.add(true);
                    valori_test19.add("ON");
                    esito_test19.add(true);
                    valori_test19.add("OFF");
                    esito_test19.add(true);
                    valori_test19.add(0);
                    esito_test19.add(false);
                    valori_test19.add(1);
                    esito_test19.add(false);
                    valori_test19.add(false);
                    esito_test19.add(false);
                    valori_test19.add(true);
                    esito_test19.add(false);
                    int TEST_NUMERO = 1;
                    int k = 0;
                    while (true) {
                        String testYaml2;
                        if (k < TEST_NUMERO) {
                            testYaml2 = "[test con enum quotata] ";
                            if (k == 1) {
                                testUrl19 = testUrl19 + "-yaml1";
                                testYaml2 = "[test con enum non quotata] ";
                            }
                        } else {
                            System.out.println("Test #19 (Enumeration con valori NO, YES ...) completato\n\n");
                            System.out.println("Test #20 (Elementi nullable ...) ...");
                            baseTestUrl20 = baseUri;
                            String json20_object = "{\"identificativo\": \"IDXX\", \"stato\": \"ON\", \"valoreintero\": 3, \"descrizione\": \"esempio di test\"}";
                            String json20_messaggio_valorizzato = "{\"string_required\": \"ValoreEsempio\", \"string_optional\": \"ValoreEsempio2\", \"enum_required\": \"ON\", \"enum_optional\": \"OFF\", \"integer_required\": 2, \"integer_optional\": 3, \"boolean_required\": false, \"boolean_optional\": true, \"array_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"object_required\": " + json20_object + ",\"object_optional\": " + json20_object + "}";
                            String json20_messaggio_non_valorizzato_string = "{\"string_required\": null, \"string_optional\": null, \"enum_required\": \"ON\", \"enum_optional\": \"OFF\", \"integer_required\": 2, \"integer_optional\": 3, \"boolean_required\": false, \"boolean_optional\": true, \"array_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"object_required\": " + json20_object + ",\"object_optional\": " + json20_object + "}";
                            String json20_messaggio_non_valorizzato_enum = "{\"string_required\": \"ValoreEsempio\", \"string_optional\": \"ValoreEsempio2\", \"enum_required\": null, \"enum_optional\": null, \"integer_required\": 2, \"integer_optional\": 3, \"boolean_required\": false, \"boolean_optional\": true, \"array_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"object_required\": " + json20_object + ",\"object_optional\": " + json20_object + "}";
                            String json20_messaggio_non_valorizzato_integer = "{\"string_required\": \"ValoreEsempio\", \"string_optional\": \"ValoreEsempio2\", \"enum_required\": \"ON\", \"enum_optional\": \"OFF\", \"integer_required\": null, \"integer_optional\": null, \"boolean_required\": false, \"boolean_optional\": true, \"array_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"object_required\": " + json20_object + ",\"object_optional\": " + json20_object + "}";
                            String json20_messaggio_non_valorizzato_boolean = "{\"string_required\": \"ValoreEsempio\", \"string_optional\": \"ValoreEsempio2\", \"enum_required\": \"ON\", \"enum_optional\": \"OFF\", \"integer_required\": 2, \"integer_optional\": 3, \"boolean_required\": null, \"boolean_optional\": null, \"array_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"object_required\": " + json20_object + ",\"object_optional\": " + json20_object + "}";
                            String json20_messaggio_non_valorizzato_array = "{\"string_required\": \"ValoreEsempio\", \"string_optional\": \"ValoreEsempio2\", \"enum_required\": \"ON\", \"enum_optional\": \"OFF\", \"integer_required\": 2, \"integer_optional\": 3, \"boolean_required\": false, \"boolean_optional\": true, \"array_required\": null, \"array_optional\": null, \"array_nullable_values_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"object_required\": " + json20_object + ",\"object_optional\": " + json20_object + "}";
                            String json20_messaggio_non_valorizzato_array_values = "{\"string_required\": \"ValoreEsempio\", \"string_optional\": \"ValoreEsempio2\", \"enum_required\": \"ON\", \"enum_optional\": \"OFF\", \"integer_required\": 2, \"integer_optional\": 3, \"boolean_required\": false, \"boolean_optional\": true, \"array_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_required\": [null,\"ValoreEsempio2\" ], \"array_nullable_values_optional\": [null,null], \"object_required\": " + json20_object + ",\"object_optional\": " + json20_object + "}";
                            String json20_messaggio_valorizzato_array_vuoto = "{\"string_required\": \"ValoreEsempio\", \"string_optional\": \"ValoreEsempio2\", \"enum_required\": \"ON\", \"enum_optional\": \"OFF\", \"integer_required\": 2, \"integer_optional\": 3, \"boolean_required\": false, \"boolean_optional\": true, \"array_required\": [], \"array_optional\": [], \"array_nullable_values_required\": [], \"array_nullable_values_optional\": [], \"object_required\": " + json20_object + ",\"object_optional\": " + json20_object + "}";
                            String json20_messaggio_non_valorizzato_object = "{\"string_required\": \"ValoreEsempio\", \"string_optional\": \"ValoreEsempio2\", \"enum_required\": \"ON\", \"enum_optional\": \"OFF\", \"integer_required\": 2, \"integer_optional\": 3, \"boolean_required\": false, \"boolean_optional\": true, \"array_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_required\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"array_nullable_values_optional\": [\"ValoreEsempio\",\"ValoreEsempio2\" ], \"object_required\": null,\"object_optional\": null}";
                            valori_test20 = new ArrayList<Object>();
                            esito_test20 = new ArrayList<Boolean>();
                            tipoTest_test20 = new ArrayList<String>();
                            path_test20 = new ArrayList<String>();
                            tipoTest_test20.add("ValorizzazioneCompleta");
                            valori_test20.add(json20_messaggio_valorizzato);
                            esito_test20.add(true);
                            path_test20.add("test-nullable");
                            tipoTest_test20.add("ValorizzazioneCompleta");
                            valori_test20.add(json20_messaggio_valorizzato);
                            esito_test20.add(true);
                            path_test20.add("test-not-nullable");
                            tipoTest_test20.add("ValorizzazioneCompleta");
                            valori_test20.add(json20_messaggio_valorizzato);
                            esito_test20.add(true);
                            path_test20.add("test-not-nullable-default");
                            tipoTest_test20.add("StringNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_string);
                            esito_test20.add(true);
                            path_test20.add("test-nullable");
                            tipoTest_test20.add("StringNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_string);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable");
                            tipoTest_test20.add("StringNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_string);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable-default");
                            tipoTest_test20.add("EnumNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_enum);
                            esito_test20.add(true);
                            path_test20.add("test-nullable");
                            tipoTest_test20.add("EnumNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_enum);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable");
                            tipoTest_test20.add("EnumNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_enum);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable-default");
                            tipoTest_test20.add("IntegerNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_integer);
                            esito_test20.add(true);
                            path_test20.add("test-nullable");
                            tipoTest_test20.add("IntegerNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_integer);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable");
                            tipoTest_test20.add("IntegerNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_integer);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable-default");
                            tipoTest_test20.add("BooleanNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_boolean);
                            esito_test20.add(true);
                            path_test20.add("test-nullable");
                            tipoTest_test20.add("BooleanNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_boolean);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable");
                            tipoTest_test20.add("BooleanNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_boolean);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable-default");
                            tipoTest_test20.add("ArrayNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_array);
                            esito_test20.add(true);
                            path_test20.add("test-nullable");
                            tipoTest_test20.add("ArrayNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_array);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable");
                            tipoTest_test20.add("ArrayNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_array);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable-default");
                            tipoTest_test20.add("ArrayValuesNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_array_values);
                            esito_test20.add(true);
                            path_test20.add("test-nullable");
                            tipoTest_test20.add("ArrayValuesNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_array_values);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable");
                            tipoTest_test20.add("ArrayValuesNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_array_values);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable-default");
                            tipoTest_test20.add("ArrayEmpty");
                            valori_test20.add(json20_messaggio_valorizzato_array_vuoto);
                            esito_test20.add(true);
                            path_test20.add("test-nullable");
                            tipoTest_test20.add("ArrayEmpty");
                            valori_test20.add(json20_messaggio_valorizzato_array_vuoto);
                            esito_test20.add(true);
                            path_test20.add("test-not-nullable");
                            tipoTest_test20.add("ArrayEmpty");
                            valori_test20.add(json20_messaggio_valorizzato_array_vuoto);
                            esito_test20.add(true);
                            path_test20.add("test-not-nullable-default");
                            tipoTest_test20.add("ObjectNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_object);
                            esito_test20.add(true);
                            path_test20.add("test-nullable");
                            tipoTest_test20.add("ObjectNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_object);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable");
                            tipoTest_test20.add("ObjectNull");
                            valori_test20.add(json20_messaggio_non_valorizzato_object);
                            esito_test20.add(false);
                            path_test20.add("test-not-nullable-default");
                            testYaml = "[test con elementi nullable] ";
                            break;
                        }
                        for (int i16 = 0; i16 < valori_test19.size(); ++i16) {
                            String tipoJava;
                            Object msgErroreAtteso11;
                            Object error9;
                            String tipoTest13;
                            TextHttpResponseEntity httpEntityResponse_test19;
                            boolean esito;
                            Object valore;
                            block613: {
                                valore = valori_test19.get(i16);
                                esito = (Boolean)esito_test19.get(i16);
                                Object valoreInserito = null;
                                if (valore instanceof String || valore instanceof Boolean) {
                                    String v;
                                    valoreInserito = "\"" + String.valueOf(valore) + "\"";
                                    if (valore instanceof String && ((v = (String)valore).equals("ON") || v.equals("OFF")) && k == 1) {
                                        testUrl19 = testUrl19 + "-onOff";
                                    }
                                } else {
                                    valoreInserito = valore.toString();
                                }
                                TextHttpRequestEntity httpEntity19 = new TextHttpRequestEntity();
                                httpEntity19.setMethod(HttpRequestMethod.POST);
                                httpEntity19.setUrl(testUrl19);
                                HashMap<String, List<String>> parametersTrasporto19 = new HashMap<String, List<String>>();
                                TransportUtils.setHeader(parametersTrasporto19, "Content-Type", "application/json");
                                httpEntity19.setHeaders(parametersTrasporto19);
                                httpEntity19.setContentType("application/json");
                                String json19 = "{\"stato1\": " + ((String)valoreInserito).toUpperCase() + ",\"stato2\": " + ((String)valoreInserito).toLowerCase() + "}";
                                httpEntity19.setContent(json19);
                                httpEntityResponse_test19 = new TextHttpResponseEntity();
                                httpEntityResponse_test19.setStatus(200);
                                httpEntityResponse_test19.setMethod(HttpRequestMethod.POST);
                                httpEntityResponse_test19.setUrl(testUrl19);
                                HashMap<String, List<String>> parametersTrasportoRisposta_test19 = new HashMap<String, List<String>>();
                                TransportUtils.setHeader(parametersTrasportoRisposta_test19, "Content-Type", "application/json");
                                httpEntityResponse_test19.setHeaders(parametersTrasportoRisposta_test19);
                                httpEntityResponse_test19.setContentType("application/json");
                                httpEntityResponse_test19.setContent(json19);
                                tipoTest13 = testYaml2 + (esito ? "[stato con valore (type:" + valore.getClass().getName() + ") '" + String.valueOf(valore) + "']" : "[stato con valore errato (type:" + valore.getClass().getName() + ") '" + String.valueOf(valore) + "']");
                                tipoTest13 = tipoTest13 + "[" + String.valueOf(openAPILibrary) + "]";
                                try {
                                    System.out.println("\t " + tipoTest13 + " validate ...");
                                    apiValidatorOpenApi2.validate(httpEntity19);
                                    if (!esito) {
                                        System.out.println("\t " + tipoTest13 + " ERRORE!");
                                        throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                    }
                                    System.out.println("\t " + tipoTest13 + " validate ok");
                                }
                                catch (ValidatorException e29) {
                                    error9 = e29.getMessage();
                                    if (((String)error9).length() > 200) {
                                        error9 = ((String)error9).substring(0, 198) + " ...";
                                    }
                                    if (esito) {
                                        System.out.println("\t " + tipoTest13 + " rilevato errore di validazione non atteso: " + (String)error9);
                                        throw new Exception(tipoTest13 + " rilevato errore di validazione non atteso: " + e29.getMessage(), e29);
                                    }
                                    System.out.println("\t " + tipoTest13 + " atteso errore di validazione, rilevato: " + (String)error9);
                                    msgErroreAtteso11 = null;
                                    switch (openAPILibrary) {
                                        case json_schema: {
                                            if (!(valore instanceof Integer)) break;
                                            tipoJava = valore instanceof Integer ? "integer" : "boolean";
                                            msgErroreAtteso11 = "1029 $.stato2: " + tipoJava + " found, string expected";
                                            break;
                                        }
                                        case openapi4j: {
                                            if (valore instanceof Integer) {
                                                msgErroreAtteso11 = "Type expected 'string', found 'integer'. (code: 1027)";
                                                break;
                                            }
                                            msgErroreAtteso11 = "body.stato1: Value '" + valore.toString().toUpperCase() + "' is not defined in the schema. (code: 1006)";
                                            break;
                                        }
                                        case swagger_request_validator: {
                                            if (valore instanceof Integer) {
                                                msgErroreAtteso11 = "[ERROR][REQUEST][POST /test-enum-no-yes @body] [Path '/stato1'] Instance value (" + String.valueOf(valore) + ") not found in enum (possible values: [\"SI\",\"NO\"";
                                                break;
                                            }
                                            msgErroreAtteso11 = "[ERROR][REQUEST][POST /test-enum-no-yes @body] [Path '/stato1'] Instance value (\"" + valore.toString().toUpperCase() + "\") not found in enum (possible values: [\"SI\",\"NO\",\"YES\",\"S\",\"N\"";
                                            break;
                                        }
                                    }
                                    if (msgErroreAtteso11 != null && !e29.getMessage().contains((CharSequence)msgErroreAtteso11)) {
                                        System.out.println("\t " + tipoTest13 + " ERRORE!");
                                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso11 + "'");
                                    }
                                    msgErroreAtteso11 = null;
                                    switch (openAPILibrary) {
                                        case json_schema: {
                                            if (!(valore instanceof Integer)) break;
                                            tipoJava = valore instanceof Integer ? "integer" : "boolean";
                                            msgErroreAtteso11 = "$.stato1: " + tipoJava + " found, string expected";
                                            break;
                                        }
                                        case openapi4j: {
                                            if (valore instanceof Integer) {
                                                msgErroreAtteso11 = "Value '" + String.valueOf(valore) + "' is not defined in the schema. (code: 1006)";
                                                break;
                                            }
                                            msgErroreAtteso11 = "body.stato2: Value '" + valore.toString().toLowerCase() + "' is not defined in the schema. (code: 1006)";
                                            break;
                                        }
                                        case swagger_request_validator: {
                                            if (valore instanceof Integer) {
                                                msgErroreAtteso11 = "[ERROR][REQUEST][POST /test-enum-no-yes @body] [Path '/stato1'] Instance value (" + String.valueOf(valore) + ") not found in enum (possible values: [\"SI\",\"NO\",\"YES\",\"S\",\"N\",\"Y\",\"";
                                                break;
                                            }
                                            msgErroreAtteso11 = "[ERROR][REQUEST][POST /test-enum-no-yes @body] [Path '/stato1'] Instance value (\"" + valore.toString().toUpperCase() + "\") not found in enum (possible values: [\"SI\",\"NO\",\"YES\",\"S\",\"N\"";
                                            break;
                                        }
                                    }
                                    if (msgErroreAtteso11 != null && !e29.getMessage().contains((CharSequence)msgErroreAtteso11)) {
                                        System.out.println("\t " + tipoTest13 + " ERRORE!");
                                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso11 + "'");
                                    }
                                    if (openAPILibrary != OpenAPILibrary.json_schema || (msgErroreAtteso11 = "$.stato1: does not have a value in the enumeration [\"SI\", \"NO\", \"YES\", \"S\", \"N\", \"Y\", \"0\", \"1\", \"ON\", \"OFF\"]") == null || e29.getMessage().contains((CharSequence)msgErroreAtteso11)) break block613;
                                    System.out.println("\t " + tipoTest13 + " ERRORE!");
                                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso11 + "'");
                                }
                            }
                            try {
                                System.out.println("\t " + tipoTest13 + " validate response ...");
                                apiValidatorOpenApi2.validate(httpEntityResponse_test19);
                                System.out.println("\t " + tipoTest13 + " validate response ok");
                                continue;
                            }
                            catch (ValidatorException e30) {
                                error9 = e30.getMessage();
                                if (((String)error9).length() > 200) {
                                    error9 = ((String)error9).substring(0, 198) + " ...";
                                }
                                if (esito) {
                                    System.out.println("\t " + tipoTest13 + " rilevato errore di validazione non atteso: " + (String)error9);
                                    throw new Exception(tipoTest13 + " rilevato errore di validazione non atteso: " + e30.getMessage(), e30);
                                }
                                System.out.println("\t " + tipoTest13 + " atteso errore di validazione, rilevato: " + (String)error9);
                                msgErroreAtteso11 = null;
                                switch (openAPILibrary) {
                                    case json_schema: {
                                        if (!(valore instanceof Integer)) break;
                                        tipoJava = valore instanceof Integer ? "integer" : "boolean";
                                        msgErroreAtteso11 = "1029 $.stato2: " + tipoJava + " found, string expected";
                                        break;
                                    }
                                    case openapi4j: {
                                        if (valore instanceof Integer) {
                                            msgErroreAtteso11 = "Type expected 'string', found 'integer'. (code: 1027)";
                                            break;
                                        }
                                        msgErroreAtteso11 = "body.stato1: Value '" + valore.toString().toUpperCase() + "' is not defined in the schema. (code: 1006)";
                                        break;
                                    }
                                    case swagger_request_validator: {
                                        if (valore instanceof Integer) {
                                            msgErroreAtteso11 = "[ERROR][RESPONSE][] [Path '/stato1'] Instance value (" + String.valueOf(valore) + ") not found in enum (possible values: [\"SI\",\"NO\",\"YES\",\"S\",\"N\",\"Y\",\"0\",\"1\",\"ON\",\"OFF\"])";
                                            break;
                                        }
                                        msgErroreAtteso11 = "[ERROR][RESPONSE][] [Path '/stato1'] Instance value (\"" + valore.toString().toUpperCase() + "\") not found in enum (possible values: [\"SI\",\"NO\",\"YES\",\"S\",\"N\",\"Y\",\"0\",\"1\",\"ON\",\"OFF\"])";
                                        break;
                                    }
                                }
                                if (msgErroreAtteso11 != null && !e30.getMessage().contains((CharSequence)msgErroreAtteso11)) {
                                    System.out.println("\t " + tipoTest13 + " ERRORE!");
                                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso11 + "'");
                                }
                                msgErroreAtteso11 = null;
                                switch (openAPILibrary) {
                                    case json_schema: {
                                        if (!(valore instanceof Integer)) break;
                                        tipoJava = valore instanceof Integer ? "integer" : "boolean";
                                        msgErroreAtteso11 = "1029 $.stato1: " + tipoJava + " found, string expected";
                                        break;
                                    }
                                    case openapi4j: {
                                        if (valore instanceof Integer) {
                                            msgErroreAtteso11 = "Value '" + String.valueOf(valore) + "' is not defined in the schema. (code: 1006)";
                                            break;
                                        }
                                        msgErroreAtteso11 = "body.stato2: Value '" + valore.toString().toLowerCase() + "' is not defined in the schema. (code: 1006)";
                                        break;
                                    }
                                    case swagger_request_validator: {
                                        if (valore instanceof Integer) {
                                            msgErroreAtteso11 = "[ERROR][RESPONSE][] [Path '/stato1'] Instance value (" + String.valueOf(valore) + ") not found in enum (possible values: [\"SI\",\"NO\",\"YES\",\"S\",\"N\",\"Y\",\"0\",\"1\",\"ON\",\"OFF\"])";
                                            break;
                                        }
                                        msgErroreAtteso11 = "[ERROR][RESPONSE][] [Path '/stato1'] Instance value (\"" + valore.toString().toUpperCase() + "\") not found in enum (possible values: [\"SI\",\"NO\",\"YES\",\"S\",\"N\",\"Y\",\"0\",\"1\",\"ON\",\"OFF\"])";
                                        break;
                                    }
                                }
                                if (msgErroreAtteso11 != null && !e30.getMessage().contains((CharSequence)msgErroreAtteso11)) {
                                    System.out.println("\t " + tipoTest13 + " ERRORE!");
                                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso11 + "'");
                                }
                                if (openAPILibrary != OpenAPILibrary.json_schema || (msgErroreAtteso11 = "$.stato1: does not have a value in the enumeration [\"SI\", \"NO\", \"YES\", \"S\", \"N\", \"Y\", \"0\", \"1\", \"ON\", \"OFF\"]") == null || e30.getMessage().contains((CharSequence)msgErroreAtteso11)) continue;
                                System.out.println("\t " + tipoTest13 + " ERRORE!");
                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + (String)msgErroreAtteso11 + "'");
                            }
                        }
                        ++k;
                    }
                    for (int i17 = 0; i17 < valori_test20.size(); ++i17) {
                        String tipologia = (String)tipoTest_test20.get(i17);
                        String valore = (String)valori_test20.get(i17);
                        boolean esito = (Boolean)esito_test20.get(i17);
                        String contextTestPath = (String)path_test20.get(i17);
                        String testUrl20 = baseTestUrl20 + "/" + contextTestPath;
                        TextHttpRequestEntity httpEntity20 = new TextHttpRequestEntity();
                        httpEntity20.setMethod(HttpRequestMethod.POST);
                        httpEntity20.setUrl(testUrl20);
                        HashMap<String, List<String>> parametersTrasporto20 = new HashMap<String, List<String>>();
                        TransportUtils.setHeader(parametersTrasporto20, "Content-Type", "application/json");
                        httpEntity20.setHeaders(parametersTrasporto20);
                        httpEntity20.setContentType("application/json");
                        httpEntity20.setContent(valore);
                        TextHttpResponseEntity httpEntityResponse_test20 = new TextHttpResponseEntity();
                        httpEntityResponse_test20.setStatus(200);
                        httpEntityResponse_test20.setMethod(HttpRequestMethod.POST);
                        httpEntityResponse_test20.setUrl(testUrl20);
                        HashMap<String, List<String>> parametersTrasportoRisposta_test20 = new HashMap<String, List<String>>();
                        TransportUtils.setHeader(parametersTrasportoRisposta_test20, "Content-Type", "application/json");
                        httpEntityResponse_test20.setHeaders(parametersTrasportoRisposta_test20);
                        httpEntityResponse_test20.setContentType("application/json");
                        httpEntityResponse_test20.setContent(valore);
                        String tipoTest14 = testYaml + (esito ? "[" + tipologia + " [/" + contextTestPath + "] MessaggioConforme: '" + valore + "']" : "[" + tipologia + " [/" + contextTestPath + "] MessaggioNonConforme: '" + valore + "']");
                        tipoTest14 = tipoTest14 + "[" + String.valueOf(openAPILibrary) + "]";
                        try {
                            System.out.println("\t " + tipoTest14 + " validate ...");
                            apiValidatorOpenApi2.validate(httpEntity20);
                            if (!esito) {
                                System.out.println("\t " + tipoTest14 + " ERRORE!");
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            System.out.println("\t " + tipoTest14 + " validate ok");
                        }
                        catch (ValidatorException e31) {
                            OpenApi3ExtendedTest.checkErrorTest20(esito, tipoTest14, e31, tipologia, openAPILibrary);
                        }
                        try {
                            System.out.println("\t " + tipoTest14 + " validate response ...");
                            apiValidatorOpenApi2.validate(httpEntityResponse_test20);
                            System.out.println("\t " + tipoTest14 + " validate response ok");
                            continue;
                        }
                        catch (ValidatorException e32) {
                            OpenApi3ExtendedTest.checkErrorTest20(esito, tipoTest14, e32, tipologia, openAPILibrary);
                        }
                    }
                    System.out.println("Test #20 (Elementi nullable) completato\n\n");
                    System.out.println("Test #21 Discriminator ...");
                    String testUrl21Base = baseUri + "/pets";
                    String cat = "{\"pet_type\": \"Cat\",  \"age\": 3}";
                    String dog1 = "{\"pet_type\": \"Dog\",  \"bark\": false,  \"breed\": \"Dingo\" }";
                    String dog2 = "{\"pet_type\": \"Dog\",  \"bark\": true }";
                    ArrayList<String> tipoTest_test21 = new ArrayList<String>();
                    tipoTest_test21.add(cat);
                    tipoTest_test21.add(dog1);
                    tipoTest_test21.add(dog2);
                    int NUMERO_RISORSE_PET = 5;
                    Set<Integer> swagger_validator_fallimenti_allof = Set.of(Integer.valueOf(0), Integer.valueOf(3));
                    int k2 = 0;
                    while (true) {
                        Iterator iterator;
                        String testUrl21;
                        String testPet;
                        if (k2 < NUMERO_RISORSE_PET) {
                            int numeroPet = k2 + 1;
                            testPet = "[test pets" + numeroPet + "] ";
                            testUrl21 = testUrl21Base + numeroPet;
                            iterator = tipoTest_test21.iterator();
                        } else {
                            System.out.println("Test #21 Discriminator completato\n\n");
                            System.out.println("Test #22 validazione json con wildcard nel subtype ...");
                            OpenApi3ExtendedTest.testSubMediatypeWildcardJsonValidation(openAPILibrary, mergeSpec, true);
                            OpenApi3ExtendedTest.testSubMediatypeWildcardJsonValidation(openAPILibrary, mergeSpec, false);
                            System.out.println("Test #22 validazione json con wildcard nel subtype completato\n\n");
                            System.out.println("Test #23 validazione contenuto base64 ...");
                            if (openAPILibrary == OpenAPILibrary.openapi4j || openAPILibrary == OpenAPILibrary.swagger_request_validator) {
                                boolean oldValue = false;
                                try {
                                    if (openAPILibrary == OpenAPILibrary.openapi4j) {
                                        oldValue = ValidationOptions.VALIDATE_BASE64_VALUES;
                                        ValidationOptions.VALIDATE_BASE64_VALUES = true;
                                    }
                                    OpenApi3ExtendedTest.testBase64Validation(openAPILibrary, mergeSpec, apiValidatorOpenApi2);
                                }
                                finally {
                                    if (openAPILibrary == OpenAPILibrary.openapi4j) {
                                        ValidationOptions.VALIDATE_BASE64_VALUES = oldValue;
                                    }
                                }
                            } else {
                                System.out.println("Skippo Test validazione file upload in base64 per libreria differente da swagger_request_validator e openapi4j");
                            }
                            System.out.println("Test #23 validazione contenuto base64 completato\n\n");
                            System.out.println("Test #24.a openapi che usano mergeKey (<<: *) ...");
                            OpenApi3ExtendedTest.testMergeKey(openAPILibrary, mergeSpec);
                            System.out.println("Test #24.a openapi che usano mergeKey (<<: *) completato\n\n");
                            System.out.println("Test #24.b openapi che usano achor ref key (*) ...");
                            OpenApi3ExtendedTest.testAnchorRefKey(openAPILibrary, mergeSpec);
                            System.out.println("Test #24.b openapi che usano achor ref key (*) completato\n\n");
                            System.out.println("Test #25 openapi che usano multipart request ...");
                            if (openAPILibrary == OpenAPILibrary.openapi4j) {
                                boolean stream = true;
                                boolean multipartOptimization = true;
                                OpenApi3ExtendedTest.testMultipartRequest(openAPILibrary, mergeSpec, !stream, !multipartOptimization);
                                OpenApi3ExtendedTest.testMultipartRequest(openAPILibrary, mergeSpec, stream, !multipartOptimization);
                                OpenApi3ExtendedTest.testMultipartRequest(openAPILibrary, mergeSpec, !stream, multipartOptimization);
                                OpenApi3ExtendedTest.testMultipartRequest(openAPILibrary, mergeSpec, stream, multipartOptimization);
                                OpenApi3ExtendedTest.testMultipartRequestAsArray(openAPILibrary, mergeSpec, !stream, !multipartOptimization);
                                OpenApi3ExtendedTest.testMultipartRequestAsArray(openAPILibrary, mergeSpec, stream, !multipartOptimization);
                                OpenApi3ExtendedTest.testMultipartRequestAsArray(openAPILibrary, mergeSpec, !stream, multipartOptimization);
                                OpenApi3ExtendedTest.testMultipartRequestAsArray(openAPILibrary, mergeSpec, stream, multipartOptimization);
                            } else {
                                System.out.println("Skippo Test multipart request per libreria differente da openapi4j");
                            }
                            System.out.println("Test #25 openapi che usano multipart request completato\n\n");
                            System.out.println("Test #26 openapi che usano format string ...");
                            OpenApi3ExtendedTest.testFormatString(openAPILibrary, mergeSpec);
                            System.out.println("Test #26 openapi che usano format string completato\n\n");
                            System.out.println("Test #27 openapi che usano path dinamici ...");
                            OpenApi3ExtendedTest.testDynamicPath(openAPILibrary, mergeSpec);
                            System.out.println("Test #27 openapi che usano path dinamici completato\n\n");
                            System.out.println("Test #28 openapi che usano parametri definiti con schemi composti ...");
                            if (openAPILibrary != OpenAPILibrary.swagger_request_validator) {
                                OpenApi3ExtendedTest.testComposedSchemaParameters(openAPILibrary, mergeSpec);
                            } else {
                                System.out.println("Skippo Test per libreria swagger request validator: bug interpretazione stringhe in header, cookie e query");
                            }
                            System.out.println("Test #28 openapi che usano parametri definiti con schemi composti completato\n\n");
                            System.out.println("Test #29 header Accept ...");
                            OpenApi3ExtendedTest.testAccept(openAPILibrary, mergeSpec);
                            System.out.println("Test #29 header Accept\n\n");
                            System.out.println("Test #30.yaml schema: {}  ...");
                            OpenApi3ExtendedTest.testSchemaEmpty(openAPILibrary, mergeSpec, true);
                            System.out.println("Test #30.yaml schema: {} completato\n\n");
                            System.out.println("Test #30.json schema: {}  ...");
                            OpenApi3ExtendedTest.testSchemaEmpty(openAPILibrary, mergeSpec, false);
                            System.out.println("Test #30.json schema: {} completato\n\n");
                            System.out.println("Testsuite completata");
                            return;
                        }
                        while (iterator.hasNext()) {
                            String contenutoParam = (String)iterator.next();
                            Object contenuto = contenutoParam;
                            if (k2 == 1 || k2 == 2 || k2 == 4) {
                                contenuto = "{\"altro\":\"descrizione generica\", \"pet\":" + contenutoParam + "}";
                            }
                            TextHttpRequestEntity httpEntity21 = new TextHttpRequestEntity();
                            httpEntity21.setMethod(HttpRequestMethod.PATCH);
                            httpEntity21.setUrl(testUrl21);
                            HashMap<String, List<String>> parametersTrasporto19 = new HashMap<String, List<String>>();
                            TransportUtils.setHeader(parametersTrasporto19, "Content-Type", "application/json");
                            httpEntity21.setHeaders(parametersTrasporto19);
                            httpEntity21.setContentType("application/json");
                            httpEntity21.setContent(contenuto);
                            TextHttpResponseEntity httpEntityResponse_test21 = new TextHttpResponseEntity();
                            httpEntityResponse_test21.setStatus(200);
                            httpEntityResponse_test21.setMethod(HttpRequestMethod.PATCH);
                            httpEntityResponse_test21.setUrl(testUrl21);
                            HashMap<String, List<String>> parametersTrasportoRisposta_test21 = new HashMap<String, List<String>>();
                            TransportUtils.setHeader(parametersTrasportoRisposta_test21, "Content-Type", "application/json");
                            httpEntityResponse_test21.setHeaders(parametersTrasportoRisposta_test21);
                            httpEntityResponse_test21.setContentType("application/json");
                            httpEntityResponse_test21.setContent(contenuto);
                            String tipoTest15 = testPet + " ";
                            tipoTest15 = tipoTest15 + "[" + String.valueOf(openAPILibrary) + "]";
                            tipoTest15 = tipoTest15 + "(url:" + testUrl21 + ") contenuto(" + (String)contenuto + ")";
                            try {
                                System.out.println("\t " + tipoTest15 + " validate ...");
                                if (openAPILibrary == OpenAPILibrary.json_schema) {
                                    System.out.println("Discriminator con allOf non supportato da " + String.valueOf(openAPILibrary));
                                    continue;
                                }
                                if (openAPILibrary == OpenAPILibrary.swagger_request_validator && swagger_validator_fallimenti_allof.contains(k2)) {
                                    System.out.println("Discriminator con allOf non supportato da swagger-request-validator!");
                                    continue;
                                }
                                apiValidatorOpenApi2.validate(httpEntity21);
                                System.out.println("\t " + tipoTest15 + " validate ok");
                            }
                            catch (ValidatorException e33) {
                                Object error10 = e33.getMessage();
                                if (((String)error10).length() > 200) {
                                    error10 = ((String)error10).substring(0, 198) + " ...";
                                }
                                System.out.println("\t " + tipoTest15 + " rilevato errore di validazione non atteso: " + (String)error10);
                                throw new Exception(tipoTest15 + " rilevato errore di validazione non atteso: " + e33.getMessage(), e33);
                            }
                            try {
                                System.out.println("\t " + tipoTest15 + " validate response ...");
                                apiValidatorOpenApi2.validate(httpEntityResponse_test21);
                                System.out.println("\t " + tipoTest15 + " validate response ok");
                            }
                            catch (ValidatorException e34) {
                                Object error11 = e34.getMessage();
                                if (((String)error11).length() > 200) {
                                    error11 = ((String)error11).substring(0, 198) + " ...";
                                }
                                System.out.println("\t " + tipoTest15 + " rilevato errore di validazione non atteso: " + (String)error11);
                                throw new Exception(tipoTest15 + " rilevato errore di validazione non atteso: " + e34.getMessage(), e34);
                            }
                        }
                        ++k2;
                    }
                }
            }
        }
    }

    private static void checkErrorTest20(boolean esito, String tipoTest, Exception e, String tipologia, OpenAPILibrary openAPILibrary) throws Exception {
        Object error = e.getMessage();
        if (((String)error).length() > 200) {
            error = ((String)error).substring(0, 198) + " ...";
        }
        String element = "-";
        String type = "-";
        boolean arrayValuesNull = false;
        if ("StringNull".equals(tipologia)) {
            element = "string_";
            type = "string";
        } else if ("EnumNull".equals(tipologia)) {
            element = "enum_";
            type = "string";
        } else if ("IntegerNull".equals(tipologia)) {
            element = "integer_";
            type = "integer";
        } else if ("BooleanNull".equals(tipologia)) {
            element = "boolean_";
            type = "boolean";
        } else if ("ArrayNull".equals(tipologia)) {
            element = "array_";
            type = "array";
        } else if ("ArrayValuesNull".equals(tipologia)) {
            arrayValuesNull = true;
        } else if ("ObjectNull".equals(tipologia)) {
            element = "object_";
            type = "object";
        }
        if (esito) {
            System.out.println("\t " + tipoTest + " rilevato errore di validazione non atteso: " + (String)error);
            throw new Exception(tipoTest + " rilevato errore di validazione non atteso: " + e.getMessage(), e);
        }
        System.out.println("\t " + tipoTest + " atteso errore di validazione, rilevato: " + (String)error);
        switch (openAPILibrary) {
            case json_schema: {
                if (arrayValuesNull) {
                    String msgErroreAtteso = "1029 $.array_nullable_values_optional[0]: null found, string expected";
                    if (msgErroreAtteso != null && !e.getMessage().contains(msgErroreAtteso)) {
                        System.out.println("\t " + tipoTest + " ERRORE!");
                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                    }
                    msgErroreAtteso = "1029 $.array_nullable_values_optional[1]: null found, string expected";
                    if (msgErroreAtteso != null && !e.getMessage().contains(msgErroreAtteso)) {
                        System.out.println("\t " + tipoTest + " ERRORE!");
                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                    }
                    msgErroreAtteso = "1029 $.array_nullable_values_required[0]: null found, string expected";
                    if (msgErroreAtteso == null || e.getMessage().contains(msgErroreAtteso)) break;
                    System.out.println("\t " + tipoTest + " ERRORE!");
                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                }
                for (int k = 0; k < 2; ++k) {
                    String msgErroreAtteso = "1029 $." + element + (k == 0 ? "required" : "optional") + ": null found, " + type + " expected";
                    if (msgErroreAtteso == null || e.getMessage().contains(msgErroreAtteso)) continue;
                    System.out.println("\t " + tipoTest + " ERRORE!");
                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                }
                break;
            }
            case openapi4j: {
                if (arrayValuesNull) {
                    String msgErroreAtteso = "body.array_nullable_values_optional.0: Null value is not allowed. (code: 1021)";
                    if (msgErroreAtteso != null && !e.getMessage().contains(msgErroreAtteso)) {
                        System.out.println("\t " + tipoTest + " ERRORE!");
                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                    }
                    msgErroreAtteso = "body.array_nullable_values_optional.1: Null value is not allowed. (code: 1021)";
                    if (msgErroreAtteso != null && !e.getMessage().contains(msgErroreAtteso)) {
                        System.out.println("\t " + tipoTest + " ERRORE!");
                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                    }
                    msgErroreAtteso = "body.array_nullable_values_required.0: Null value is not allowed. (code: 1021)";
                    if (msgErroreAtteso == null || e.getMessage().contains(msgErroreAtteso)) break;
                    System.out.println("\t " + tipoTest + " ERRORE!");
                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                }
                for (int k = 0; k < 2; ++k) {
                    String suffix = k == 0 ? "required" : "optional";
                    String msgErroreAtteso = "body." + element + suffix + ": Null value is not allowed. (code: 1021)";
                    if (msgErroreAtteso == null || e.getMessage().contains(msgErroreAtteso)) continue;
                    System.out.println("\t " + tipoTest + " ERRORE!");
                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                }
                break;
            }
            case swagger_request_validator: {
                if (arrayValuesNull) {
                    String msgErroreAtteso = "[Path '/array_nullable_values_optional/0'] Instance type (null) does not match any allowed primitive type (allowed: [\"string\"])";
                    if (msgErroreAtteso != null && !e.getMessage().contains(msgErroreAtteso)) {
                        System.out.println("\t " + tipoTest + " ERRORE!");
                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                    }
                    msgErroreAtteso = "[Path '/array_nullable_values_optional/1'] Instance type (null) does not match any allowed primitive type (allowed: [\"string\"])";
                    if (msgErroreAtteso != null && !e.getMessage().contains(msgErroreAtteso)) {
                        System.out.println("\t " + tipoTest + " ERRORE!");
                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                    }
                    msgErroreAtteso = "[Path '/array_nullable_values_required/0'] Instance type (null) does not match any allowed primitive type (allowed: [\"string\"])";
                    if (msgErroreAtteso == null || e.getMessage().contains(msgErroreAtteso)) break;
                    System.out.println("\t " + tipoTest + " ERRORE!");
                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                }
                for (int k = 0; k < 2; ++k) {
                    String suffix = k == 0 ? "required" : "optional";
                    String msgErroreAtteso = "[Path '/" + element + suffix + "'] Instance type (null) does not match any allowed primitive type (allowed:";
                    if (msgErroreAtteso == null || e.getMessage().contains(msgErroreAtteso)) continue;
                    System.out.println("\t " + tipoTest + " ERRORE!");
                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso + "'");
                }
                break;
            }
        }
    }

    private static void testSubMediatypeWildcardJsonValidation(OpenAPILibrary openAPILibrary, boolean mergeSpec, boolean validateWildcard) throws UtilsException, ProcessingException, URISyntaxException, Exception {
        block7: {
            HashMap<String, List<String>> headersS1;
            IApiValidator apiValidatorOpenApi4j;
            block6: {
                System.out.println("#### Verifica per validazione json con wildcard (" + validateWildcard + ") nel subtype ####");
                URL url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/allegati.yaml");
                ApiSchema apiSchemaYaml = new ApiSchema("teamdigitale-openapi_definitions.yaml", Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/service/schemi/standard/teamdigitale-openapi_definitions.yaml")), ApiSchemaType.YAML);
                IApiReader apiReaderOpenApi4j = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
                ApiReaderConfig configOpenApi4j = new ApiReaderConfig();
                configOpenApi4j.setProcessInclude(false);
                apiReaderOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi4j, apiSchemaYaml);
                Api apiOpenApi4j = apiReaderOpenApi4j.read();
                apiValidatorOpenApi4j = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
                OpenapiApiValidatorConfig configO = new OpenapiApiValidatorConfig();
                configO.setEmitLogError(logSystemOutError);
                configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
                configO.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
                configO.getOpenApiValidatorConfig().setValidateAPISpec(true);
                configO.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
                configO.getOpenApiValidatorConfig().setValidateWildcardSubtypeAsJson(validateWildcard);
                apiValidatorOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi4j, configO);
                System.out.println("Test Richiesta...");
                TextHttpRequestEntity requestS1 = new TextHttpRequestEntity();
                requestS1.setMethod(HttpRequestMethod.POST);
                requestS1.setUrl("documenti/qualsiasi/" + UUID.randomUUID().toString());
                headersS1 = new HashMap<String, List<String>>();
                TransportUtils.setHeader(headersS1, "Content-Type", "text/plain");
                requestS1.setContentType("text/plain");
                requestS1.setHeaders(headersS1);
                requestS1.setContent("{ a }");
                String erroreAttesoRichiesta = openAPILibrary == OpenAPILibrary.openapi4j ? "body: Type expected 'object', found 'string'. (code: 1027)" : "[ERROR] Unable to parse JSON - Unexpected character ('a' (code 97)): was expecting double-quote to start field name";
                try {
                    apiValidatorOpenApi4j.validate(requestS1);
                    if (openAPILibrary != OpenAPILibrary.json_schema && validateWildcard) {
                        throw new Exception("Errore atteso '" + erroreAttesoRichiesta + "' non rilevato");
                    }
                }
                catch (ValidatorException e) {
                    System.out.println(e.getMessage());
                    if (e.getMessage().contains(erroreAttesoRichiesta)) break block6;
                    throw new Exception("Errore atteso '" + erroreAttesoRichiesta + "' non rilevato");
                }
            }
            System.out.println("Test Richiesta Superato!");
            System.out.println("Test Risposta...");
            TextHttpResponseEntity httpResponseTestS1 = new TextHttpResponseEntity();
            httpResponseTestS1.setStatus(200);
            httpResponseTestS1.setMethod(HttpRequestMethod.GET);
            httpResponseTestS1.setUrl("documenti/qualsiasi/" + UUID.randomUUID().toString());
            headersS1 = new HashMap();
            TransportUtils.setHeader(headersS1, "Content-Type", "text/plain");
            httpResponseTestS1.setHeaders(headersS1);
            httpResponseTestS1.setContentType("text/plain");
            httpResponseTestS1.setContent("{ a }");
            String erroreAttesoRisposta = openAPILibrary == OpenAPILibrary.openapi4j ? "body: Type expected 'object', found 'string'. (code: 1027)" : "[ERROR] Unable to parse JSON - Unexpected character ('a' (code 97)): was expecting double-quote to start field name";
            try {
                apiValidatorOpenApi4j.validate(httpResponseTestS1);
                if (openAPILibrary != OpenAPILibrary.json_schema && validateWildcard) {
                    throw new Exception("Errore atteso '" + erroreAttesoRisposta + "' non rilevato");
                }
            }
            catch (ValidatorException e) {
                System.out.println(e.getMessage());
                if (e.getMessage().contains(erroreAttesoRisposta)) break block7;
                throw new Exception("Errore atteso '" + erroreAttesoRisposta + "' non rilevato");
            }
        }
        System.out.println("Test Risposta Superato!");
        System.out.println("TEST #S-1 per validazione json con wildcard (" + validateWildcard + ") nel subtype completato!");
    }

    private static void testBase64Validation(OpenAPILibrary openAPILibrary, boolean mergeSpec, IApiValidator validator) throws Exception {
        System.out.println("TEST #S-2 per validazione file in base64");
        System.out.println("Valido richiesta con contenuto corretto..");
        TextHttpRequestEntity validRequest = new TextHttpRequestEntity();
        validRequest.setUrl("/documenti/testbase64/" + UUID.randomUUID().toString());
        validRequest.setMethod(HttpRequestMethod.POST);
        validRequest.setContent("Q2lhbyBiYmVsbG8h");
        HashMap<String, List<String>> parametersTrasporto = new HashMap<String, List<String>>();
        TransportUtils.addHeader(parametersTrasporto, "Content-Type", "application/octet-stream");
        validRequest.setHeaders(parametersTrasporto);
        validRequest.setContentType("application/octet-stream");
        validator.validate(validRequest);
        System.out.println("Nessun errore sollevato, ok!");
        System.out.println("Valido richiesta con contenuto non corretto..");
        TextHttpRequestEntity invalidRequest = new TextHttpRequestEntity();
        invalidRequest.setUrl("/documenti/testbase64/" + UUID.randomUUID().toString());
        invalidRequest.setMethod(HttpRequestMethod.POST);
        invalidRequest.setContent("{ asper");
        parametersTrasporto = new HashMap();
        TransportUtils.addHeader(parametersTrasporto, "Content-Type", "application/octet-stream");
        invalidRequest.setHeaders(parametersTrasporto);
        invalidRequest.setContentType("application/octet-stream");
        String erroreAttesoRichiesta = null;
        if (openAPILibrary == OpenAPILibrary.openapi4j) {
            erroreAttesoRichiesta = "body: Value '{ asper' does not match format 'base64'. (code: 1007)";
        } else if (openAPILibrary == OpenAPILibrary.swagger_request_validator) {
            erroreAttesoRichiesta = "[ERROR] [REQUEST] err.format.base64.badLength, should be multiple of 4: 7";
        }
        try {
            validator.validate(invalidRequest);
            throw new Exception("Errore atteso '" + erroreAttesoRichiesta + "' non rilevato");
        }
        catch (ValidatorException e) {
            System.out.println(e.getMessage());
            if (!e.getMessage().contains(erroreAttesoRichiesta)) {
                throw new Exception("Errore atteso '" + erroreAttesoRichiesta + "' non rilevato");
            }
            System.out.println("Errore rilevato, ok!");
            System.out.println("Valido risposta con contenuto corretto..");
            TextHttpResponseEntity validResponse = new TextHttpResponseEntity();
            validResponse.setUrl("/documenti/testbase64/" + UUID.randomUUID().toString());
            validResponse.setMethod(HttpRequestMethod.POST);
            validResponse.setStatus(200);
            validResponse.setContent("Q2lhbyBiYmVsbG8h");
            parametersTrasporto = new HashMap();
            TransportUtils.addHeader(parametersTrasporto, "Content-Type", "application/octet-stream");
            validResponse.setHeaders(parametersTrasporto);
            validResponse.setContentType("application/octet-stream");
            validator.validate(validResponse);
            System.out.println("Nessun errore sollevato, ok!");
            System.out.println("Valido risposta con contenuto non corretto..");
            TextHttpResponseEntity invalidResponse = new TextHttpResponseEntity();
            invalidResponse.setUrl("/documenti/testbase64/" + UUID.randomUUID().toString());
            invalidResponse.setMethod(HttpRequestMethod.POST);
            invalidResponse.setStatus(200);
            invalidResponse.setContent("{ asper");
            parametersTrasporto = new HashMap();
            TransportUtils.addHeader(parametersTrasporto, "Content-Type", "application/octet-stream");
            invalidResponse.setContentType("application/octet-stream");
            invalidResponse.setHeaders(parametersTrasporto);
            String erroreAttesoRisposta = null;
            if (openAPILibrary == OpenAPILibrary.openapi4j) {
                erroreAttesoRisposta = "body: Value '{ asper' does not match format 'base64'. (code: 1007)";
            } else if (openAPILibrary == OpenAPILibrary.swagger_request_validator) {
                erroreAttesoRisposta = "[ERROR] [RESPONSE] err.format.base64.badLength, should be multiple of 4: 7";
            }
            try {
                validator.validate(invalidResponse);
                throw new Exception("Errore atteso '" + erroreAttesoRisposta + "' non rilevato");
            }
            catch (ValidatorException e2) {
                System.out.println(e2.getMessage());
                if (!e2.getMessage().contains(erroreAttesoRisposta)) {
                    throw new Exception("Errore atteso '" + erroreAttesoRisposta + "' non rilevato");
                }
                System.out.println("Errore rilevato, ok!");
                System.out.println("TEST #S-2 per validazione file in base64 completato!");
                return;
            }
        }
    }

    private static void testMergeKey(OpenAPILibrary openAPILibrary, boolean mergeSpec) throws UtilsException, ProcessingException, URISyntaxException, Exception {
        System.out.println("#### Verifica OpenAPI YAML con mergeKey ####");
        URL url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/mergeKey.yaml");
        IApiReader apiReaderOpenApi4j = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        ApiReaderConfig configOpenApi4j = new ApiReaderConfig();
        configOpenApi4j.setProcessInclude(false);
        apiReaderOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi4j);
        Api apiOpenApi4j = apiReaderOpenApi4j.read();
        try {
            apiOpenApi4j.validate();
        }
        catch (ProcessingException pe) {
            pe.printStackTrace(System.out);
            throw new Exception(" Documento contenente errori: " + pe.getMessage(), pe);
        }
        catch (ParseWarningException warning) {
            System.out.println("Documento contenente anomalie: " + warning.getMessage());
        }
        IApiValidator apiValidatorOpenApi4j = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
        OpenapiApiValidatorConfig configO = new OpenapiApiValidatorConfig();
        configO.setEmitLogError(logSystemOutError);
        configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
        configO.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
        configO.getOpenApiValidatorConfig().setValidateAPISpec(true);
        configO.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
        apiValidatorOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi4j, configO);
        System.out.println("Test Richiesta...");
        TextHttpRequestEntity requestS1 = new TextHttpRequestEntity();
        requestS1.setMethod(HttpRequestMethod.GET);
        requestS1.setUrl("/test/" + UUID.randomUUID().toString());
        try {
            apiValidatorOpenApi4j.validate(requestS1);
        }
        catch (ValidatorException e) {
            System.out.println(e.getMessage());
            throw new Exception("Errore non atteso");
        }
        System.out.println("Test Richiesta Superato!");
        System.out.println("Test Risposta...");
        TextHttpResponseEntity httpResponseTestS1 = new TextHttpResponseEntity();
        httpResponseTestS1.setStatus(200);
        httpResponseTestS1.setMethod(HttpRequestMethod.GET);
        httpResponseTestS1.setUrl("/test/" + UUID.randomUUID().toString());
        HashMap<String, List<String>> headersS1 = new HashMap<String, List<String>>();
        TransportUtils.setHeader(headersS1, "Content-Type", "application/json");
        httpResponseTestS1.setHeaders(headersS1);
        httpResponseTestS1.setContentType("application/json");
        httpResponseTestS1.setContent("{ \"test\": \"01043931007\", \"valida\": false }");
        try {
            apiValidatorOpenApi4j.validate(httpResponseTestS1);
        }
        catch (ValidatorException e) {
            System.out.println(e.getMessage());
            throw new Exception("Errore non atteso");
        }
        httpResponseTestS1.setStatus(400);
        headersS1 = new HashMap();
        TransportUtils.setHeader(headersS1, "Content-Type", "application/problem+json");
        httpResponseTestS1.setHeaders(headersS1);
        httpResponseTestS1.setContentType("application/problem+json");
        httpResponseTestS1.setContent("{ \"type\": \"https://example.com/400\", \"title\": \"example\", \"detail\": \"example\" }");
        try {
            apiValidatorOpenApi4j.validate(httpResponseTestS1);
        }
        catch (ValidatorException e) {
            System.out.println(e.getMessage());
            throw new Exception("Errore non atteso");
        }
        httpResponseTestS1.setStatus(400);
        headersS1 = new HashMap();
        TransportUtils.setHeader(headersS1, "Content-Type", "application/json");
        httpResponseTestS1.setHeaders(headersS1);
        httpResponseTestS1.setContentType("application/json");
        httpResponseTestS1.setContent("{ \"type\": \"https://example.com/400\", \"title\": \"example\", \"detail\": \"example\" }");
        String erroreAttesoRisposta = null;
        switch (openAPILibrary) {
            case json_schema: {
                erroreAttesoRisposta = "Content-Type 'application/json' (http response status '400') unsupported";
                break;
            }
            case openapi4j: {
                erroreAttesoRisposta = "Content type 'application/json' is not allowed for body content. (code: 203)";
                break;
            }
            case swagger_request_validator: {
                erroreAttesoRisposta = "[ERROR][RESPONSE][] Response Content-Type header 'application/json' does not match any allowed types. Must be one of: [application/problem+json].";
            }
        }
        try {
            apiValidatorOpenApi4j.validate(httpResponseTestS1);
            throw new Exception("Errore atteso '" + erroreAttesoRisposta + "' non rilevato");
        }
        catch (ValidatorException e) {
            System.out.println(e.getMessage());
            if (!e.getMessage().contains(erroreAttesoRisposta)) {
                throw new Exception("Errore atteso '" + erroreAttesoRisposta + "' non rilevato");
            }
            System.out.println("Test Risposta Superato!");
            System.out.println("TEST OpenAPI YAML con mergeKey completato!");
            return;
        }
    }

    private static void testAnchorRefKey(OpenAPILibrary openAPILibrary, boolean mergeSpec) throws UtilsException, ProcessingException, URISyntaxException, Exception {
        System.out.println("#### Verifica OpenAPI YAML con anchorRefKey ####");
        URL url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/anchorRefKey.yaml");
        IApiReader apiReaderOpenApi4j = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        ApiReaderConfig configOpenApi4j = new ApiReaderConfig();
        configOpenApi4j.setProcessInclude(false);
        apiReaderOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi4j);
        Api apiOpenApi4j = apiReaderOpenApi4j.read();
        try {
            apiOpenApi4j.validate();
        }
        catch (ProcessingException pe) {
            pe.printStackTrace(System.out);
            throw new Exception(" Documento contenente errori: " + pe.getMessage(), pe);
        }
        catch (ParseWarningException warning) {
            System.out.println("Documento contenente anomalie: " + warning.getMessage());
        }
        IApiValidator apiValidatorOpenApi4j = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
        OpenapiApiValidatorConfig configO = new OpenapiApiValidatorConfig();
        configO.setEmitLogError(logSystemOutError);
        configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
        configO.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
        configO.getOpenApiValidatorConfig().setValidateAPISpec(true);
        configO.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
        apiValidatorOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi4j, configO);
        ArrayList<String> operations = new ArrayList<String>();
        operations.add("/opDefinisceAnchor");
        operations.add("/opRiferisceAnchor");
        for (String op : operations) {
            block16: {
                System.out.println("Test Richiesta (" + op + ")...");
                TextHttpRequestEntity requestS1 = new TextHttpRequestEntity();
                requestS1.setMethod(HttpRequestMethod.POST);
                requestS1.setUrl(op);
                HashMap<String, List<String>> headersS1 = new HashMap<String, List<String>>();
                TransportUtils.setHeader(headersS1, "Content-Type", "application/json");
                requestS1.setHeaders(headersS1);
                requestS1.setContentType("application/json");
                requestS1.setContent("{ \"id\": \"01043931007\", \"codice\": \"xx\" }");
                try {
                    apiValidatorOpenApi4j.validate(requestS1);
                }
                catch (ValidatorException e) {
                    System.out.println(e.getMessage());
                    throw new Exception("Errore non atteso");
                }
                System.out.println("Test Richiesta (" + op + ") Superato!");
                System.out.println("Test Risposta (" + op + ")...");
                TextHttpResponseEntity httpResponseTestS1 = new TextHttpResponseEntity();
                httpResponseTestS1.setStatus(200);
                httpResponseTestS1.setMethod(HttpRequestMethod.POST);
                httpResponseTestS1.setUrl("/opRiferisceAnchor");
                headersS1 = new HashMap();
                TransportUtils.addHeader(headersS1, "Content-Type", "application/json");
                TransportUtils.addHeader(headersS1, "X-RateLimit-Limit", "10");
                TransportUtils.addHeader(headersS1, "X-RateLimit-Remaining", "5");
                TransportUtils.addHeader(headersS1, "X-RateLimit-Reset", "10");
                httpResponseTestS1.setHeaders(headersS1);
                httpResponseTestS1.setContentType("application/json");
                httpResponseTestS1.setContent("{ \"detail\": \"01043931007\", \"status\": 200 }");
                try {
                    apiValidatorOpenApi4j.validate(httpResponseTestS1);
                }
                catch (ValidatorException e) {
                    System.out.println(e.getMessage());
                    throw new Exception("Errore non atteso");
                }
                headersS1 = new HashMap();
                TransportUtils.addHeader(headersS1, "Content-Type", "application/json");
                httpResponseTestS1.setHeaders(headersS1);
                httpResponseTestS1.setContentType("application/json");
                httpResponseTestS1.setContent("{ \"detail\": \"01043931007\", \"status\": 200 }");
                String erroreAttesoRisposta = null;
                switch (openAPILibrary) {
                    case json_schema: {
                        erroreAttesoRisposta = "Content-Type 'application/json' (http response status '400') unsupported";
                        break;
                    }
                    case openapi4j: {
                        erroreAttesoRisposta = "Parameter 'X-RateLimit-Remaining' is required. (code: 206)";
                        break;
                    }
                    case swagger_request_validator: {
                        erroreAttesoRisposta = "[ERROR][RESPONSE][] Header 'X-RateLimit-Limit' is expected on path '/opRiferisceAnchor' but not found in response.";
                    }
                }
                try {
                    apiValidatorOpenApi4j.validate(httpResponseTestS1);
                    if (openAPILibrary != OpenAPILibrary.json_schema) {
                        throw new Exception("Errore atteso '" + erroreAttesoRisposta + "' non rilevato");
                    }
                }
                catch (ValidatorException e) {
                    System.out.println(e.getMessage());
                    if (e.getMessage().contains(erroreAttesoRisposta)) break block16;
                    throw new Exception("Errore atteso '" + erroreAttesoRisposta + "' non rilevato");
                }
            }
            System.out.println("Test Risposta (" + op + ") Superato!");
        }
        System.out.println("TEST OpenAPI YAML con anchorRefKey completato!");
    }

    private static void testMultipartRequest(OpenAPILibrary openAPILibrary, boolean mergeSpec, boolean stream, boolean multipartOptimization) throws UtilsException, ProcessingException, URISyntaxException, Exception {
        System.out.println("#### Verifica Multipart Request (stream:" + stream + " multipartOptimization:" + multipartOptimization + ") ####");
        URL url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/allegati.yaml");
        ApiSchema apiSchemaYaml = new ApiSchema("teamdigitale-openapi_definitions.yaml", Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/service/schemi/standard/teamdigitale-openapi_definitions.yaml")), ApiSchemaType.YAML);
        IApiReader apiReaderOpenApi4j = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        ApiReaderConfig configOpenApi4j = new ApiReaderConfig();
        configOpenApi4j.setProcessInclude(false);
        apiReaderOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi4j, apiSchemaYaml);
        Api apiOpenApi4j = apiReaderOpenApi4j.read();
        IApiValidator apiValidatorOpenApi4j = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
        OpenapiApiValidatorConfig configO = new OpenapiApiValidatorConfig();
        configO.setEmitLogError(logSystemOutError);
        configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
        configO.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
        configO.getOpenApiValidatorConfig().setValidateAPISpec(true);
        configO.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
        configO.getOpenApiValidatorConfig().setValidateMultipartOptimization(multipartOptimization);
        apiValidatorOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi4j, configO);
        String cat = "{\"pet_type\": \"Cat\",  \"age\": 3}";
        String dog1 = "{\"pet_type\": \"Dog\",  \"bark\": false,  \"breed\": \"Dingo\" }";
        String dog2 = "{\"pet_type\": \"Dog\",  \"bark\": true }";
        String contenuto_cat = "{\"altro\":\"descrizione generica\", \"pet\":" + cat + "}";
        String contenuto_dog1 = "{\"altro\":\"descrizione generica\", \"pet\":" + dog1 + "}";
        String contenuto_dog2 = "{\"altro\":\"descrizione generica\", \"pet\":" + dog2 + "}";
        String contenuto_errato1 = "{\"altroErrore\":\"descrizione generica\", \"pet\":" + dog2 + "}";
        String contenuto_errato2 = "{\"pet\":" + dog2 + "}";
        String catErrato = "{\"pet_type\": \"CatErrato\",  \"age\": 3}";
        String contenuto_errato3 = "{\"altro\":\"descrizione generica\", \"pet\":" + catErrato + "}";
        byte[] pdf = Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/openapi/test/test.pdf"));
        byte[] pdfEncodedBase64 = Base64Utilities.encode(pdf);
        ArrayList<String> macroTest_path = new ArrayList<String>();
        ArrayList<String> macroTest_subtype = new ArrayList<String>();
        macroTest_path.add("/documenti/multipart/form-data/strict");
        macroTest_subtype.add("form-data");
        macroTest_path.add("/documenti/multipart/mixed/strict");
        macroTest_subtype.add("mixed");
        macroTest_path.add("/documenti/multipart/form-data/optionalWithoutEncoding");
        macroTest_subtype.add("form-data");
        macroTest_path.add("/documenti/multipart/mixed/optionalWithoutEncoding");
        macroTest_subtype.add("mixed");
        macroTest_path.add("/documenti/multipart/form-data-and-mixed/strict");
        macroTest_subtype.add("form-data");
        macroTest_path.add("/documenti/multipart/form-data-and-mixed/strict");
        macroTest_subtype.add("mixed");
        for (int j = 0; j < macroTest_path.size(); ++j) {
            String subtype;
            String macroTestPath = (String)macroTest_path.get(j);
            String macroTestSubtype = (String)macroTest_subtype.get(j);
            ArrayList<String> tipoTest = new ArrayList<String>();
            ArrayList<Boolean> erroreAttesoTest = new ArrayList<Boolean>();
            ArrayList<Object> msgErroreAttesoTest = new ArrayList<Object>();
            ArrayList<String> msgErroreAttesoRispostaTest = new ArrayList<String>();
            ArrayList<String> pathTest = new ArrayList<String>();
            ArrayList<HttpRequestMethod> methodTest = new ArrayList<HttpRequestMethod>();
            ArrayList<String> attachment_subtype = new ArrayList<String>();
            ArrayList<String> attachment1_name = new ArrayList<String>();
            ArrayList<Object> attachment1_content = new ArrayList<Object>();
            ArrayList<String> attachment1_contentType = new ArrayList<String>();
            ArrayList<String> attachment1_fileName = new ArrayList<String>();
            ArrayList<String> attachment2_name = new ArrayList<String>();
            ArrayList<Object> attachment2_content = new ArrayList<Object>();
            ArrayList<String> attachment2_contentType = new ArrayList<String>();
            ArrayList<String> attachment2_fileName = new ArrayList<String>();
            ArrayList<String> attachment3_name = new ArrayList<String>();
            ArrayList<byte[]> attachment3_content = new ArrayList<byte[]>();
            ArrayList<String> attachment3_contentType = new ArrayList<String>();
            ArrayList<String> attachment3_fileName = new ArrayList<String>();
            ArrayList<String> attachment4_name = new ArrayList<String>();
            ArrayList<byte[]> attachment4_content = new ArrayList<byte[]>();
            ArrayList<String> attachment4_contentType = new ArrayList<String>();
            ArrayList<String> attachment4_fileName = new ArrayList<String>();
            ArrayList<String> attachment5_name = new ArrayList<String>();
            ArrayList<byte[]> attachment5_content = new ArrayList<byte[]>();
            ArrayList<String> attachment5_contentType = new ArrayList<String>();
            ArrayList<String> attachment5_fileName = new ArrayList<String>();
            tipoTest.add("OK-1: cat");
            erroreAttesoTest.add(false);
            msgErroreAttesoTest.add(null);
            msgErroreAttesoRispostaTest.add(null);
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_cat);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("OK-2: dog1");
            erroreAttesoTest.add(false);
            msgErroreAttesoTest.add(null);
            msgErroreAttesoRispostaTest.add(null);
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_dog1);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("OK-3: dog2 con file name in tutti i parametri");
            erroreAttesoTest.add(false);
            msgErroreAttesoTest.add(null);
            msgErroreAttesoRispostaTest.add(null);
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add("\"id.txt\"");
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_dog2);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add("\"metadati.json\"");
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("OK-4: parameter senza doppi apici \"");
            erroreAttesoTest.add(false);
            msgErroreAttesoTest.add(null);
            msgErroreAttesoRispostaTest.add(null);
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("id");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("metadati");
            attachment2_content.add(contenuto_dog2);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add("docPdf");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("docPdf2");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("OK-5: fileName senza doppi apici \"");
            erroreAttesoTest.add(false);
            msgErroreAttesoTest.add(null);
            msgErroreAttesoRispostaTest.add(null);
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_dog2);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("attachment.pdf");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("attachment2.pdf");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("OK-6: fileName non presente \"");
            erroreAttesoTest.add(false);
            msgErroreAttesoTest.add(null);
            msgErroreAttesoRispostaTest.add(null);
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_dog2);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add(null);
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add(null);
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("OK-7: parametro docPdf2 (opzionale) non presente");
            erroreAttesoTest.add(false);
            msgErroreAttesoTest.add(null);
            msgErroreAttesoRispostaTest.add(null);
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_dog2);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add(null);
            attachment4_content.add(null);
            attachment4_contentType.add(null);
            attachment4_fileName.add(null);
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("OK-8: posizioni invertite");
            erroreAttesoTest.add(false);
            msgErroreAttesoTest.add(null);
            msgErroreAttesoRispostaTest.add(null);
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment2_name.add("\"id\"");
            attachment2_content.add("2147483647");
            attachment2_contentType.add("text/plain");
            attachment2_fileName.add(null);
            attachment1_name.add("\"metadati\"");
            attachment1_content.add(contenuto_dog2);
            attachment1_contentType.add("application/json");
            attachment1_fileName.add(null);
            attachment4_name.add("\"docPdf\"");
            attachment4_content.add(pdf);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment.pdf\"");
            attachment3_name.add("\"docPdf2\"");
            attachment3_content.add(pdfEncodedBase64);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("ERROR-1: attachment ulteriore, non previsto");
            if (macroTestPath.endsWith("optionalWithoutEncoding") || multipartOptimization) {
                erroreAttesoTest.add(false);
                msgErroreAttesoTest.add(null);
                msgErroreAttesoRispostaTest.add(null);
            } else {
                erroreAttesoTest.add(true);
                msgErroreAttesoTest.add("Additional property 'docUlteriore' is not allowed. (code: 1000)");
                msgErroreAttesoRispostaTest.add("Additional property 'docUlteriore' is not allowed. (code: 1000)");
            }
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_cat);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add("\"docUlteriore\"");
            attachment5_content.add(pdfEncodedBase64);
            attachment5_contentType.add("application/pdf");
            attachment5_fileName.add("\"attachmentOther.bin\"");
            tipoTest.add("ERROR-2: contenuto errato nei metadati, required claim 'altro' presente con un nome differente");
            erroreAttesoTest.add(true);
            msgErroreAttesoTest.add("body.metadati: Field 'altro' is required. (code: 1026)");
            msgErroreAttesoRispostaTest.add("body.metadati: Field 'altro' is required. (code: 1026)");
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_errato1);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("ERROR-3: contenuto errato nei metadati, required claim 'altro' non presente e fileName presente in tutti i parametri");
            erroreAttesoTest.add(true);
            msgErroreAttesoTest.add("body.metadati: Field 'altro' is required. (code: 1026)");
            msgErroreAttesoRispostaTest.add("body.metadati: Field 'altro' is required. (code: 1026)");
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add("\"id.txt\"");
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_errato2);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add("\"metadati.json\"");
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("ERROR-4: contenuto errato nei metadati, discriminator value errato");
            erroreAttesoTest.add(true);
            msgErroreAttesoTest.add("body.metadati.pet: Schema selection can't be made for discriminator 'pet_type' with value 'CatErrato'. (code: 1003)");
            msgErroreAttesoRispostaTest.add("body.metadati.pet: Schema selection can't be made for discriminator 'pet_type' with value 'CatErrato'. (code: 1003)");
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_errato3);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("ERROR-5: parametro primitivo id con value errato (string)");
            erroreAttesoTest.add(true);
            msgErroreAttesoTest.add("body.id: Value 'ValoreNonInteroERR' does not match format 'int32'. (code: 1007)");
            msgErroreAttesoRispostaTest.add("body.id: Value 'ValoreNonInteroERR' does not match format 'int32'. (code: 1007)");
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("ValoreNonInteroERR");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_cat);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("ERROR-6: parametro primitivo id con value errato (string) e fileName presente");
            erroreAttesoTest.add(true);
            msgErroreAttesoTest.add("body.id: Value 'ValoreNonInteroERR' does not match format 'int32'. (code: 1007)");
            msgErroreAttesoRispostaTest.add("body.id: Value 'ValoreNonInteroERR' does not match format 'int32'. (code: 1007)");
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("ValoreNonInteroERR");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add("\"id.txt\"");
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_cat);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add("\"metadati.json\"");
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("ERROR-7: parametro docPdf non presente");
            if (macroTestPath.endsWith("optionalWithoutEncoding") || multipartOptimization) {
                erroreAttesoTest.add(false);
                msgErroreAttesoTest.add(null);
                msgErroreAttesoRispostaTest.add(null);
            } else {
                erroreAttesoTest.add(true);
                msgErroreAttesoTest.add("body: Field 'docPdf' is required. (code: 1026)");
                msgErroreAttesoRispostaTest.add("body: Field 'docPdf' is required. (code: 1026)");
            }
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_cat);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add(null);
            attachment3_content.add(null);
            attachment3_contentType.add(null);
            attachment3_fileName.add(null);
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            tipoTest.add("ERROR-8: parametro docPdf non dichiarato tramite name");
            if (macroTestPath.endsWith("optionalWithoutEncoding") || multipartOptimization) {
                erroreAttesoTest.add(false);
                msgErroreAttesoTest.add(null);
                msgErroreAttesoRispostaTest.add(null);
            } else {
                erroreAttesoTest.add(true);
                msgErroreAttesoTest.add("body: Field 'docPdf' is required. (code: 1026)");
                msgErroreAttesoRispostaTest.add("body: Field 'docPdf' is required. (code: 1026)");
            }
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_cat);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add(null);
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            if (!macroTestPath.contains("form-data-and-mixed")) {
                tipoTest.add("ERROR-9: content-type multipart opposto tra mixed e form-data");
                erroreAttesoTest.add(true);
                subtype = "form-data".equals(macroTestSubtype) ? "mixed" : "form-data";
                msgErroreAttesoTest.add("Content type 'multipart/" + subtype + ";");
                msgErroreAttesoRispostaTest.add("is not allowed for body content. (code: 203)");
                pathTest.add(macroTestPath);
                methodTest.add(HttpRequestMethod.POST);
                attachment_subtype.add(subtype);
                attachment1_name.add("\"id\"");
                attachment1_content.add("2147483647");
                attachment1_contentType.add("text/plain");
                attachment1_fileName.add(null);
                attachment2_name.add("\"metadati\"");
                attachment2_content.add(contenuto_cat);
                attachment2_contentType.add("application/json");
                attachment2_fileName.add(null);
                attachment3_name.add("\"docPdf\"");
                attachment3_content.add(pdf);
                attachment3_contentType.add("application/pdf");
                attachment3_fileName.add("\"attachment.pdf\"");
                attachment4_name.add("\"docPdf2\"");
                attachment4_content.add(pdfEncodedBase64);
                attachment4_contentType.add("application/pdf");
                attachment4_fileName.add("\"attachment2.pdf\"");
                attachment5_name.add(null);
                attachment5_content.add(null);
                attachment5_contentType.add(null);
                attachment5_fileName.add(null);
            }
            tipoTest.add("ERROR-10: content-type multipart diverso da quello definito");
            erroreAttesoTest.add(true);
            subtype = "related";
            msgErroreAttesoTest.add("Content type 'multipart/" + subtype + ";");
            msgErroreAttesoRispostaTest.add("is not allowed for body content. (code: 203)");
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(subtype);
            attachment1_name.add("\"id\"");
            attachment1_content.add("2147483647");
            attachment1_contentType.add("text/plain");
            attachment1_fileName.add(null);
            attachment2_name.add("\"metadati\"");
            attachment2_content.add(contenuto_cat);
            attachment2_contentType.add("application/json");
            attachment2_fileName.add(null);
            attachment3_name.add("\"docPdf\"");
            attachment3_content.add(pdf);
            attachment3_contentType.add("application/pdf");
            attachment3_fileName.add("\"attachment.pdf\"");
            attachment4_name.add("\"docPdf2\"");
            attachment4_content.add(pdfEncodedBase64);
            attachment4_contentType.add("application/pdf");
            attachment4_fileName.add("\"attachment2.pdf\"");
            attachment5_name.add(null);
            attachment5_content.add(null);
            attachment5_contentType.add(null);
            attachment5_fileName.add(null);
            for (int i = 0; i < attachment1_name.size(); ++i) {
                String tipo = (String)tipoTest.get(i);
                boolean erroreAtteso = (Boolean)erroreAttesoTest.get(i);
                String msgErroreAttesoRichiesta = (String)msgErroreAttesoTest.get(i);
                String msgErroreAttesoRisposta = (String)msgErroreAttesoRispostaTest.get(i);
                String path = (String)pathTest.get(i);
                HttpRequestMethod method = (HttpRequestMethod)methodTest.get(i);
                MimeMultipart mm = MultipartUtilities.buildMimeMultipart((String)attachment_subtype.get(i), (String)attachment1_content.get(i), (String)attachment1_contentType.get(i), (String)attachment1_name.get(i), (String)attachment1_fileName.get(i), (String)attachment2_content.get(i), (String)attachment2_contentType.get(i), (String)attachment2_name.get(i), (String)attachment2_fileName.get(i), (byte[])attachment3_content.get(i), (String)attachment3_contentType.get(i), (String)attachment3_name.get(i), (String)attachment3_fileName.get(i), (byte[])attachment4_content.get(i), (String)attachment4_contentType.get(i), (String)attachment4_name.get(i), (String)attachment4_fileName.get(i), (byte[])attachment5_content.get(i), (String)attachment5_contentType.get(i), (String)attachment5_name.get(i), (String)attachment5_fileName.get(i));
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                mm.writeTo(os);
                os.flush();
                os.close();
                String contentTypeSwA = mm.getContentType();
                System.out.println("\tTest Richiesta [" + tipo + "] path:" + path + " ...");
                HttpBaseRequestEntity request = null;
                if (stream) {
                    request = new InputStreamHttpRequestEntity();
                    request.setContent(new ByteArrayInputStream(os.toByteArray()));
                } else {
                    request = new BinaryHttpRequestEntity();
                    ((BinaryHttpRequestEntity)request).setContent(os.toByteArray());
                }
                request.setUrl(path);
                request.setMethod(method);
                HashMap<String, List<String>> parametersTrasporto = new HashMap<String, List<String>>();
                TransportUtils.addHeader(parametersTrasporto, "Content-Type", contentTypeSwA);
                request.setHeaders(parametersTrasporto);
                request.setContentType(contentTypeSwA);
                try {
                    apiValidatorOpenApi4j.validate(request);
                    if (erroreAtteso) {
                        throw new Exception("Atteso errore '" + msgErroreAttesoRichiesta + "' non rilevato");
                    }
                }
                catch (ValidatorException e) {
                    if (erroreAtteso && e.getMessage() != null && e.getMessage().contains(msgErroreAttesoRichiesta)) {
                        System.out.println("Errore atteso: " + e.getMessage());
                    }
                    throw new Exception("Errore non atteso: " + e.getMessage());
                }
                System.out.println("\tTest Richiesta [" + tipo + "] path:" + path + " superato");
                System.out.println("\tTest Risposta [" + tipo + "] path:" + path + " ...");
                HttpBaseResponseEntity response = null;
                if (stream) {
                    response = new InputStreamHttpResponseEntity();
                    response.setContent(new ByteArrayInputStream(os.toByteArray()));
                } else {
                    response = new BinaryHttpResponseEntity();
                    ((BinaryHttpResponseEntity)response).setContent(os.toByteArray());
                }
                response.setStatus(200);
                response.setMethod(method);
                response.setUrl(path);
                HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                TransportUtils.setHeader(responseHeaders, "Content-Type", contentTypeSwA);
                response.setHeaders(responseHeaders);
                response.setContentType(contentTypeSwA);
                try {
                    apiValidatorOpenApi4j.validate(response);
                    if (erroreAtteso) {
                        throw new Exception("Atteso errore '" + msgErroreAttesoRichiesta + "' non rilevato");
                    }
                }
                catch (ValidatorException e) {
                    if (erroreAtteso && e.getMessage() != null && e.getMessage().contains(msgErroreAttesoRisposta)) {
                        System.out.println("Errore atteso: " + e.getMessage());
                    }
                    throw new Exception("Errore non atteso: " + e.getMessage());
                }
                System.out.println("\tTest Risposta [" + tipo + "] path:" + path + " superato");
            }
        }
        System.out.println("TEST Verifica Multipart Request completato (stream:" + stream + " multipartOptimization:" + multipartOptimization + ")!");
    }

    private static void testMultipartRequestAsArray(OpenAPILibrary openAPILibrary, boolean mergeSpec, boolean stream, boolean multipartOptimization) throws UtilsException, ProcessingException, URISyntaxException, Exception {
        System.out.println("#### Verifica Multipart Request as array (stream:" + stream + " multipartOptimization:" + multipartOptimization + ") ####");
        URL url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/allegati.yaml");
        ApiSchema apiSchemaYaml = new ApiSchema("teamdigitale-openapi_definitions.yaml", Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/service/schemi/standard/teamdigitale-openapi_definitions.yaml")), ApiSchemaType.YAML);
        IApiReader apiReaderOpenApi4j = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        ApiReaderConfig configOpenApi4j = new ApiReaderConfig();
        configOpenApi4j.setProcessInclude(false);
        apiReaderOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi4j, apiSchemaYaml);
        Api apiOpenApi4j = apiReaderOpenApi4j.read();
        IApiValidator apiValidatorOpenApi4j = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
        OpenapiApiValidatorConfig configO = new OpenapiApiValidatorConfig();
        configO.setEmitLogError(logSystemOutError);
        configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
        configO.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
        configO.getOpenApiValidatorConfig().setValidateAPISpec(true);
        configO.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
        apiValidatorOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi4j, configO);
        String cat = "{\"pet_type\": \"Cat\",  \"age\": 3}";
        String dog1 = "{\"pet_type\": \"Dog\",  \"bark\": false,  \"breed\": \"Dingo\" }";
        String dog2 = "{\"pet_type\": \"Dog\",  \"bark\": true }";
        String contenuto_cat = "{\"altro\":\"descrizione generica\", \"pet\":" + cat + "}";
        String contenuto_dog1 = "{\"altro\":\"descrizione generica\", \"pet\":" + dog1 + "}";
        String contenuto_dog2 = "{\"altro\":\"descrizione generica\", \"pet\":" + dog2 + "}";
        String contenuto_errato1 = "{\"altroErrore\":\"descrizione generica\", \"pet\":" + dog2 + "}";
        String contenuto_errato2 = "{\"pet\":" + dog2 + "}";
        String catErrato = "{\"pet_type\": \"CatErrato\",  \"age\": 3}";
        String contenuto_errato3 = "{\"altro\":\"descrizione generica\", \"pet\":" + catErrato + "}";
        byte[] pdf = Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/openapi/test/test.pdf"));
        ArrayList<String> macroTest_path = new ArrayList<String>();
        ArrayList<String> macroTest_subtype = new ArrayList<String>();
        macroTest_path.add("/documenti/multipart/form-data/array-binary");
        macroTest_subtype.add("form-data");
        macroTest_path.add("/documenti/multipart/mixed/array-binary");
        macroTest_subtype.add("mixed");
        macroTest_path.add("/documenti/multipart/form-data/array-json");
        macroTest_subtype.add("form-data");
        macroTest_path.add("/documenti/multipart/mixed/array-json");
        macroTest_subtype.add("mixed");
        for (int j = 0; j < macroTest_path.size(); ++j) {
            String macroTestPath = (String)macroTest_path.get(j);
            String macroTestSubtype = (String)macroTest_subtype.get(j);
            ArrayList<String> tipoTest = new ArrayList<String>();
            ArrayList<Boolean> erroreAttesoTest = new ArrayList<Boolean>();
            ArrayList<String> msgErroreAttesoTest = new ArrayList<String>();
            ArrayList<String> msgErroreAttesoRispostaTest = new ArrayList<String>();
            ArrayList<String> pathTest = new ArrayList<String>();
            ArrayList<HttpRequestMethod> methodTest = new ArrayList<HttpRequestMethod>();
            ArrayList<String> attachment_subtype = new ArrayList<String>();
            ArrayList<String> attachment_name = new ArrayList<String>();
            ArrayList attachment_content = new ArrayList();
            ArrayList<String> attachment_contentType = new ArrayList<String>();
            ArrayList<CallSite> attachment_fileName = new ArrayList<CallSite>();
            String templateNumero = "NUMERO";
            tipoTest.add("OK-1: cat");
            erroreAttesoTest.add(false);
            msgErroreAttesoTest.add(null);
            msgErroreAttesoRispostaTest.add(null);
            pathTest.add(macroTestPath);
            methodTest.add(HttpRequestMethod.POST);
            attachment_subtype.add(macroTestSubtype);
            attachment_name.add("\"archivi\"");
            ArrayList<byte[]> l = new ArrayList<byte[]>();
            if (macroTestPath.endsWith("array-json")) {
                l.add(contenuto_cat.getBytes());
                l.add(contenuto_dog1.getBytes());
                l.add(contenuto_dog2.getBytes());
            } else {
                l.add(pdf);
                l.add(pdf);
                l.add(pdf);
            }
            attachment_content.add(l);
            if (macroTestPath.endsWith("array-json")) {
                attachment_contentType.add("application/json");
                attachment_fileName.add((CallSite)((Object)("\"attachment" + templateNumero + ".json\"")));
            } else {
                attachment_contentType.add("application/pdf");
                attachment_fileName.add((CallSite)((Object)("\"attachment" + templateNumero + ".pdf\"")));
            }
            if (macroTestPath.endsWith("array-json")) {
                tipoTest.add("ERROR-1: contenuto errato nei metadati, required claim 'altro' presente con un nome differente");
                erroreAttesoTest.add(true);
                msgErroreAttesoTest.add("body.archivi.0: Field 'altro' is required. (code: 1026)");
                msgErroreAttesoRispostaTest.add("body.archivi.0: Field 'altro' is required. (code: 1026)");
                pathTest.add(macroTestPath);
                methodTest.add(HttpRequestMethod.POST);
                attachment_subtype.add(macroTestSubtype);
                attachment_name.add("\"archivi\"");
                l = new ArrayList();
                l.add(contenuto_errato1.getBytes());
                l.add(contenuto_dog1.getBytes());
                l.add(contenuto_dog2.getBytes());
                attachment_content.add(l);
                attachment_contentType.add("application/json");
                attachment_fileName.add((CallSite)((Object)("\"attachment" + templateNumero + ".json\"")));
                tipoTest.add("ERROR-2: contenuto errato nei metadati, required claim 'altro' non presente e fileName non presente");
                erroreAttesoTest.add(true);
                msgErroreAttesoTest.add("body.archivi.1: Field 'altro' is required. (code: 1026)");
                msgErroreAttesoRispostaTest.add("body.archivi.1: Field 'altro' is required. (code: 1026)");
                pathTest.add(macroTestPath);
                methodTest.add(HttpRequestMethod.POST);
                attachment_subtype.add(macroTestSubtype);
                attachment_name.add("\"archivi\"");
                l = new ArrayList();
                l.add(contenuto_cat.getBytes());
                l.add(contenuto_errato2.getBytes());
                l.add(contenuto_dog2.getBytes());
                attachment_content.add(l);
                attachment_contentType.add("application/json");
                attachment_fileName.add(null);
                tipoTest.add("ERROR-3: contenuto errato nei metadati, discriminator value errato");
                erroreAttesoTest.add(true);
                msgErroreAttesoTest.add("body.archivi.2.pet: Schema selection can't be made for discriminator 'pet_type' with value 'CatErrato'. (code: 1003)");
                msgErroreAttesoRispostaTest.add("body.archivi.2.pet: Schema selection can't be made for discriminator 'pet_type' with value 'CatErrato'. (code: 1003)");
                pathTest.add(macroTestPath);
                methodTest.add(HttpRequestMethod.POST);
                attachment_subtype.add(macroTestSubtype);
                attachment_name.add("\"archivi\"");
                l = new ArrayList();
                l.add(contenuto_cat.getBytes());
                l.add(contenuto_dog1.getBytes());
                l.add(contenuto_errato3.getBytes());
                attachment_content.add(l);
                attachment_contentType.add("application/json");
                attachment_fileName.add((CallSite)((Object)("\"attachment" + templateNumero + ".json\"")));
            }
            for (int i = 0; i < attachment_name.size(); ++i) {
                String tipo = (String)tipoTest.get(i);
                boolean erroreAtteso = (Boolean)erroreAttesoTest.get(i);
                String msgErroreAttesoRichiesta = (String)msgErroreAttesoTest.get(i);
                String msgErroreAttesoRisposta = (String)msgErroreAttesoRispostaTest.get(i);
                String path = (String)pathTest.get(i);
                HttpRequestMethod method = (HttpRequestMethod)methodTest.get(i);
                MimeMultipart mm = MultipartUtilities.buildMimeMultipart((String)attachment_subtype.get(i), (List)attachment_content.get(i), (String)attachment_contentType.get(i), (String)attachment_name.get(i), (String)attachment_fileName.get(i));
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                mm.writeTo(os);
                os.flush();
                os.close();
                String contentTypeSwA = mm.getContentType();
                if (macroTestPath.endsWith("array-json")) {
                    System.out.println("Multipart (" + contentTypeSwA + "): \n" + os.toString());
                }
                System.out.println("\tTest Richiesta [" + tipo + "] path:" + path + " ...");
                HttpBaseRequestEntity request = null;
                if (stream) {
                    request = new InputStreamHttpRequestEntity();
                    request.setContent(new ByteArrayInputStream(os.toByteArray()));
                } else {
                    request = new BinaryHttpRequestEntity();
                    ((BinaryHttpRequestEntity)request).setContent(os.toByteArray());
                }
                request.setUrl(path);
                request.setMethod(method);
                HashMap<String, List<String>> parametersTrasporto = new HashMap<String, List<String>>();
                TransportUtils.addHeader(parametersTrasporto, "Content-Type", contentTypeSwA);
                request.setHeaders(parametersTrasporto);
                request.setContentType(contentTypeSwA);
                try {
                    apiValidatorOpenApi4j.validate(request);
                    if (erroreAtteso) {
                        throw new Exception("Atteso errore '" + msgErroreAttesoRichiesta + "' non rilevato");
                    }
                }
                catch (ValidatorException e) {
                    if (erroreAtteso && e.getMessage() != null && e.getMessage().contains(msgErroreAttesoRichiesta)) {
                        System.out.println("Errore atteso: " + e.getMessage());
                    }
                    throw new Exception("Errore non atteso: " + e.getMessage());
                }
                System.out.println("\tTest Richiesta [" + tipo + "] path:" + path + " superato");
                System.out.println("\tTest Risposta [" + tipo + "] path:" + path + " ...");
                HttpBaseResponseEntity response = null;
                if (stream) {
                    response = new InputStreamHttpResponseEntity();
                    response.setContent(new ByteArrayInputStream(os.toByteArray()));
                } else {
                    response = new BinaryHttpResponseEntity();
                    ((BinaryHttpResponseEntity)response).setContent(os.toByteArray());
                }
                response.setStatus(200);
                response.setMethod(method);
                response.setUrl(path);
                HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                TransportUtils.setHeader(responseHeaders, "Content-Type", contentTypeSwA);
                response.setHeaders(responseHeaders);
                response.setContentType(contentTypeSwA);
                try {
                    apiValidatorOpenApi4j.validate(response);
                    if (erroreAtteso) {
                        throw new Exception("Atteso errore '" + msgErroreAttesoRichiesta + "' non rilevato");
                    }
                }
                catch (ValidatorException e) {
                    if (erroreAtteso && e.getMessage() != null && e.getMessage().contains(msgErroreAttesoRisposta)) {
                        System.out.println("Errore atteso: " + e.getMessage());
                    }
                    throw new Exception("Errore non atteso: " + e.getMessage());
                }
                System.out.println("\tTest Risposta [" + tipo + "] path:" + path + " superato");
            }
        }
        System.out.println("TEST Verifica Multipart Request as array completato (stream:" + stream + " multipartOptimization:" + multipartOptimization + ")!");
    }

    private static void testFormatString(OpenAPILibrary openAPILibrary, boolean mergeSpec) throws UtilsException, ProcessingException, URISyntaxException, Exception {
        System.out.println("#### Verifica Format String ####");
        URL url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/allegati.yaml");
        ApiSchema apiSchemaYaml = new ApiSchema("teamdigitale-openapi_definitions.yaml", Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/service/schemi/standard/teamdigitale-openapi_definitions.yaml")), ApiSchemaType.YAML);
        IApiReader apiReaderOpenApi4j = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        ApiReaderConfig configOpenApi4j = new ApiReaderConfig();
        configOpenApi4j.setProcessInclude(false);
        apiReaderOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi4j, apiSchemaYaml);
        Api apiOpenApi4j = apiReaderOpenApi4j.read();
        IApiValidator apiValidatorOpenApi4j = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
        OpenapiApiValidatorConfig configO = new OpenapiApiValidatorConfig();
        configO.setEmitLogError(logSystemOutError);
        configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
        configO.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
        configO.getOpenApiValidatorConfig().setValidateAPISpec(true);
        configO.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
        apiValidatorOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi4j, configO);
        String emailCorrette = "\"info@govway.org\", \"Info@GovWay.org\", \"InfoTest@TEST.govway.org\"";
        String uuidCorretti = "\"843bdd09-f3ad-11ec-8c78-5254003636a4\", \"000bdd09-f3ad-11ec-8c78-0004003636a4\"";
        String uriCorrette = "\"http://govway.org/test\",\"https://TEST.GovWay.org/test?prova=1\",\"https://TEST.GovWay.org/test?prova=2&prova=3\",\"urn:prova@govway.info\",\"type:id\",\"file://c:/test\",\"file:///tmp/test\",\"file://../../relative\",\"foo://example.com:8042/over/there?name=ferret#nose\",\"urn:example:animal:ferret:nose\",\"https://datatracker.ietf.org/doc/html/rfc3986#section-3\"";
        String hostnameCorretti = "\"prova1\",\"govway-test.prova.org\",\"AltroHostname.TEST-PROVA2\",\"EsempioDiTestcon123\"";
        String ipCorretti = "\"127.0.0.1\",\"10.220.22.0\"";
        String ip6Corretti = "\"2001:0db8:85a3:0000:0000:8a2e:0370:7334\"";
        String jsonCorretto = "{ \"email\": [" + emailCorrette + "], \"uuid\": [" + uuidCorretti + "], \"uri\":[" + uriCorrette + "], \"hostname\":[" + hostnameCorretti + "], \"ipv4\":[" + ipCorretti + "], \"ipv6\":[" + ip6Corretti + "] }";
        ArrayList<String> tipoTest = new ArrayList<String>();
        ArrayList<CallSite> messagggioTest = new ArrayList<CallSite>();
        ArrayList<Boolean> erroreAttesoTest = new ArrayList<Boolean>();
        ArrayList<String> msgErroreAttesoTest_request_openapi4j = new ArrayList<String>();
        ArrayList<String> msgErroreAttesoTest_response_openapi4j = new ArrayList<String>();
        ArrayList<String> msgErroreAttesoTest_request_swagger_request = new ArrayList<String>();
        ArrayList<String> msgErroreAttesoTest_response_swagger_request = new ArrayList<String>();
        ArrayList<String> msgErroreAttesoTest_request_json_schema = new ArrayList<String>();
        ArrayList<String> msgErroreAttesoTest_response_json_schema = new ArrayList<String>();
        tipoTest.add("OK-1");
        messagggioTest.add((CallSite)((Object)jsonCorretto));
        erroreAttesoTest.add(false);
        msgErroreAttesoTest_request_openapi4j.add(null);
        msgErroreAttesoTest_response_openapi4j.add(null);
        msgErroreAttesoTest_request_swagger_request.add(null);
        msgErroreAttesoTest_response_swagger_request.add(null);
        msgErroreAttesoTest_request_json_schema.add(null);
        msgErroreAttesoTest_response_json_schema.add(null);
        String emailErrata1 = "\"info.it\"";
        String jsonErrateMail1 = "{ \"email\": [" + emailErrata1 + "], \"uuid\": [" + uuidCorretti + "], \"uri\":[" + uriCorrette + "], \"hostname\":[" + hostnameCorretti + "], \"ipv4\":[" + ipCorretti + "], \"ipv6\":[" + ip6Corretti + "] }";
        tipoTest.add("ERROR-MAIL-1");
        messagggioTest.add((CallSite)((Object)jsonErrateMail1));
        erroreAttesoTest.add(true);
        msgErroreAttesoTest_request_openapi4j.add("body.email.0: Value 'info.it' does not match format 'email'. (code: 1007)");
        msgErroreAttesoTest_response_openapi4j.add("body.email.0: Value 'info.it' does not match format 'email'. (code: 1007)");
        msgErroreAttesoTest_request_swagger_request.add("[ERROR][REQUEST][POST /documenti/format-string @body] [Path '/email/0'] String \"info.it\" is not a valid email address");
        msgErroreAttesoTest_response_swagger_request.add("[ERROR][RESPONSE][] [Path '/email/0'] String \"info.it\" is not a valid email address");
        msgErroreAttesoTest_request_json_schema.add("1009 $.email[0]: does not match the email pattern must be a valid RFC 5321 Mailbox");
        msgErroreAttesoTest_response_json_schema.add("1009 $.email[0]: does not match the email pattern must be a valid RFC 5321 Mailbox");
        String emailErrata2 = "\"Info\"";
        String jsonErrateMail2 = "{ \"email\": [" + emailErrata2 + "], \"uuid\": [" + uuidCorretti + "], \"uri\":[" + uriCorrette + "], \"hostname\":[" + hostnameCorretti + "], \"ipv4\":[" + ipCorretti + "], \"ipv6\":[" + ip6Corretti + "] }";
        tipoTest.add("ERROR-MAIL-2");
        messagggioTest.add((CallSite)((Object)jsonErrateMail2));
        erroreAttesoTest.add(true);
        msgErroreAttesoTest_request_openapi4j.add("body.email.0: Value 'Info' does not match format 'email'. (code: 1007)");
        msgErroreAttesoTest_response_openapi4j.add("body.email.0: Value 'Info' does not match format 'email'. (code: 1007)");
        msgErroreAttesoTest_request_swagger_request.add("[ERROR][REQUEST][POST /documenti/format-string @body] [Path '/email/0'] String \"Info\" is not a valid email address");
        msgErroreAttesoTest_response_swagger_request.add("[ERROR][RESPONSE][] [Path '/email/0'] String \"Info\" is not a valid email address");
        msgErroreAttesoTest_request_json_schema.add("1009 $.email[0]: does not match the email pattern must be a valid RFC 5321 Mailbox");
        msgErroreAttesoTest_response_json_schema.add("1009 $.email[0]: does not match the email pattern must be a valid RFC 5321 Mailbox");
        String uuidErrata1 = "\"43bdd09-f3ad-11ec-8c78-5254003636a4\"";
        String jsonErrateUuid1 = "{ \"email\": [" + emailCorrette + "], \"uuid\": [" + uuidErrata1 + "], \"uri\":[" + uriCorrette + "], \"hostname\":[" + hostnameCorretti + "], \"ipv4\":[" + ipCorretti + "], \"ipv6\":[" + ip6Corretti + "] }";
        tipoTest.add("ERROR-UUID-1");
        messagggioTest.add((CallSite)((Object)jsonErrateUuid1));
        erroreAttesoTest.add(true);
        msgErroreAttesoTest_request_openapi4j.add("body.uuid.0: Value '43bdd09-f3ad-11ec-8c78-5254003636a4' does not match format 'uuid'. (code: 1007)");
        msgErroreAttesoTest_response_openapi4j.add("body.uuid.0: Value '43bdd09-f3ad-11ec-8c78-5254003636a4' does not match format 'uuid'. (code: 1007)");
        msgErroreAttesoTest_request_swagger_request.add("SKIP");
        msgErroreAttesoTest_response_swagger_request.add("SKIP");
        msgErroreAttesoTest_request_json_schema.add("1009 $.uuid[0]: does not match the uuid pattern must be a valid RFC 4122 UUID");
        msgErroreAttesoTest_response_json_schema.add("1009 $.uuid[0]: does not match the uuid pattern must be a valid RFC 4122 UUID");
        String uuidErrata2 = "\"843bdd09-f3ad-11ec-8c78-5254003636a\"";
        String jsonErrateUuid2 = "{ \"email\": [" + emailCorrette + "], \"uuid\": [" + uuidErrata2 + "], \"uri\":[" + uriCorrette + "], \"hostname\":[" + hostnameCorretti + "], \"ipv4\":[" + ipCorretti + "], \"ipv6\":[" + ip6Corretti + "] }";
        tipoTest.add("ERROR-UUID-2");
        messagggioTest.add((CallSite)((Object)jsonErrateUuid2));
        erroreAttesoTest.add(true);
        msgErroreAttesoTest_request_openapi4j.add("body.uuid.0: Value '843bdd09-f3ad-11ec-8c78-5254003636a' does not match format 'uuid'. (code: 1007)");
        msgErroreAttesoTest_response_openapi4j.add("body.uuid.0: Value '843bdd09-f3ad-11ec-8c78-5254003636a' does not match format 'uuid'. (code: 1007)");
        msgErroreAttesoTest_request_swagger_request.add("SKIP");
        msgErroreAttesoTest_response_swagger_request.add("SKIP");
        msgErroreAttesoTest_request_json_schema.add("1009 $.uuid[0]: does not match the uuid pattern must be a valid RFC 4122 UUID");
        msgErroreAttesoTest_response_json_schema.add("1009 $.uuid[0]: does not match the uuid pattern must be a valid RFC 4122 UUID");
        String uuidErrata3 = "\"843bdd09f3ad11ec8c785254003636a4\"";
        String jsonErrateUuid3 = "{ \"email\": [" + emailCorrette + "], \"uuid\": [" + uuidErrata3 + "], \"uri\":[" + uriCorrette + "], \"hostname\":[" + hostnameCorretti + "], \"ipv4\":[" + ipCorretti + "], \"ipv6\":[" + ip6Corretti + "] }";
        tipoTest.add("ERROR-UUID-3");
        messagggioTest.add((CallSite)((Object)jsonErrateUuid3));
        erroreAttesoTest.add(true);
        msgErroreAttesoTest_request_openapi4j.add("body.uuid.0: Value '843bdd09f3ad11ec8c785254003636a4' does not match format 'uuid'. (code: 1007)");
        msgErroreAttesoTest_response_openapi4j.add("body.uuid.0: Value '843bdd09f3ad11ec8c785254003636a4' does not match format 'uuid'. (code: 1007)");
        msgErroreAttesoTest_request_swagger_request.add("[ERROR][REQUEST][POST /documenti/format-string @body] [Path '/uuid/0'] Input string \"843bdd09f3ad11ec8c785254003636a4\" is not a valid UUID");
        msgErroreAttesoTest_response_swagger_request.add("[ERROR][RESPONSE][] [Path '/uuid/0'] Input string \"843bdd09f3ad11ec8c785254003636a4\" is not a valid UUID");
        msgErroreAttesoTest_request_json_schema.add("1009 $.uuid[0]: does not match the uuid pattern must be a valid RFC 4122 UUID");
        msgErroreAttesoTest_response_json_schema.add("1009 $.uuid[0]: does not match the uuid pattern must be a valid RFC 4122 UUID");
        String uriErrata1 = "\"govway.org\"";
        String jsonErrateUri1 = "{ \"email\": [" + emailCorrette + "], \"uuid\": [" + uuidCorretti + "], \"uri\":[" + uriErrata1 + "], \"hostname\":[" + hostnameCorretti + "], \"ipv4\":[" + ipCorretti + "], \"ipv6\":[" + ip6Corretti + "] }";
        tipoTest.add("ERROR-URI-1");
        messagggioTest.add((CallSite)((Object)jsonErrateUri1));
        erroreAttesoTest.add(true);
        msgErroreAttesoTest_request_openapi4j.add("body.uri.0: Value 'govway.org' does not match format 'uri'. (code: 1007)");
        msgErroreAttesoTest_response_openapi4j.add("body.uri.0: Value 'govway.org' does not match format 'uri'. (code: 1007)");
        msgErroreAttesoTest_request_swagger_request.add("SKIP");
        msgErroreAttesoTest_response_swagger_request.add("SKIP");
        msgErroreAttesoTest_request_json_schema.add("1009 $.uri[0]: does not match the uri pattern");
        msgErroreAttesoTest_response_json_schema.add("1009 $.uri[0]: does not match the uri pattern");
        String hostnameErrata1 = "\"test_con_underscore\"";
        String jsonErrateHostname1 = "{ \"email\": [" + emailCorrette + "], \"uuid\": [" + uuidCorretti + "], \"uri\":[" + uriCorrette + "], \"hostname\":[" + hostnameErrata1 + "], \"ipv4\":[" + ipCorretti + "], \"ipv6\":[" + ip6Corretti + "] }";
        tipoTest.add("ERROR-HOSTNAME-1");
        messagggioTest.add((CallSite)((Object)jsonErrateHostname1));
        erroreAttesoTest.add(true);
        msgErroreAttesoTest_request_openapi4j.add("body.hostname.0: Value 'test_con_underscore' does not match format 'hostname'. (code: 1007)");
        msgErroreAttesoTest_response_openapi4j.add("body.hostname.0: Value 'test_con_underscore' does not match format 'hostname'. (code: 1007)");
        msgErroreAttesoTest_request_swagger_request.add("SKIP");
        msgErroreAttesoTest_response_swagger_request.add("SKIP");
        msgErroreAttesoTest_request_json_schema.add("1009 $.hostname[0]: does not match the hostname pattern");
        msgErroreAttesoTest_response_json_schema.add("1009 $.hostname[0]: does not match the hostname pattern");
        String ipErrata1 = "\"indirizzoSenzaNumeri\"";
        String jsonErrateIp1 = "{ \"email\": [" + emailCorrette + "], \"uuid\": [" + uuidCorretti + "], \"uri\":[" + uriCorrette + "], \"hostname\":[" + hostnameCorretti + "], \"ipv4\":[" + ipErrata1 + "], \"ipv6\":[" + ip6Corretti + "] }";
        tipoTest.add("ERROR-IPv4-1");
        messagggioTest.add((CallSite)((Object)jsonErrateIp1));
        erroreAttesoTest.add(true);
        msgErroreAttesoTest_request_openapi4j.add("body.ipv4.0: Value 'indirizzoSenzaNumeri' does not match format 'ipv4'. (code: 1007)");
        msgErroreAttesoTest_response_openapi4j.add("body.ipv4.0: Value 'indirizzoSenzaNumeri' does not match format 'ipv4'. (code: 1007)");
        msgErroreAttesoTest_request_swagger_request.add("[ERROR][REQUEST][POST /documenti/format-string @body] [Path '/ipv4/0'] String \"indirizzoSenzaNumeri\" is not a valid IPv4 address");
        msgErroreAttesoTest_response_swagger_request.add("[ERROR][RESPONSE][] [Path '/ipv4/0'] String \"indirizzoSenzaNumeri\" is not a valid IPv4 address");
        msgErroreAttesoTest_request_json_schema.add("1009 $.ipv4[0]: does not match the ipv4 pattern");
        msgErroreAttesoTest_response_json_schema.add("1009 $.ipv4[0]: does not match the ipv4 pattern");
        String ipv6Errata1 = "\"indirizzoSenzaNumeri\"";
        String jsonErrateIpv61 = "{ \"email\": [" + emailCorrette + "], \"uuid\": [" + uuidCorretti + "], \"uri\":[" + uriCorrette + "], \"hostname\":[" + hostnameCorretti + "], \"ipv4\":[" + ipCorretti + "], \"ipv6\":[" + ipv6Errata1 + "] }";
        tipoTest.add("ERROR-IPv6-1");
        messagggioTest.add((CallSite)((Object)jsonErrateIpv61));
        erroreAttesoTest.add(true);
        msgErroreAttesoTest_request_openapi4j.add("body.ipv6.0: Value 'indirizzoSenzaNumeri' does not match format 'ipv6'. (code: 1007)");
        msgErroreAttesoTest_response_openapi4j.add("body.ipv6.0: Value 'indirizzoSenzaNumeri' does not match format 'ipv6'. (code: 1007)");
        msgErroreAttesoTest_request_swagger_request.add("[ERROR][REQUEST][POST /documenti/format-string @body] [Path '/ipv6/0'] String \"indirizzoSenzaNumeri\" is not a valid IPv6 address");
        msgErroreAttesoTest_response_swagger_request.add("[ERROR][RESPONSE][] [Path '/ipv6/0'] String \"indirizzoSenzaNumeri\" is not a valid IPv6 address");
        msgErroreAttesoTest_request_json_schema.add("1009 $.ipv6[0]: does not match the ipv6 pattern");
        msgErroreAttesoTest_response_json_schema.add("1009 $.ipv6[0]: does not match the ipv6 pattern");
        for (int i = 0; i < tipoTest.size(); ++i) {
            String path;
            String tipo;
            block15: {
                String contentType;
                HttpRequestMethod method;
                String msgErroreAttesoRisposta;
                String content;
                boolean erroreAtteso;
                block14: {
                    tipo = (String)tipoTest.get(i);
                    erroreAtteso = (Boolean)erroreAttesoTest.get(i);
                    content = (String)messagggioTest.get(i);
                    String msgErroreAttesoRichiesta = null;
                    msgErroreAttesoRisposta = null;
                    switch (openAPILibrary) {
                        case openapi4j: {
                            msgErroreAttesoRichiesta = (String)msgErroreAttesoTest_request_openapi4j.get(i);
                            msgErroreAttesoRisposta = (String)msgErroreAttesoTest_response_openapi4j.get(i);
                            break;
                        }
                        case swagger_request_validator: {
                            msgErroreAttesoRichiesta = (String)msgErroreAttesoTest_request_swagger_request.get(i);
                            msgErroreAttesoRisposta = (String)msgErroreAttesoTest_response_swagger_request.get(i);
                            break;
                        }
                        case json_schema: {
                            msgErroreAttesoRichiesta = (String)msgErroreAttesoTest_request_json_schema.get(i);
                            msgErroreAttesoRisposta = (String)msgErroreAttesoTest_response_json_schema.get(i);
                            break;
                        }
                    }
                    path = "/documenti/format-string";
                    method = HttpRequestMethod.POST;
                    contentType = "application/json";
                    System.out.println("\tTest Richiesta [" + tipo + "] path:" + path + " ...");
                    TextHttpRequestEntity request = new TextHttpRequestEntity();
                    request.setUrl(path);
                    request.setMethod(method);
                    request.setContent(content);
                    HashMap<String, List<String>> parametersTrasporto = new HashMap<String, List<String>>();
                    TransportUtils.addHeader(parametersTrasporto, "Content-Type", contentType);
                    request.setHeaders(parametersTrasporto);
                    request.setContentType(contentType);
                    try {
                        apiValidatorOpenApi4j.validate(request);
                        if (!erroreAtteso) break block14;
                        if ("SKIP".equals(msgErroreAttesoRichiesta)) {
                            System.out.println("WARN Libreria non supporta ancora correttamente la validazione, si attendeva un errore");
                            break block14;
                        }
                        throw new Exception("Atteso errore (" + tipo + ") '" + msgErroreAttesoRichiesta + "' non rilevato");
                    }
                    catch (ValidatorException e) {
                        if (erroreAtteso && e.getMessage() != null && e.getMessage().contains(msgErroreAttesoRichiesta)) {
                            System.out.println("Errore atteso: " + e.getMessage());
                        }
                        throw new Exception("Errore non atteso (" + tipo + "): " + e.getMessage());
                    }
                }
                System.out.println("\tTest Richiesta [" + tipo + "] path:" + path + " superato");
                System.out.println("\tTest Risposta [" + tipo + "] path:" + path + " ...");
                TextHttpResponseEntity response = new TextHttpResponseEntity();
                response.setContent(content);
                response.setStatus(200);
                response.setMethod(method);
                response.setUrl(path);
                HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                TransportUtils.setHeader(responseHeaders, "Content-Type", contentType);
                response.setHeaders(responseHeaders);
                response.setContentType(contentType);
                try {
                    apiValidatorOpenApi4j.validate(response);
                    if (!erroreAtteso) break block15;
                    if ("SKIP".equals(msgErroreAttesoRisposta)) {
                        System.out.println("WARN Libreria non supporta ancora correttamente la validazione, si attendeva un errore");
                        break block15;
                    }
                    throw new Exception("Atteso errore (" + tipo + ") '" + msgErroreAttesoRisposta + "' non rilevato");
                }
                catch (ValidatorException e) {
                    if (erroreAtteso && e.getMessage() != null && e.getMessage().contains(msgErroreAttesoRisposta)) {
                        System.out.println("Errore atteso: " + e.getMessage());
                    }
                    throw new Exception("Errore non atteso (" + tipo + "): " + e.getMessage());
                }
            }
            System.out.println("\tTest Risposta [" + tipo + "] path:" + path + " superato");
        }
        System.out.println("TEST Verifica Format String completato!");
    }

    private static void testDynamicPath(OpenAPILibrary openAPILibrary, boolean mergeSpec) throws UtilsException, ProcessingException, URISyntaxException, Exception {
        System.out.println("#### Verifica Dynamic Path ####");
        URL url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/allegati.yaml");
        ApiSchema apiSchemaYaml = new ApiSchema("teamdigitale-openapi_definitions.yaml", Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/service/schemi/standard/teamdigitale-openapi_definitions.yaml")), ApiSchemaType.YAML);
        IApiReader apiReaderOpenApi4j = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        ApiReaderConfig configOpenApi4j = new ApiReaderConfig();
        configOpenApi4j.setProcessInclude(false);
        apiReaderOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi4j, apiSchemaYaml);
        Api apiOpenApi4j = apiReaderOpenApi4j.read();
        IApiValidator apiValidatorOpenApi4j = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
        OpenapiApiValidatorConfig configO = new OpenapiApiValidatorConfig();
        configO.setEmitLogError(logSystemOutError);
        configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
        configO.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
        configO.getOpenApiValidatorConfig().setValidateAPISpec(true);
        configO.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
        apiValidatorOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi4j, configO);
        String parameter1 = "080.253.61401A";
        String parameter2 = "080.253.61401A.KP%2F2022%2F293.02175680483.2022-01-12T00:00:00+02:00";
        String parameter2_risorsaNonTrovata = "080.253.61401A.KP/2022/293.02175680483.2022-01-12T00:00:00+02:00";
        String parameterNonValido = "prova=fr";
        String parameterNonValido_url_encoded = "prova%3Dfr";
        String parameterIllegalForUrl = "prova\\=fr";
        String parameterIllegalForUrl_url_encoded = "prova%5C%3Dfr";
        ArrayList<String> tipoTest = new ArrayList<String>();
        ArrayList<HttpRequestMethod> methodTest = new ArrayList<HttpRequestMethod>();
        ArrayList<String> parametroTest = new ArrayList<String>();
        ArrayList<Boolean> erroreAttesoTest = new ArrayList<Boolean>();
        ArrayList<Boolean> erroreAttesoProcessingTest = new ArrayList<Boolean>();
        ArrayList<Object> erroreAtteso_openapi4j = new ArrayList<Object>();
        ArrayList<Object> erroreAtteso_swagger_request = new ArrayList<Object>();
        ArrayList<Object> erroreAtteso_json_schema = new ArrayList<Object>();
        tipoTest.add("GET-1");
        methodTest.add(HttpRequestMethod.GET);
        parametroTest.add(parameter1);
        erroreAttesoTest.add(false);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add(null);
        erroreAtteso_swagger_request.add(null);
        erroreAtteso_json_schema.add(null);
        tipoTest.add("GET-2");
        methodTest.add(HttpRequestMethod.GET);
        parametroTest.add(parameter2);
        erroreAttesoTest.add(false);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add(null);
        erroreAtteso_swagger_request.add(null);
        erroreAtteso_json_schema.add(null);
        tipoTest.add("PUT-1");
        methodTest.add(HttpRequestMethod.PUT);
        parametroTest.add(parameter1);
        erroreAttesoTest.add(false);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add(null);
        erroreAtteso_swagger_request.add(null);
        erroreAtteso_json_schema.add(null);
        tipoTest.add("PUT-2");
        methodTest.add(HttpRequestMethod.PUT);
        parametroTest.add(parameter2);
        erroreAttesoTest.add(false);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add(null);
        erroreAtteso_swagger_request.add(null);
        erroreAtteso_json_schema.add(null);
        tipoTest.add("POST-1");
        methodTest.add(HttpRequestMethod.PUT);
        parametroTest.add(parameter1);
        erroreAttesoTest.add(false);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add(null);
        erroreAtteso_swagger_request.add(null);
        erroreAtteso_json_schema.add(null);
        tipoTest.add("POST-2");
        methodTest.add(HttpRequestMethod.PUT);
        parametroTest.add(parameter2);
        erroreAttesoTest.add(false);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add(null);
        erroreAtteso_swagger_request.add(null);
        erroreAtteso_json_schema.add(null);
        tipoTest.add("GET-OPERATION-NOT-FOUND");
        methodTest.add(HttpRequestMethod.GET);
        parametroTest.add(parameter2_risorsaNonTrovata);
        erroreAttesoTest.add(false);
        erroreAttesoProcessingTest.add(true);
        erroreAtteso_openapi4j.add("Resource GET '/documenti/dynamic-path/" + parameter2_risorsaNonTrovata + "' not found");
        erroreAtteso_swagger_request.add("Resource GET '/documenti/dynamic-path/" + parameter2_risorsaNonTrovata + "' not found");
        erroreAtteso_json_schema.add("Resource GET '/documenti/dynamic-path/" + parameter2_risorsaNonTrovata + "' not found");
        tipoTest.add("PUT-OPERATION-NOT-FOUND");
        methodTest.add(HttpRequestMethod.PUT);
        parametroTest.add(parameter2_risorsaNonTrovata);
        erroreAttesoTest.add(false);
        erroreAttesoProcessingTest.add(true);
        erroreAtteso_openapi4j.add("Resource PUT '/documenti/dynamic-path/" + parameter2_risorsaNonTrovata + "' not found");
        erroreAtteso_swagger_request.add("Resource PUT '/documenti/dynamic-path/" + parameter2_risorsaNonTrovata + "' not found");
        erroreAtteso_json_schema.add("Resource PUT '/documenti/dynamic-path/" + parameter2_risorsaNonTrovata + "' not found");
        tipoTest.add("POST-OPERATION-NOT-FOUND");
        methodTest.add(HttpRequestMethod.POST);
        parametroTest.add(parameter2_risorsaNonTrovata);
        erroreAttesoTest.add(false);
        erroreAttesoProcessingTest.add(true);
        erroreAtteso_openapi4j.add("Resource POST '/documenti/dynamic-path/" + parameter2_risorsaNonTrovata + "' not found");
        erroreAtteso_swagger_request.add("Resource POST '/documenti/dynamic-path/" + parameter2_risorsaNonTrovata + "' not found");
        erroreAtteso_json_schema.add("Resource POST '/documenti/dynamic-path/" + parameter2_risorsaNonTrovata + "' not found");
        tipoTest.add("GET-NON_VALIDO-1");
        methodTest.add(HttpRequestMethod.GET);
        parametroTest.add(parameterNonValido);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        tipoTest.add("GET-NON_VALIDO-UrlEncoded");
        methodTest.add(HttpRequestMethod.GET);
        parametroTest.add(parameterNonValido_url_encoded);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova=fr' (urlEncoded: 'prova%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova=fr' (urlEncoded: 'prova%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        tipoTest.add("POST-NON_VALIDO-1");
        methodTest.add(HttpRequestMethod.POST);
        parametroTest.add(parameterNonValido);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        tipoTest.add("POST-NON_VALIDO-UrlEncoded");
        methodTest.add(HttpRequestMethod.POST);
        parametroTest.add(parameterNonValido_url_encoded);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova=fr' (urlEncoded: 'prova%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova=fr' (urlEncoded: 'prova%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        tipoTest.add("PUT-NON_VALIDO-1");
        methodTest.add(HttpRequestMethod.PUT);
        parametroTest.add(parameterNonValido);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        tipoTest.add("PUT-NON_VALIDO-UrlEncoded");
        methodTest.add(HttpRequestMethod.PUT);
        parametroTest.add(parameterNonValido_url_encoded);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova=fr' (urlEncoded: 'prova%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova=fr' (urlEncoded: 'prova%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        tipoTest.add("GET-ILLEGAL_CHARACTER-1");
        methodTest.add(HttpRequestMethod.GET);
        parametroTest.add(parameterIllegalForUrl);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova\\\\=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova\\=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova\\=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        tipoTest.add("GET-ILLEGAL_CHARACTER-UrlEncoded");
        methodTest.add(HttpRequestMethod.GET);
        parametroTest.add(parameterIllegalForUrl_url_encoded);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova\\\\=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova\\=fr' (urlEncoded: 'prova%5C%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova\\=fr' (urlEncoded: 'prova%5C%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        tipoTest.add("POST-ILLEGAL_CHARACTER-1");
        methodTest.add(HttpRequestMethod.POST);
        parametroTest.add(parameterIllegalForUrl);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova\\\\=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova\\=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova\\=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        tipoTest.add("POST-ILLEGAL_CHARACTER-UrlEncoded");
        methodTest.add(HttpRequestMethod.POST);
        parametroTest.add(parameterIllegalForUrl_url_encoded);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova\\\\=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova\\=fr' (urlEncoded: 'prova%5C%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova\\=fr' (urlEncoded: 'prova%5C%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        tipoTest.add("PUT-ILLEGAL_CHARACTER-1");
        methodTest.add(HttpRequestMethod.PUT);
        parametroTest.add(parameterIllegalForUrl);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova\\\\=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova\\=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova\\=fr' in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        tipoTest.add("PUT-ILLEGAL_CHARACTER-UrlEncoded");
        methodTest.add(HttpRequestMethod.PUT);
        parametroTest.add(parameterIllegalForUrl_url_encoded);
        erroreAttesoTest.add(true);
        erroreAttesoProcessingTest.add(false);
        erroreAtteso_openapi4j.add("dynamic_id: 'prova\\\\=fr' does not respect pattern '^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$'. (code: 1025)\nFrom: dynamic_id.<pattern>");
        erroreAtteso_swagger_request.add("Invalid value 'prova\\=fr' (urlEncoded: 'prova%5C%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        erroreAtteso_json_schema.add("Invalid value 'prova\\=fr' (urlEncoded: 'prova%5C%3Dfr') in dynamic path 'dynamic_id' (expected type 'string'): Pattern match failed ('^[A-Za-z0-9\\-\\.\\+_:\\/\\\\]{1,73}$')");
        for (int i = 0; i < tipoTest.size(); ++i) {
            String path;
            String tipo;
            block15: {
                tipo = (String)tipoTest.get(i);
                boolean erroreAtteso = (Boolean)erroreAttesoTest.get(i);
                boolean erroreAttesoProcessing = (Boolean)erroreAttesoProcessingTest.get(i);
                String content = "HelloWorld";
                String msgErroreAttesoRichiesta = null;
                switch (openAPILibrary) {
                    case openapi4j: {
                        msgErroreAttesoRichiesta = (String)erroreAtteso_openapi4j.get(i);
                        break;
                    }
                    case swagger_request_validator: {
                        msgErroreAttesoRichiesta = (String)erroreAtteso_swagger_request.get(i);
                        break;
                    }
                    case json_schema: {
                        msgErroreAttesoRichiesta = (String)erroreAtteso_json_schema.get(i);
                        break;
                    }
                }
                path = "/documenti/dynamic-path/" + (String)parametroTest.get(i);
                HttpRequestMethod method = (HttpRequestMethod)methodTest.get(i);
                String contentType = "text/plain";
                System.out.println("\tTest Richiesta [" + tipo + "] path:" + path + " ...");
                TextHttpRequestEntity request = new TextHttpRequestEntity();
                request.setUrl(path);
                request.setMethod(method);
                if (!HttpRequestMethod.GET.equals(method)) {
                    request.setContent(content);
                    HashMap<String, List<String>> parametersTrasporto = new HashMap<String, List<String>>();
                    TransportUtils.addHeader(parametersTrasporto, "Content-Type", contentType);
                    request.setHeaders(parametersTrasporto);
                    request.setContentType(contentType);
                }
                try {
                    apiValidatorOpenApi4j.validate(request);
                    if (!erroreAtteso) break block15;
                    if ("SKIP".equals(msgErroreAttesoRichiesta)) {
                        System.out.println("WARN Libreria non supporta ancora correttamente la validazione, si attendeva un errore");
                        break block15;
                    }
                    throw new Exception("Atteso errore (" + tipo + ") '" + msgErroreAttesoRichiesta + "' non rilevato");
                }
                catch (ValidatorException e) {
                    if (erroreAtteso && e.getMessage() != null && e.getMessage().contains(msgErroreAttesoRichiesta)) {
                        System.out.println("Errore atteso: " + e.getMessage());
                    }
                    throw new Exception("Errore non atteso (" + tipo + "): " + e.getMessage());
                }
                catch (ProcessingException pe) {
                    if (erroreAttesoProcessing && pe.getMessage() != null && pe.getMessage().contains(msgErroreAttesoRichiesta)) {
                        System.out.println("Errore atteso: " + pe.getMessage());
                    }
                    if ("GET-ILLEGAL_CHARACTER-1".equals(tipo) || "POST-ILLEGAL_CHARACTER-1".equals(tipo) || "PUT-ILLEGAL_CHARACTER-1".equals(tipo)) {
                        String errore2 = "Illegal character in path at index 29: /documenti/dynamic-path/prova\\=fr";
                        if (pe.getMessage() != null && pe.getMessage().contains(errore2)) {
                            System.out.println("Errore atteso: " + pe.getMessage());
                        }
                        throw new Exception("Errore non atteso (" + tipo + "): " + pe.getMessage());
                    }
                    throw new Exception("Errore non atteso (" + tipo + "): " + pe.getMessage());
                }
            }
            System.out.println("\tTest Richiesta [" + tipo + "] path:" + path + " superato");
        }
        System.out.println("TEST Verifica Format String completato!");
    }

    private static void testComposedSchemaParameters(OpenAPILibrary openAPILibrary, boolean mergeSpec) throws UtilsException, ProcessingException, URISyntaxException, Exception {
        System.out.println("#### Verifica ComposedSchemaParameters ####");
        URL url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/allegati.yaml");
        ApiSchema apiSchemaYaml = new ApiSchema("teamdigitale-openapi_definitions.yaml", Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/service/schemi/standard/teamdigitale-openapi_definitions.yaml")), ApiSchemaType.YAML);
        IApiReader apiReaderOpenApi4j = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        ApiReaderConfig configOpenApi4j = new ApiReaderConfig();
        configOpenApi4j.setProcessInclude(false);
        apiReaderOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi4j, apiSchemaYaml);
        Api apiOpenApi4j = apiReaderOpenApi4j.read();
        IApiValidator apiValidatorOpenApi4j = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
        OpenapiApiValidatorConfig configO = new OpenapiApiValidatorConfig();
        configO.setEmitLogError(logSystemOutError);
        configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
        configO.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
        configO.getOpenApiValidatorConfig().setValidateAPISpec(true);
        configO.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
        apiValidatorOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi4j, configO);
        ArrayList<String> tipoTest = new ArrayList<String>();
        ArrayList<String> complexTypeTest = new ArrayList<String>();
        ArrayList<String> pathTest = new ArrayList<String>();
        ArrayList<String> queryTest = new ArrayList<String>();
        ArrayList<String> headerTest = new ArrayList<String>();
        ArrayList<String> cookieTest = new ArrayList<String>();
        ArrayList<String> pathInLineTest = new ArrayList<String>();
        ArrayList<String> queryInLineTest = new ArrayList<String>();
        ArrayList<String> headerInLineTest = new ArrayList<String>();
        ArrayList<String> cookieInLineTest = new ArrayList<String>();
        ArrayList<Boolean> erroreAttesoRichiestaTest = new ArrayList<Boolean>();
        ArrayList<Boolean> erroreAttesoRispostaTest = new ArrayList<Boolean>();
        ArrayList<Object> msgErroreAttesoTest_openapi4j = new ArrayList<Object>();
        ArrayList<Object> msgErroreAttesoTest_swagger_request = new ArrayList<Object>();
        ArrayList<Object> msgErroreAttesoTest_swagger_response = new ArrayList<Object>();
        ArrayList<CallSite> msgErroreAttesoTest_json_schema = new ArrayList<CallSite>();
        String valoreCorretto1 = "ABCDEFGHILK";
        String valoreCorretto2 = "01234";
        String valoreNonCorretto1 = "ABCDEFGHILKALTRECIFRE";
        String valoreNonCorretto2 = "0123456789aa";
        String valoreCorrettoInt1 = "20";
        String valoreCorrettoInt2 = "53";
        String valoreNonCorrettoInt = "59";
        tipoTest.add("OK-1");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(false);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add(null);
        msgErroreAttesoTest_swagger_request.add(null);
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add(null);
        tipoTest.add("OK-2");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto2);
        queryTest.add(valoreCorretto2);
        headerTest.add(valoreCorretto2);
        cookieTest.add(valoreCorretto2);
        pathInLineTest.add(valoreCorrettoInt2);
        queryInLineTest.add(valoreCorrettoInt2);
        headerInLineTest.add(valoreCorrettoInt2);
        cookieInLineTest.add(valoreCorrettoInt2);
        erroreAttesoRichiestaTest.add(false);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add(null);
        msgErroreAttesoTest_swagger_request.add(null);
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add(null);
        tipoTest.add("ERRORE-PATH-1");
        complexTypeTest.add("any_of");
        pathTest.add(valoreNonCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_path: '" + valoreNonCorretto1 + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_path.<anyOf>.<pattern>\ncomposed_schema_any_of_path: '" + valoreNonCorretto1 + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_path.<anyOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Invalid value '" + valoreNonCorretto1 + "' in dynamic path 'composed_schema_any_of_path' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorretto1 + "' in dynamic path 'composed_schema_any_of_path' (expected type 'string'): Pattern match failed ('^[0-9]{3,5}$')");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in dynamic path 'composed_schema_any_of_path' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorretto1 + "' in dynamic path 'composed_schema_any_of_path' (expected type 'string'): Pattern match failed ('^[0-9]{3,5}$')")));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-PATH-2");
        complexTypeTest.add("any_of");
        pathTest.add(valoreNonCorretto2);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_path: '" + valoreNonCorretto2 + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_path.<anyOf>.<pattern>\ncomposed_schema_any_of_path: '" + valoreNonCorretto2 + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_path.<anyOf>.<pattern>");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto2 + "' in dynamic path 'composed_schema_any_of_path' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorretto2 + "' in dynamic path 'composed_schema_any_of_path' (expected type 'string'): Pattern match failed ('^[0-9]{3,5}$')")));
        msgErroreAttesoTest_swagger_request.add((String)msgErroreAttesoTest_json_schema.get(msgErroreAttesoTest_json_schema.size() - 1));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-PATH-3");
        complexTypeTest.add("any_of");
        pathTest.add(valoreNonCorrettoInt);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_path: '" + valoreNonCorrettoInt + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_path.<anyOf>.<pattern>\ncomposed_schema_any_of_path: Min length is '3', found '2'. (code: 1017)\nFrom: composed_schema_any_of_path.<anyOf>.<minLength>\ncomposed_schema_any_of_path: '" + valoreNonCorrettoInt + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_path.<anyOf>.<pattern>");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in dynamic path 'composed_schema_any_of_path' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorrettoInt + "' in dynamic path 'composed_schema_any_of_path' (expected type 'string'): Too short, expected min length '3'")));
        msgErroreAttesoTest_swagger_request.add((String)msgErroreAttesoTest_json_schema.get(msgErroreAttesoTest_json_schema.size() - 1));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-PATH-INLINE-1");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreNonCorretto1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_path_inline: Value '" + valoreNonCorretto1 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_path_inline.<anyOf>.<format>\ncomposed_schema_any_of_path_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_path_inline.<anyOf>.<type>\ncomposed_schema_any_of_path_inline: Value '" + valoreNonCorretto1 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_path_inline.<anyOf>.<format>\ncomposed_schema_any_of_path_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_path_inline.<anyOf>.<type>");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in dynamic path 'composed_schema_any_of_path_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto1 + "\"\nInvalid value '" + valoreNonCorretto1 + "' in dynamic path 'composed_schema_any_of_path_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto1 + "\"")));
        msgErroreAttesoTest_swagger_request.add((String)msgErroreAttesoTest_json_schema.get(msgErroreAttesoTest_json_schema.size() - 1));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-PATH-INLINE-2");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreNonCorretto2);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_path_inline: Value '" + valoreNonCorretto2 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_path_inline.<anyOf>.<format>\ncomposed_schema_any_of_path_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_path_inline.<anyOf>.<type>\ncomposed_schema_any_of_path_inline: Value '" + valoreNonCorretto2 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_path_inline.<anyOf>.<format>\ncomposed_schema_any_of_path_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_path_inline.<anyOf>.<type>");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto2 + "' in dynamic path 'composed_schema_any_of_path_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto2 + "\"\nInvalid value '" + valoreNonCorretto2 + "' in dynamic path 'composed_schema_any_of_path_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto2 + "\"")));
        msgErroreAttesoTest_swagger_request.add((String)msgErroreAttesoTest_json_schema.get(msgErroreAttesoTest_json_schema.size() - 1));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-PATH-INLINE-3");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreNonCorrettoInt);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_path_inline: Maximum is '20', found '" + valoreNonCorrettoInt + "'. (code: 1010)\nFrom: composed_schema_any_of_path_inline.<anyOf>.<maximum>\ncomposed_schema_any_of_path_inline: Maximum is '55', found '" + valoreNonCorrettoInt + "'. (code: 1010)\nFrom: composed_schema_any_of_path_inline.<anyOf>.<maximum>");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in dynamic path 'composed_schema_any_of_path_inline' (expected type 'int32'): Value higher than the maximum '20'\nInvalid value '" + valoreNonCorrettoInt + "' in dynamic path 'composed_schema_any_of_path_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        msgErroreAttesoTest_swagger_request.add((String)msgErroreAttesoTest_json_schema.get(msgErroreAttesoTest_json_schema.size() - 1));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-QUERY-1");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreNonCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_query: '" + valoreNonCorretto1 + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_query.<anyOf>.<pattern>\ncomposed_schema_any_of_query: '" + valoreNonCorretto1 + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_query.<anyOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @query.composed_schema_any_of_query] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto1 + "\"\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto1 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto1 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto1 + "\"");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in query parameter 'composed_schema_any_of_query' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorretto1 + "' in query parameter 'composed_schema_any_of_query' (expected type 'string'): Pattern match failed ('^[0-9]{3,5}$')")));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-QUERY-2");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreNonCorretto2);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_query: '" + valoreNonCorretto2 + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_query.<anyOf>.<pattern>\ncomposed_schema_any_of_query: '" + valoreNonCorretto2 + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_query.<anyOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @query.composed_schema_any_of_query] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto2 + "\"\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto2 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto2 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto2 + "\"");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto2 + "' in query parameter 'composed_schema_any_of_query' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorretto2 + "' in query parameter 'composed_schema_any_of_query' (expected type 'string'): Pattern match failed ('^[0-9]{3,5}$')")));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-QUERY-3");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreNonCorrettoInt);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_query: '" + valoreNonCorrettoInt + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_query.<anyOf>.<pattern>\ncomposed_schema_any_of_query: Min length is '3', found '2'. (code: 1017)\nFrom: composed_schema_any_of_query.<anyOf>.<minLength>\ncomposed_schema_any_of_query: '" + valoreNonCorrettoInt + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_query.<anyOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @query.composed_schema_any_of_query] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\n\t* /anyOf/1: String \"" + valoreNonCorrettoInt + "\" is too short (length: 2, required minimum: 3)\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\t\n\t- [ERROR][] String \"" + valoreNonCorrettoInt + "\" is too short (length: 2, required minimum: 3)\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorrettoInt + "\"");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in query parameter 'composed_schema_any_of_query' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorrettoInt + "' in query parameter 'composed_schema_any_of_query' (expected type 'string'): Too short, expected min length '3'")));
        tipoTest.add("ERRORE-QUERY-INLINE-1");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreNonCorretto1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_query_inline: Value '" + valoreNonCorretto1 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_query_inline.<anyOf>.<format>\ncomposed_schema_any_of_query_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_query_inline.<anyOf>.<type>\ncomposed_schema_any_of_query_inline: Value '" + valoreNonCorretto1 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_query_inline.<anyOf>.<format>\ncomposed_schema_any_of_query_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_query_inline.<anyOf>.<type>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @query.composed_schema_any_of_query_inline] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\n\t* /anyOf/1: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in query parameter 'composed_schema_any_of_query_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto1 + "\"\nInvalid value '" + valoreNonCorretto1 + "' in query parameter 'composed_schema_any_of_query_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto1 + "\"")));
        tipoTest.add("ERRORE-QUERY-INLINE-2");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreNonCorretto2);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_query_inline: Value '" + valoreNonCorretto2 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_query_inline.<anyOf>.<format>\ncomposed_schema_any_of_query_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_query_inline.<anyOf>.<type>\ncomposed_schema_any_of_query_inline: Value '" + valoreNonCorretto2 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_query_inline.<anyOf>.<format>\ncomposed_schema_any_of_query_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_query_inline.<anyOf>.<type>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @query.composed_schema_any_of_query_inline] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\n\t* /anyOf/1: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto2 + "' in query parameter 'composed_schema_any_of_query_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto2 + "\"\nInvalid value '" + valoreNonCorretto2 + "' in query parameter 'composed_schema_any_of_query_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto2 + "\"")));
        tipoTest.add("ERRORE-QUERY-INLINE-3");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreNonCorrettoInt);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_query_inline: Maximum is '20', found '" + valoreNonCorrettoInt + "'. (code: 1010)\nFrom: composed_schema_any_of_query_inline.<anyOf>.<maximum>\ncomposed_schema_any_of_query_inline: Maximum is '55', found '" + valoreNonCorrettoInt + "'. (code: 1010)\nFrom: composed_schema_any_of_query_inline.<anyOf>.<maximum>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @query.composed_schema_any_of_query_inline] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Numeric instance is greater than the required maximum (maximum: 20, found: 59)\n\t* /anyOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: 59)\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 20, found: 59)\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: 59)");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in query parameter 'composed_schema_any_of_query_inline' (expected type 'int32'): Value higher than the maximum '20'\nInvalid value '" + valoreNonCorrettoInt + "' in query parameter 'composed_schema_any_of_query_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        tipoTest.add("ERRORE-COOKIE-1");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreNonCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_cookie: '" + valoreNonCorretto1 + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_cookie.<anyOf>.<pattern>\ncomposed_schema_any_of_cookie: '" + valoreNonCorretto1 + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_cookie.<anyOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @cookie.composed_schema_any_of_cookie] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto1 + "\"\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto1 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto1 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto1 + "\"");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in cookie 'composed_schema_any_of_cookie' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorretto1 + "' in cookie 'composed_schema_any_of_cookie' (expected type 'string'): Pattern match failed ('^[0-9]{3,5}$')")));
        tipoTest.add("ERRORE-COOKIE-2");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreNonCorretto2);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_cookie: '" + valoreNonCorretto2 + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_cookie.<anyOf>.<pattern>\ncomposed_schema_any_of_cookie: '" + valoreNonCorretto2 + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_cookie.<anyOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @cookie.composed_schema_any_of_cookie] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto2 + "\"\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto2 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto2 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto2 + "\"");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto2 + "' in cookie 'composed_schema_any_of_cookie' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorretto2 + "' in cookie 'composed_schema_any_of_cookie' (expected type 'string'): Pattern match failed ('^[0-9]{3,5}$')")));
        tipoTest.add("ERRORE-COOKIE-3");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreNonCorrettoInt);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_cookie: '" + valoreNonCorrettoInt + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_cookie.<anyOf>.<pattern>\ncomposed_schema_any_of_cookie: Min length is '3', found '2'. (code: 1017)\nFrom: composed_schema_any_of_cookie.<anyOf>.<minLength>\ncomposed_schema_any_of_cookie: '" + valoreNonCorrettoInt + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_cookie.<anyOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @cookie.composed_schema_any_of_cookie] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\n\t* /anyOf/1: String \"" + valoreNonCorrettoInt + "\" is too short (length: 2, required minimum: 3)\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\t\n\t- [ERROR][] String \"" + valoreNonCorrettoInt + "\" is too short (length: 2, required minimum: 3)\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorrettoInt + "\"");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in cookie 'composed_schema_any_of_cookie' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorrettoInt + "' in cookie 'composed_schema_any_of_cookie' (expected type 'string'): Too short, expected min length '3'")));
        tipoTest.add("ERRORE-COOKIE-INLINE-1");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreNonCorretto1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_cookie_inline: Value '" + valoreNonCorretto1 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_cookie_inline.<anyOf>.<format>\ncomposed_schema_any_of_cookie_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_cookie_inline.<anyOf>.<type>\ncomposed_schema_any_of_cookie_inline: Value '" + valoreNonCorretto1 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_cookie_inline.<anyOf>.<format>\ncomposed_schema_any_of_cookie_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_cookie_inline.<anyOf>.<type>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @cookie.composed_schema_any_of_cookie_inline] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\n\t* /anyOf/1: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in cookie 'composed_schema_any_of_cookie_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto1 + "\"\nInvalid value '" + valoreNonCorretto1 + "' in cookie 'composed_schema_any_of_cookie_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto1 + "\"")));
        tipoTest.add("ERRORE-COOKIE-INLINE-2");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreNonCorretto2);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_cookie_inline: Value '" + valoreNonCorretto2 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_cookie_inline.<anyOf>.<format>\ncomposed_schema_any_of_cookie_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_cookie_inline.<anyOf>.<type>\ncomposed_schema_any_of_cookie_inline: Value '" + valoreNonCorretto2 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_cookie_inline.<anyOf>.<format>\ncomposed_schema_any_of_cookie_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_cookie_inline.<anyOf>.<type>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @cookie.composed_schema_any_of_cookie_inline] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\n\t* /anyOf/1: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto2 + "' in cookie 'composed_schema_any_of_cookie_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto2 + "\"\nInvalid value '" + valoreNonCorretto2 + "' in cookie 'composed_schema_any_of_cookie_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto2 + "\"")));
        tipoTest.add("ERRORE-COOKIE-INLINE-3");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreNonCorrettoInt);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_cookie_inline: Maximum is '20', found '" + valoreNonCorrettoInt + "'. (code: 1010)\nFrom: composed_schema_any_of_cookie_inline.<anyOf>.<maximum>\ncomposed_schema_any_of_cookie_inline: Maximum is '55', found '" + valoreNonCorrettoInt + "'. (code: 1010)\nFrom: composed_schema_any_of_cookie_inline.<anyOf>.<maximum>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @cookie.composed_schema_any_of_cookie_inline] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Numeric instance is greater than the required maximum (maximum: 20, found: 59)\n\t* /anyOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: 59)\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 20, found: 59)\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: 59)");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in cookie 'composed_schema_any_of_cookie_inline' (expected type 'int32'): Value higher than the maximum '20'\nInvalid value '" + valoreNonCorrettoInt + "' in cookie 'composed_schema_any_of_cookie_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        tipoTest.add("ERRORE-HEADER-1");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreNonCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_header: '" + valoreNonCorretto1 + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_header.<anyOf>.<pattern>\ncomposed_schema_any_of_header: '" + valoreNonCorretto1 + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_header.<anyOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @header.composed_schema_any_of_header] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto1 + "\"\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto1 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto1 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto1 + "\"");
        msgErroreAttesoTest_swagger_response.add("Validation failed.\n[ERROR][RESPONSE][] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto1 + "\"\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto1 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto1 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto1 + "\"");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in http header 'composed_schema_any_of_header' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorretto1 + "' in http header 'composed_schema_any_of_header' (expected type 'string'): Pattern match failed ('^[0-9]{3,5}$')")));
        tipoTest.add("ERRORE-HEADER-2");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreNonCorretto2);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_header: '" + valoreNonCorretto2 + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_header.<anyOf>.<pattern>\ncomposed_schema_any_of_header: '" + valoreNonCorretto2 + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_header.<anyOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @header.composed_schema_any_of_header] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto2 + "\"\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto2 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto2 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto2 + "\"");
        msgErroreAttesoTest_swagger_response.add("[ERROR][RESPONSE][] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto2 + "\"\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto2 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorretto2 + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorretto2 + "\"");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto2 + "' in http header 'composed_schema_any_of_header' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorretto2 + "' in http header 'composed_schema_any_of_header' (expected type 'string'): Pattern match failed ('^[0-9]{3,5}$')")));
        tipoTest.add("ERRORE-HEADER-3");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreNonCorrettoInt);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_header: '" + valoreNonCorrettoInt + "' does not respect pattern '^[A-Z]{11}$'. (code: 1025)\nFrom: composed_schema_any_of_header.<anyOf>.<pattern>\ncomposed_schema_any_of_header: Min length is '3', found '2'. (code: 1017)\nFrom: composed_schema_any_of_header.<anyOf>.<minLength>\ncomposed_schema_any_of_header: '" + valoreNonCorrettoInt + "' does not respect pattern '^[0-9]{3,5}$'. (code: 1025)\nFrom: composed_schema_any_of_header.<anyOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @header.composed_schema_any_of_header] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\n\t* /anyOf/1: String \"" + valoreNonCorrettoInt + "\" is too short (length: 2, required minimum: 3)\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\t\n\t- [ERROR][] String \"" + valoreNonCorrettoInt + "\" is too short (length: 2, required minimum: 3)\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorrettoInt + "\"");
        msgErroreAttesoTest_swagger_response.add("Validation failed.\n[ERROR][RESPONSE][] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\n\t* /anyOf/1: String \"" + valoreNonCorrettoInt + "\" is too short (length: 2, required minimum: 3)\n\t* /anyOf/1: ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{11}$\" does not match input string \"" + valoreNonCorrettoInt + "\"\t\n\t- [ERROR][] String \"" + valoreNonCorrettoInt + "\" is too short (length: 2, required minimum: 3)\t\n\t- [ERROR][] ECMA 262 regex \"^[0-9]{3,5}$\" does not match input string \"" + valoreNonCorrettoInt + "\"");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in http header 'composed_schema_any_of_header' (expected type 'string'): Pattern match failed ('^[A-Z]{11}$')\nInvalid value '" + valoreNonCorrettoInt + "' in http header 'composed_schema_any_of_header' (expected type 'string'): Too short, expected min length '3'")));
        tipoTest.add("ERRORE-HEADER-INLINE-1");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreNonCorretto1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_header_inline: Value '" + valoreNonCorretto1 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_header_inline.<anyOf>.<format>\ncomposed_schema_any_of_header_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_header_inline.<anyOf>.<type>\ncomposed_schema_any_of_header_inline: Value '" + valoreNonCorretto1 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_header_inline.<anyOf>.<format>\ncomposed_schema_any_of_header_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_header_inline.<anyOf>.<type>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @header.composed_schema_any_of_header_inline] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\n\t* /anyOf/1: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])");
        msgErroreAttesoTest_swagger_response.add("Validation failed.\n[ERROR][RESPONSE][] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\n\t* /anyOf/1: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in http header 'composed_schema_any_of_header_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto1 + "\"\nInvalid value '" + valoreNonCorretto1 + "' in http header 'composed_schema_any_of_header_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto1 + "\"")));
        tipoTest.add("ERRORE-HEADER-INLINE-2");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreNonCorretto2);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_header_inline: Value '" + valoreNonCorretto2 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_header_inline.<anyOf>.<format>\ncomposed_schema_any_of_header_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_header_inline.<anyOf>.<type>\ncomposed_schema_any_of_header_inline: Value '" + valoreNonCorretto2 + "' does not match format 'int32'. (code: 1007)\nFrom: composed_schema_any_of_header_inline.<anyOf>.<format>\ncomposed_schema_any_of_header_inline: Type expected 'integer', found 'string'. (code: 1027)\nFrom: composed_schema_any_of_header_inline.<anyOf>.<type>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @header.composed_schema_any_of_header_inline] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\n\t* /anyOf/1: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])");
        msgErroreAttesoTest_swagger_response.add("Validation failed.\n[ERROR][RESPONSE][] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\n\t* /anyOf/1: Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])\t\n\t- [ERROR][] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto2 + "' in http header 'composed_schema_any_of_header_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto2 + "\"\nInvalid value '" + valoreNonCorretto2 + "' in http header 'composed_schema_any_of_header_inline' (expected type 'int32'): For input string: \"" + valoreNonCorretto2 + "\"")));
        tipoTest.add("ERRORE-HEADER-INLINE-3");
        complexTypeTest.add("any_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreNonCorrettoInt);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_any_of_header_inline: Maximum is '20', found '" + valoreNonCorrettoInt + "'. (code: 1010)\nFrom: composed_schema_any_of_header_inline.<anyOf>.<maximum>\ncomposed_schema_any_of_header_inline: Maximum is '55', found '" + valoreNonCorrettoInt + "'. (code: 1010)\nFrom: composed_schema_any_of_header_inline.<anyOf>.<maximum>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/any_of/ABCDEFGHILK/20 @header.composed_schema_any_of_header_inline] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Numeric instance is greater than the required maximum (maximum: 20, found: 59)\n\t* /anyOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: 59)\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 20, found: 59)\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: 59)");
        msgErroreAttesoTest_swagger_response.add("Validation failed.\n[ERROR][RESPONSE][] Instance failed to match at least one required schema among 2\n\t* /anyOf/0: Numeric instance is greater than the required maximum (maximum: 20, found: 59)\n\t* /anyOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: 59)\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 20, found: 59)\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: 59)");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in http header 'composed_schema_any_of_header_inline' (expected type 'int32'): Value higher than the maximum '20'\nInvalid value '" + valoreNonCorrettoInt + "' in http header 'composed_schema_any_of_header_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        valoreCorretto1 = "ABCDEFGHILK";
        String valoreNonCorrettoInAssoluto = "A";
        String valoreNonCorrettoRegolaDue = "ABCDE";
        valoreCorrettoInt1 = "50";
        String valoreNonCorrettoIntInAssoluto = "104";
        String valoreNonCorrettoIntRegolaDue = "90";
        tipoTest.add("OK-1");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(false);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add(null);
        msgErroreAttesoTest_swagger_request.add(null);
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add(null);
        tipoTest.add("ERRORE-PATH-1");
        complexTypeTest.add("all_of");
        pathTest.add(valoreNonCorrettoRegolaDue);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_path: Min length is '7', found '" + valoreNonCorrettoRegolaDue.length() + "'. (code: 1017)\nFrom: composed_schema_all_of_path.<allOf>.<minLength>");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoRegolaDue + "' in dynamic path 'composed_schema_all_of_path' (expected type 'string'): Too short, expected min length '7'")));
        msgErroreAttesoTest_swagger_request.add((String)msgErroreAttesoTest_json_schema.get(msgErroreAttesoTest_json_schema.size() - 1));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-PATH-2");
        complexTypeTest.add("all_of");
        pathTest.add(valoreNonCorrettoInAssoluto);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_path: '" + valoreNonCorrettoInAssoluto + "' does not respect pattern '^[A-Z]{5,11}$'. (code: 1025)\nFrom: composed_schema_all_of_path.<allOf>.<pattern>");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInAssoluto + "' in dynamic path 'composed_schema_all_of_path' (expected type 'string'): Pattern match failed ('^[A-Z]{5,11}$')\nInvalid value '" + valoreNonCorrettoInAssoluto + "' in dynamic path 'composed_schema_all_of_path' (expected type 'string'): Too short, expected min length '7'")));
        msgErroreAttesoTest_swagger_request.add((String)msgErroreAttesoTest_json_schema.get(msgErroreAttesoTest_json_schema.size() - 1));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-PATH-INLINE-1");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreNonCorrettoIntRegolaDue);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_path_inline: Maximum is '55', found '" + valoreNonCorrettoIntRegolaDue + "'. (code: 1010)\nFrom: composed_schema_all_of_path_inline.<allOf>.<maximum>");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoIntRegolaDue + "' in dynamic path 'composed_schema_all_of_path_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        msgErroreAttesoTest_swagger_request.add((String)msgErroreAttesoTest_json_schema.get(msgErroreAttesoTest_json_schema.size() - 1));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-PATH-INLINE-2");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreNonCorrettoIntInAssoluto);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_path_inline: Maximum is '100', found '" + valoreNonCorrettoIntInAssoluto + "'. (code: 1010)\nFrom: composed_schema_all_of_path_inline.<allOf>.<maximum>");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoIntInAssoluto + "' in dynamic path 'composed_schema_all_of_path_inline' (expected type 'int32'): Value higher than the maximum '100'\nInvalid value '" + valoreNonCorrettoIntInAssoluto + "' in dynamic path 'composed_schema_all_of_path_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        msgErroreAttesoTest_swagger_request.add((String)msgErroreAttesoTest_json_schema.get(msgErroreAttesoTest_json_schema.size() - 1));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-QUERY-1");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreNonCorrettoRegolaDue);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_query: Min length is '7', found '" + valoreNonCorrettoRegolaDue.length() + "'. (code: 1017)\nFrom: composed_schema_all_of_query.<allOf>.<minLength>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @query.composed_schema_all_of_query] Instance failed to match all required schemas (matched only 1 out of 2)\n\t* /allOf/1: String \"ABCDE\" is too short (length: " + valoreNonCorrettoRegolaDue.length() + ", required minimum: 7)\t\n\t- [ERROR][] String \"ABCDE\" is too short (length: " + valoreNonCorrettoRegolaDue.length() + ", required minimum: 7)");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoRegolaDue + "' in query parameter 'composed_schema_all_of_query' (expected type 'string'): Too short, expected min length '7'")));
        tipoTest.add("ERRORE-QUERY-2");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreNonCorrettoInAssoluto);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_query: '" + valoreNonCorrettoInAssoluto + "' does not respect pattern '^[A-Z]{5,11}$'. (code: 1025)\nFrom: composed_schema_all_of_query.<allOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @query.composed_schema_all_of_query] Instance failed to match all required schemas (matched only 0 out of 2)\n\t* /allOf/0: ECMA 262 regex \"^[A-Z]{5,11}$\" does not match input string \"" + valoreNonCorrettoInAssoluto + "\"\n\t* /allOf/1: String \"A\" is too short (length: 1, required minimum: 7)\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{5,11}$\" does not match input string \"" + valoreNonCorrettoInAssoluto + "\"\t\n\t- [ERROR][] String \"A\" is too short (length: 1, required minimum: 7)");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInAssoluto + "' in query parameter 'composed_schema_all_of_query' (expected type 'string'): Pattern match failed ('^[A-Z]{5,11}$')\nInvalid value '" + valoreNonCorrettoInAssoluto + "' in query parameter 'composed_schema_all_of_query' (expected type 'string'): Too short, expected min length '7'")));
        tipoTest.add("ERRORE-QUERY-INLINE-1");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreNonCorrettoIntRegolaDue);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_query_inline: Maximum is '55', found '" + valoreNonCorrettoIntRegolaDue + "'. (code: 1010)\nFrom: composed_schema_all_of_query_inline.<allOf>.<maximum>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @query.composed_schema_all_of_query_inline] Instance failed to match all required schemas (matched only 1 out of 2)\n\t* /allOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntRegolaDue + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntRegolaDue + ")");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoIntRegolaDue + "' in query parameter 'composed_schema_all_of_query_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        tipoTest.add("ERRORE-QUERY-INLINE-2");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreNonCorrettoIntInAssoluto);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_query_inline: Maximum is '100', found '" + valoreNonCorrettoIntInAssoluto + "'. (code: 1010)\nFrom: composed_schema_all_of_query_inline.<allOf>.<maximum>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @query.composed_schema_all_of_query_inline] Instance failed to match all required schemas (matched only 0 out of 2)\n\t* /allOf/0: Numeric instance is greater than the required maximum (maximum: 100, found: " + valoreNonCorrettoIntInAssoluto + ")\n\t* /allOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntInAssoluto + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 100, found: " + valoreNonCorrettoIntInAssoluto + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntInAssoluto + ")");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoIntInAssoluto + "' in query parameter 'composed_schema_all_of_query_inline' (expected type 'int32'): Value higher than the maximum '100'\nInvalid value '" + valoreNonCorrettoIntInAssoluto + "' in query parameter 'composed_schema_all_of_query_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        tipoTest.add("ERRORE-COOKIE-1");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreNonCorrettoRegolaDue);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_cookie: Min length is '7', found '" + valoreNonCorrettoRegolaDue.length() + "'. (code: 1017)\nFrom: composed_schema_all_of_cookie.<allOf>.<minLength>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @cookie.composed_schema_all_of_cookie] Instance failed to match all required schemas (matched only 1 out of 2)\n\t* /allOf/1: String \"ABCDE\" is too short (length: " + valoreNonCorrettoRegolaDue.length() + ", required minimum: 7)\t\n\t- [ERROR][] String \"ABCDE\" is too short (length: " + valoreNonCorrettoRegolaDue.length() + ", required minimum: 7)");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoRegolaDue + "' in cookie 'composed_schema_all_of_cookie' (expected type 'string'): Too short, expected min length '7'")));
        tipoTest.add("ERRORE-COOKIE-2");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreNonCorrettoInAssoluto);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_cookie: '" + valoreNonCorrettoInAssoluto + "' does not respect pattern '^[A-Z]{5,11}$'. (code: 1025)\nFrom: composed_schema_all_of_cookie.<allOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @cookie.composed_schema_all_of_cookie] Instance failed to match all required schemas (matched only 0 out of 2)\n\t* /allOf/0: ECMA 262 regex \"^[A-Z]{5,11}$\" does not match input string \"" + valoreNonCorrettoInAssoluto + "\"\n\t* /allOf/1: String \"" + valoreNonCorrettoInAssoluto + "\" is too short (length: 1, required minimum: 7)\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{5,11}$\" does not match input string \"" + valoreNonCorrettoInAssoluto + "\"\t\n\t- [ERROR][] String \"" + valoreNonCorrettoInAssoluto + "\" is too short (length: 1, required minimum: 7)");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInAssoluto + "' in cookie 'composed_schema_all_of_cookie' (expected type 'string'): Pattern match failed ('^[A-Z]{5,11}$')\nInvalid value '" + valoreNonCorrettoInAssoluto + "' in cookie 'composed_schema_all_of_cookie' (expected type 'string'): Too short, expected min length '7'")));
        tipoTest.add("ERRORE-COOKIE-INLINE-1");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreNonCorrettoIntRegolaDue);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_cookie_inline: Maximum is '55', found '" + valoreNonCorrettoIntRegolaDue + "'. (code: 1010)\nFrom: composed_schema_all_of_cookie_inline.<allOf>.<maximum>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @cookie.composed_schema_all_of_cookie_inline] Instance failed to match all required schemas (matched only 1 out of 2)\n\t* /allOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntRegolaDue + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntRegolaDue + ")");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoIntRegolaDue + "' in cookie 'composed_schema_all_of_cookie_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        tipoTest.add("ERRORE-COOKIE-INLINE-2");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreNonCorrettoIntInAssoluto);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_cookie_inline: Maximum is '100', found '" + valoreNonCorrettoIntInAssoluto + "'. (code: 1010)\nFrom: composed_schema_all_of_cookie_inline.<allOf>.<maximum>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @cookie.composed_schema_all_of_cookie_inline] Instance failed to match all required schemas (matched only 0 out of 2)\n\t* /allOf/0: Numeric instance is greater than the required maximum (maximum: 100, found: " + valoreNonCorrettoIntInAssoluto + ")\n\t* /allOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntInAssoluto + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 100, found: " + valoreNonCorrettoIntInAssoluto + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntInAssoluto + ")");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoIntInAssoluto + "' in cookie 'composed_schema_all_of_cookie_inline' (expected type 'int32'): Value higher than the maximum '100'\nInvalid value '" + valoreNonCorrettoIntInAssoluto + "' in cookie 'composed_schema_all_of_cookie_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        tipoTest.add("ERRORE-HEADER-1");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreNonCorrettoRegolaDue);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_header: Min length is '7', found '" + valoreNonCorrettoRegolaDue.length() + "'. (code: 1017)\nFrom: composed_schema_all_of_header.<allOf>.<minLength>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @header.composed_schema_all_of_header] Instance failed to match all required schemas (matched only 1 out of 2)\n\t* /allOf/1: String \"ABCDE\" is too short (length: " + valoreNonCorrettoRegolaDue.length() + ", required minimum: 7)\t\n\t- [ERROR][] String \"ABCDE\" is too short (length: " + valoreNonCorrettoRegolaDue.length() + ", required minimum: 7)");
        msgErroreAttesoTest_swagger_response.add("Validation failed.\n[ERROR][RESPONSE][] Instance failed to match all required schemas (matched only 1 out of 2)\n\t* /allOf/1: String \"ABCDE\" is too short (length: " + valoreNonCorrettoRegolaDue.length() + ", required minimum: 7)\t\n\t- [ERROR][] String \"ABCDE\" is too short (length: " + valoreNonCorrettoRegolaDue.length() + ", required minimum: 7)");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoRegolaDue + "' in http header 'composed_schema_all_of_header' (expected type 'string'): Too short, expected min length '7'")));
        tipoTest.add("ERRORE-HEADER-2");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreNonCorrettoInAssoluto);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_header: '" + valoreNonCorrettoInAssoluto + "' does not respect pattern '^[A-Z]{5,11}$'. (code: 1025)\nFrom: composed_schema_all_of_header.<allOf>.<pattern>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @header.composed_schema_all_of_header] Instance failed to match all required schemas (matched only 0 out of 2)\n\t* /allOf/0: ECMA 262 regex \"^[A-Z]{5,11}$\" does not match input string \"" + valoreNonCorrettoInAssoluto + "\"\n\t* /allOf/1: String \"" + valoreNonCorrettoInAssoluto + "\" is too short (length: 1, required minimum: 7)\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{5,11}$\" does not match input string \"" + valoreNonCorrettoInAssoluto + "\"\t\n\t- [ERROR][] String \"" + valoreNonCorrettoInAssoluto + "\" is too short (length: 1, required minimum: 7)");
        msgErroreAttesoTest_swagger_response.add("Validation failed.\n[ERROR][RESPONSE][] Instance failed to match all required schemas (matched only 0 out of 2)\n\t* /allOf/0: ECMA 262 regex \"^[A-Z]{5,11}$\" does not match input string \"" + valoreNonCorrettoInAssoluto + "\"\n\t* /allOf/1: String \"" + valoreNonCorrettoInAssoluto + "\" is too short (length: 1, required minimum: 7)\t\n\t- [ERROR][] ECMA 262 regex \"^[A-Z]{5,11}$\" does not match input string \"" + valoreNonCorrettoInAssoluto + "\"\t\n\t- [ERROR][] String \"" + valoreNonCorrettoInAssoluto + "\" is too short (length: 1, required minimum: 7)");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInAssoluto + "' in http header 'composed_schema_all_of_header' (expected type 'string'): Pattern match failed ('^[A-Z]{5,11}$')\nInvalid value '" + valoreNonCorrettoInAssoluto + "' in http header 'composed_schema_all_of_header' (expected type 'string'): Too short, expected min length '7'")));
        tipoTest.add("ERRORE-HEADER-INLINE-1");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreNonCorrettoIntRegolaDue);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_header_inline: Maximum is '55', found '" + valoreNonCorrettoIntRegolaDue + "'. (code: 1010)\nFrom: composed_schema_all_of_header_inline.<allOf>.<maximum>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @header.composed_schema_all_of_header_inline] Instance failed to match all required schemas (matched only 1 out of 2)\n\t* /allOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntRegolaDue + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntRegolaDue + ")");
        msgErroreAttesoTest_swagger_response.add("Validation failed.\n[ERROR][RESPONSE][] Instance failed to match all required schemas (matched only 1 out of 2)\n\t* /allOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntRegolaDue + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntRegolaDue + ")");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoIntRegolaDue + "' in http header 'composed_schema_all_of_header_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        tipoTest.add("ERRORE-HEADER-INLINE-2");
        complexTypeTest.add("all_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreNonCorrettoIntInAssoluto);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_all_of_header_inline: Maximum is '100', found '" + valoreNonCorrettoIntInAssoluto + "'. (code: 1010)\nFrom: composed_schema_all_of_header_inline.<allOf>.<maximum>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/all_of/ABCDEFGHILK/50 @header.composed_schema_all_of_header_inline] Instance failed to match all required schemas (matched only 0 out of 2)\n\t* /allOf/0: Numeric instance is greater than the required maximum (maximum: 100, found: " + valoreNonCorrettoIntInAssoluto + ")\n\t* /allOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntInAssoluto + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 100, found: " + valoreNonCorrettoIntInAssoluto + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntInAssoluto + ")");
        msgErroreAttesoTest_swagger_response.add("Validation failed.\n[ERROR][RESPONSE][] Instance failed to match all required schemas (matched only 0 out of 2)\n\t* /allOf/0: Numeric instance is greater than the required maximum (maximum: 100, found: " + valoreNonCorrettoIntInAssoluto + ")\n\t* /allOf/1: Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntInAssoluto + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 100, found: " + valoreNonCorrettoIntInAssoluto + ")\t\n\t- [ERROR][] Numeric instance is greater than the required maximum (maximum: 55, found: " + valoreNonCorrettoIntInAssoluto + ")");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoIntInAssoluto + "' in http header 'composed_schema_all_of_header_inline' (expected type 'int32'): Value higher than the maximum '100'\nInvalid value '" + valoreNonCorrettoIntInAssoluto + "' in http header 'composed_schema_all_of_header_inline' (expected type 'int32'): Value higher than the maximum '55'")));
        valoreCorretto1 = "ABCDE";
        valoreNonCorretto1 = "ABCDEFGHILK";
        valoreCorrettoInt1 = "90";
        valoreNonCorrettoInt = "50";
        tipoTest.add("OK-1");
        complexTypeTest.add("one_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(false);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add(null);
        msgErroreAttesoTest_swagger_request.add(null);
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add(null);
        tipoTest.add("ERRORE-PATH-1");
        complexTypeTest.add("one_of");
        pathTest.add(valoreNonCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_one_of_path: More than 1 schema is valid. (code: 1023)\nFrom: composed_schema_one_of_path.<oneOf>");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in dynamic path 'composed_schema_one_of_path': expected validates the value against exactly one of the subschemas; founded valid in 2 schemas")));
        msgErroreAttesoTest_swagger_request.add((String)msgErroreAttesoTest_json_schema.get(msgErroreAttesoTest_json_schema.size() - 1));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-PATH-INLINE-1");
        complexTypeTest.add("one_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreNonCorrettoInt);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_one_of_path_inline: More than 1 schema is valid. (code: 1023)\nFrom: composed_schema_one_of_path_inline.<oneOf>");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in dynamic path 'composed_schema_one_of_path_inline': expected validates the value against exactly one of the subschemas; founded valid in 2 schemas")));
        msgErroreAttesoTest_swagger_request.add((String)msgErroreAttesoTest_json_schema.get(msgErroreAttesoTest_json_schema.size() - 1));
        msgErroreAttesoTest_swagger_response.add(null);
        tipoTest.add("ERRORE-QUERY-1");
        complexTypeTest.add("one_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreNonCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_one_of_query: More than 1 schema is valid. (code: 1023)\nFrom: composed_schema_one_of_query.<oneOf>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/one_of/ABCDE/90 @query.composed_schema_one_of_query] Instance failed to match exactly one schema (matched 2 out of 2)");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in query parameter 'composed_schema_one_of_query': expected validates the value against exactly one of the subschemas; founded valid in 2 schemas")));
        tipoTest.add("ERRORE-QUERY-INLINE-1");
        complexTypeTest.add("one_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreNonCorrettoInt);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_one_of_query_inline: More than 1 schema is valid. (code: 1023)\nFrom: composed_schema_one_of_query_inline.<oneOf>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/one_of/ABCDE/90 @query.composed_schema_one_of_query_inline] Instance failed to match exactly one schema (matched 2 out of 2)");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in query parameter 'composed_schema_one_of_query_inline': expected validates the value against exactly one of the subschemas; founded valid in 2 schemas")));
        tipoTest.add("ERRORE-COOKIE-1");
        complexTypeTest.add("one_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreNonCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_one_of_cookie: More than 1 schema is valid. (code: 1023)\nFrom: composed_schema_one_of_cookie.<oneOf>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/one_of/ABCDE/90 @cookie.composed_schema_one_of_cookie] Instance failed to match exactly one schema (matched 2 out of 2)");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in cookie 'composed_schema_one_of_cookie': expected validates the value against exactly one of the subschemas; founded valid in 2 schemas")));
        tipoTest.add("ERRORE-COOKIE-INLINE-1");
        complexTypeTest.add("one_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreNonCorrettoInt);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(false);
        msgErroreAttesoTest_openapi4j.add("composed_schema_one_of_cookie_inline: More than 1 schema is valid. (code: 1023)\nFrom: composed_schema_one_of_cookie_inline.<oneOf>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/one_of/ABCDE/90 @cookie.composed_schema_one_of_cookie_inline] Instance failed to match exactly one schema (matched 2 out of 2)");
        msgErroreAttesoTest_swagger_response.add(null);
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in cookie 'composed_schema_one_of_cookie_inline': expected validates the value against exactly one of the subschemas; founded valid in 2 schemas")));
        tipoTest.add("ERRORE-HEADER-1");
        complexTypeTest.add("one_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreNonCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreCorrettoInt1);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_one_of_header: More than 1 schema is valid. (code: 1023)\nFrom: composed_schema_one_of_header.<oneOf>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/one_of/ABCDE/90 @header.composed_schema_one_of_header] Instance failed to match exactly one schema (matched 2 out of 2)");
        msgErroreAttesoTest_swagger_response.add("Validation failed.\n[ERROR][RESPONSE][] Instance failed to match exactly one schema (matched 2 out of 2)");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorretto1 + "' in http header 'composed_schema_one_of_header': expected validates the value against exactly one of the subschemas; founded valid in 2 schemas")));
        tipoTest.add("ERRORE-HEADER-INLINE-1");
        complexTypeTest.add("one_of");
        pathTest.add(valoreCorretto1);
        queryTest.add(valoreCorretto1);
        headerTest.add(valoreCorretto1);
        cookieTest.add(valoreCorretto1);
        pathInLineTest.add(valoreCorrettoInt1);
        queryInLineTest.add(valoreCorrettoInt1);
        headerInLineTest.add(valoreNonCorrettoInt);
        cookieInLineTest.add(valoreCorrettoInt1);
        erroreAttesoRichiestaTest.add(true);
        erroreAttesoRispostaTest.add(true);
        msgErroreAttesoTest_openapi4j.add("composed_schema_one_of_header_inline: More than 1 schema is valid. (code: 1023)\nFrom: composed_schema_one_of_header_inline.<oneOf>");
        msgErroreAttesoTest_swagger_request.add("Validation failed.\n[ERROR][REQUEST][POST /documenti/composed-schema-parameters/one_of/ABCDE/90 @header.composed_schema_one_of_header_inline] Instance failed to match exactly one schema (matched 2 out of 2)");
        msgErroreAttesoTest_swagger_response.add("Validation failed.\n[ERROR][RESPONSE][] Instance failed to match exactly one schema (matched 2 out of 2)");
        msgErroreAttesoTest_json_schema.add((CallSite)((Object)("Invalid value '" + valoreNonCorrettoInt + "' in http header 'composed_schema_one_of_header_inline': expected validates the value against exactly one of the subschemas; founded valid in 2 schemas")));
        for (int i = 0; i < tipoTest.size(); ++i) {
            String path;
            String complexType;
            String tipo;
            block17: {
                String contentType;
                HttpRequestMethod method;
                String msgErroreAtteso;
                String content;
                boolean erroreAttesoRisposta;
                String headerInLineParam;
                String headerParam;
                block16: {
                    tipo = (String)tipoTest.get(i);
                    complexType = (String)complexTypeTest.get(i);
                    String pathParam = (String)pathTest.get(i);
                    headerParam = (String)headerTest.get(i);
                    String queryParam = (String)queryTest.get(i);
                    String cookieParam = (String)cookieTest.get(i);
                    String pathInLineParam = (String)pathInLineTest.get(i);
                    headerInLineParam = (String)headerInLineTest.get(i);
                    String queryInLineParam = (String)queryInLineTest.get(i);
                    String cookieInLineParam = (String)cookieInLineTest.get(i);
                    boolean erroreAttesoRichiesta = (Boolean)erroreAttesoRichiestaTest.get(i);
                    erroreAttesoRisposta = (Boolean)erroreAttesoRispostaTest.get(i);
                    content = "Hello World";
                    msgErroreAtteso = null;
                    switch (openAPILibrary) {
                        case openapi4j: {
                            msgErroreAtteso = (String)msgErroreAttesoTest_openapi4j.get(i);
                            break;
                        }
                        case swagger_request_validator: {
                            msgErroreAtteso = (String)msgErroreAttesoTest_swagger_request.get(i);
                            break;
                        }
                        case json_schema: {
                            msgErroreAtteso = (String)msgErroreAttesoTest_json_schema.get(i);
                            break;
                        }
                    }
                    if (msgErroreAtteso == null) {
                        msgErroreAtteso = "undefined";
                    }
                    path = "/documenti/composed-schema-parameters/" + complexType + "/" + pathParam + "/" + pathInLineParam;
                    method = HttpRequestMethod.POST;
                    contentType = "text/plain";
                    System.out.println("\tTest Richiesta (" + complexType + ") [" + tipo + "] (i:" + i + ") path:" + path + " ...");
                    TextHttpRequestEntity request = new TextHttpRequestEntity();
                    request.setUrl(path);
                    request.setMethod(method);
                    request.setContent(content);
                    HashMap<String, List<String>> parametersTrasporto = new HashMap<String, List<String>>();
                    TransportUtils.addHeader(parametersTrasporto, "Content-Type", contentType);
                    TransportUtils.addHeader(parametersTrasporto, "composed_schema_" + complexType + "_header", headerParam);
                    TransportUtils.addHeader(parametersTrasporto, "composed_schema_" + complexType + "_header_inline", headerInLineParam);
                    request.setHeaders(parametersTrasporto);
                    request.setContentType(contentType);
                    HashMap<String, List<String>> parametersQuery = new HashMap<String, List<String>>();
                    TransportUtils.addHeader(parametersQuery, "composed_schema_" + complexType + "_query", queryParam);
                    TransportUtils.addHeader(parametersQuery, "composed_schema_" + complexType + "_query_inline", queryInLineParam);
                    request.setParameters(parametersQuery);
                    ArrayList<Cookie> cookies = new ArrayList<Cookie>();
                    Cookie c1 = new Cookie("composed_schema_" + complexType + "_cookie", cookieParam);
                    Cookie c2 = new Cookie("composed_schema_" + complexType + "_cookie_inline", cookieInLineParam);
                    cookies.add(c1);
                    cookies.add(c2);
                    request.setCookies(cookies);
                    try {
                        apiValidatorOpenApi4j.validate(request);
                        if (!erroreAttesoRichiesta) break block16;
                        if ("SKIP".equals(msgErroreAtteso)) {
                            System.out.println("WARN Libreria non supporta ancora correttamente la validazione, si attendeva un errore");
                            break block16;
                        }
                        throw new Exception("Atteso errore (" + tipo + ") '" + msgErroreAtteso + "' non rilevato");
                    }
                    catch (ValidatorException e) {
                        if (erroreAttesoRichiesta && e.getMessage() != null && e.getMessage().contains(msgErroreAtteso)) {
                            System.out.println("Errore atteso: " + e.getMessage());
                        }
                        throw new Exception("Errore non atteso (" + tipo + "): " + e.getMessage() + "\n Errore Invece Atteso: " + msgErroreAtteso);
                    }
                }
                System.out.println("\tTest Richiesta (" + complexType + ") [" + tipo + "] path:" + path + " superato");
                System.out.println("\tTest Risposta (" + complexType + ") [" + tipo + "] path:" + path + " ...");
                if (openAPILibrary == OpenAPILibrary.swagger_request_validator && (msgErroreAtteso = (String)msgErroreAttesoTest_swagger_response.get(i)) == null) {
                    msgErroreAtteso = "undefined";
                }
                TextHttpResponseEntity response = new TextHttpResponseEntity();
                response.setContent(content);
                response.setStatus(200);
                response.setMethod(method);
                response.setUrl(path);
                HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                TransportUtils.setHeader(responseHeaders, "Content-Type", contentType);
                TransportUtils.addHeader(responseHeaders, "composed_schema_" + complexType + "_header", headerParam);
                TransportUtils.addHeader(responseHeaders, "composed_schema_" + complexType + "_header_inline", headerInLineParam);
                response.setHeaders(responseHeaders);
                response.setContentType(contentType);
                try {
                    apiValidatorOpenApi4j.validate(response);
                    if (!erroreAttesoRisposta) break block17;
                    if ("SKIP".equals(msgErroreAtteso)) {
                        System.out.println("WARN Libreria non supporta ancora correttamente la validazione, si attendeva un errore");
                        break block17;
                    }
                    throw new Exception("Atteso errore (" + tipo + ") '" + msgErroreAtteso + "' non rilevato");
                }
                catch (ValidatorException e) {
                    if (erroreAttesoRisposta && e.getMessage() != null && e.getMessage().contains(msgErroreAtteso)) {
                        System.out.println("Errore atteso: " + e.getMessage());
                    }
                    throw new Exception("Errore non atteso (" + tipo + "): " + e.getMessage() + "\n Errore Invece Atteso: " + msgErroreAtteso);
                }
            }
            System.out.println("\tTest Risposta (" + complexType + ") [" + tipo + "] path:" + path + " superato");
        }
        System.out.println("TEST Verifica ComposedSchemaParameters completato!");
    }

    private static void testAccept(OpenAPILibrary openAPILibrary, boolean mergeSpec) throws UtilsException, ProcessingException, URISyntaxException, Exception {
        System.out.println("#### Verifica Format Accept ####");
        URL url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/allegati.yaml");
        ApiSchema apiSchemaYaml = new ApiSchema("teamdigitale-openapi_definitions.yaml", Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/service/schemi/standard/teamdigitale-openapi_definitions.yaml")), ApiSchemaType.YAML);
        IApiReader apiReaderOpenApi4j = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        ApiReaderConfig configOpenApi4j = new ApiReaderConfig();
        configOpenApi4j.setProcessInclude(false);
        apiReaderOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi4j, apiSchemaYaml);
        Api apiOpenApi4j = apiReaderOpenApi4j.read();
        IApiValidator apiValidatorOpenApi4j = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
        OpenapiApiValidatorConfig configO = new OpenapiApiValidatorConfig();
        configO.setEmitLogError(logSystemOutError);
        configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
        configO.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
        configO.getOpenApiValidatorConfig().setValidateAPISpec(true);
        configO.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
        apiValidatorOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi4j, configO);
        String path = "/documenti/eef036bf-48af-11ed-97b9-005056ae1884";
        HttpRequestMethod method = HttpRequestMethod.GET;
        String contentType = "text/plain";
        ArrayList<String> tipoTest = new ArrayList<String>();
        tipoTest.add("text/xml");
        tipoTest.add("application/json ");
        tipoTest.add(" application/json ");
        tipoTest.add("application/json;q=0.2");
        tipoTest.add("text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        tipoTest.add("text/html, image/gif, image/jpeg,*;q=.2,*/*;q=.2");
        tipoTest.add("text/html, image/gif, image/jpeg, * ; q=.2, */* ; q=.2");
        tipoTest.add("text/html, image/gif, image/jpeg, *; q= .2, */*; q= .2");
        tipoTest.add("text/html, image/gif, image/jpeg,*;q= .2,*/*;q= .2");
        tipoTest.add("text/html, image/gif, image/jpeg, * ; q= .2, */* ; q= .2");
        tipoTest.add("text/html, image/gif, image/jpeg, *; q=0.5, */*; q=0.5");
        tipoTest.add("text/html, image/gif, image/jpeg,*;q=0.5,*/*;q=0.5");
        tipoTest.add("text/html, image/gif, image/jpeg, * ; q=0.5, */* ; q=0.5");
        tipoTest.add("text/html, image/gif, image/jpeg, *; q= 0.5, */*; q= 0.5");
        tipoTest.add("text/html, image/gif, image/jpeg,*;q= 0.5,*/*;q= 0.5");
        tipoTest.add("text/html, image/gif, image/jpeg, * ; q= 0.5, */* ; q= 0.2");
        for (int i = 0; i < tipoTest.size(); ++i) {
            String tipo = (String)tipoTest.get(i);
            System.out.println("\tTest Richiesta path:" + path + " (" + tipo + ") ...");
            TextHttpRequestEntity request = new TextHttpRequestEntity();
            request.setUrl(path);
            request.setMethod(method);
            HashMap<String, List<String>> parametersTrasporto = new HashMap<String, List<String>>();
            TransportUtils.addHeader(parametersTrasporto, "Accept", tipo);
            request.setHeaders(parametersTrasporto);
            try {
                apiValidatorOpenApi4j.validate(request);
            }
            catch (ValidatorException e) {
                throw new Exception("Errore non atteso: " + e.getMessage(), e);
            }
            String valueHeaderAccept = TransportUtils.getFirstValue(request.getHeaders(), "Accept");
            if (valueHeaderAccept == null || !valueHeaderAccept.equals(tipo)) {
                throw new Exception("Header Accept '" + valueHeaderAccept + "' diverso da quello atteso '+valueHeaderAccept+'");
            }
            System.out.println("\tTest Richiesta  path:" + path + " (" + tipo + ") superato");
            System.out.println("\tTest Risposta path:" + path + " (" + tipo + ") ...");
            TextHttpResponseEntity response = new TextHttpResponseEntity();
            response.setContent("PROVA");
            response.setStatus(200);
            response.setMethod(method);
            response.setUrl(path);
            HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
            TransportUtils.setHeader(responseHeaders, "Content-Type", contentType);
            TransportUtils.addHeader(responseHeaders, "Accept", tipo);
            response.setHeaders(responseHeaders);
            response.setContentType(contentType);
            try {
                apiValidatorOpenApi4j.validate(response);
            }
            catch (ValidatorException e) {
                throw new Exception("Errore non atteso: " + e.getMessage());
            }
            valueHeaderAccept = TransportUtils.getFirstValue(response.getHeaders(), "Accept");
            if (valueHeaderAccept == null || !valueHeaderAccept.equals(tipo)) {
                throw new Exception("Header Accept '" + valueHeaderAccept + "' diverso da quello atteso '+valueHeaderAccept+'");
            }
            System.out.println("\tTest Risposta path:" + path + " (" + tipo + ") superato");
        }
        System.out.println("TEST Format Accept completato!");
    }

    private static void testSchemaEmpty(OpenAPILibrary openAPILibrary, boolean mergeSpec, boolean yamlTest) throws UtilsException, ProcessingException, URISyntaxException, Exception {
        System.out.println("#### Verifica schema empty ####");
        URL url = null;
        ApiSchema apiSchema = null;
        if (yamlTest) {
            url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/allegati.yaml");
            apiSchema = new ApiSchema("teamdigitale-openapi_definitions.yaml", Utilities.getAsByteArray(OpenApi3ExtendedTest.class.getResourceAsStream("/org/openspcoop2/utils/service/schemi/standard/teamdigitale-openapi_definitions.yaml")), ApiSchemaType.YAML);
        } else {
            url = OpenApi3ExtendedTest.class.getResource("/org/openspcoop2/utils/openapi/test/allegati.json");
        }
        IApiReader apiReaderOpenApi4j = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        ApiReaderConfig configOpenApi4j = new ApiReaderConfig();
        configOpenApi4j.setProcessInclude(false);
        if (apiSchema != null) {
            apiReaderOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi4j, apiSchema);
        } else {
            apiReaderOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), new File(url.toURI()), configOpenApi4j);
        }
        Api apiOpenApi4j = apiReaderOpenApi4j.read();
        ApiOperation apiOp = null;
        for (ApiOperation op : apiOpenApi4j.getOperations()) {
            if (!"/test-tipo-vuto/{esempio_path}".equals(op.getPath())) continue;
            apiOp = op;
            break;
        }
        if (apiOp == null) {
            throw new UtilsException("Operation not found");
        }
        IApiValidator apiValidatorOpenApi4j = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
        OpenapiApiValidatorConfig configO = new OpenapiApiValidatorConfig();
        configO.setEmitLogError(logSystemOutError);
        configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
        configO.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
        configO.getOpenApiValidatorConfig().setValidateAPISpec(true);
        configO.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
        apiValidatorOpenApi4j.init(LoggerWrapperFactory.getLogger(OpenApi3ExtendedTest.class), apiOpenApi4j, configO);
        String pathPrefix = "/test-tipo-vuto/";
        HttpRequestMethod method = HttpRequestMethod.GET;
        String contentType = "text/plain";
        ArrayList<String> valoriTest = new ArrayList<String>();
        valoriTest.add("provaqualsiasitest");
        valoriTest.add("3");
        valoriTest.add("true");
        int sizeTest = 5;
        for (int i = 0; i < sizeTest; ++i) {
            for (int j = 0; j < valoriTest.size(); ++j) {
                String valoreTest = (String)valoriTest.get(j);
                String verifica = null;
                if (i == 0) {
                    verifica = "path";
                } else if (i == 1) {
                    verifica = "query";
                } else if (i == 2) {
                    verifica = "header";
                } else if (i == 3) {
                    verifica = "cookie";
                } else if (i == 4) {
                    verifica = "header_risposta";
                }
                String path = pathPrefix + ("path".equals(verifica) ? valoreTest : "pathcasuale");
                System.out.println("\tTest Richiesta path:" + path + " (" + verifica + ") param:'" + valoreTest + "' ...");
                if (apiOp.getRequest().getDynamicPathParameter(0).getApiParameterSchema() == null) {
                    throw new UtilsException("Schema is null for path");
                }
                if (apiOp.getRequest().getDynamicPathParameter(0).getApiParameterSchema().getType() == null) {
                    throw new UtilsException("Schema type is null for path");
                }
                if (apiOp.getRequest().getQueryParameter(0).getApiParameterSchema() == null) {
                    throw new UtilsException("Schema is null for query");
                }
                if (apiOp.getRequest().getQueryParameter(0).getApiParameterSchema().getType() == null) {
                    throw new UtilsException("Schema type is null for query");
                }
                if (apiOp.getRequest().getHeaderParameter(0).getApiParameterSchema() == null) {
                    throw new UtilsException("Schema is null for header");
                }
                if (apiOp.getRequest().getHeaderParameter(0).getApiParameterSchema().getType() == null) {
                    throw new UtilsException("Schema type is null for header");
                }
                if (apiOp.getRequest().getCookieParameter(0).getApiParameterSchema() == null) {
                    throw new UtilsException("Schema is null for cookie");
                }
                if (apiOp.getRequest().getCookieParameter(0).getApiParameterSchema().getType() == null) {
                    throw new UtilsException("Schema type is null for cookie");
                }
                if (apiOp.getResponse(0).getHeaderParameter(0).getApiParameterSchema() == null) {
                    throw new UtilsException("Schema is null for response header");
                }
                if (apiOp.getResponse(0).getHeaderParameter(0).getApiParameterSchema().getType() == null) {
                    throw new UtilsException("Schema type is null for response header");
                }
                TextHttpRequestEntity request = new TextHttpRequestEntity();
                request.setUrl(path);
                request.setMethod(method);
                HashMap<String, List<String>> parametersTrasporto = new HashMap<String, List<String>>();
                TransportUtils.setHeader(parametersTrasporto, "Content-Type", contentType);
                TransportUtils.addHeader(parametersTrasporto, "esempio_header", "header".equals(verifica) ? valoreTest : "valorecasuale");
                request.setHeaders(parametersTrasporto);
                HashMap<String, List<String>> parametersQuery = new HashMap<String, List<String>>();
                TransportUtils.addParameter(parametersQuery, "esempio_query", "query".equals(verifica) ? valoreTest : "valorecasuale");
                request.setParameters(parametersQuery);
                ArrayList<Cookie> cookies = new ArrayList<Cookie>();
                Cookie c1 = new Cookie("esempio_cookie", "cookie".equals(verifica) ? valoreTest : "valorecasuale");
                cookies.add(c1);
                request.setCookies(cookies);
                request.setContentType(contentType);
                request.setContent("valorecasuale");
                try {
                    apiValidatorOpenApi4j.validate(request);
                }
                catch (ValidatorException e) {
                    throw new UtilsException("Errore non atteso: " + e.getMessage(), e);
                }
                System.out.println("\tTest Richiesta path:" + path + " (" + verifica + ") param:'" + valoreTest + "' verifica superata");
                System.out.println("\tTest Risposta path:" + path + " (" + verifica + ") param:'" + valoreTest + "' ...");
                TextHttpResponseEntity response = new TextHttpResponseEntity();
                response.setContent("PROVA");
                response.setStatus(200);
                response.setMethod(method);
                response.setUrl(path);
                HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                TransportUtils.setHeader(responseHeaders, "Content-Type", contentType);
                TransportUtils.addHeader(responseHeaders, "esempio_header_risposta", "header_risposta".equals(verifica) ? valoreTest : "valorecasuale");
                response.setHeaders(responseHeaders);
                response.setContentType(contentType);
                request.setContent("valorecasuale");
                try {
                    apiValidatorOpenApi4j.validate(response);
                }
                catch (ValidatorException e) {
                    throw new UtilsException("Errore non atteso: " + e.getMessage());
                }
                System.out.println("\tTest Risposta path:" + path + " (" + verifica + ") param:'" + valoreTest + "' verifica superata");
            }
        }
        System.out.println("Verifica schema empty completato!");
    }
}

